/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegisterEvent
extends Event
implements IModBusEvent {
    @NotNull
    private final class_5321<? extends class_2378<?>> registryKey;
    @Nullable
    final ForgeRegistry<?> forgeRegistry;
    @Nullable
    private final class_2378<?> vanillaRegistry;

    RegisterEvent(@NotNull class_5321<? extends class_2378<?>> registryKey, @Nullable ForgeRegistry<?> forgeRegistry, @Nullable class_2378<?> vanillaRegistry) {
        this.registryKey = registryKey;
        this.forgeRegistry = forgeRegistry;
        this.vanillaRegistry = vanillaRegistry;
    }

    public <T> void register(class_5321<? extends class_2378<T>> registryKey, class_2960 name, Supplier<T> valueSupplier) {
        if (this.registryKey.equals(registryKey)) {
            if (this.forgeRegistry != null) {
                this.forgeRegistry.register(name, valueSupplier.get());
            } else if (this.vanillaRegistry != null) {
                class_2378.method_10230(this.vanillaRegistry, (class_2960)name, valueSupplier.get());
            }
        }
    }

    public <T> void register(class_5321<? extends class_2378<T>> registryKey, Consumer<RegisterHelper<T>> consumer) {
        if (this.registryKey.equals(registryKey)) {
            consumer.accept((name, value) -> this.register(registryKey, name, () -> value));
        }
    }

    @NotNull
    public class_5321<? extends class_2378<?>> getRegistryKey() {
        return this.registryKey;
    }

    @Nullable
    public <T> IForgeRegistry<T> getForgeRegistry() {
        return this.forgeRegistry;
    }

    @Nullable
    public <T> class_2378<T> getVanillaRegistry() {
        return this.vanillaRegistry;
    }

    public String toString() {
        return "RegisterEvent";
    }

    @FunctionalInterface
    public static interface RegisterHelper<T> {
        default public void register(String name, T value) {
            this.register(new class_2960(ModLoadingContext.get().getActiveNamespace(), name), value);
        }

        default public void register(class_5321<T> key, T value) {
            this.register(key.method_29177(), value);
        }

        public void register(class_2960 var1, T var2);
    }
}

