/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries.holdersets;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7876;
import net.minecraftforge.common.extensions.IForgeHolderSet;
import net.minecraftforge.registries.holdersets.ICustomHolderSet;
import net.minecraftforge.registries.holdersets.OrHolderSet;
import org.jetbrains.annotations.Nullable;

public abstract class CompositeHolderSet<T>
implements ICustomHolderSet<T> {
    private final List<Runnable> owners = new ArrayList<Runnable>();
    private final List<class_6885<T>> components;
    @Nullable
    private Set<class_6880<T>> set = null;
    @Nullable
    private List<class_6880<T>> list = null;

    public CompositeHolderSet(List<class_6885<T>> components) {
        this.components = components;
        for (class_6885<T> holderset : components) {
            holderset.addInvalidationListener(this::invalidate);
        }
    }

    protected abstract Set<class_6880<T>> createSet();

    public List<class_6885<T>> getComponents() {
        return this.components;
    }

    public Set<class_6880<T>> getSet() {
        Set<class_6880<T>> thisSet = this.set;
        if (thisSet == null) {
            Set<class_6880<T>> set = this.createSet();
            this.set = set;
            return set;
        }
        return thisSet;
    }

    public List<class_6880<T>> getList() {
        List<class_6880<T>> thisList = this.list;
        if (thisList == null) {
            List<class_6880<T>> list = List.copyOf(this.getSet());
            this.list = list;
            return list;
        }
        return thisList;
    }

    @Override
    public void addInvalidationListener(Runnable runnable) {
        this.owners.add(runnable);
    }

    private void invalidate() {
        this.set = null;
        this.list = null;
        for (Runnable runnable : this.owners) {
            runnable.run();
        }
    }

    public Stream<class_6880<T>> method_40239() {
        return this.getList().stream();
    }

    public int method_40247() {
        return this.getList().size();
    }

    public Either<class_6862<T>, List<class_6880<T>>> method_40248() {
        return Either.right(this.getList());
    }

    public Optional<class_6880<T>> method_40243(class_5819 rand) {
        List<class_6880<T>> list = this.getList();
        int size = list.size();
        return size > 0 ? Optional.of(list.get(rand.method_43048(size))) : Optional.empty();
    }

    public class_6880<T> method_40240(int i) {
        return this.getList().get(i);
    }

    public boolean method_40241(class_6880<T> holder) {
        return this.getSet().contains(holder);
    }

    public boolean method_46768(class_7876<T> holderOwner) {
        for (class_6885<T> component : this.components) {
            if (component.method_46768(holderOwner)) continue;
            return false;
        }
        return true;
    }

    public Optional<class_6862<T>> method_45925() {
        return Optional.empty();
    }

    public Iterator<class_6880<T>> iterator() {
        return this.getList().iterator();
    }

    public List<class_6885<T>> homogenize() {
        List<class_6885<T>> components = this.getComponents();
        if (this.isHomogenous()) {
            return components;
        }
        ArrayList<class_6885<T>> outputs = new ArrayList<class_6885<T>>();
        for (class_6885<T> holderset : components) {
            if (holderset instanceof ICustomHolderSet) {
                outputs.add(holderset);
                continue;
            }
            outputs.add(new OrHolderSet<T>(List.of(holderset)));
        }
        return outputs;
    }

    public boolean isHomogenous() {
        List<class_6885<T>> holderSets = this.getComponents();
        if (holderSets.size() < 2) {
            return true;
        }
        IForgeHolderSet.SerializationType firstType = holderSets.get(0).serializationType();
        if (firstType == IForgeHolderSet.SerializationType.UNKNOWN) {
            return false;
        }
        int size = holderSets.size();
        for (int i = 1; i < size; ++i) {
            IForgeHolderSet.SerializationType type = holderSets.get(i).serializationType();
            if (type == firstType) continue;
            return false;
        }
        return true;
    }
}

