/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_2535;
import net.minecraft.class_2539;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2889;
import net.minecraft.class_2909;
import net.minecraft.class_3195;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5352;
import net.minecraft.class_5455;
import net.minecraft.class_6306;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.StructureModifier;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.gametest.ForgeGameTestHooks;
import net.minecraftforge.network.ConnectionType;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.resource.PathPackResources;
import net.minecraftforge.server.LanguageHook;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;

public class ServerLifecycleHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker SERVERHOOKS = MarkerManager.getMarker((String)"SERVERHOOKS");
    private static final class_5218 SERVERCONFIG = new class_5218("serverconfig");
    private static volatile CountDownLatch exitLatch = null;
    private static MinecraftServer currentServer;
    private static AtomicBoolean allowLogins;

    private static Path getServerConfigPath(MinecraftServer server) {
        Path serverConfig = server.method_27050(SERVERCONFIG);
        if (!Files.isDirectory(serverConfig, new LinkOption[0])) {
            try {
                Files.createDirectories(serverConfig, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return serverConfig;
    }

    public static boolean handleServerAboutToStart(MinecraftServer server) {
        currentServer = server;
        LogicalSidedProvider.setServer(() -> server);
        ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.SERVER, ServerLifecycleHooks.getServerConfigPath(server));
        ServerLifecycleHooks.runModifiers(server);
        return !MinecraftForge.EVENT_BUS.post((Event)new ServerAboutToStartEvent(server));
    }

    public static boolean handleServerStarting(MinecraftServer server) {
        DistExecutor.runWhenOn(Dist.DEDICATED_SERVER, () -> () -> {
            LanguageHook.loadLanguagesOnServer(server);
            if (!(server instanceof class_6306)) {
                ForgeGameTestHooks.registerGametests();
            }
        });
        PermissionAPI.initializePermissionAPI();
        return !MinecraftForge.EVENT_BUS.post((Event)new ServerStartingEvent(server));
    }

    public static void handleServerStarted(MinecraftServer server) {
        MinecraftForge.EVENT_BUS.post((Event)new ServerStartedEvent(server));
        allowLogins.set(true);
    }

    public static void handleServerStopping(MinecraftServer server) {
        allowLogins.set(false);
        MinecraftForge.EVENT_BUS.post((Event)new ServerStoppingEvent(server));
    }

    public static void expectServerStopped() {
        exitLatch = new CountDownLatch(1);
    }

    public static void handleServerStopped(MinecraftServer server) {
        if (!server.method_3816()) {
            GameData.revertToFrozen();
        }
        MinecraftForge.EVENT_BUS.post((Event)new ServerStoppedEvent(server));
        currentServer = null;
        LogicalSidedProvider.setServer(null);
        CountDownLatch latch = exitLatch;
        if (latch != null) {
            latch.countDown();
            exitLatch = null;
        }
    }

    public static MinecraftServer getCurrentServer() {
        return currentServer;
    }

    public static boolean handleServerLogin(class_2889 packet, class_2535 manager) {
        if (!allowLogins.get()) {
            class_5250 text = class_2561.method_43470((String)"Server is still starting! Please wait before reconnecting.");
            LOGGER.info(SERVERHOOKS, "Disconnecting Player (server is still starting): {}", (Object)text.method_10851());
            manager.method_10743((class_2596)new class_2909((class_2561)text));
            manager.method_10747((class_2561)text);
            return false;
        }
        if (packet.method_12573() == class_2539.field_20593) {
            ConnectionType connectionType = ConnectionType.forVersionFlag(packet.getFMLVersion());
            int versionNumber = connectionType.getFMLVersionNumber(packet.getFMLVersion());
            if (connectionType == ConnectionType.MODDED && versionNumber != 3) {
                ServerLifecycleHooks.rejectConnection(manager, connectionType, "This modded server is not impl compatible with your modded client. Please verify your Forge version closely matches the server. Got net version " + versionNumber + " this server is net version 3");
                return false;
            }
            if (connectionType == ConnectionType.VANILLA && !NetworkRegistry.acceptsVanillaClientConnections()) {
                ServerLifecycleHooks.rejectConnection(manager, connectionType, "This server has mods that require Forge or Kilt to be installed on the client. Contact your server admin for more details.");
                return false;
            }
        }
        if (packet.method_12573() == class_2539.field_20592) {
            return true;
        }
        NetworkHooks.registerServerLoginChannel(manager, packet);
        return true;
    }

    private static void rejectConnection(class_2535 manager, ConnectionType type, String message2) {
        manager.method_10750(class_2539.field_20593);
        String ip = "local";
        if (manager.method_10755() != null) {
            ip = manager.method_10755().toString();
        }
        LOGGER.info(SERVERHOOKS, "[{}] Disconnecting {} connection attempt: {}", (Object)ip, (Object)type, (Object)message2);
        class_5250 text = class_2561.method_43470((String)message2);
        manager.method_10743((class_2596)new class_2909((class_2561)text));
        manager.method_10747((class_2561)text);
    }

    public static void handleExit(int retVal) {
        System.exit(retVal);
    }

    @ApiStatus.Internal
    public static class_3285 buildPackFinder(Map<IModFile, ? extends PathPackResources> modResourcePacks) {
        return packAcceptor -> ServerLifecycleHooks.serverPackFinder(modResourcePacks, packAcceptor);
    }

    private static void serverPackFinder(Map<IModFile, ? extends PathPackResources> modResourcePacks, Consumer<class_3288> packAcceptor) {
        for (Map.Entry<IModFile, ? extends PathPackResources> e : modResourcePacks.entrySet()) {
            IModInfo mod = (IModInfo)e.getKey().getModInfos().get(0);
            if (Objects.equals(mod.getModId(), "minecraft")) continue;
            String name = "mod:" + mod.getModId();
            class_3288 modPack = class_3288.method_45275((String)name, (class_2561)class_2561.method_43470((String)e.getValue().method_14409()), (boolean)false, id -> (class_3262)e.getValue(), (class_3264)class_3264.field_14190, (class_3288.class_3289)class_3288.class_3289.field_14281, (class_5352)class_5352.field_25347);
            if (modPack == null) {
                ModLoader.get().addWarning(new ModLoadingWarning(mod, ModLoadingStage.ERROR, "fml.modloading.brokenresources", e.getKey()));
                continue;
            }
            LOGGER.debug(Logging.CORE, "Generating PackInfo named {} for mod file {}", (Object)name, (Object)e.getKey().getFilePath());
            packAcceptor.accept(modPack);
        }
    }

    private static void runModifiers(MinecraftServer server) {
        class_5455.class_6890 registries = server.method_30611();
        List<BiomeModifier> biomeModifiers = registries.method_30530(ForgeRegistries.Keys.BIOME_MODIFIERS).method_40270().map(class_6880::comp_349).toList();
        List<StructureModifier> structureModifiers = registries.method_30530(ForgeRegistries.Keys.STRUCTURE_MODIFIERS).method_40270().map(class_6880::comp_349).toList();
        registries.method_30530(class_7924.field_41236).method_40270().forEach(biomeHolder -> ((class_1959)biomeHolder.comp_349()).modifiableBiomeInfo().applyBiomeModifiers((class_6880<class_1959>)biomeHolder, biomeModifiers));
        registries.method_30530(class_7924.field_41246).method_40270().forEach(structureHolder -> ((class_3195)structureHolder.comp_349()).modifiableStructureInfo().applyStructureModifiers((class_6880<class_3195>)structureHolder, structureModifiers));
    }

    static {
        allowLogins = new AtomicBoolean(false);
    }
}

