/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraftforge.common.WorldWorkerManager;

public class ChunkGenWorker
implements WorldWorkerManager.IWorker {
    private final class_2168 listener;
    protected final class_2338 start;
    protected final int total;
    private final class_3218 dim;
    private final Queue<class_2338> queue;
    private final int notificationFrequency;
    private int lastNotification = 0;
    private long lastNotifcationTime = 0L;
    private int genned = 0;
    private Boolean keepingLoaded;

    public ChunkGenWorker(class_2168 listener, class_2338 start, int total, class_3218 dim, int interval) {
        this.listener = listener;
        this.start = start;
        this.total = total;
        this.dim = dim;
        this.queue = this.buildQueue();
        this.notificationFrequency = interval != -1 ? interval : Math.max(total / 20, 100);
        this.lastNotifcationTime = System.currentTimeMillis();
    }

    protected Queue<class_2338> buildQueue() {
        ArrayDeque<class_2338> ret = new ArrayDeque<class_2338>();
        ret.add(this.start);
        int radius = 1;
        while (ret.size() < this.total) {
            int q;
            for (q = -radius + 1; q <= radius && ret.size() < this.total; ++q) {
                ret.add(this.start.method_10069(radius, 0, q));
            }
            for (q = radius - 1; q >= -radius && ret.size() < this.total; --q) {
                ret.add(this.start.method_10069(q, 0, radius));
            }
            for (q = radius - 1; q >= -radius && ret.size() < this.total; --q) {
                ret.add(this.start.method_10069(-radius, 0, q));
            }
            for (q = -radius + 1; q <= radius && ret.size() < this.total; ++q) {
                ret.add(this.start.method_10069(q, 0, -radius));
            }
            ++radius;
        }
        return ret;
    }

    public class_5250 getStartMessage(class_2168 sender) {
        return class_2561.method_43469((String)"commands.forge.gen.start", (Object[])new Object[]{this.total, this.start.method_10263(), this.start.method_10260(), this.dim});
    }

    @Override
    public boolean hasWork() {
        return this.queue.size() > 0;
    }

    @Override
    public boolean doWork() {
        class_2338 next = this.queue.poll();
        if (next != null) {
            class_2791 chunk;
            int z;
            int x;
            if (++this.lastNotification >= this.notificationFrequency || this.lastNotifcationTime < System.currentTimeMillis() - 60000L) {
                this.listener.method_9226(() -> class_2561.method_43469((String)"commands.forge.gen.progress", (Object[])new Object[]{this.total - this.queue.size(), this.total}), true);
                this.lastNotification = 0;
                this.lastNotifcationTime = System.currentTimeMillis();
            }
            if (!this.dim.method_8393(x = next.method_10263(), z = next.method_10260()) && !(chunk = this.dim.method_8402(x, z, class_2806.field_12798, true)).method_12009().method_12165(class_2806.field_12803)) {
                chunk = this.dim.method_22342(x, z, class_2806.field_12803);
                ++this.genned;
            }
        }
        if (this.queue.size() == 0) {
            this.listener.method_9226(() -> class_2561.method_43469((String)"commands.forge.gen.complete", (Object[])new Object[]{this.genned, this.total, this.dim.method_27983().method_29177()}), true);
            return false;
        }
        return true;
    }
}

