/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.google.common.collect.Maps;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

class EntityCommand {
    EntityCommand() {
    }

    static ArgumentBuilder<class_2168, ?> register() {
        return class_2170.method_9247((String)"entity").then(EntityListCommand.register());
    }

    private static class EntityListCommand {
        private static final SimpleCommandExceptionType INVALID_FILTER = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.forge.entity.list.invalid"));
        private static final DynamicCommandExceptionType INVALID_DIMENSION = new DynamicCommandExceptionType(dim -> class_2561.method_43469((String)"commands.forge.entity.list.invalidworld", (Object[])new Object[]{dim}));
        private static final SimpleCommandExceptionType NO_ENTITIES = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.forge.entity.list.none"));

        private EntityListCommand() {
        }

        static ArgumentBuilder<class_2168, ?> register() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(cs -> cs.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"filter", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> class_2172.method_9264(ForgeRegistries.ENTITY_TYPES.getKeys().stream().map(class_2960::toString).map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).executes(ctx -> EntityListCommand.execute((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"filter"), (class_5321<class_1937>)class_2181.method_9289((CommandContext)ctx, (String)"dim").method_27983())))).executes(ctx -> EntityListCommand.execute((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"filter"), (class_5321<class_1937>)((class_2168)ctx.getSource()).method_9225().method_27983())))).executes(ctx -> EntityListCommand.execute((class_2168)ctx.getSource(), "*", (class_5321<class_1937>)((class_2168)ctx.getSource()).method_9225().method_27983()));
        }

        private static int execute(class_2168 sender, String filter2, class_5321<class_1937> dim) throws CommandSyntaxException {
            String cleanFilter = filter2.replace("?", ".?").replace("*", ".*?");
            Set names = ForgeRegistries.ENTITY_TYPES.getKeys().stream().filter(n -> n.toString().matches(cleanFilter)).collect(Collectors.toSet());
            if (names.isEmpty()) {
                throw INVALID_FILTER.create();
            }
            class_3218 level = sender.method_9211().method_3847(dim);
            if (level == null) {
                throw INVALID_DIMENSION.create(dim);
            }
            HashMap list = Maps.newHashMap();
            level.method_31592().method_31803().forEach(e -> {
                MutablePair info = list.computeIfAbsent(ForgeRegistries.ENTITY_TYPES.getKey(e.method_5864()), k -> MutablePair.of((Object)0, (Object)Maps.newHashMap()));
                class_1923 chunk = new class_1923(e.method_24515());
                MutablePair mutablePair = info;
                Integer n = (Integer)mutablePair.left;
                mutablePair.left = (Integer)mutablePair.left + 1;
                ((Map)info.right).put(chunk, ((Map)info.right).getOrDefault(chunk, 0) + 1);
            });
            if (names.size() == 1) {
                class_2960 name = (class_2960)names.iterator().next();
                Pair info = (Pair)list.get(name);
                if (info == null) {
                    throw NO_ENTITIES.create();
                }
                sender.method_9226(() -> class_2561.method_43469((String)"commands.forge.entity.list.single.header", (Object[])new Object[]{name, info.getLeft()}), false);
                ArrayList toSort = new ArrayList();
                toSort.addAll(((Map)info.getRight()).entrySet());
                toSort.sort((a, b) -> {
                    if (Objects.equals(a.getValue(), b.getValue())) {
                        return ((class_1923)a.getKey()).toString().compareTo(((class_1923)b.getKey()).toString());
                    }
                    return (Integer)b.getValue() - (Integer)a.getValue();
                });
                long limit = 10L;
                for (Map.Entry entry : toSort) {
                    if (limit-- == 0L) break;
                    sender.method_9226(() -> class_2561.method_43470((String)("  " + String.valueOf(e2.getValue()) + ": " + ((class_1923)e.getKey()).field_9181 + ", " + ((class_1923)e.getKey()).field_9180)), false);
                }
                return toSort.size();
            }
            ArrayList info = new ArrayList();
            list.forEach((key, value) -> {
                if (names.contains(key)) {
                    Pair of = Pair.of((Object)key, (Object)((Integer)value.left));
                    info.add(of);
                }
            });
            info.sort((a, b) -> {
                if (Objects.equals(a.getRight(), b.getRight())) {
                    return ((class_2960)a.getKey()).toString().compareTo(((class_2960)b.getKey()).toString());
                }
                return (Integer)b.getRight() - (Integer)a.getRight();
            });
            if (info.size() == 0) {
                throw NO_ENTITIES.create();
            }
            int count = info.stream().mapToInt(Pair::getRight).sum();
            sender.method_9226(() -> class_2561.method_43469((String)"commands.forge.entity.list.multiple.header", (Object[])new Object[]{count}), false);
            info.forEach(e -> sender.method_9226(() -> class_2561.method_43470((String)("  " + String.valueOf(e.getValue()) + ": " + String.valueOf(e.getKey()))), false));
            return info.size();
        }
    }
}

