/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7079;

class TagsCommand {
    private static final long PAGE_SIZE = 8L;
    private static final class_5321<class_2378<class_2378<?>>> ROOT_REGISTRY_KEY = class_5321.method_29180((class_2960)new class_2960("root"));
    private static final DynamicCommandExceptionType UNKNOWN_REGISTRY = new DynamicCommandExceptionType(key -> class_2561.method_43469((String)"commands.forge.tags.error.unknown_registry", (Object[])new Object[]{key}));
    private static final Dynamic2CommandExceptionType UNKNOWN_TAG = new Dynamic2CommandExceptionType((tag, registry) -> class_2561.method_43469((String)"commands.forge.tags.error.unknown_tag", (Object[])new Object[]{tag, registry}));
    private static final Dynamic2CommandExceptionType UNKNOWN_ELEMENT = new Dynamic2CommandExceptionType((tag, registry) -> class_2561.method_43469((String)"commands.forge.tags.error.unknown_element", (Object[])new Object[]{tag, registry}));

    TagsCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"tags").requires(cs -> cs.method_9259(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"registry", (ArgumentType)class_7079.method_41224(ROOT_REGISTRY_KEY)).suggests(TagsCommand::suggestRegistries).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(ctx -> TagsCommand.listTags((CommandContext<class_2168>)ctx, 1))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> TagsCommand.listTags((CommandContext<class_2168>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))).then(class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"tag", (ArgumentType)class_2232.method_9441()).suggests(TagsCommand.suggestFromRegistry(r -> r.method_40273().map(class_6862::comp_327)::iterator)).executes(ctx -> TagsCommand.listTagElements((CommandContext<class_2168>)ctx, 1))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> TagsCommand.listTagElements((CommandContext<class_2168>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))))).then(class_2170.method_9247((String)"query").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"element", (ArgumentType)class_2232.method_9441()).suggests(TagsCommand.suggestFromRegistry(class_2378::method_10235)).executes(ctx -> TagsCommand.queryElementTags((CommandContext<class_2168>)ctx, 1))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> TagsCommand.queryElementTags((CommandContext<class_2168>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))));
    }

    private static int listTags(CommandContext<class_2168> ctx, int page) throws CommandSyntaxException {
        class_5321<class_2378<?>> registryKey = TagsCommand.getResourceKey(ctx, "registry", ROOT_REGISTRY_KEY).orElseThrow();
        class_2378 registry = (class_2378)((class_2168)ctx.getSource()).method_9211().method_30611().method_33310(registryKey).orElseThrow(() -> UNKNOWN_REGISTRY.create((Object)registryKey.method_29177()));
        long tagCount = registry.method_40272().count();
        ((class_2168)ctx.getSource()).method_9226(() -> TagsCommand.createMessage(class_2561.method_43469((String)"commands.forge.tags.registry_key", (Object[])new Object[]{class_2561.method_43470((String)registryKey.method_29177().toString()).method_27692(class_124.field_1065)}), "commands.forge.tags.tag_count", "commands.forge.tags.copy_tag_names", tagCount, page, class_124.field_1077, () -> registry.method_40272().map(Pair::getSecond).map(s -> (String)s.method_40248().map(k -> k.comp_327().toString(), Object::toString))), false);
        return (int)tagCount;
    }

    private static int listTagElements(CommandContext<class_2168> ctx, int page) throws CommandSyntaxException {
        class_5321<class_2378<?>> registryKey = TagsCommand.getResourceKey(ctx, "registry", ROOT_REGISTRY_KEY).orElseThrow();
        class_2378 registry = (class_2378)((class_2168)ctx.getSource()).method_9211().method_30611().method_33310(registryKey).orElseThrow(() -> UNKNOWN_REGISTRY.create((Object)registryKey.method_29177()));
        class_2960 tagLocation = class_2232.method_9443(ctx, (String)"tag");
        class_6862 tagKey = class_6862.method_40092((class_5321)((class_5321)TagsCommand.cast(registryKey)), (class_2960)tagLocation);
        class_6885.class_6888 tag = (class_6885.class_6888)registry.method_40266((class_6862)TagsCommand.cast(tagKey)).orElseThrow(() -> UNKNOWN_TAG.create((Object)tagKey.comp_327(), (Object)registryKey.method_29177()));
        ((class_2168)ctx.getSource()).method_9226(() -> TagsCommand.createMessage(class_2561.method_43469((String)"commands.forge.tags.tag_key", (Object[])new Object[]{class_2561.method_43470((String)tagKey.comp_326().method_29177().toString()).method_27692(class_124.field_1065), class_2561.method_43470((String)tagKey.comp_327().toString()).method_27692(class_124.field_1077)}), "commands.forge.tags.element_count", "commands.forge.tags.copy_element_names", tag.method_40247(), page, class_124.field_1054, () -> tag.method_40239().map(s -> (String)s.method_40229().map(k -> k.method_29177().toString(), Object::toString))), false);
        return tag.method_40247();
    }

    private static int queryElementTags(CommandContext<class_2168> ctx, int page) throws CommandSyntaxException {
        class_5321<class_2378<?>> registryKey = TagsCommand.getResourceKey(ctx, "registry", ROOT_REGISTRY_KEY).orElseThrow();
        class_2378 registry = (class_2378)((class_2168)ctx.getSource()).method_9211().method_30611().method_33310(registryKey).orElseThrow(() -> UNKNOWN_REGISTRY.create((Object)registryKey.method_29177()));
        class_2960 elementLocation = class_2232.method_9443(ctx, (String)"element");
        class_5321 elementKey = class_5321.method_29179((class_5321)((class_5321)TagsCommand.cast(registryKey)), (class_2960)elementLocation);
        class_6880 elementHolder = (class_6880)registry.method_40264((class_5321)TagsCommand.cast(elementKey)).orElseThrow(() -> UNKNOWN_ELEMENT.create((Object)elementLocation, (Object)registryKey.method_29177()));
        long containingTagsCount = elementHolder.method_40228().count();
        ((class_2168)ctx.getSource()).method_9226(() -> TagsCommand.createMessage(class_2561.method_43469((String)"commands.forge.tags.element", (Object[])new Object[]{class_2561.method_43470((String)registryKey.method_29177().toString()).method_27692(class_124.field_1065), class_2561.method_43470((String)elementLocation.toString()).method_27692(class_124.field_1054)}), "commands.forge.tags.containing_tag_count", "commands.forge.tags.copy_tag_names", containingTagsCount, page, class_124.field_1077, () -> elementHolder.method_40228().map(k -> k.comp_327().toString())), false);
        return (int)containingTagsCount;
    }

    private static class_5250 createMessage(class_5250 header, String containsText, String copyHoverText, long count, long currentPage, class_124 elementColor, Supplier<Stream<String>> names) {
        String allElementNames = names.get().sorted().collect(Collectors.joining("\n"));
        long totalPages = (count - 1L) / 8L + 1L;
        long actualPage = (long)class_3532.method_15363((float)currentPage, (float)1.0f, (float)totalPages);
        class_5250 containsComponent = class_2561.method_43469((String)containsText, (Object[])new Object[]{count});
        if (count > 0L) {
            containsComponent = class_2564.method_10885((class_2561)containsComponent.method_27694(s -> s.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_21462, allElementNames)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)copyHoverText)))));
            containsComponent = class_2561.method_43469((String)"commands.forge.tags.page_info", (Object[])new Object[]{containsComponent, actualPage, totalPages});
        }
        class_5250 tagElements = class_2561.method_43470((String)"").method_10852((class_2561)containsComponent);
        names.get().sorted().skip(8L * (actualPage - 1L)).limit(8L).map(class_2561::method_43470).map(t -> t.method_27692(elementColor)).map(t -> class_2561.method_43471((String)"\n - ").method_10852((class_2561)t)).forEach(arg_0 -> ((class_5250)tagElements).method_10852(arg_0));
        return header.method_27693("\n").method_10852((class_2561)tagElements);
    }

    private static CompletableFuture<Suggestions> suggestRegistries(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        ((class_2168)ctx.getSource()).method_30497().method_40311().map(class_5455.class_6892::comp_350).map(class_5321::method_29177).map(class_2960::toString).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static SuggestionProvider<class_2168> suggestFromRegistry(Function<class_2378<?>, Iterable<class_2960>> namesFunction) {
        return (ctx, builder) -> TagsCommand.getResourceKey((CommandContext<class_2168>)ctx, "registry", ROOT_REGISTRY_KEY).flatMap(key -> ((class_2168)ctx.getSource()).method_30497().method_33310(key).map(registry -> {
            class_2172.method_9270((Iterable)((Iterable)namesFunction.apply((class_2378<?>)registry)), (SuggestionsBuilder)builder);
            return builder.buildFuture();
        })).orElseGet(() -> ((SuggestionsBuilder)builder).buildFuture());
    }

    private static <T> Optional<class_5321<T>> getResourceKey(CommandContext<class_2168> ctx, String name, class_5321<class_2378<T>> registryKey) {
        class_5321 key = (class_5321)ctx.getArgument(name, class_5321.class);
        return key.method_39752(registryKey);
    }

    private static <O> O cast(Object input) {
        return (O)input;
    }
}

