/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_2164;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.timings.ForgeTimings;
import net.minecraftforge.server.timings.TimeTracker;

class TrackCommand {
    private static final DecimalFormat TIME_FORMAT = new DecimalFormat("#####0.00");

    TrackCommand() {
    }

    static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"track").then(StartTrackingCommand.register())).then(ResetTrackingCommand.register())).then(TrackResultsEntity.register())).then(TrackResultsBlockEntity.register())).then(StartTrackingCommand.register());
    }

    private static class StartTrackingCommand {
        private StartTrackingCommand() {
        }

        static ArgumentBuilder<class_2168, ?> register() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"start").requires(cs -> cs.method_9259(2))).then(class_2170.method_9247((String)"te").then(class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
                int duration = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration");
                TimeTracker.BLOCK_ENTITY_UPDATE.reset();
                TimeTracker.BLOCK_ENTITY_UPDATE.enable(duration);
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.forge.tracking.be.enabled", (Object[])new Object[]{duration}), true);
                return 0;
            })))).then(class_2170.method_9247((String)"entity").then(class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
                int duration = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration");
                TimeTracker.ENTITY_UPDATE.reset();
                TimeTracker.ENTITY_UPDATE.enable(duration);
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.forge.tracking.entity.enabled", (Object[])new Object[]{duration}), true);
                return 0;
            })));
        }
    }

    private static class ResetTrackingCommand {
        private ResetTrackingCommand() {
        }

        static ArgumentBuilder<class_2168, ?> register() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(cs -> cs.method_9259(2))).then(class_2170.method_9247((String)"te").executes(ctx -> {
                TimeTracker.BLOCK_ENTITY_UPDATE.reset();
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.forge.tracking.be.reset"), true);
                return 0;
            }))).then(class_2170.method_9247((String)"entity").executes(ctx -> {
                TimeTracker.ENTITY_UPDATE.reset();
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.forge.tracking.entity.reset"), true);
                return 0;
            }));
        }
    }

    private static class TrackResultsEntity {
        private TrackResultsEntity() {
        }

        static ArgumentBuilder<class_2168, ?> register() {
            return class_2170.method_9247((String)"entity").executes(ctx -> TrackResults.execute((class_2168)ctx.getSource(), TimeTracker.ENTITY_UPDATE, data -> {
                class_1297 entity = (class_1297)data.getObject().get();
                if (entity == null) {
                    return class_2561.method_43471((String)"commands.forge.tracking.invalid");
                }
                class_2338 pos = entity.method_24515();
                double averageTimings = data.getAverageTimings();
                String tickTime = (averageTimings > 1000.0 ? TIME_FORMAT.format(averageTimings / 1000.0) : TIME_FORMAT.format(averageTimings)) + (averageTimings < 1000.0 ? "\u03bcs" : "ms");
                return class_2561.method_43469((String)"commands.forge.tracking.timing_entry", (Object[])new Object[]{ForgeRegistries.ENTITY_TYPES.getKey(entity.method_5864()), entity.method_37908().method_27983().method_29177().toString(), pos.method_10263(), pos.method_10264(), pos.method_10260(), tickTime});
            }));
        }
    }

    private static class TrackResultsBlockEntity {
        private TrackResultsBlockEntity() {
        }

        static ArgumentBuilder<class_2168, ?> register() {
            return class_2170.method_9247((String)"te").executes(ctx -> TrackResults.execute((class_2168)ctx.getSource(), TimeTracker.BLOCK_ENTITY_UPDATE, data -> {
                class_2586 be = (class_2586)data.getObject().get();
                if (be == null) {
                    return class_2561.method_43471((String)"commands.forge.tracking.invalid");
                }
                class_2338 pos = be.method_11016();
                double averageTimings = data.getAverageTimings();
                String tickTime = (averageTimings > 1000.0 ? TIME_FORMAT.format(averageTimings / 1000.0) : TIME_FORMAT.format(averageTimings)) + (averageTimings < 1000.0 ? "\u03bcs" : "ms");
                return class_2561.method_43469((String)"commands.forge.tracking.timing_entry", (Object[])new Object[]{ForgeRegistries.BLOCK_ENTITY_TYPES.getKey(be.method_11017()), be.method_10997().method_27983().method_29177().toString(), pos.method_10263(), pos.method_10264(), pos.method_10260(), tickTime});
            }));
        }
    }

    private static class TrackResults {
        private TrackResults() {
        }

        private static <T> List<ForgeTimings<T>> getSortedTimings(TimeTracker<T> tracker) {
            ArrayList<ForgeTimings<T>> list = new ArrayList<ForgeTimings<T>>();
            list.addAll((Collection<ForgeTimings<T>>)tracker.getTimingData());
            list.sort(Comparator.comparingDouble(ForgeTimings::getAverageTimings));
            Collections.reverse(list);
            return list;
        }

        private static <T> int execute(class_2168 source, TimeTracker<T> tracker, Function<ForgeTimings<T>, class_2561> toString) throws class_2164 {
            List<ForgeTimings<T>> timingsList = TrackResults.getSortedTimings(tracker);
            if (timingsList.isEmpty()) {
                source.method_9226(() -> class_2561.method_43471((String)"commands.forge.tracking.no_data"), true);
            } else {
                timingsList.stream().filter(timings -> timings.getObject().get() != null).limit(10L).forEach(timings -> source.method_9226(() -> (class_2561)toString.apply((ForgeTimings)timings), true));
            }
            return 0;
        }
    }
}

