/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.permission.nodes;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PermissionNode<T> {
    private final String nodeName;
    private final PermissionType<T> type;
    private final PermissionResolver<T> defaultResolver;
    private final PermissionDynamicContextKey<?>[] dynamics;
    @Nullable
    private class_2561 readableName;
    @Nullable
    private class_2561 description;

    public PermissionNode(class_2960 nodeName, PermissionType<T> type, PermissionResolver<T> defaultResolver, PermissionDynamicContextKey ... dynamics) {
        this(nodeName.method_12836(), nodeName.method_12832(), type, defaultResolver, dynamics);
    }

    public PermissionNode(String modID, String nodeName, PermissionType<T> type, PermissionResolver<T> defaultResolver, PermissionDynamicContextKey ... dynamics) {
        this(modID + "." + nodeName, type, defaultResolver, dynamics);
    }

    private PermissionNode(String nodeName, PermissionType<T> type, PermissionResolver<T> defaultResolver, PermissionDynamicContextKey ... dynamics) {
        this.nodeName = nodeName;
        this.type = type;
        this.dynamics = dynamics;
        this.defaultResolver = defaultResolver;
    }

    public PermissionNode setInformation(@NotNull class_2561 readableName, @NotNull class_2561 description) {
        Preconditions.checkNotNull((Object)readableName, (String)"Readable name for PermissionNodes must not be null %s", (Object)this.nodeName);
        Preconditions.checkNotNull((Object)description, (String)"Description for PermissionNodes must not be null %s", (Object)this.nodeName);
        this.readableName = readableName;
        this.description = description;
        return this;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public PermissionType<T> getType() {
        return this.type;
    }

    public PermissionDynamicContextKey<?>[] getDynamics() {
        return this.dynamics;
    }

    public PermissionResolver<T> getDefaultResolver() {
        return this.defaultResolver;
    }

    @Nullable
    public class_2561 getReadableName() {
        return this.readableName;
    }

    @Nullable
    public class_2561 getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PermissionNode)) {
            return false;
        }
        PermissionNode otherNode = (PermissionNode)o;
        return this.nodeName.equals(otherNode.nodeName) && this.type.equals(otherNode.type);
    }

    public int hashCode() {
        return Objects.hash(this.nodeName, this.type);
    }

    @FunctionalInterface
    public static interface PermissionResolver<T> {
        public T resolve(@Nullable class_3222 var1, UUID var2, PermissionDynamicContext<?> ... var3);
    }
}

