/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.kilt.forgeinjects.world.item.crafting;

import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_6862;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.bluspring.kilt.helpers.mixin.CreateStatic;
import xyz.bluspring.kilt.injections.item.crafting.IngredientInjection;

@Mixin(value={class_1856.class})
public class IngredientInject
implements IngredientInjection {
    private static final AtomicInteger INVALIDATION_COUNTER = IngredientInjection.INVALIDATION_COUNTER;
    @Shadow
    @Nullable
    public class_1799[] field_9018;
    @Shadow
    @Nullable
    public IntList field_9016;
    private int invalidationCounter;

    @CreateStatic
    private static void invalidateAll() {
        IngredientInjection.invalidateAll();
    }

    @CreateStatic
    private static class_1856 merge(Collection<class_1856> parts) {
        return IngredientInjection.merge(parts);
    }

    @Override
    public boolean checkInvalidation() {
        int currentInvalidationCounter = IngredientInjection.INVALIDATION_COUNTER.get();
        if (this.invalidationCounter != currentInvalidationCounter) {
            this.invalidate();
            return true;
        }
        return false;
    }

    @Override
    public void markValid() {
        this.invalidationCounter = INVALIDATION_COUNTER.get();
    }

    @Override
    public void invalidate() {
        this.field_9018 = null;
        this.field_9016 = null;
    }

    @Override
    public IIngredientSerializer<? extends class_1856> getSerializer() {
        if (!this.isVanilla()) {
            throw new IllegalStateException();
        }
        return VanillaIngredientSerializer.INSTANCE;
    }

    @Override
    public boolean isVanilla() {
        return this.getClass().getPackageName().startsWith("net.minecraft");
    }

    @Inject(at={@At(value="HEAD")}, method={"fromNetwork"}, cancellable=true)
    private static void kilt$checkForgeRecipeFromNetwork(class_2540 friendlyByteBuf, CallbackInfoReturnable<class_1856> cir) {
        try {
            friendlyByteBuf.markReaderIndex();
            int size = friendlyByteBuf.method_10816();
            if (size == -1) {
                cir.setReturnValue((Object)CraftingHelper.getIngredient(friendlyByteBuf.method_10810(), friendlyByteBuf));
                return;
            }
            cir.setReturnValue((Object)class_1856.method_8092(Stream.generate(() -> new class_1856.class_1857(friendlyByteBuf.method_10819())).limit(size)));
        }
        catch (Throwable ignored) {
            friendlyByteBuf.resetReaderIndex();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lcom/google/gson/JsonElement;isJsonObject()Z", shift=At.Shift.BEFORE, remap=false)}, method={"fromJson(Lcom/google/gson/JsonElement;Z)Lnet/minecraft/world/item/crafting/Ingredient;"}, cancellable=true)
    private static void kilt$checkForgeRecipeFromJson(JsonElement json, boolean canBeEmpty, CallbackInfoReturnable<class_1856> cir) {
        try {
            class_1856 ret = CraftingHelper.getIngredient(json, canBeEmpty);
            if (ret != null) {
                cir.setReturnValue((Object)ret);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"toNetwork"}, cancellable=true)
    public void kilt$writeNonVanillaIds(class_2540 friendlyByteBuf, CallbackInfo ci) {
        try {
            if (!this.isVanilla()) {
                if (this.getSerializer() == VanillaIngredientSerializer.INSTANCE || CraftingHelper.getID(this.getSerializer()) == null) {
                    return;
                }
                CraftingHelper.write(friendlyByteBuf, (class_1856)this);
                ci.cancel();
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    @Mixin(value={class_1856.class_1858.class})
    public static class TagValueInject {
        @Shadow
        @Final
        public class_6862<class_1792> field_9022;

        @Inject(at={@At(value="RETURN")}, method={"getItems"})
        public void kilt$addEmptyTag(CallbackInfoReturnable<Collection<class_1799>> cir) {
            Collection list = (Collection)cir.getReturnValue();
            if (list.size() == 0) {
                list.add(new class_1799((class_1935)class_2246.field_10499).method_7977((class_2561)class_2561.method_43470((String)("Empty Tag: " + String.valueOf(this.field_9022.comp_327())))));
            }
        }
    }
}

