/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.kilt.forgeinjects.world.level.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4970;
import net.minecraft.class_6880;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.bluspring.kilt.helpers.mixin.CreateInitializer;
import xyz.bluspring.kilt.injections.world.level.block.LiquidBlockInjection;

@Mixin(value={class_2404.class}, priority=1070)
public abstract class LiquidBlockInject
extends class_2248
implements LiquidBlockInjection {
    @Shadow
    @Final
    @Mutable
    protected class_3609 field_11279;
    @Mutable
    @Shadow
    @Final
    private List<class_3610> field_11276;
    private Supplier<? extends class_3611> supplier;
    private boolean fluidStateCacheInitialized = false;

    public LiquidBlockInject(class_4970.class_2251 properties) {
        super(properties);
    }

    @Override
    @Intrinsic
    public class_3609 getFluid() {
        if (this.supplier != null && this.field_11279 == null) {
            this.field_11279 = (class_3609)this.supplier.get();
        }
        return this.field_11279;
    }

    @Inject(at={@At(value="HEAD")}, method={"isPathfindable", "getPickupSound", "pickupBlock", "shouldSpreadLiquid", "onPlace", "skipRendering", "updateShape", "neighborChanged"})
    public void kilt$cacheFluidState(CallbackInfo ci) {
        this.getFluid();
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/world/level/material/FlowingFluid;Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V"})
    public void kilt$setFluidSupplier(class_3609 flowingFluid, class_4970.class_2251 properties, CallbackInfo ci) {
        this.fluidStateCacheInitialized = true;
        class_6880.class_6883 fluidSupplier = ForgeRegistries.FLUIDS.getDelegate((class_3611)flowingFluid).orElse(null);
        if (fluidSupplier != null) {
            this.supplier = fluidSupplier;
        }
    }

    @Inject(at={@At(value="INVOKE", target="Ljava/util/List;get(I)Ljava/lang/Object;", shift=At.Shift.BEFORE)}, method={"getFluidState"})
    public void kilt$loadFluidStateCaches(class_2680 blockState, CallbackInfoReturnable<class_3610> cir) {
        if (!this.fluidStateCacheInitialized) {
            this.initFluidStateCache();
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/LiquidBlock;shouldSpreadLiquid(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z"), method={"neighborChanged"})
    public boolean kilt$useForgeNeighborsChanged(class_2404 instance, class_1937 level, class_2338 blockPos, class_2680 blockState) {
        return !FluidInteractionRegistry.canInteract(level, blockPos);
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/LiquidBlock;shouldSpreadLiquid(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z"), method={"onPlace"})
    public boolean kilt$useForgeOnPlace(class_2404 instance, class_1937 level, class_2338 blockPos, class_2680 blockState) {
        return !FluidInteractionRegistry.canInteract(level, blockPos);
    }

    protected synchronized void initFluidStateCache() {
        if (!this.fluidStateCacheInitialized) {
            this.field_11276.add(this.getFluid().method_15729(false));
            for (int i = 1; i < 8; ++i) {
                this.field_11276.add(this.getFluid().method_15728(8 - i, false));
            }
            this.field_11276.add(this.getFluid().method_15728(8, true));
            this.fluidStateCacheInitialized = true;
        }
    }

    @CreateInitializer
    public LiquidBlockInject(Supplier<? extends class_3609> fluidSupplier, class_4970.class_2251 properties) {
        super(properties);
        this.field_11279 = null;
        this.field_11276 = Lists.newArrayList();
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)class_2404.field_11278, (Comparable)Integer.valueOf(0)));
        this.supplier = fluidSupplier;
    }
}

