/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.kilt.loader.asm;

import com.chocohead.mm.api.ClassTinkerers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.lib.accesswidener.AccessWidener;
import net.fabricmc.loader.impl.lib.accesswidener.AccessWidenerReader;
import net.minecraftforge.fart.internal.EnhancedRemapper;
import net.minecraftforge.srgutils.IMappingFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.bluspring.kilt.loader.KiltFlags;
import xyz.bluspring.kilt.loader.remap.KiltEnhancedRemapper;
import xyz.bluspring.kilt.loader.remap.KiltRemapper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004'()*B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u0010\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0003J-\u0010\u0017\u001a\u00020\u00162\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001c\u0010\u001b\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001eR \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020!0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u001c\u0010%\u001a\n \u001a*\u0004\u0018\u00010$0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006+"}, d2={"Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader;", "", "<init>", "()V", "", "info", "", "println", "(Ljava/lang/String;)V", "", "data", "convertTransformers", "([B)V", "", "split", "className", "handleAccessTransform", "(Ljava/util/List;Ljava/lang/String;)V", "runTransformers", "srgClassName", "Lnet/fabricmc/loader/impl/lib/accesswidener/AccessWidener;", "accessWidener", "", "widenAccessForVanillaClasses", "(Ljava/util/List;Ljava/lang/String;Lnet/fabricmc/loader/impl/lib/accesswidener/AccessWidener;)Z", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "debug", "Z", "hasLoaded", "", "Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$ClassTransformInfo;", "classTransformInfo", "Ljava/util/Map;", "Ljava/util/regex/Pattern;", "whitespace", "Ljava/util/regex/Pattern;", "AccessType", "Final", "ClassTransformInfo", "TransformInfo", "Kilt"})
@SourceDebugExtension(value={"SMAP\nAccessTransformerLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessTransformerLoader.kt\nxyz/bluspring/kilt/loader/asm/AccessTransformerLoader\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,414:1\n216#2,2:415\n216#2:421\n217#2:433\n216#2:434\n217#2:442\n295#3,2:417\n774#3:422\n865#3,2:423\n1869#3:425\n1870#3:428\n1869#3:429\n1870#3:432\n774#3:435\n865#3,2:436\n1869#3:438\n1870#3:441\n13805#4,2:419\n13805#4,2:426\n13805#4,2:430\n13805#4,2:439\n*S KotlinDebug\n*F\n+ 1 AccessTransformerLoader.kt\nxyz/bluspring/kilt/loader/asm/AccessTransformerLoader\n*L\n180#1:415,2\n205#1:421\n205#1:433\n267#1:434\n267#1:442\n381#1:417,2\n210#1:422\n210#1:423,2\n210#1:425\n210#1:428\n238#1:429\n238#1:432\n273#1:435\n273#1:436,2\n273#1:438\n273#1:441\n186#1:419,2\n213#1:426,2\n241#1:430,2\n276#1:439,2\n*E\n"})
public final class AccessTransformerLoader {
    @NotNull
    public static final AccessTransformerLoader INSTANCE = new AccessTransformerLoader();
    private static final Logger logger = LoggerFactory.getLogger((String)"Kilt Access Transformers");
    private static final boolean debug = KiltFlags.ENABLE_ACCESS_TRANSFORMER_DEBUG;
    private static boolean hasLoaded;
    @NotNull
    private static final Map<String, ClassTransformInfo> classTransformInfo;
    private static final Pattern whitespace;

    private AccessTransformerLoader() {
    }

    private final void println(String info) {
        if (debug) {
            logger.info(info);
        } else {
            logger.debug(info);
        }
    }

    public final void convertTransformers(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        AccessWidener accessWidener = FabricLoaderImpl.INSTANCE.getAccessWidener();
        String textData = new String(data, Charsets.UTF_8);
        String delimiter = StringsKt.contains$default((CharSequence)textData, (CharSequence)"\r\n", (boolean)false, (int)2, null) ? "\r\n" : "\n";
        String[] stringArray = new String[]{delimiter};
        Iterator iterator = ((Iterable)StringsKt.split$default((CharSequence)textData, (String[])stringArray, (boolean)false, (int)0, (int)6, null)).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            String line = (String)iterator.next();
            if (StringsKt.startsWith$default((String)line, (String)"#", (boolean)false, (int)2, null) || StringsKt.isBlank((CharSequence)line)) continue;
            try {
                CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)line)).toString();
                Pattern pattern = whitespace;
                Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"whitespace");
                List split = StringsKt.split$default((CharSequence)charSequence, (Pattern)pattern, (int)0, (int)2, null);
                String srgClassName = StringsKt.replace$default((String)((String)split.get(1)), (String)".", (String)"/", (boolean)false, (int)4, null);
                if (!StringsKt.startsWith$default((String)srgClassName, (String)"net/minecraft/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)srgClassName, (String)"com/mojang/", (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNull((Object)accessWidener);
                if (this.widenAccessForVanillaClasses(split, srgClassName, accessWidener)) continue;
                this.handleAccessTransform(split, srgClassName);
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to process access transformer at line " + (index + 1) + ": \"" + line + "\"", e);
            }
        }
    }

    private final void handleAccessTransform(List<String> split, String className) {
        Final finalType;
        AccessType accessType = switch (StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)split.get(0), (CharSequence)"-f"), (CharSequence)"+f")) {
            case "public" -> AccessType.PUBLIC;
            case "protected" -> AccessType.PROTECTED;
            case "private" -> AccessType.PRIVATE;
            case "default" -> AccessType.PACKAGE_PRIVATE;
            default -> throw new IllegalArgumentException("Expected public/protected/private/default, got " + split.get(0));
        };
        Final final_ = StringsKt.endsWith$default((String)split.get(0), (String)"-f", (boolean)false, (int)2, null) ? Final.REMOVE : (finalType = StringsKt.endsWith$default((String)split.get(0), (String)"+f", (boolean)false, (int)2, null) ? Final.ADD : Final.DEFAULT);
        if (split.size() > 2 && !StringsKt.startsWith$default((String)split.get(2), (String)"#", (boolean)false, (int)2, null)) {
            if (StringsKt.contains$default((CharSequence)split.get(2), (CharSequence)"(", (boolean)false, (int)2, null)) {
                Object name = null;
                name = "";
                Object descriptor = null;
                descriptor = "";
                AccessTransformerLoader $this$handleAccessTransform_u24lambda_u240 = this;
                boolean bl = false;
                boolean isInDescriptor = false;
                String string = split.get(2);
                int n = string.length();
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    if (c == '(') {
                        isInDescriptor = true;
                    }
                    if (isInDescriptor) {
                        descriptor = "" + descriptor + c;
                        continue;
                    }
                    name = "" + name + c;
                }
                String methodName = name;
                ClassTransformInfo classTransformInfo = AccessTransformerLoader.classTransformInfo.get(className);
                if (classTransformInfo == null) {
                    classTransformInfo = new ClassTransformInfo(AccessType.DEFAULT, Final.DEFAULT, null, null, 12, null);
                }
                ClassTransformInfo transformInfo = classTransformInfo;
                Pair pair = new Pair((Object)methodName, descriptor);
                AccessType priorityAccess = accessType;
                Final priorityFinal = finalType;
                if (transformInfo.getMethods().containsKey(pair)) {
                    TransformInfo transformInfo2 = transformInfo.getMethods().get(pair);
                    Intrinsics.checkNotNull((Object)transformInfo2);
                    TransformInfo methodTransformInfo = transformInfo2;
                    if (priorityAccess.ordinal() < methodTransformInfo.getCurrentAccessType().ordinal()) {
                        methodTransformInfo.setCurrentAccessType(priorityAccess);
                    }
                    if (priorityFinal.ordinal() < methodTransformInfo.getFinal().ordinal()) {
                        methodTransformInfo.setFinal(priorityFinal);
                    }
                } else {
                    transformInfo.getMethods().put((Pair<String, String>)pair, new TransformInfo(priorityAccess, priorityFinal));
                }
                if (!AccessTransformerLoader.classTransformInfo.containsKey(className)) {
                    AccessTransformerLoader.classTransformInfo.put(className, transformInfo);
                }
            } else {
                ClassTransformInfo transformInfo;
                String name;
                String fieldName = name = split.get(2);
                ClassTransformInfo classTransformInfo = AccessTransformerLoader.classTransformInfo.get(className);
                if (classTransformInfo == null) {
                    classTransformInfo = new ClassTransformInfo(AccessType.DEFAULT, Final.DEFAULT, null, null, 12, null);
                }
                if ((transformInfo = classTransformInfo).getFields().containsKey(fieldName)) {
                    TransformInfo transformInfo3 = transformInfo.getFields().get(fieldName);
                    Intrinsics.checkNotNull((Object)transformInfo3);
                    TransformInfo fieldTransformInfo = transformInfo3;
                    if (accessType.ordinal() < fieldTransformInfo.getCurrentAccessType().ordinal()) {
                        fieldTransformInfo.setCurrentAccessType(accessType);
                    }
                    if (finalType.ordinal() < fieldTransformInfo.getFinal().ordinal()) {
                        fieldTransformInfo.setFinal(finalType);
                    }
                } else {
                    transformInfo.getFields().put(fieldName, new TransformInfo(accessType, finalType));
                }
                if (!AccessTransformerLoader.classTransformInfo.containsKey(className)) {
                    AccessTransformerLoader.classTransformInfo.put(className, transformInfo);
                }
            }
        } else {
            ClassTransformInfo transformInfo = classTransformInfo.get(className);
            AccessType priorityAccess = accessType;
            Final priorityFinal = finalType;
            if (transformInfo == null) {
                classTransformInfo.put(className, new ClassTransformInfo(priorityAccess, priorityFinal, null, null, 12, null));
            } else {
                if (priorityAccess.ordinal() < transformInfo.getCurrentAccessType().ordinal()) {
                    transformInfo.setCurrentAccessType(priorityAccess);
                }
                if (priorityFinal.ordinal() < transformInfo.getFinal().ordinal()) {
                    transformInfo.setFinal(priorityFinal);
                }
            }
        }
    }

    public final void runTransformers() {
        if (hasLoaded) {
            return;
        }
        long startTime = System.currentTimeMillis();
        logger.info("Adding access transformers to mixin");
        Map<String, ClassTransformInfo> $this$forEach$iv = classTransformInfo;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ClassTransformInfo>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ClassTransformInfo> element$iv;
            Map.Entry<String, ClassTransformInfo> entry = element$iv = iterator.next();
            boolean bl = false;
            String mappedClassName = entry.getKey();
            ClassTransformInfo classTransformInfo = entry.getValue();
            ClassTinkerers.addTransformation((String)mappedClassName, arg_0 -> AccessTransformerLoader.runTransformers$lambda$0$0(mappedClassName, classTransformInfo, arg_0));
        }
        logger.info("Finished loading access transformers (took " + (System.currentTimeMillis() - startTime) + "ms)");
        hasLoaded = true;
    }

    private final boolean widenAccessForVanillaClasses(List<String> split, String srgClassName, AccessWidener accessWidener) {
        block17: {
            String intermediaryClassName;
            block15: {
                Object object;
                String name;
                block20: {
                    block19: {
                        Object v2;
                        block14: {
                            block18: {
                                KiltEnhancedRemapper remapper;
                                block16: {
                                    intermediaryClassName = KiltRemapper.remapClass$default(KiltRemapper.INSTANCE, srgClassName, false, false, 6, null);
                                    remapper = KiltRemapper.INSTANCE.getEnhancedRemapper();
                                    if (split.size() <= 2 || StringsKt.startsWith$default((String)split.get(2), (String)"#", (boolean)false, (int)2, null)) break block15;
                                    if (!Intrinsics.areEqual((Object)split.get(2), (Object)"*")) break block16;
                                    EnhancedRemapper.MClass classInfo = remapper.getClass(srgClassName).orElse(null);
                                    if (classInfo == null) {
                                        logger.warn("Missing class reference (SRG: " + srgClassName + ", Intermediary: " + intermediaryClassName + ") for access transform, skipping.");
                                        return false;
                                    }
                                    for (Optional fieldOpt : classInfo.getFields()) {
                                        EnhancedRemapper.MClass.MField field;
                                        if ((EnhancedRemapper.MClass.MField)fieldOpt.orElse(null) == null) continue;
                                        accessWidener.visitField(intermediaryClassName, field.getMapped(), remapper.mapDesc(field.getDescriptor()), AccessWidenerReader.AccessType.ACCESSIBLE, true);
                                        accessWidener.visitField(intermediaryClassName, field.getMapped(), remapper.mapDesc(field.getDescriptor()), AccessWidenerReader.AccessType.MUTABLE, true);
                                    }
                                    for (Optional methodOpt : classInfo.getMethods()) {
                                        EnhancedRemapper.MClass.MMethod method;
                                        if ((EnhancedRemapper.MClass.MMethod)methodOpt.orElse(null) == null) continue;
                                        accessWidener.visitMethod(intermediaryClassName, method.getMapped(), remapper.mapMethodDesc(method.getDescriptor()), AccessWidenerReader.AccessType.ACCESSIBLE, true);
                                        accessWidener.visitMethod(intermediaryClassName, method.getMapped(), remapper.mapMethodDesc(method.getDescriptor()), AccessWidenerReader.AccessType.EXTENDABLE, true);
                                    }
                                    break block17;
                                }
                                if (!StringsKt.contains$default((CharSequence)split.get(2), (CharSequence)"(", (boolean)false, (int)2, null)) break block18;
                                Object name2 = null;
                                name2 = "";
                                Object descriptor = null;
                                descriptor = "";
                                AccessTransformerLoader $this$widenAccessForVanillaClasses_u24lambda_u240 = this;
                                boolean bl = false;
                                boolean isInDescriptor = false;
                                String string = split.get(2);
                                int n = string.length();
                                for (int i = 0; i < n; ++i) {
                                    char c = string.charAt(i);
                                    if (c == '(') {
                                        isInDescriptor = true;
                                    }
                                    if (isInDescriptor) {
                                        descriptor = "" + descriptor + c;
                                        continue;
                                    }
                                    name2 = "" + name2 + c;
                                }
                                String mappedDescriptor = KiltRemapper.remapDescriptor$default(KiltRemapper.INSTANCE, (String)descriptor, false, false, 6, null);
                                if (Intrinsics.areEqual((Object)name2, (Object)"*")) {
                                    EnhancedRemapper.MClass mClass = remapper.getClass(intermediaryClassName).orElse(null);
                                    if (mClass == null) {
                                        return false;
                                    }
                                    EnhancedRemapper.MClass cls = mClass;
                                    for (Optional methodOpt : cls.getMethods()) {
                                        methodOpt.ifPresent(arg_0 -> AccessTransformerLoader.widenAccessForVanillaClasses$lambda$2(arg_0 -> AccessTransformerLoader.widenAccessForVanillaClasses$lambda$1(mappedDescriptor, accessWidener, intermediaryClassName, arg_0), arg_0));
                                    }
                                    return true;
                                }
                                String methodName = remapper.mapMethodName(StringsKt.replace$default((String)srgClassName, (String)".", (String)"/", (boolean)false, (int)4, null), (String)name2, (String)descriptor);
                                accessWidener.visitMethod(intermediaryClassName, methodName, mappedDescriptor, AccessWidenerReader.AccessType.ACCESSIBLE, true);
                                accessWidener.visitMethod(intermediaryClassName, methodName, mappedDescriptor, AccessWidenerReader.AccessType.EXTENDABLE, true);
                                break block17;
                            }
                            name = split.get(2);
                            object = KiltRemapper.INSTANCE.getSrgIntermediaryMapping().getClass(srgClassName);
                            if (object == null || (object = object.getFields()) == null) break block19;
                            Iterable $this$firstOrNull$iv = (Iterable)object;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                IMappingFile.IField it = (IMappingFile.IField)element$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it.getOriginal(), (Object)name)) continue;
                                v2 = element$iv;
                                break block14;
                            }
                            v2 = null;
                        }
                        if ((object = (IMappingFile.IField)v2) != null) break block20;
                    }
                    return false;
                }
                Object fieldInfo = object;
                String string = fieldInfo.getDescriptor();
                if (string == null) {
                    return false;
                }
                String fieldName = KiltRemapper.INSTANCE.getEnhancedRemapper().mapFieldName(StringsKt.replace$default((String)srgClassName, (String)".", (String)"/", (boolean)false, (int)4, null), name, string);
                String string2 = fieldInfo.getDescriptor();
                Intrinsics.checkNotNull((Object)string2);
                accessWidener.visitField(intermediaryClassName, fieldName, KiltRemapper.remapDescriptor$default(KiltRemapper.INSTANCE, string2, false, false, 6, null), AccessWidenerReader.AccessType.ACCESSIBLE, true);
                String string3 = fieldInfo.getDescriptor();
                Intrinsics.checkNotNull((Object)string3);
                accessWidener.visitField(intermediaryClassName, fieldName, KiltRemapper.remapDescriptor$default(KiltRemapper.INSTANCE, string3, false, false, 6, null), AccessWidenerReader.AccessType.MUTABLE, true);
                break block17;
            }
            accessWidener.visitClass(intermediaryClassName, AccessWidenerReader.AccessType.ACCESSIBLE, true);
            accessWidener.visitClass(intermediaryClassName, AccessWidenerReader.AccessType.EXTENDABLE, true);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final void runTransformers$lambda$0$0(String $mappedClassName, ClassTransformInfo $classTransformInfo, ClassNode classNode) {
        int n;
        Iterable element$iv;
        Map.Entry entry;
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        INSTANCE.println("access transforming class " + $mappedClassName);
        if ($classTransformInfo.getCurrentAccessType() != AccessType.DEFAULT) {
            $this$forEach$iv = AccessType.values();
            $i$f$forEach = false;
            int n2 = ((AccessType[])$this$forEach$iv).length;
            for (int i = 0; i < n2; ++i) {
                Object element$iv2;
                Object accessType = element$iv2 = $this$forEach$iv[i];
                boolean bl = false;
                classNode.access &= ~((AccessType)((Object)accessType)).getFlag();
            }
            classNode.access |= $classTransformInfo.getCurrentAccessType().getFlag();
            INSTANCE.println("set class to access type " + $classTransformInfo.getCurrentAccessType().name());
        }
        if ($classTransformInfo.getFinal() != Final.DEFAULT) {
            classNode.access = $classTransformInfo.getFinal() == Final.ADD ? classNode.access | 0x10 : classNode.access & 0xFFFFFFEF;
            INSTANCE.println("set class to final type " + $classTransformInfo.getFinal().name());
        }
        $this$forEach$iv = $classTransformInfo.getFields();
        $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            AccessType accessType;
            AccessType element$iv3;
            AccessType[] $this$forEach$iv2;
            Iterable $this$forEach$iv3;
            int n3;
            Iterator $this$filterTo$iv$iv;
            Map.Entry element$iv4;
            entry = element$iv4 = iterator.next();
            boolean bl = false;
            String fieldName = (String)entry.getKey();
            TransformInfo fieldTransformInfo = (TransformInfo)entry.getValue();
            String mappedFieldName = fieldName;
            INSTANCE.println("transforming field " + mappedFieldName);
            List list = classNode.fields;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fields");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                FieldNode it = (FieldNode)element$iv$iv;
                n3 = 0;
                if (!(Intrinsics.areEqual((Object)it.name, (Object)mappedFieldName) || Intrinsics.areEqual((Object)mappedFieldName, (Object)"*"))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            $this$filterTo$iv$iv = $this$forEach$iv3.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                element$iv = $this$filterTo$iv$iv.next();
                FieldNode fieldNode = (FieldNode)element$iv;
                boolean bl2 = false;
                if (fieldTransformInfo.getCurrentAccessType() != AccessType.DEFAULT) {
                    $this$forEach$iv2 = AccessType.values();
                    boolean $i$f$forEach3 = false;
                    n = $this$forEach$iv2.length;
                    for (n3 = 0; n3 < n; ++n3) {
                        accessType = element$iv3 = $this$forEach$iv2[n3];
                        boolean bl3 = false;
                        fieldNode.access &= ~accessType.getFlag();
                    }
                    fieldNode.access |= fieldTransformInfo.getCurrentAccessType().getFlag();
                    INSTANCE.println("set field to access type " + fieldTransformInfo.getCurrentAccessType().name());
                }
                if (fieldTransformInfo.getFinal() == Final.DEFAULT) continue;
                fieldNode.access = fieldTransformInfo.getFinal() == Final.ADD ? (fieldNode.access |= 0x10) : (fieldNode.access &= 0xFFFFFFEF);
                INSTANCE.println("set field to final type " + fieldTransformInfo.getFinal().name());
            }
            if (!Intrinsics.areEqual((Object)mappedFieldName, (Object)"*")) continue;
            List list2 = classNode.methods;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"methods");
            $this$forEach$iv3 = list2;
            $i$f$forEach2 = false;
            $this$filterTo$iv$iv = $this$forEach$iv3.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                element$iv = $this$filterTo$iv$iv.next();
                MethodNode methodNode = (MethodNode)element$iv;
                boolean bl4 = false;
                if (fieldTransformInfo.getCurrentAccessType() != AccessType.DEFAULT) {
                    $this$forEach$iv2 = AccessType.values();
                    boolean $i$f$forEach4 = false;
                    n = $this$forEach$iv2.length;
                    for (n3 = 0; n3 < n; ++n3) {
                        accessType = element$iv3 = $this$forEach$iv2[n3];
                        boolean bl5 = false;
                        methodNode.access &= ~accessType.getFlag();
                    }
                    methodNode.access |= fieldTransformInfo.getCurrentAccessType().getFlag();
                    INSTANCE.println("set method to access type " + fieldTransformInfo.getCurrentAccessType().name());
                }
                if (fieldTransformInfo.getFinal() == Final.DEFAULT) continue;
                methodNode.access = fieldTransformInfo.getFinal() == Final.ADD ? (methodNode.access |= 0x10) : (methodNode.access &= 0xFFFFFFEF);
                INSTANCE.println("set method to final type " + fieldTransformInfo.getFinal().name());
            }
        }
        $this$forEach$iv = $classTransformInfo.getMethods();
        $i$f$forEach = false;
        for (Map.Entry element$iv5 : $this$forEach$iv.entrySet()) {
            void $this$forEach$iv4;
            void $this$filterTo$iv$iv;
            entry = element$iv5;
            boolean bl = false;
            Pair pair = (Pair)entry.getKey();
            TransformInfo methodTransformInfo = (TransformInfo)entry.getValue();
            String mappedMethodName = (String)pair.getFirst();
            String mappedDescriptor = (String)pair.getSecond();
            INSTANCE.println("transforming method " + mappedMethodName + mappedDescriptor);
            List list = classNode.methods;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"methods");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            element$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MethodNode it = (MethodNode)element$iv$iv;
                boolean bl6 = false;
                if (!((Intrinsics.areEqual((Object)it.name, (Object)mappedMethodName) || Intrinsics.areEqual((Object)it.name, (Object)"*")) && Intrinsics.areEqual((Object)it.desc, (Object)mappedDescriptor))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach5 = false;
            for (Object element$iv6 : $this$forEach$iv4) {
                MethodNode methodNode = (MethodNode)element$iv6;
                boolean bl7 = false;
                if (methodTransformInfo.getCurrentAccessType() != AccessType.DEFAULT) {
                    AccessType[] $this$forEach$iv5 = AccessType.values();
                    boolean $i$f$forEach6 = false;
                    int n4 = $this$forEach$iv5.length;
                    for (n = 0; n < n4; ++n) {
                        AccessType element$iv7;
                        AccessType accessType = element$iv7 = $this$forEach$iv5[n];
                        boolean bl8 = false;
                        methodNode.access &= ~accessType.getFlag();
                    }
                    methodNode.access |= methodTransformInfo.getCurrentAccessType().getFlag();
                    INSTANCE.println("set method to access type " + methodTransformInfo.getCurrentAccessType().name());
                }
                if (methodTransformInfo.getFinal() == Final.DEFAULT) continue;
                methodNode.access = methodTransformInfo.getFinal() == Final.ADD ? (methodNode.access |= 0x10) : (methodNode.access &= 0xFFFFFFEF);
                INSTANCE.println("set method to final type " + methodTransformInfo.getFinal().name());
            }
        }
    }

    private static final Unit widenAccessForVanillaClasses$lambda$1(String $mappedDescriptor, AccessWidener $accessWidener, String $intermediaryClassName, EnhancedRemapper.MClass.MMethod it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Intrinsics.areEqual((Object)it.getDescriptor(), (Object)$mappedDescriptor)) {
            return Unit.INSTANCE;
        }
        $accessWidener.visitMethod($intermediaryClassName, it.getMapped(), $mappedDescriptor, AccessWidenerReader.AccessType.ACCESSIBLE, true);
        $accessWidener.visitMethod($intermediaryClassName, it.getMapped(), $mappedDescriptor, AccessWidenerReader.AccessType.EXTENDABLE, true);
        return Unit.INSTANCE;
    }

    private static final void widenAccessForVanillaClasses$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        classTransformInfo = new LinkedHashMap();
        whitespace = Pattern.compile("[ \t]+");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\b\n\u0002\b\f\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$AccessType;", "", "", "flag", "<init>", "(Ljava/lang/String;II)V", "I", "getFlag", "()I", "PUBLIC", "PROTECTED", "PACKAGE_PRIVATE", "PRIVATE", "DEFAULT", "Kilt"})
    private static final class AccessType
    extends Enum<AccessType> {
        private final int flag;
        public static final /* enum */ AccessType PUBLIC = new AccessType(1);
        public static final /* enum */ AccessType PROTECTED = new AccessType(4);
        public static final /* enum */ AccessType PACKAGE_PRIVATE = new AccessType(0);
        public static final /* enum */ AccessType PRIVATE = new AccessType(2);
        public static final /* enum */ AccessType DEFAULT = new AccessType(0);
        private static final /* synthetic */ AccessType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private AccessType(int flag) {
            this.flag = flag;
        }

        public final int getFlag() {
            return this.flag;
        }

        public static AccessType[] values() {
            return (AccessType[])$VALUES.clone();
        }

        public static AccessType valueOf(String value) {
            return Enum.valueOf(AccessType.class, value);
        }

        @NotNull
        public static EnumEntries<AccessType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = accessTypeArray = new AccessType[]{AccessType.PUBLIC, AccessType.PROTECTED, AccessType.PACKAGE_PRIVATE, AccessType.PRIVATE, AccessType.DEFAULT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\b\u0082\b\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012 \b\u0002\u0010\u000b\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J(\u0010\u0014\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0013J\\\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062 \b\u0002\u0010\u000b\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0019\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0007H\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\u000f\"\u0004\b\"\u0010#R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010$\u001a\u0004\b%\u0010\u0011\"\u0004\b&\u0010'R#\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010(\u001a\u0004\b)\u0010\u0013R/\u0010\u000b\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n\u0012\u0004\u0012\u00020\b0\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010(\u001a\u0004\b*\u0010\u0013\u00a8\u0006+"}, d2={"Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$ClassTransformInfo;", "", "Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$AccessType;", "currentAccessType", "Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$Final;", "final", "", "", "Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$TransformInfo;", "fields", "Lkotlin/Pair;", "methods", "<init>", "(Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$AccessType;Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$Final;Ljava/util/Map;Ljava/util/Map;)V", "component1", "()Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$AccessType;", "component2", "()Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$Final;", "component3", "()Ljava/util/Map;", "component4", "copy", "(Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$AccessType;Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$Final;Ljava/util/Map;Ljava/util/Map;)Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$ClassTransformInfo;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$AccessType;", "getCurrentAccessType", "setCurrentAccessType", "(Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$AccessType;)V", "Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$Final;", "getFinal", "setFinal", "(Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$Final;)V", "Ljava/util/Map;", "getFields", "getMethods", "Kilt"})
    private static final class ClassTransformInfo {
        @NotNull
        private AccessType currentAccessType;
        @NotNull
        private Final final;
        @NotNull
        private final Map<String, TransformInfo> fields;
        @NotNull
        private final Map<Pair<String, String>, TransformInfo> methods;

        public ClassTransformInfo(@NotNull AccessType currentAccessType, @NotNull Final final_, @NotNull Map<String, TransformInfo> fields, @NotNull Map<Pair<String, String>, TransformInfo> methods) {
            Intrinsics.checkNotNullParameter((Object)((Object)currentAccessType), (String)"currentAccessType");
            Intrinsics.checkNotNullParameter((Object)((Object)final_), (String)"final");
            Intrinsics.checkNotNullParameter(fields, (String)"fields");
            Intrinsics.checkNotNullParameter(methods, (String)"methods");
            this.currentAccessType = currentAccessType;
            this.final = final_;
            this.fields = fields;
            this.methods = methods;
        }

        public /* synthetic */ ClassTransformInfo(AccessType accessType, Final final_, Map map, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                map = new LinkedHashMap();
            }
            if ((n & 8) != 0) {
                map2 = new LinkedHashMap();
            }
            this(accessType, final_, map, map2);
        }

        @NotNull
        public final AccessType getCurrentAccessType() {
            return this.currentAccessType;
        }

        public final void setCurrentAccessType(@NotNull AccessType accessType) {
            Intrinsics.checkNotNullParameter((Object)((Object)accessType), (String)"<set-?>");
            this.currentAccessType = accessType;
        }

        @NotNull
        public final Final getFinal() {
            return this.final;
        }

        public final void setFinal(@NotNull Final final_) {
            Intrinsics.checkNotNullParameter((Object)((Object)final_), (String)"<set-?>");
            this.final = final_;
        }

        @NotNull
        public final Map<String, TransformInfo> getFields() {
            return this.fields;
        }

        @NotNull
        public final Map<Pair<String, String>, TransformInfo> getMethods() {
            return this.methods;
        }

        @NotNull
        public final AccessType component1() {
            return this.currentAccessType;
        }

        @NotNull
        public final Final component2() {
            return this.final;
        }

        @NotNull
        public final Map<String, TransformInfo> component3() {
            return this.fields;
        }

        @NotNull
        public final Map<Pair<String, String>, TransformInfo> component4() {
            return this.methods;
        }

        @NotNull
        public final ClassTransformInfo copy(@NotNull AccessType currentAccessType, @NotNull Final final_, @NotNull Map<String, TransformInfo> fields, @NotNull Map<Pair<String, String>, TransformInfo> methods) {
            Intrinsics.checkNotNullParameter((Object)((Object)currentAccessType), (String)"currentAccessType");
            Intrinsics.checkNotNullParameter((Object)((Object)final_), (String)"final");
            Intrinsics.checkNotNullParameter(fields, (String)"fields");
            Intrinsics.checkNotNullParameter(methods, (String)"methods");
            return new ClassTransformInfo(currentAccessType, final_, fields, methods);
        }

        public static /* synthetic */ ClassTransformInfo copy$default(ClassTransformInfo classTransformInfo, AccessType accessType, Final final_, Map map, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                accessType = classTransformInfo.currentAccessType;
            }
            if ((n & 2) != 0) {
                final_ = classTransformInfo.final;
            }
            if ((n & 4) != 0) {
                map = classTransformInfo.fields;
            }
            if ((n & 8) != 0) {
                map2 = classTransformInfo.methods;
            }
            return classTransformInfo.copy(accessType, final_, map, map2);
        }

        @NotNull
        public String toString() {
            return "ClassTransformInfo(currentAccessType=" + this.currentAccessType + ", final=" + this.final + ", fields=" + this.fields + ", methods=" + this.methods + ")";
        }

        public int hashCode() {
            int result = this.currentAccessType.hashCode();
            result = result * 31 + this.final.hashCode();
            result = result * 31 + ((Object)this.fields).hashCode();
            result = result * 31 + ((Object)this.methods).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassTransformInfo)) {
                return false;
            }
            ClassTransformInfo classTransformInfo = (ClassTransformInfo)other;
            if (this.currentAccessType != classTransformInfo.currentAccessType) {
                return false;
            }
            if (this.final != classTransformInfo.final) {
                return false;
            }
            if (!Intrinsics.areEqual(this.fields, classTransformInfo.fields)) {
                return false;
            }
            return Intrinsics.areEqual(this.methods, classTransformInfo.methods);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$Final;", "", "<init>", "(Ljava/lang/String;I)V", "REMOVE", "ADD", "DEFAULT", "Kilt"})
    private static final class Final
    extends Enum<Final> {
        public static final /* enum */ Final REMOVE = new Final();
        public static final /* enum */ Final ADD = new Final();
        public static final /* enum */ Final DEFAULT = new Final();
        private static final /* synthetic */ Final[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Final[] values() {
            return (Final[])$VALUES.clone();
        }

        public static Final valueOf(String value) {
            return Enum.valueOf(Final.class, value);
        }

        @NotNull
        public static EnumEntries<Final> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = finalArray = new Final[]{Final.REMOVE, Final.ADD, Final.DEFAULT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\t\"\u0004\b\u001a\u0010\u001bR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\u000b\"\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$TransformInfo;", "", "Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$AccessType;", "currentAccessType", "Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$Final;", "final", "<init>", "(Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$AccessType;Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$Final;)V", "component1", "()Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$AccessType;", "component2", "()Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$Final;", "copy", "(Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$AccessType;Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$Final;)Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$TransformInfo;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$AccessType;", "getCurrentAccessType", "setCurrentAccessType", "(Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$AccessType;)V", "Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$Final;", "getFinal", "setFinal", "(Lxyz/bluspring/kilt/loader/asm/AccessTransformerLoader$Final;)V", "Kilt"})
    private static final class TransformInfo {
        @NotNull
        private AccessType currentAccessType;
        @NotNull
        private Final final;

        public TransformInfo(@NotNull AccessType currentAccessType, @NotNull Final final_) {
            Intrinsics.checkNotNullParameter((Object)((Object)currentAccessType), (String)"currentAccessType");
            Intrinsics.checkNotNullParameter((Object)((Object)final_), (String)"final");
            this.currentAccessType = currentAccessType;
            this.final = final_;
        }

        @NotNull
        public final AccessType getCurrentAccessType() {
            return this.currentAccessType;
        }

        public final void setCurrentAccessType(@NotNull AccessType accessType) {
            Intrinsics.checkNotNullParameter((Object)((Object)accessType), (String)"<set-?>");
            this.currentAccessType = accessType;
        }

        @NotNull
        public final Final getFinal() {
            return this.final;
        }

        public final void setFinal(@NotNull Final final_) {
            Intrinsics.checkNotNullParameter((Object)((Object)final_), (String)"<set-?>");
            this.final = final_;
        }

        @NotNull
        public final AccessType component1() {
            return this.currentAccessType;
        }

        @NotNull
        public final Final component2() {
            return this.final;
        }

        @NotNull
        public final TransformInfo copy(@NotNull AccessType currentAccessType, @NotNull Final final_) {
            Intrinsics.checkNotNullParameter((Object)((Object)currentAccessType), (String)"currentAccessType");
            Intrinsics.checkNotNullParameter((Object)((Object)final_), (String)"final");
            return new TransformInfo(currentAccessType, final_);
        }

        public static /* synthetic */ TransformInfo copy$default(TransformInfo transformInfo, AccessType accessType, Final final_, int n, Object object) {
            if ((n & 1) != 0) {
                accessType = transformInfo.currentAccessType;
            }
            if ((n & 2) != 0) {
                final_ = transformInfo.final;
            }
            return transformInfo.copy(accessType, final_);
        }

        @NotNull
        public String toString() {
            return "TransformInfo(currentAccessType=" + this.currentAccessType + ", final=" + this.final + ")";
        }

        public int hashCode() {
            int result = this.currentAccessType.hashCode();
            result = result * 31 + this.final.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TransformInfo)) {
                return false;
            }
            TransformInfo transformInfo = (TransformInfo)other;
            if (this.currentAccessType != transformInfo.currentAccessType) {
                return false;
            }
            return this.final == transformInfo.final;
        }
    }
}

