/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.kilt.loader.asm.coremod;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.fabricmc.loader.impl.gui.FabricGuiEntry;
import net.fabricmc.loader.impl.gui.FabricStatusTree;
import org.jetbrains.annotations.NotNull;
import xyz.bluspring.kilt.loader.KiltFlags;
import xyz.bluspring.kilt.loader.asm.coremod.CoreMod;
import xyz.bluspring.kilt.loader.mod.ForgeMod;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u0010\u0010\u000eR\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0018\u001a\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lxyz/bluspring/kilt/loader/asm/coremod/CoreModLoader;", "", "<init>", "()V", "Lxyz/bluspring/kilt/loader/mod/ForgeMod;", "mod", "", "scanAndLoadCoreMods", "(Lxyz/bluspring/kilt/loader/mod/ForgeMod;)V", "", "", "ALLOWED_PACKAGES", "Ljava/util/Set;", "getALLOWED_PACKAGES", "()Ljava/util/Set;", "ALLOWED_CLASSES", "getALLOWED_CLASSES", "", "Lxyz/bluspring/kilt/loader/asm/coremod/CoreMod;", "loadedCoreMods", "Ljava/util/List;", "getLoadedCoreMods", "()Ljava/util/List;", "", "enableCoreMods", "Z", "getEnableCoreMods", "()Z", "Kilt"})
public final class CoreModLoader {
    @NotNull
    public static final CoreModLoader INSTANCE = new CoreModLoader();
    @NotNull
    private static final Set<String> ALLOWED_PACKAGES;
    @NotNull
    private static final Set<String> ALLOWED_CLASSES;
    @NotNull
    private static final List<CoreMod> loadedCoreMods;
    private static final boolean enableCoreMods;

    private CoreModLoader() {
    }

    @NotNull
    public final Set<String> getALLOWED_PACKAGES() {
        return ALLOWED_PACKAGES;
    }

    @NotNull
    public final Set<String> getALLOWED_CLASSES() {
        return ALLOWED_CLASSES;
    }

    @NotNull
    public final List<CoreMod> getLoadedCoreMods() {
        return loadedCoreMods;
    }

    public final boolean getEnableCoreMods() {
        return enableCoreMods;
    }

    public final void scanAndLoadCoreMods(@NotNull ForgeMod mod) {
        Intrinsics.checkNotNullParameter((Object)((Object)mod), (String)"mod");
        if (!enableCoreMods) {
            return;
        }
        try {
            InputStream entry = mod.getFile("META-INF/coremods.json");
            if (entry != null) {
                InputStream inputStream = entry;
                Charset charset = Charsets.UTF_8;
                Reader reader = new InputStreamReader(inputStream, charset);
                int n = 8192;
                JsonObject json = JsonParser.parseReader((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))).getAsJsonObject();
                for (String key : json.keySet()) {
                    String filePath = json.get(key).getAsString();
                    Intrinsics.checkNotNull((Object)key);
                    Intrinsics.checkNotNull((Object)filePath);
                    CoreMod coreMod = new CoreMod(mod, key, filePath);
                    coreMod.init();
                    mod.getCoreMods().add(coreMod);
                    loadedCoreMods.add(coreMod);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FabricGuiEntry.displayError((String)("Failed to load coremods in " + mod.getDisplayName() + " (" + mod.getModId() + ")!"), (Throwable)e, CoreModLoader::scanAndLoadCoreMods$lambda$0, (boolean)true);
        }
    }

    private static final void scanAndLoadCoreMods$lambda$0(FabricStatusTree it) {
        FabricStatusTree.FabricStatusTab tab = it.addTab("Kilt Error");
        it.tabs.removeIf(arg_0 -> CoreModLoader.scanAndLoadCoreMods$lambda$0$1(arg_0 -> CoreModLoader.scanAndLoadCoreMods$lambda$0$0(tab, arg_0), arg_0));
    }

    private static final boolean scanAndLoadCoreMods$lambda$0$0(FabricStatusTree.FabricStatusTab $tab, FabricStatusTree.FabricStatusTab t) {
        return !Intrinsics.areEqual((Object)t, (Object)$tab);
    }

    private static final boolean scanAndLoadCoreMods$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new String[]{"java.util", "java.util.function", "org.objectweb.asm.util"};
        ALLOWED_PACKAGES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"net.minecraftforge.coremod.api.ASMAPI", "org.objectweb.asm.Opcodes", "org.objectweb.asm.tree.AbstractInsnNode", "org.objectweb.asm.tree.FieldInsnNode", "org.objectweb.asm.tree.FrameNode", "org.objectweb.asm.tree.IincInsnNode", "org.objectweb.asm.tree.InsnNode", "org.objectweb.asm.tree.IntInsnNode", "org.objectweb.asm.tree.InsnList", "org.objectweb.asm.tree.InvokeDynamicInsnNode", "org.objectweb.asm.tree.JumpInsnNode", "org.objectweb.asm.tree.LabelNode", "org.objectweb.asm.tree.LdcInsnNode", "org.objectweb.asm.tree.LineNumberNode", "org.objectweb.asm.tree.LocalVariableAnnotationNode", "org.objectweb.asm.tree.LocalVariableNode", "org.objectweb.asm.tree.LookupSwitchInsnNode", "org.objectweb.asm.tree.MethodInsnNode", "org.objectweb.asm.tree.MultiANewArrayInsnNode", "org.objectweb.asm.tree.TableSwitchInsnNode", "org.objectweb.asm.tree.TryCatchBlockNode", "org.objectweb.asm.tree.TypeAnnotationNode", "org.objectweb.asm.tree.TypeInsnNode", "org.objectweb.asm.tree.VarInsnNode", "org.objectweb.asm.tree.FieldNode", "org.objectweb.asm.tree.MethodNode", "org.objectweb.asm.tree.ParameterNode", "org.objectweb.asm.Attribute", "org.objectweb.asm.Handle", "org.objectweb.asm.Label", "org.objectweb.asm.Type", "org.objectweb.asm.TypePath", "org.objectweb.asm.TypeReference", "xyz.bluspring.kilt.loader.asm.coremod.CoreModHelper", "xyz.bluspring.kilt.loader.asm.coremod.RemappingFieldInsnNode", "xyz.bluspring.kilt.loader.asm.coremod.RemappingMethodInsnNode"};
        ALLOWED_CLASSES = SetsKt.setOf((Object[])objectArray);
        loadedCoreMods = new ArrayList();
        enableCoreMods = KiltFlags.DISABLE_COREMODS;
    }
}

