/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.kilt.loader.remap.fixers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import xyz.bluspring.kilt.api.remapping.InsnConflictRemapProvider;
import xyz.bluspring.kilt.loader.remap.KiltRemapper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\"\u0010\f\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u001c\u0010\u000f\u001a\n \u000b*\u0004\u0018\u00010\u000e0\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R\u001c\u0010\u0015\u001a\n \u000b*\u0004\u0018\u00010\u00110\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lxyz/bluspring/kilt/loader/remap/fixers/WorkaroundFixer;", "", "<init>", "()V", "Lorg/objectweb/asm/tree/ClassNode;", "classNode", "", "fixClass", "(Lorg/objectweb/asm/tree/ClassNode;)V", "", "Lxyz/bluspring/kilt/api/remapping/InsnConflictRemapProvider;", "kotlin.jvm.PlatformType", "insnConflictRemapProviders", "Ljava/util/List;", "Lnet/fabricmc/loader/api/MappingResolver;", "mappingResolver", "Lnet/fabricmc/loader/api/MappingResolver;", "", "customSlotMapped", "Ljava/lang/String;", "minecraftMapped", "mcGuiMapped", "Kilt"})
@SourceDebugExtension(value={"SMAP\nWorkaroundFixer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkaroundFixer.kt\nxyz/bluspring/kilt/loader/remap/fixers/WorkaroundFixer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1761#2,3:113\n*S KotlinDebug\n*F\n+ 1 WorkaroundFixer.kt\nxyz/bluspring/kilt/loader/remap/fixers/WorkaroundFixer\n*L\n109#1:113,3\n*E\n"})
public final class WorkaroundFixer {
    @NotNull
    public static final WorkaroundFixer INSTANCE = new WorkaroundFixer();
    @NotNull
    private static final List<InsnConflictRemapProvider> insnConflictRemapProviders;
    private static final MappingResolver mappingResolver;
    @NotNull
    private static final String customSlotMapped;
    @NotNull
    private static final String minecraftMapped;
    private static final String mcGuiMapped;

    private WorkaroundFixer() {
    }

    public final void fixClass(@NotNull ClassNode classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        List methodReplace = new ArrayList();
        for (MethodNode method : classNode.methods) {
            Iterator<Object> iterator;
            Map newNodeMap = new LinkedHashMap();
            Intrinsics.checkNotNullExpressionValue((Object)method.instructions.iterator(), (String)"iterator(...)");
            block1: while (iterator.hasNext()) {
                AbstractInsnNode insnNode = (AbstractInsnNode)iterator.next();
                if (insnNode instanceof MethodInsnNode) {
                    for (InsnConflictRemapProvider insnConflictRemapProvider : insnConflictRemapProviders) {
                        String string = ((MethodInsnNode)insnNode).owner;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"owner");
                        String string2 = ((MethodInsnNode)insnNode).name;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                        String string3 = ((MethodInsnNode)insnNode).desc;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"desc");
                        String remapped = insnConflictRemapProvider.remapMethod(string, string2, string3);
                        if (Intrinsics.areEqual((Object)remapped, (Object)((MethodInsnNode)insnNode).name)) continue;
                        KiltRemapper.INSTANCE.getLogger$Kilt().debug("Provider " + insnConflictRemapProvider.getClass().getName() + " remapped method " + ((MethodInsnNode)insnNode).owner + "#" + ((MethodInsnNode)insnNode).name + ((MethodInsnNode)insnNode).desc + " to " + remapped);
                        MethodInsnNode node = new MethodInsnNode(((MethodInsnNode)insnNode).getOpcode(), ((MethodInsnNode)insnNode).owner, remapped, ((MethodInsnNode)insnNode).desc);
                        newNodeMap.put(insnNode, node);
                        continue block1;
                    }
                } else if (insnNode instanceof FieldInsnNode) {
                    for (InsnConflictRemapProvider insnConflictRemapProvider : insnConflictRemapProviders) {
                        String string = ((FieldInsnNode)insnNode).owner;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"owner");
                        String string4 = ((FieldInsnNode)insnNode).name;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"name");
                        String string5 = ((FieldInsnNode)insnNode).desc;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"desc");
                        String remapped = insnConflictRemapProvider.remapField(string, string4, string5);
                        if (Intrinsics.areEqual((Object)remapped, (Object)((FieldInsnNode)insnNode).name)) continue;
                        KiltRemapper.INSTANCE.getLogger$Kilt().debug("Provider " + insnConflictRemapProvider.getClass().getName() + " remapped field " + ((FieldInsnNode)insnNode).owner + "#" + ((FieldInsnNode)insnNode).name + ((FieldInsnNode)insnNode).desc + " to " + remapped);
                        FieldInsnNode node = new FieldInsnNode(((FieldInsnNode)insnNode).getOpcode(), ((FieldInsnNode)insnNode).owner, remapped, ((FieldInsnNode)insnNode).desc);
                        newNodeMap.put(insnNode, node);
                        continue block1;
                    }
                } else if (insnNode instanceof InvokeDynamicInsnNode) {
                    Object[] newArgs = new Object[((InvokeDynamicInsnNode)insnNode).bsmArgs.length];
                    Intrinsics.checkNotNullExpressionValue((Object)((InvokeDynamicInsnNode)insnNode).bsmArgs, (String)"bsmArgs");
                    Object[] objectArray = ((InvokeDynamicInsnNode)insnNode).bsmArgs;
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        int i2 = i;
                        Object arg = objectArray[i];
                        if (arg instanceof Handle) {
                            String newName = ((Handle)arg).getName();
                            for (InsnConflictRemapProvider provider2 : insnConflictRemapProviders) {
                                String string = ((Handle)arg).getOwner();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOwner(...)");
                                String string6 = ((Handle)arg).getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
                                String string7 = ((Handle)arg).getDesc();
                                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getDesc(...)");
                                String remapped = provider2.remapMethod(string, string6, string7);
                                if (Intrinsics.areEqual((Object)remapped, (Object)((Handle)arg).getName())) continue;
                                KiltRemapper.INSTANCE.getLogger$Kilt().debug("Provider " + provider2.getClass().getName() + " remapped dynamic method " + ((Handle)arg).getOwner() + "#" + ((Handle)arg).getName() + ((Handle)arg).getDesc() + " to " + remapped);
                                newName = remapped;
                                break;
                            }
                            if (!Intrinsics.areEqual((Object)newName, (Object)((Handle)arg).getName())) {
                                newArgs[i2] = new Handle(((Handle)arg).getTag(), ((Handle)arg).getOwner(), newName, ((Handle)arg).getDesc(), ((Handle)arg).isInterface());
                                continue;
                            }
                        }
                        newArgs[i2] = arg;
                    }
                    ((InvokeDynamicInsnNode)insnNode).bsmArgs = newArgs;
                }
                if (insnNode instanceof FieldInsnNode && Intrinsics.areEqual((Object)((FieldInsnNode)insnNode).owner, (Object)minecraftMapped)) {
                    AbstractInsnNode followingInsn;
                    if (!Intrinsics.areEqual((Object)((FieldInsnNode)insnNode).name, (Object)"f_91065_") && !Intrinsics.areEqual((Object)((FieldInsnNode)insnNode).name, (Object)mcGuiMapped) && !Intrinsics.areEqual((Object)((FieldInsnNode)insnNode).name, (Object)"gui") || (followingInsn = method.instructions.get(method.instructions.indexOf(insnNode) + 1)).getOpcode() != 192 || !(followingInsn instanceof TypeInsnNode) || !Intrinsics.areEqual((Object)((TypeInsnNode)followingInsn).desc, (Object)"net/minecraftforge/client/gui/overlay/ForgeGui")) continue;
                    newNodeMap.put(insnNode, new FieldInsnNode(180, ((FieldInsnNode)insnNode).owner, "kilt$forgeGui", ((FieldInsnNode)insnNode).desc));
                    continue;
                }
                if (insnNode instanceof MethodInsnNode && Intrinsics.areEqual((Object)((MethodInsnNode)insnNode).owner, (Object)"java/lang/System") && Intrinsics.areEqual((Object)((MethodInsnNode)insnNode).name, (Object)"exit") && Intrinsics.areEqual((Object)((MethodInsnNode)insnNode).desc, (Object)"(I)V")) {
                    newNodeMap.put(insnNode, new MethodInsnNode(184, "xyz/bluspring/kilt/util/KiltHelper", "handleSystemExit", ((MethodInsnNode)insnNode).desc));
                    continue;
                }
                if (!(insnNode instanceof TypeInsnNode) || ((TypeInsnNode)insnNode).getOpcode() != 193 || !Intrinsics.areEqual((Object)((TypeInsnNode)insnNode).desc, (Object)"org/violetmoon/quark/mixin/mixins/client/accessor/AccessorCustomCreativeSlot")) continue;
                newNodeMap.put(insnNode, new TypeInsnNode(193, customSlotMapped));
            }
            if (!(!newNodeMap.isEmpty())) continue;
            iterator = newNodeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                AbstractInsnNode oldNode = (AbstractInsnNode)entry.getKey();
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)entry.getValue();
                method.instructions.set(oldNode, abstractInsnNode);
            }
            Intrinsics.checkNotNull((Object)method);
            methodReplace.add(method);
        }
        classNode.methods.removeIf(arg_0 -> WorkaroundFixer.fixClass$lambda$1(arg_0 -> WorkaroundFixer.fixClass$lambda$0(methodReplace, arg_0), arg_0));
        classNode.methods.addAll(methodReplace);
    }

    private static final boolean fixClass$lambda$0(List $methodReplace, MethodNode it) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $methodReplace;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MethodNode a = (MethodNode)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.name, (Object)a.name) && Intrinsics.areEqual((Object)a.desc, (Object)it.desc))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean fixClass$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        ServiceLoader<InsnConflictRemapProvider> serviceLoader = ServiceLoader.load(InsnConflictRemapProvider.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
        insnConflictRemapProviders = CollectionsKt.toList((Iterable)serviceLoader);
        mappingResolver = FabricLoader.getInstance().getMappingResolver();
        customSlotMapped = KiltRemapper.remapClass$default(KiltRemapper.INSTANCE, "net/minecraft/client/gui/screens/inventory/CreativeModeInventoryScreen$CustomCreativeSlot", false, false, 6, null);
        minecraftMapped = KiltRemapper.remapClass$default(KiltRemapper.INSTANCE, "net/minecraft/client/Minecraft", false, false, 6, null);
        mcGuiMapped = mappingResolver.mapFieldName("intermediary", "net.minecraft.class_310", "field_1705", "Lnet/minecraft/class_329;");
    }
}

