/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.kilt.util;

import com.chocohead.mm.CasualStreamHandler;
import com.chocohead.mm.api.ClassTinkerers;
import java.net.URL;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.bluspring.kilt.Kilt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jk\u0010\u0012\u001a\u00028\u0000\"\f\b\u0000\u0010\u0005*\u0006\u0012\u0002\b\u00030\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\b2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u00000\f2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00100\u000fH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lxyz/bluspring/kilt/util/EnumUtils;", "", "<init>", "()V", "", "T", "Ljava/lang/Class;", "clazz", "", "values", "", "name", "Ljava/util/function/Function;", "", "createValue", "Ljava/util/function/Consumer;", "", "setValues", "addEnumToClass", "(Ljava/lang/Class;[Ljava/lang/Enum;Ljava/lang/String;Ljava/util/function/Function;Ljava/util/function/Consumer;)Ljava/lang/Enum;", "", "byteArray", "loadClass", "(Ljava/lang/String;[B)Ljava/lang/Class;", "Kilt"})
public final class EnumUtils {
    @NotNull
    public static final EnumUtils INSTANCE = new EnumUtils();

    private EnumUtils() {
    }

    @JvmStatic
    @NotNull
    public static final <T extends Enum<?>> T addEnumToClass(@NotNull Class<T> clazz, @NotNull T[] values, @NotNull String name, @NotNull Function<Integer, T> createValue, @NotNull Consumer<List<T>> setValues) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(createValue, (String)"createValue");
        Intrinsics.checkNotNullParameter(setValues, (String)"setValues");
        List list = ArraysKt.toMutableList((Object[])values);
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            T enumValue = values[i];
            if (!StringsKt.equals((String)((Enum)enumValue).name(), (String)name, (boolean)true)) continue;
            return enumValue;
        }
        T t = createValue.apply(values.length);
        Intrinsics.checkNotNullExpressionValue(t, (String)"apply(...)");
        Enum value = (Enum)t;
        if (value instanceof IExtensibleEnum) {
            ((IExtensibleEnum)((Object)value)).init();
        }
        list.add(value);
        setValues.accept(list);
        try {
            UnsafeHacks.cleanEnumCache(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)value;
    }

    @JvmStatic
    @Nullable
    public static final Class<?> loadClass(@NotNull String name, @NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        try {
            String className = StringsKt.replace$default((String)name, (String)"/", (String)".", (boolean)false, (int)4, null);
            URL url = CasualStreamHandler.create((String)className, (byte[])byteArray);
            if (ClassTinkerers.addURL((URL)url)) {
                return Class.forName(className);
            }
            return null;
        }
        catch (Exception e) {
            Kilt.Companion.getLogger().error("Failed to dynamically load class " + name + "!");
            e.printStackTrace();
            return null;
        }
    }
}

