/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.kilt.util;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u0003R\u001c\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lxyz/bluspring/kilt/util/LayeredStackTracker;", "", "<init>", "()V", "", "source", "", "push", "(Ljava/lang/String;)V", "pop", "dump", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "", "Lxyz/bluspring/kilt/util/LayeredStackTracker$Layer;", "layers", "Ljava/util/List;", "Lkotlin/collections/ArrayDeque;", "currentLayer", "Lkotlin/collections/ArrayDeque;", "Layer", "Kilt"})
public final class LayeredStackTracker {
    private final Logger logger = LoggerFactory.getLogger((String)"LayeredStackTracker");
    @NotNull
    private final List<Layer> layers = new ArrayList();
    @NotNull
    private ArrayDeque<Layer> currentLayer = new ArrayDeque();

    public final void push(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Layer layer = new Layer(this.currentLayer.size(), source, null, 4, null);
        this.layers.add(layer);
        this.currentLayer.addLast((Object)layer);
    }

    /*
     * WARNING - void declaration
     */
    public final void pop(@NotNull String source) {
        void $this$pop_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (this.currentLayer.isEmpty()) {
            this.logger.warn(source + " attempted to pop layer but there were no more layers!");
            return;
        }
        Object object = this.currentLayer.removeLast();
        Layer layer = (Layer)object;
        List<Layer> list = this.layers;
        boolean bl = false;
        $this$pop_u24lambda_u240.setEnd(source);
        list.add((Layer)object);
    }

    public final void dump() {
        this.logger.error("Dumping current layers!");
        List seenLayers = new ArrayList();
        for (Layer layer : this.layers) {
            if (seenLayers.contains(layer)) {
                this.logger.error(StringsKt.repeat((CharSequence)"x", (int)(layer.getIndex() + 1)) + " " + layer.getEnd());
                continue;
            }
            this.logger.error(StringsKt.repeat((CharSequence)"-", (int)(layer.getIndex() + 1)) + " " + layer.getStart());
            seenLayers.add(layer);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\f\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\fJ0\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\fR$\u0010\u0006\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b\u001a\u0010\f\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lxyz/bluspring/kilt/util/LayeredStackTracker$Layer;", "", "", "index", "", "start", "end", "<init>", "(ILjava/lang/String;Ljava/lang/String;)V", "component1", "()I", "component2", "()Ljava/lang/String;", "component3", "copy", "(ILjava/lang/String;Ljava/lang/String;)Lxyz/bluspring/kilt/util/LayeredStackTracker$Layer;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "I", "getIndex", "Ljava/lang/String;", "getStart", "getEnd", "setEnd", "(Ljava/lang/String;)V", "Kilt"})
    private static final class Layer {
        private final int index;
        @NotNull
        private final String start;
        @Nullable
        private String end;

        public Layer(int index, @NotNull String start, @Nullable String end) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            this.index = index;
            this.start = start;
            this.end = end;
        }

        public /* synthetic */ Layer(int n, String string, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                string2 = null;
            }
            this(n, string, string2);
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final String getStart() {
            return this.start;
        }

        @Nullable
        public final String getEnd() {
            return this.end;
        }

        public final void setEnd(@Nullable String string) {
            this.end = string;
        }

        public final int component1() {
            return this.index;
        }

        @NotNull
        public final String component2() {
            return this.start;
        }

        @Nullable
        public final String component3() {
            return this.end;
        }

        @NotNull
        public final Layer copy(int index, @NotNull String start, @Nullable String end) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            return new Layer(index, start, end);
        }

        public static /* synthetic */ Layer copy$default(Layer layer, int n, String string, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = layer.index;
            }
            if ((n2 & 2) != 0) {
                string = layer.start;
            }
            if ((n2 & 4) != 0) {
                string2 = layer.end;
            }
            return layer.copy(n, string, string2);
        }

        @NotNull
        public String toString() {
            return "Layer(index=" + this.index + ", start=" + this.start + ", end=" + this.end + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.index);
            result = result * 31 + this.start.hashCode();
            result = result * 31 + (this.end == null ? 0 : this.end.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Layer)) {
                return false;
            }
            Layer layer = (Layer)other;
            if (this.index != layer.index) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.start, (Object)layer.start)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.end, (Object)layer.end);
        }
    }
}

