/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.platform.forge;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.eventbus.api.IEventBus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011RT\u0010\u0015\u001aB\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00060\u0006 \u0013* \u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00140\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016Rl\u0010\u0018\u001aZ\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00040\u0004\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0013*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b0\u000b \u0013*,\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00040\u0004\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0013*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b0\u000b\u0018\u00010\u00170\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Ldev/architectury/platform/forge/EventBuses;", "", "<init>", "()V", "", "modId", "Lnet/minecraftforge/eventbus/api/IEventBus;", "bus", "", "registerModEventBus", "(Ljava/lang/String;Lnet/minecraftforge/eventbus/api/IEventBus;)V", "Ljava/util/function/Consumer;", "busConsumer", "onRegistered", "(Ljava/lang/String;Ljava/util/function/Consumer;)V", "Ljava/util/Optional;", "getModEventBus", "(Ljava/lang/String;)Ljava/util/Optional;", "", "kotlin.jvm.PlatformType", "", "EVENT_BUS_MAP", "Ljava/util/Map;", "Lcom/google/common/collect/Multimap;", "ON_REGISTERED", "Lcom/google/common/collect/Multimap;", "Kilt"})
public final class EventBuses {
    @NotNull
    public static final EventBuses INSTANCE = new EventBuses();
    private static final Map<String, IEventBus> EVENT_BUS_MAP = Collections.synchronizedMap(new LinkedHashMap());
    private static final Multimap<String, Consumer<IEventBus>> ON_REGISTERED = Multimaps.synchronizedMultimap((Multimap)((Multimap)LinkedListMultimap.create()));

    private EventBuses() {
    }

    @JvmStatic
    public static final void registerModEventBus(@NotNull String modId, @NotNull IEventBus bus) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        if (EVENT_BUS_MAP.putIfAbsent(modId, bus) != null) {
            throw new IllegalStateException("Can't register event bus for mod " + modId + " because it was previously registered!");
        }
        for (Consumer consumer : ON_REGISTERED.get((Object)modId)) {
            consumer.accept(bus);
        }
    }

    @JvmStatic
    public static final void onRegistered(@NotNull String modId, @NotNull Consumer<IEventBus> busConsumer) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        Intrinsics.checkNotNullParameter(busConsumer, (String)"busConsumer");
        if (EVENT_BUS_MAP.containsKey(modId)) {
            IEventBus iEventBus = EVENT_BUS_MAP.get(modId);
            Intrinsics.checkNotNull((Object)iEventBus);
            busConsumer.accept(iEventBus);
        } else {
            ON_REGISTERED.put((Object)modId, busConsumer);
        }
    }

    @JvmStatic
    @NotNull
    public static final Optional<IEventBus> getModEventBus(@NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        Optional<IEventBus> optional = Optional.ofNullable(EVENT_BUS_MAP.get(modId));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }
}

