/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.IdentityHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2164;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2321;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7699;
import net.minecraftforge.client.ClientCommandSourceStack;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.command.CommandHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public class ClientCommandHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static CommandDispatcher<class_2168> commands = null;

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(ClientCommandHandler::handleClientPlayerLogin);
    }

    private static void handleClientPlayerLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        class_634 connection = event.getPlayer().field_3944;
        connection.field_3696 = ClientCommandHandler.mergeServerCommands((CommandDispatcher<class_2172>)new CommandDispatcher(), class_7157.method_46722((class_7225.class_7874)connection.method_29091(), (class_7699)connection.method_45735()));
    }

    @ApiStatus.Internal
    public static CommandDispatcher<class_2172> mergeServerCommands(CommandDispatcher<class_2172> serverCommands, class_7157 buildContext) {
        CommandDispatcher commandsTemp = new CommandDispatcher();
        MinecraftForge.EVENT_BUS.post((Event)new RegisterClientCommandsEvent((CommandDispatcher<class_2168>)commandsTemp, buildContext));
        commands = new CommandDispatcher();
        ClientCommandHandler.copy(commandsTemp.getRoot(), commands.getRoot());
        RootCommandNode serverCommandsRoot = serverCommands.getRoot();
        CommandDispatcher newServerCommands = new CommandDispatcher();
        ClientCommandHandler.copy(serverCommandsRoot, newServerCommands.getRoot());
        CommandHelper.mergeCommandNode(commands.getRoot(), newServerCommands.getRoot(), new IdentityHashMap(), ClientCommandHandler.getSource(), context -> 0, suggestions -> {
            SuggestionProvider suggestionProvider = class_2321.method_10026((SuggestionProvider)suggestions);
            if (suggestionProvider == class_2321.field_10933) {
                suggestionProvider = (context, builder) -> {
                    ClientCommandSourceStack source = ClientCommandHandler.getSource();
                    StringReader reader = new StringReader(context.getInput());
                    if (reader.canRead() && reader.peek() == '/') {
                        reader.skip();
                    }
                    ParseResults parse = commands.parse(reader, (Object)source);
                    return commands.getCompletionSuggestions(parse);
                };
            }
            return suggestionProvider;
        });
        return newServerCommands;
    }

    public static CommandDispatcher<class_2168> getDispatcher() {
        return commands;
    }

    public static ClientCommandSourceStack getSource() {
        class_746 player = class_310.method_1551().field_1724;
        return new ClientCommandSourceStack((class_2165)player, player.method_19538(), player.method_5802(), player.method_5691(), player.method_5477().getString(), player.method_5476(), (class_1297)player);
    }

    private static <S> void copy(CommandNode<S> sourceNode, CommandNode<S> resultNode) {
        IdentityHashMap<Object, Object> newNodes = new IdentityHashMap<Object, Object>();
        newNodes.put(sourceNode, resultNode);
        for (CommandNode child : sourceNode.getChildren()) {
            CommandNode copy = newNodes.computeIfAbsent(child, innerChild -> {
                ArgumentBuilder builder = innerChild.createBuilder();
                CommandNode innerCopy = builder.build();
                ClientCommandHandler.copy(innerChild, innerCopy);
                return innerCopy;
            });
            resultNode.addChild(copy);
        }
    }

    public static boolean runCommand(String command) {
        StringReader reader = new StringReader(command);
        ClientCommandSourceStack source = ClientCommandHandler.getSource();
        try {
            commands.execute(reader, (Object)source);
        }
        catch (class_2164 execution) {
            class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)"").method_10852(execution.method_9199()).method_27692(class_124.field_1061));
        }
        catch (CommandSyntaxException syntax) {
            if (syntax.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand() || syntax.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument()) {
                return false;
            }
            class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)"").method_10852(class_2564.method_10883((Message)syntax.getRawMessage())).method_27692(class_124.field_1061));
            if (syntax.getInput() != null && syntax.getCursor() >= 0) {
                int position = Math.min(syntax.getInput().length(), syntax.getCursor());
                class_5250 details = class_2561.method_43470((String)"").method_27692(class_124.field_1080).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, reader.getString())));
                if (position > 10) {
                    details.method_27693("...");
                }
                details.method_27693(syntax.getInput().substring(Math.max(0, position - 10), position));
                if (position < syntax.getInput().length()) {
                    details.method_10852((class_2561)class_2561.method_43470((String)syntax.getInput().substring(position)).method_27695(new class_124[]{class_124.field_1061, class_124.field_1073}));
                }
                details.method_10852((class_2561)class_2561.method_43471((String)"command.context.here").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
                class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)details).method_27692(class_124.field_1061));
            }
        }
        catch (Exception generic) {
            class_5250 message2 = class_2561.method_43470((String)(generic.getMessage() == null ? generic.getClass().getName() : generic.getMessage()));
            class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43471((String)"command.failed").method_27692(class_124.field_1061).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)message2))));
            LOGGER.error("Error executing client command \"{}\"", (Object)command, (Object)generic);
        }
        return true;
    }
}

