/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4668;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.util.NonNullSupplier;

public enum ForgeRenderTypes {
    ITEM_LAYERED_SOLID(() -> ForgeRenderTypes.getItemLayeredSolid(class_1059.field_5275)),
    ITEM_LAYERED_CUTOUT(() -> ForgeRenderTypes.getItemLayeredCutout(class_1059.field_5275)),
    ITEM_LAYERED_CUTOUT_MIPPED(() -> ForgeRenderTypes.getItemLayeredCutoutMipped(class_1059.field_5275)),
    ITEM_LAYERED_TRANSLUCENT(() -> ForgeRenderTypes.getItemLayeredTranslucent(class_1059.field_5275)),
    ITEM_UNSORTED_TRANSLUCENT(() -> ForgeRenderTypes.getUnsortedTranslucent(class_1059.field_5275)),
    ITEM_UNLIT_TRANSLUCENT(() -> ForgeRenderTypes.getUnlitTranslucent(class_1059.field_5275)),
    ITEM_UNSORTED_UNLIT_TRANSLUCENT(() -> ForgeRenderTypes.getUnlitTranslucent(class_1059.field_5275, false)),
    TRANSLUCENT_ON_PARTICLES_TARGET(() -> ForgeRenderTypes.getTranslucentParticlesTarget(class_1059.field_5275));

    public static boolean enableTextTextureLinearFiltering;
    private final NonNullSupplier<class_1921> renderTypeSupplier;

    public static class_1921 getItemLayeredSolid(class_2960 textureLocation) {
        return Internal.LAYERED_ITEM_SOLID.apply(textureLocation);
    }

    public static class_1921 getItemLayeredCutout(class_2960 textureLocation) {
        return Internal.LAYERED_ITEM_CUTOUT.apply(textureLocation);
    }

    public static class_1921 getItemLayeredCutoutMipped(class_2960 textureLocation) {
        return Internal.LAYERED_ITEM_CUTOUT_MIPPED.apply(textureLocation);
    }

    public static class_1921 getItemLayeredTranslucent(class_2960 textureLocation) {
        return Internal.LAYERED_ITEM_TRANSLUCENT.apply(textureLocation);
    }

    public static class_1921 getUnsortedTranslucent(class_2960 textureLocation) {
        return Internal.UNSORTED_TRANSLUCENT.apply(textureLocation);
    }

    public static class_1921 getUnlitTranslucent(class_2960 textureLocation) {
        return Internal.UNLIT_TRANSLUCENT_SORTED.apply(textureLocation);
    }

    public static class_1921 getUnlitTranslucent(class_2960 textureLocation, boolean sortingEnabled) {
        return (sortingEnabled ? Internal.UNLIT_TRANSLUCENT_SORTED : Internal.UNLIT_TRANSLUCENT_UNSORTED).apply(textureLocation);
    }

    public static class_1921 getEntityCutoutMipped(class_2960 textureLocation) {
        return Internal.LAYERED_ITEM_CUTOUT_MIPPED.apply(textureLocation);
    }

    public static class_1921 getText(class_2960 locationIn) {
        return Internal.TEXT.apply(locationIn);
    }

    public static class_1921 getTextIntensity(class_2960 locationIn) {
        return Internal.TEXT_INTENSITY.apply(locationIn);
    }

    public static class_1921 getTextPolygonOffset(class_2960 locationIn) {
        return Internal.TEXT_POLYGON_OFFSET.apply(locationIn);
    }

    public static class_1921 getTextIntensityPolygonOffset(class_2960 locationIn) {
        return Internal.TEXT_INTENSITY_POLYGON_OFFSET.apply(locationIn);
    }

    public static class_1921 getTextSeeThrough(class_2960 locationIn) {
        return Internal.TEXT_SEETHROUGH.apply(locationIn);
    }

    public static class_1921 getTextIntensitySeeThrough(class_2960 locationIn) {
        return Internal.TEXT_INTENSITY_SEETHROUGH.apply(locationIn);
    }

    public static class_1921 getTranslucentParticlesTarget(class_2960 locationIn) {
        return Internal.TRANSLUCENT_PARTICLES_TARGET.apply(locationIn);
    }

    private ForgeRenderTypes(NonNullSupplier<class_1921> renderTypeSupplier) {
        this.renderTypeSupplier = NonNullLazy.of(renderTypeSupplier);
    }

    public class_1921 get() {
        return this.renderTypeSupplier.get();
    }

    static {
        enableTextTextureLinearFiltering = false;
    }

    private static class Internal
    extends class_1921 {
        private static final class_4668.class_5942 RENDERTYPE_ENTITY_TRANSLUCENT_UNLIT_SHADER = new class_4668.class_5942(ForgeHooksClient.ClientEvents::getEntityTranslucentUnlitShader);
        public static Function<class_2960, class_1921> UNSORTED_TRANSLUCENT = class_156.method_34866(Internal::unsortedTranslucent);
        private static final BiFunction<class_2960, Boolean, class_1921> ENTITY_TRANSLUCENT = class_156.method_34865((p_173227_, p_173228_) -> {
            class_1921.class_4688 rendertype$compositestate = class_1921.class_4688.method_23598().method_34578(field_29407).method_34577((class_4668.class_5939)new class_4668.class_4683(p_173227_, false, false)).method_23615(field_21370).method_23603(field_21345).method_23608(field_21383).method_23611(field_21385).method_23617(p_173228_.booleanValue());
            return Internal.method_24049((String)"entity_translucent", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)true, (class_1921.class_4688)rendertype$compositestate);
        });
        public static Function<class_2960, class_1921> UNLIT_TRANSLUCENT_SORTED = class_156.method_34866(tex -> Internal.unlitTranslucent(tex, true));
        public static Function<class_2960, class_1921> UNLIT_TRANSLUCENT_UNSORTED = class_156.method_34866(tex -> Internal.unlitTranslucent(tex, false));
        public static Function<class_2960, class_1921> LAYERED_ITEM_SOLID = class_156.method_34866(Internal::layeredItemSolid);
        public static Function<class_2960, class_1921> LAYERED_ITEM_CUTOUT = class_156.method_34866(Internal::layeredItemCutout);
        public static Function<class_2960, class_1921> LAYERED_ITEM_CUTOUT_MIPPED = class_156.method_34866(Internal::layeredItemCutoutMipped);
        public static Function<class_2960, class_1921> LAYERED_ITEM_TRANSLUCENT = class_156.method_34866(Internal::layeredItemTranslucent);
        public static Function<class_2960, class_1921> TEXT = class_156.method_34866(Internal::getText);
        public static Function<class_2960, class_1921> TEXT_INTENSITY = class_156.method_34866(Internal::getTextIntensity);
        public static Function<class_2960, class_1921> TEXT_POLYGON_OFFSET = class_156.method_34866(Internal::getTextPolygonOffset);
        public static Function<class_2960, class_1921> TEXT_INTENSITY_POLYGON_OFFSET = class_156.method_34866(Internal::getTextIntensityPolygonOffset);
        public static Function<class_2960, class_1921> TEXT_SEETHROUGH = class_156.method_34866(Internal::getTextSeeThrough);
        public static Function<class_2960, class_1921> TEXT_INTENSITY_SEETHROUGH = class_156.method_34866(Internal::getTextIntensitySeeThrough);
        public static Function<class_2960, class_1921> TRANSLUCENT_PARTICLES_TARGET = class_156.method_34866(Internal::getTranslucentParticlesTarget);

        private Internal(String name, class_293 fmt, class_293.class_5596 glMode, int size, boolean doCrumbling, boolean depthSorting, Runnable onEnable, Runnable onDisable) {
            super(name, fmt, glMode, size, doCrumbling, depthSorting, onEnable, onDisable);
            throw new IllegalStateException("This class must not be instantiated");
        }

        private static class_1921 unsortedTranslucent(class_2960 textureLocation) {
            boolean sortingEnabled = false;
            class_1921.class_4688 renderState = class_1921.class_4688.method_23598().method_34578(class_1921.field_29407).method_34577((class_4668.class_5939)new class_4668.class_4683(textureLocation, false, false)).method_23615(field_21370).method_23603(field_21345).method_23608(field_21383).method_23611(field_21385).method_23617(true);
            return Internal.method_24049((String)"forge_entity_unsorted_translucent", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)renderState);
        }

        private static class_1921 unlitTranslucent(class_2960 textureLocation, boolean sortingEnabled) {
            class_1921.class_4688 renderState = class_1921.class_4688.method_23598().method_34578(RENDERTYPE_ENTITY_TRANSLUCENT_UNLIT_SHADER).method_34577((class_4668.class_5939)new class_4668.class_4683(textureLocation, false, false)).method_23615(field_21370).method_23603(field_21345).method_23608(field_21383).method_23611(field_21385).method_23617(true);
            return Internal.method_24049((String)"forge_entity_unlit_translucent", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)sortingEnabled, (class_1921.class_4688)renderState);
        }

        private static class_1921 layeredItemSolid(class_2960 locationIn) {
            class_1921.class_4688 rendertype$state = class_1921.class_4688.method_23598().method_34578(class_1921.field_29450).method_34577((class_4668.class_5939)new class_4668.class_4683(locationIn, false, false)).method_23615(field_21364).method_23608(field_21383).method_23611(field_21385).method_23617(true);
            return Internal.method_24049((String)"forge_item_entity_solid", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)rendertype$state);
        }

        private static class_1921 layeredItemCutout(class_2960 locationIn) {
            class_1921.class_4688 rendertype$state = class_1921.class_4688.method_23598().method_34578(class_1921.field_29451).method_34577((class_4668.class_5939)new class_4668.class_4683(locationIn, false, false)).method_23615(field_21364).method_23608(field_21383).method_23611(field_21385).method_23617(true);
            return Internal.method_24049((String)"forge_item_entity_cutout", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)rendertype$state);
        }

        private static class_1921 layeredItemCutoutMipped(class_2960 locationIn) {
            class_1921.class_4688 rendertype$state = class_1921.class_4688.method_23598().method_34578(class_1921.field_29408).method_34577((class_4668.class_5939)new class_4668.class_4683(locationIn, false, true)).method_23615(field_21364).method_23608(field_21383).method_23611(field_21385).method_23617(true);
            return Internal.method_24049((String)"forge_item_entity_cutout_mipped", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)rendertype$state);
        }

        private static class_1921 layeredItemTranslucent(class_2960 locationIn) {
            class_1921.class_4688 rendertype$state = class_1921.class_4688.method_23598().method_34578(class_1921.field_29407).method_34577((class_4668.class_5939)new class_4668.class_4683(locationIn, false, false)).method_23615(field_21370).method_23608(field_21383).method_23611(field_21385).method_23617(true);
            return Internal.method_24049((String)"forge_item_entity_translucent_cull", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)true, (class_1921.class_4688)rendertype$state);
        }

        private static class_1921 getText(class_2960 locationIn) {
            class_1921.class_4688 rendertype$state = class_1921.class_4688.method_23598().method_34578(field_29427).method_34577((class_4668.class_5939)new CustomizableTextureState(locationIn, () -> enableTextTextureLinearFiltering, () -> false)).method_23615(field_21370).method_23608(field_21383).method_23617(false);
            return Internal.method_24049((String)"forge_text", (class_293)class_290.field_20888, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)rendertype$state);
        }

        private static class_1921 getTextIntensity(class_2960 locationIn) {
            class_1921.class_4688 rendertype$state = class_1921.class_4688.method_23598().method_34578(field_33628).method_34577((class_4668.class_5939)new CustomizableTextureState(locationIn, () -> enableTextTextureLinearFiltering, () -> false)).method_23615(field_21370).method_23608(field_21383).method_23617(false);
            return Internal.method_24049((String)"text_intensity", (class_293)class_290.field_20888, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)rendertype$state);
        }

        private static class_1921 getTextPolygonOffset(class_2960 locationIn) {
            class_1921.class_4688 rendertype$state = class_1921.class_4688.method_23598().method_34578(field_29427).method_34577((class_4668.class_5939)new CustomizableTextureState(locationIn, () -> enableTextTextureLinearFiltering, () -> false)).method_23615(field_21370).method_23608(field_21383).method_23607(field_21353).method_23617(false);
            return Internal.method_24049((String)"text_intensity", (class_293)class_290.field_20888, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)rendertype$state);
        }

        private static class_1921 getTextIntensityPolygonOffset(class_2960 locationIn) {
            class_1921.class_4688 rendertype$state = class_1921.class_4688.method_23598().method_34578(field_33628).method_34577((class_4668.class_5939)new CustomizableTextureState(locationIn, () -> enableTextTextureLinearFiltering, () -> false)).method_23615(field_21370).method_23608(field_21383).method_23607(field_21353).method_23617(false);
            return Internal.method_24049((String)"text_intensity", (class_293)class_290.field_20888, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)rendertype$state);
        }

        private static class_1921 getTextSeeThrough(class_2960 locationIn) {
            class_1921.class_4688 rendertype$state = class_1921.class_4688.method_23598().method_34578(field_29428).method_34577((class_4668.class_5939)new CustomizableTextureState(locationIn, () -> enableTextTextureLinearFiltering, () -> false)).method_23615(field_21370).method_23608(field_21383).method_23604(field_21346).method_23616(field_21350).method_23617(false);
            return Internal.method_24049((String)"forge_text_see_through", (class_293)class_290.field_20888, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)rendertype$state);
        }

        private static class_1921 getTextIntensitySeeThrough(class_2960 locationIn) {
            class_1921.class_4688 rendertype$state = class_1921.class_4688.method_23598().method_34578(field_33629).method_34577((class_4668.class_5939)new CustomizableTextureState(locationIn, () -> enableTextTextureLinearFiltering, () -> false)).method_23615(field_21370).method_23608(field_21383).method_23604(field_21346).method_23616(field_21350).method_23617(false);
            return Internal.method_24049((String)"forge_text_see_through", (class_293)class_290.field_20888, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)rendertype$state);
        }

        private static class_1921 getTranslucentParticlesTarget(class_2960 locationIn) {
            class_1921.class_4688 rendertype$state = class_1921.class_4688.method_23598().method_34578(field_29446).method_34577((class_4668.class_5939)new class_4668.class_4683(locationIn, false, true)).method_23615(field_21370).method_23608(field_21383).method_23610(field_25281).method_23617(true);
            return Internal.method_24049((String)"forge_translucent_particles_target", (class_293)class_290.field_1590, (class_293.class_5596)class_293.class_5596.field_27382, (int)0x200000, (boolean)true, (boolean)true, (class_1921.class_4688)rendertype$state);
        }
    }

    private static class CustomizableTextureState
    extends class_4668.class_4683 {
        private CustomizableTextureState(class_2960 resLoc, Supplier<Boolean> blur, Supplier<Boolean> mipmap) {
            super(resLoc, blur.get().booleanValue(), mipmap.get().booleanValue());
            this.field_21361 = () -> {
                this.field_21398 = (Boolean)blur.get();
                this.field_21399 = (Boolean)mipmap.get();
                class_1060 texturemanager = class_310.method_1551().method_1531();
                texturemanager.method_4619(resLoc).method_4527(this.field_21398, this.field_21399);
                RenderSystem.setShaderTexture((int)0, (class_2960)resLoc);
            };
        }
    }
}

