/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraftforge.client.IItemDecorator;
import net.minecraftforge.client.event.RegisterItemDecorationsEvent;
import net.minecraftforge.fml.ModLoader;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ItemDecoratorHandler {
    private final List<IItemDecorator> itemDecorators;
    private static Map<class_1792, ItemDecoratorHandler> DECORATOR_LOOKUP = ImmutableMap.of();
    private static final ItemDecoratorHandler EMPTY = new ItemDecoratorHandler();

    private ItemDecoratorHandler() {
        this.itemDecorators = ImmutableList.of();
    }

    private ItemDecoratorHandler(List<IItemDecorator> itemDecorators) {
        this.itemDecorators = ImmutableList.copyOf(itemDecorators);
    }

    public static void init() {
        HashMap<class_1792, List<IItemDecorator>> decorators = new HashMap<class_1792, List<IItemDecorator>>();
        RegisterItemDecorationsEvent event = new RegisterItemDecorationsEvent(decorators);
        ModLoader.get().postEventWrapContainerInModOrder(event);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        decorators.forEach((item, itemDecorators) -> builder.put(item, (Object)new ItemDecoratorHandler((List<IItemDecorator>)itemDecorators)));
        DECORATOR_LOOKUP = builder.build();
    }

    public static ItemDecoratorHandler of(class_1799 stack) {
        return DECORATOR_LOOKUP.getOrDefault(stack.method_7909(), EMPTY);
    }

    public void render(class_332 guiGraphics, class_327 font, class_1799 stack, int xOffset, int yOffset) {
        this.resetRenderState();
        for (IItemDecorator itemDecorator : this.itemDecorators) {
            if (!itemDecorator.render(guiGraphics, font, stack, xOffset, yOffset)) continue;
            this.resetRenderState();
        }
    }

    private void resetRenderState() {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }
}

