/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1860;
import net.minecraft.class_314;
import net.minecraft.class_3956;
import net.minecraft.class_5421;
import net.minecraftforge.client.event.RegisterRecipeBookCategoriesEvent;
import net.minecraftforge.fml.ModLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class RecipeBookManager {
    private static final Map<class_314, List<class_314>> AGGREGATE_CATEGORIES = new HashMap<class_314, List<class_314>>();
    private static final Map<class_5421, List<class_314>> TYPE_CATEGORIES = new HashMap<class_5421, List<class_314>>();
    private static final Map<class_3956<?>, Function<class_1860<?>, class_314>> RECIPE_CATEGORY_LOOKUPS = new HashMap();
    private static final Map<class_314, List<class_314>> AGGREGATE_CATEGORIES_VIEW = Collections.unmodifiableMap(AGGREGATE_CATEGORIES);

    @Nullable
    public static <T extends class_1860<?>> class_314 findCategories(class_3956<T> type, T recipe) {
        Function<class_1860<?>, class_314> lookup = RECIPE_CATEGORY_LOOKUPS.get(type);
        return lookup != null ? lookup.apply(recipe) : null;
    }

    @ApiStatus.Internal
    public static Map<class_314, List<class_314>> getAggregateCategories() {
        return AGGREGATE_CATEGORIES_VIEW;
    }

    @ApiStatus.Internal
    public static List<class_314> getCustomCategoriesOrEmpty(class_5421 recipeBookType) {
        return TYPE_CATEGORIES.getOrDefault(recipeBookType, List.of());
    }

    @ApiStatus.Internal
    public static void init() {
        HashMap<class_314, ImmutableList<class_314>> aggregateCategories = new HashMap<class_314, ImmutableList<class_314>>((Map<class_314, ImmutableList<class_314>>)ImmutableMap.of((Object)class_314.field_1809, (Object)ImmutableList.of((Object)class_314.field_1813, (Object)class_314.field_1806, (Object)class_314.field_1810, (Object)class_314.field_1803), (Object)class_314.field_1804, (Object)ImmutableList.of((Object)class_314.field_1808, (Object)class_314.field_1811, (Object)class_314.field_1812), (Object)class_314.field_17110, (Object)ImmutableList.of((Object)class_314.field_17111, (Object)class_314.field_17112), (Object)class_314.field_17113, (Object)ImmutableList.of((Object)class_314.field_17114)));
        HashMap<class_5421, ImmutableList<class_314>> typeCategories = new HashMap<class_5421, ImmutableList<class_314>>();
        HashMap recipeCategoryLookups = new HashMap();
        RegisterRecipeBookCategoriesEvent event = new RegisterRecipeBookCategoriesEvent(aggregateCategories, typeCategories, recipeCategoryLookups);
        ModLoader.get().postEventWrapContainerInModOrder(event);
        AGGREGATE_CATEGORIES.putAll(aggregateCategories);
        TYPE_CATEGORIES.putAll(typeCategories);
        RECIPE_CATEGORY_LOOKUPS.putAll(recipeCategoryLookups);
    }
}

