/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.google.common.base.Preconditions;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.IModBusEvent;
import org.jetbrains.annotations.ApiStatus;

public class RegisterNamedRenderTypesEvent
extends Event
implements IModBusEvent {
    private final Map<class_2960, RenderTypeGroup> renderTypes;

    @ApiStatus.Internal
    public RegisterNamedRenderTypesEvent(Map<class_2960, RenderTypeGroup> renderTypes) {
        this.renderTypes = renderTypes;
    }

    public void register(String name, class_1921 blockRenderType, class_1921 entityRenderType) {
        this.register(name, blockRenderType, entityRenderType, entityRenderType);
    }

    public void register(String name, class_1921 blockRenderType, class_1921 entityRenderType, class_1921 fabulousEntityRenderType) {
        class_2960 key = new class_2960(ModLoadingContext.get().getActiveNamespace(), name);
        Preconditions.checkArgument((!this.renderTypes.containsKey(key) ? 1 : 0) != 0, (Object)("Render type already registered: " + String.valueOf(key)));
        Preconditions.checkArgument((blockRenderType.method_23031() == class_290.field_1590 ? 1 : 0) != 0, (Object)"The block render type must use the BLOCK vertex format.");
        Preconditions.checkArgument((blockRenderType.getChunkLayerId() >= 0 ? 1 : 0) != 0, (Object)"Only chunk render types can be used for block rendering. Query RenderType#chunkBufferLayers() for a list.");
        Preconditions.checkArgument((entityRenderType.method_23031() == class_290.field_1580 ? 1 : 0) != 0, (Object)"The entity render type must use the NEW_ENTITY vertex format.");
        Preconditions.checkArgument((fabulousEntityRenderType.method_23031() == class_290.field_1580 ? 1 : 0) != 0, (Object)"The fabulous entity render type must use the NEW_ENTITY vertex format.");
        this.renderTypes.put(key, new RenderTypeGroup(blockRenderType, entityRenderType, fabulousEntityRenderType));
    }
}

