/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_5636;
import net.minecraft.class_6854;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.ApiStatus;

public abstract class ViewportEvent
extends Event {
    private final class_757 renderer;
    private final class_4184 camera;
    private final double partialTick;

    @ApiStatus.Internal
    public ViewportEvent(class_757 renderer, class_4184 camera, double partialTick) {
        this.renderer = renderer;
        this.camera = camera;
        this.partialTick = partialTick;
    }

    public class_757 getRenderer() {
        return this.renderer;
    }

    public class_4184 getCamera() {
        return this.camera;
    }

    public double getPartialTick() {
        return this.partialTick;
    }

    public static class ComputeFov
    extends ViewportEvent {
        private final boolean usedConfiguredFov;
        private double fov;

        @ApiStatus.Internal
        public ComputeFov(class_757 renderer, class_4184 camera, double renderPartialTicks, double fov, boolean usedConfiguredFov) {
            super(renderer, camera, renderPartialTicks);
            this.usedConfiguredFov = usedConfiguredFov;
            this.setFOV(fov);
        }

        public double getFOV() {
            return this.fov;
        }

        public void setFOV(double fov) {
            this.fov = fov;
        }

        public boolean usedConfiguredFov() {
            return this.usedConfiguredFov;
        }
    }

    public static class ComputeCameraAngles
    extends ViewportEvent {
        private float yaw;
        private float pitch;
        private float roll;

        @ApiStatus.Internal
        public ComputeCameraAngles(class_757 renderer, class_4184 camera, double renderPartialTicks, float yaw, float pitch, float roll) {
            super(renderer, camera, renderPartialTicks);
            this.setYaw(yaw);
            this.setPitch(pitch);
            this.setRoll(roll);
        }

        public float getYaw() {
            return this.yaw;
        }

        public void setYaw(float yaw) {
            this.yaw = yaw;
        }

        public float getPitch() {
            return this.pitch;
        }

        public void setPitch(float pitch) {
            this.pitch = pitch;
        }

        public float getRoll() {
            return this.roll;
        }

        public void setRoll(float roll) {
            this.roll = roll;
        }
    }

    public static class ComputeFogColor
    extends ViewportEvent {
        private float red;
        private float green;
        private float blue;

        @ApiStatus.Internal
        public ComputeFogColor(class_4184 camera, float partialTicks, float red, float green, float blue) {
            super(class_310.method_1551().field_1773, camera, partialTicks);
            this.setRed(red);
            this.setGreen(green);
            this.setBlue(blue);
        }

        public float getRed() {
            return this.red;
        }

        public void setRed(float red) {
            this.red = red;
        }

        public float getGreen() {
            return this.green;
        }

        public void setGreen(float green) {
            this.green = green;
        }

        public float getBlue() {
            return this.blue;
        }

        public void setBlue(float blue) {
            this.blue = blue;
        }
    }

    @Cancelable
    public static class RenderFog
    extends ViewportEvent {
        private final class_758.class_4596 mode;
        private final class_5636 type;
        private float farPlaneDistance;
        private float nearPlaneDistance;
        private class_6854 fogShape;

        @ApiStatus.Internal
        public RenderFog(class_758.class_4596 mode, class_5636 type, class_4184 camera, float partialTicks, float nearPlaneDistance, float farPlaneDistance, class_6854 fogShape) {
            super(class_310.method_1551().field_1773, camera, partialTicks);
            this.mode = mode;
            this.type = type;
            this.setFarPlaneDistance(farPlaneDistance);
            this.setNearPlaneDistance(nearPlaneDistance);
            this.setFogShape(fogShape);
        }

        public class_758.class_4596 getMode() {
            return this.mode;
        }

        public class_5636 getType() {
            return this.type;
        }

        public float getFarPlaneDistance() {
            return this.farPlaneDistance;
        }

        public float getNearPlaneDistance() {
            return this.nearPlaneDistance;
        }

        public class_6854 getFogShape() {
            return this.fogShape;
        }

        public void setFarPlaneDistance(float distance) {
            this.farPlaneDistance = distance;
        }

        public void setNearPlaneDistance(float distance) {
            this.nearPlaneDistance = distance;
        }

        public void setFogShape(class_6854 shape) {
            this.fogShape = shape;
        }

        public void scaleFarPlaneDistance(float factor) {
            this.farPlaneDistance *= factor;
        }

        public void scaleNearPlaneDistance(float factor) {
            this.nearPlaneDistance *= factor;
        }
    }
}

