/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_156;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_3544;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_7367;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.extensions.IForgeGuiGraphics;
import net.minecraftforge.client.gui.widget.ModListWidget;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.common.util.MavenVersionStringHelper;
import net.minecraftforge.common.util.Size2i;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.resource.PathPackResources;
import net.minecraftforge.resource.ResourcePackLoader;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.slf4j.Logger;

public class ModListScreen
extends class_437 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int PADDING = 6;
    private static final int BUTTON_MARGIN = 1;
    private static final int NUM_BUTTONS = SortType.values().length;
    private final class_437 parentScreen;
    private ModListWidget modList;
    private InfoPanel modInfo;
    private ModListWidget.ModEntry selected = null;
    private int listWidth;
    private List<IModInfo> mods;
    private final List<IModInfo> unsortedMods;
    private class_4185 configButton;
    private class_4185 openModsFolderButton;
    private class_4185 doneButton;
    private String lastFilterText = "";
    private class_342 search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;

    private static String stripControlCodes(String value) {
        return class_3544.method_15440((String)value);
    }

    public ModListScreen(class_437 parentScreen) {
        super((class_2561)class_2561.method_43471((String)"fml.menu.mods.title"));
        this.parentScreen = parentScreen;
        this.mods = ModList.get().getMods();
        this.unsortedMods = List.copyOf(this.mods);
    }

    public void method_25426() {
        for (IModInfo mod : this.mods) {
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().method_1727(mod.getDisplayName()) + 10);
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().method_1727(MavenVersionStringHelper.artifactVersionToString(mod.getVersion())) + 5);
        }
        this.listWidth = Math.max(Math.min(this.listWidth, this.field_22789 / 3), 100);
        this.listWidth += this.listWidth % NUM_BUTTONS != 0 ? NUM_BUTTONS - this.listWidth % NUM_BUTTONS : 0;
        int modInfoWidth = this.field_22789 - this.listWidth - 18;
        int doneButtonWidth = Math.min(modInfoWidth, 200);
        int y = this.field_22790 - 20 - 6;
        int fullButtonHeight = 32;
        this.doneButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), b -> this.method_25419()).method_46434((this.listWidth + 6 + this.field_22789 - doneButtonWidth) / 2, y, doneButtonWidth, 20).method_46431();
        this.openModsFolderButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"fml.menu.mods.openmodsfolder"), b -> class_156.method_668().method_672(FMLPaths.MODSDIR.get().toFile())).method_46434(6, y, this.listWidth, 20).method_46431();
        this.configButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"fml.menu.mods.config"), b -> this.displayModConfig()).method_46434(6, y -= 26, this.listWidth, 20).method_46431();
        this.search = new class_342(this.getFontRenderer(), 7, y -= 20, this.listWidth - 2, 14, (class_2561)class_2561.method_43471((String)"fml.menu.mods.search"));
        int n = this.search.method_46427();
        Objects.requireNonNull(this.getFontRenderer());
        this.modList = new ModListWidget(this, this.listWidth, fullButtonHeight, n - 9 - 6);
        this.modList.method_25333(6);
        this.modInfo = new InfoPanel(this.field_22787, modInfoWidth, this.field_22790 - 6 - fullButtonHeight, 6);
        this.method_37063((class_364)this.modList);
        this.method_37063((class_364)this.modInfo);
        this.method_37063((class_364)this.search);
        this.method_37063((class_364)this.doneButton);
        this.method_37063((class_364)this.configButton);
        this.method_37063((class_364)this.openModsFolderButton);
        this.search.method_25365(false);
        this.search.method_1856(true);
        this.configButton.field_22763 = false;
        int width = this.listWidth / NUM_BUTTONS;
        int x = 6;
        SortType.NORMAL.button = class_4185.method_46430((class_2561)SortType.NORMAL.getButtonText(), b -> this.resortMods(SortType.NORMAL)).method_46434(x, 6, width - 1, 20).method_46431();
        this.method_37063((class_364)SortType.NORMAL.button);
        SortType.A_TO_Z.button = class_4185.method_46430((class_2561)SortType.A_TO_Z.getButtonText(), b -> this.resortMods(SortType.A_TO_Z)).method_46434(x += width + 1, 6, width - 1, 20).method_46431();
        this.method_37063((class_364)SortType.A_TO_Z.button);
        SortType.Z_TO_A.button = class_4185.method_46430((class_2561)SortType.Z_TO_A.getButtonText(), b -> this.resortMods(SortType.Z_TO_A)).method_46434(x += width + 1, 6, width - 1, 20).method_46431();
        this.method_37063((class_364)SortType.Z_TO_A.button);
        this.resortMods(SortType.NORMAL);
        this.updateCache();
    }

    private void displayModConfig() {
        if (this.selected == null) {
            return;
        }
        try {
            ConfigScreenHandler.getScreenFactoryFor(this.selected.getInfo()).map(f -> (class_437)f.apply(this.field_22787, this)).ifPresent(newScreen -> this.field_22787.method_1507(newScreen));
        }
        catch (Exception e) {
            LOGGER.error("There was a critical issue trying to build the config GUI for {}", (Object)this.selected.getInfo().getModId(), (Object)e);
        }
    }

    public void method_25393() {
        this.search.method_1865();
        this.modList.method_25313((class_350.class_351)this.selected);
        if (!this.search.method_1882().equals(this.lastFilterText)) {
            this.reloadMods();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadMods();
            this.mods.sort(this.sortType);
            this.modList.refreshList();
            if (this.selected != null) {
                this.selected = this.modList.method_25396().stream().filter(e -> e.getInfo() == this.selected.getInfo()).findFirst().orElse(null);
                this.updateCache();
            }
            this.sorted = true;
        }
    }

    public <T extends class_4280.class_4281<T>> void buildModList(Consumer<T> modListViewConsumer, Function<IModInfo, T> newEntry) {
        for (IModInfo mod : this.mods) {
            modListViewConsumer.accept((class_4280.class_4281)newEntry.apply(mod));
        }
    }

    private void reloadMods() {
        this.mods = this.unsortedMods.stream().filter(mi -> StringUtils.toLowerCase(ModListScreen.stripControlCodes(mi.getDisplayName())).contains(StringUtils.toLowerCase(this.search.method_1882()))).collect(Collectors.toList());
        this.lastFilterText = this.search.method_1882();
    }

    private void resortMods(SortType newSort) {
        this.sortType = newSort;
        for (SortType sort : SortType.values()) {
            if (sort.button == null) continue;
            sort.button.field_22763 = this.sortType != sort;
        }
        this.sorted = false;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.modList.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.modInfo != null) {
            this.modInfo.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        class_5250 text = class_2561.method_43471((String)"fml.menu.mods.search");
        int x = this.modList.getLeft() + (this.modList.getRight() - this.modList.getLeft()) / 2 - this.getFontRenderer().method_27525((class_5348)text) / 2;
        this.search.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        class_327 class_3273 = this.getFontRenderer();
        class_5481 class_54812 = text.method_30937();
        int n = this.search.method_46427();
        Objects.requireNonNull(this.getFontRenderer());
        guiGraphics.method_51430(class_3273, class_54812, x, n - 9, 0xFFFFFF, false);
    }

    public class_310 getMinecraftInstance() {
        return this.field_22787;
    }

    public class_327 getFontRenderer() {
        return this.field_22793;
    }

    public void setSelected(ModListWidget.ModEntry entry) {
        this.selected = entry == this.selected ? null : entry;
        this.updateCache();
    }

    private void updateCache() {
        if (this.selected == null) {
            this.configButton.field_22763 = false;
            this.modInfo.clearInfo();
            return;
        }
        final IModInfo selectedMod = this.selected.getInfo();
        this.configButton.field_22763 = ConfigScreenHandler.getScreenFactoryFor(selectedMod).isPresent();
        ArrayList<String> lines = new ArrayList<String>();
        VersionChecker.CheckResult vercheck = VersionChecker.getResult(selectedMod);
        Pair logoData = selectedMod.getLogoFile().map(logoFile -> {
            class_1060 tm = this.field_22787.method_1531();
            PathPackResources resourcePack = ResourcePackLoader.getPackFor(selectedMod.getModId()).orElse(ResourcePackLoader.getPackFor("forge").orElseThrow(() -> new RuntimeException("Can't find forge, WHAT!")));
            try {
                class_1011 logo = null;
                class_7367<InputStream> logoResource = resourcePack.method_14410((String)logoFile);
                if (logoResource != null) {
                    logo = class_1011.method_4309((InputStream)((InputStream)logoResource.get()));
                }
                if (logo != null) {
                    return Pair.of((Object)tm.method_4617("modlogo", new class_1043(logo){

                        public void method_4524() {
                            this.method_23207();
                            class_1011 td = this.method_4525();
                            this.method_4525().method_22619(0, 0, 0, 0, 0, td.method_4307(), td.method_4323(), selectedMod.getLogoBlur(), false, false, false);
                        }
                    }), (Object)new Size2i(logo.method_4307(), logo.method_4323()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Pair.of(null, (Object)new Size2i(0, 0));
        }).orElse(Pair.of(null, (Object)new Size2i(0, 0)));
        lines.add(selectedMod.getDisplayName());
        lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.version", MavenVersionStringHelper.artifactVersionToString(selectedMod.getVersion())));
        lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.idstate", selectedMod.getModId(), ModList.get().getModContainerById(selectedMod.getModId()).map(ModContainer::getCurrentState).map(Object::toString).orElse("NONE")));
        selectedMod.getConfig().getConfigElement(new String[]{"credits"}).ifPresent(credits -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.credits", credits)));
        selectedMod.getConfig().getConfigElement(new String[]{"authors"}).ifPresent(authors -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.authors", authors)));
        selectedMod.getConfig().getConfigElement(new String[]{"displayURL"}).ifPresent(displayURL -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.displayurl", displayURL)));
        if (selectedMod.getOwningFile() == null || selectedMod.getOwningFile().getMods().size() == 1) {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.nochildmods", new Object[0]));
        } else {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.childmods", selectedMod.getOwningFile().getMods().stream().map(IModInfo::getDisplayName).collect(Collectors.joining(","))));
        }
        if (vercheck.status().isOutdated()) {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.updateavailable", vercheck.url() == null ? "" : vercheck.url()));
        }
        lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.license", ((ModFileInfo)selectedMod.getOwningFile()).getLicense()));
        lines.add(null);
        lines.add(selectedMod.getDescription());
        if (vercheck.status().isOutdated() && !vercheck.changes().isEmpty()) {
            lines.add(null);
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.changelogheader", new Object[0]));
            for (Map.Entry<ComparableVersion, String> entry : vercheck.changes().entrySet()) {
                lines.add("  " + String.valueOf(entry.getKey()) + ":");
                lines.add(entry.getValue());
                lines.add(null);
            }
        }
        this.modInfo.setInfo(lines, (class_2960)logoData.getLeft(), (Size2i)logoData.getRight());
    }

    public void method_25410(class_310 mc, int width, int height) {
        String s = this.search.method_1882();
        SortType sort = this.sortType;
        ModListWidget.ModEntry selected = this.selected;
        this.method_25423(mc, width, height);
        this.search.method_1852(s);
        this.selected = selected;
        if (!this.search.method_1882().isEmpty()) {
            this.reloadMods();
        }
        if (sort != SortType.NORMAL) {
            this.resortMods(sort);
        }
        this.updateCache();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parentScreen);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum SortType implements Comparator<IModInfo>
    {
        NORMAL,
        A_TO_Z{

            @Override
            protected int compare(String name1, String name2) {
                return name1.compareTo(name2);
            }
        }
        ,
        Z_TO_A{

            @Override
            protected int compare(String name1, String name2) {
                return name2.compareTo(name1);
            }
        };

        class_4185 button;

        @Override
        protected int compare(String name1, String name2) {
            return 0;
        }

        @Override
        public int compare(IModInfo o1, IModInfo o2) {
            String name1 = StringUtils.toLowerCase(ModListScreen.stripControlCodes(o1.getDisplayName()));
            String name2 = StringUtils.toLowerCase(ModListScreen.stripControlCodes(o2.getDisplayName()));
            return this.compare(name1, name2);
        }

        class_2561 getButtonText() {
            return class_2561.method_43471((String)("fml.menu.mods." + StringUtils.toLowerCase(this.name())));
        }
    }

    class InfoPanel
    extends ScrollPanel {
        private class_2960 logoPath;
        private Size2i logoDims;
        private List<class_5481> lines;

        InfoPanel(class_310 mcIn, int widthIn, int heightIn, int topIn) {
            super(mcIn, widthIn, heightIn, topIn, ModListScreen.this.modList.getRight() + 6);
            this.logoDims = new Size2i(0, 0);
            this.lines = Collections.emptyList();
        }

        void setInfo(List<String> lines, class_2960 logoPath, Size2i logoDims) {
            this.logoPath = logoPath;
            this.logoDims = logoDims;
            this.lines = this.resizeContent(lines);
        }

        void clearInfo() {
            this.logoPath = null;
            this.logoDims = new Size2i(0, 0);
            this.lines = Collections.emptyList();
        }

        private List<class_5481> resizeContent(List<String> lines) {
            ArrayList<class_5481> ret = new ArrayList<class_5481>();
            for (String line : lines) {
                if (line == null) {
                    ret.add(null);
                    continue;
                }
                class_2561 chat = ForgeHooks.newChatWithLinks(line, false);
                int maxTextLength = this.width - 12;
                if (maxTextLength < 0) continue;
                ret.addAll(class_2477.method_10517().method_30933(ModListScreen.this.field_22793.method_27527().method_27495((class_5348)chat, maxTextLength, class_2583.field_24360)));
            }
            return ret;
        }

        @Override
        public int getContentHeight() {
            int height = 50;
            int n = this.lines.size();
            Objects.requireNonNull(ModListScreen.this.field_22793);
            if ((height += n * 9) < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        @Override
        protected int getScrollAmount() {
            Objects.requireNonNull(ModListScreen.this.field_22793);
            return 9 * 3;
        }

        @Override
        protected void drawPanel(class_332 guiGraphics, int entryRight, int relativeY, class_289 tess, int mouseX, int mouseY) {
            if (this.logoPath != null) {
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int headerHeight = 50;
                ((IForgeGuiGraphics)guiGraphics).blitInscribed(this.logoPath, this.left + 6, relativeY, this.width - 12, headerHeight, this.logoDims.width, this.logoDims.height, false, true);
                relativeY += headerHeight + 6;
            }
            for (class_5481 line : this.lines) {
                if (line != null) {
                    RenderSystem.enableBlend();
                    guiGraphics.method_35720(ModListScreen.this.field_22793, line, this.left + 6, relativeY, 0xFFFFFF);
                    RenderSystem.disableBlend();
                }
                Objects.requireNonNull(ModListScreen.this.field_22793);
                relativeY += 9;
            }
            class_2583 component = this.findTextLine(mouseX, mouseY);
            if (component != null) {
                guiGraphics.method_51441(ModListScreen.this.field_22793, component, mouseX, mouseY);
            }
        }

        private class_2583 findTextLine(int mouseX, int mouseY) {
            if (!this.method_25405(mouseX, mouseY)) {
                return null;
            }
            double offset = (float)(mouseY - this.top - 6 - this.border) + this.scrollDistance;
            if (this.logoPath != null) {
                offset -= 50.0;
            }
            if (offset <= 0.0) {
                return null;
            }
            Objects.requireNonNull(ModListScreen.this.field_22793);
            int lineIdx = (int)(offset / 9.0);
            if (lineIdx >= this.lines.size() || lineIdx < 0) {
                return null;
            }
            class_5481 line = this.lines.get(lineIdx);
            if (line != null) {
                return ModListScreen.this.field_22793.method_27527().method_30876(line, mouseX - this.left - this.border);
            }
            return null;
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            class_2583 component = this.findTextLine((int)mouseX, (int)mouseY);
            if (component != null) {
                ModListScreen.this.method_25430(component);
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        public class_6379.class_6380 method_37018() {
            return class_6379.class_6380.field_33784;
        }

        public void method_37020(class_6382 p_169152_) {
        }
    }
}

