/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1316;
import net.minecraft.class_1324;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_266;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_340;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_5134;
import net.minecraft.class_5348;
import net.minecraft.class_634;
import net.minecraft.class_757;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.gui.overlay.GuiOverlayManager;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public class ForgeGui
extends class_329 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int WHITE = 0xFFFFFF;
    public static final List<NamedGuiOverlay> kilt$alreadyProcessedOverlays = new ArrayList<NamedGuiOverlay>();
    public static double rayTraceDistance = 20.0;
    public int leftHeight = 39;
    public int rightHeight = 39;
    private class_327 font = null;
    private final ForgeDebugScreenOverlay debugOverlay;

    public ForgeGui(class_310 mc) {
        super(mc, mc.method_1480());
        this.debugOverlay = new ForgeDebugScreenOverlay(mc);
    }

    public class_310 getMinecraft() {
        return this.field_2035;
    }

    public void setupOverlayRenderState(boolean blend, boolean depthTest) {
        if (blend) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        } else {
            RenderSystem.disableBlend();
        }
        if (depthTest) {
            RenderSystem.enableDepthTest();
        } else {
            RenderSystem.disableDepthTest();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34542);
    }

    public void kilt$setupRender() {
        this.field_2011 = this.field_2035.method_22683().method_4486();
        this.field_2029 = this.field_2035.method_22683().method_4502();
        this.rightHeight = 39;
        this.leftHeight = 39;
    }

    public void method_1753(class_332 guiGraphics, float partialTick) {
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderGuiEvent.Pre(this.field_2035.method_22683(), guiGraphics, partialTick))) {
            return;
        }
        this.font = this.field_2035.field_1772;
        this.field_2034.method_43052((long)this.field_2042 * 312871L);
        GuiOverlayManager.getOverlays().forEach(entry -> {
            try {
                if (entry.id().method_12836().equals("minecraft")) {
                    return;
                }
                if (kilt$alreadyProcessedOverlays.contains(entry)) {
                    return;
                }
                kilt$alreadyProcessedOverlays.add((NamedGuiOverlay)entry);
                IGuiOverlay overlay = entry.overlay();
                if (this.pre((NamedGuiOverlay)entry, guiGraphics)) {
                    return;
                }
                overlay.render(this, guiGraphics, partialTick, this.field_2011, this.field_2029);
                this.post((NamedGuiOverlay)entry, guiGraphics);
            }
            catch (Exception e) {
                LOGGER.error("Error rendering overlay '{}'", (Object)entry.id(), (Object)e);
            }
        });
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MinecraftForge.EVENT_BUS.post((Event)new RenderGuiEvent.Post(this.field_2035.method_22683(), guiGraphics, partialTick));
    }

    public boolean shouldDrawSurvivalElements() {
        return this.field_2035.field_1761.method_2908() && this.field_2035.method_1560() instanceof class_1657;
    }

    protected void renderSubtitles(class_332 guiGraphics) {
        this.field_2027.method_1957(guiGraphics);
    }

    protected void renderBossHealth(class_332 guiGraphics) {
        RenderSystem.defaultBlendFunc();
        this.field_2035.method_16011().method_15396("bossHealth");
        this.field_2030.method_1796(guiGraphics);
        this.field_2035.method_16011().method_15407();
    }

    void renderSpyglassOverlay(class_332 guiGraphics) {
        float deltaFrame = this.field_2035.method_1534();
        this.field_27959 = class_3532.method_16439((float)(0.5f * deltaFrame), (float)this.field_27959, (float)1.125f);
        if (this.field_2035.field_1690.method_31044().method_31034()) {
            if (this.field_2035.field_1724.method_31550()) {
                this.method_32598(guiGraphics, this.field_27959);
            } else {
                this.field_27959 = 0.5f;
            }
        }
    }

    public void renderHelmet(float partialTick, class_332 guiGraphics) {
        this.kilt$renderHelmet(partialTick, guiGraphics, false);
    }

    @ApiStatus.Internal
    public boolean kilt$renderHelmet(float partialTick, class_332 guiGraphics, boolean kilt$isKiltCall) {
        class_1799 itemstack = this.field_2035.field_1724.method_31548().method_7372(3);
        if (this.field_2035.field_1690.method_31044().method_31034() && !itemstack.method_7960()) {
            class_1792 item = itemstack.method_7909();
            if (item == class_2246.field_10147.method_8389()) {
                if (kilt$isKiltCall) {
                    return true;
                }
                this.method_31977(guiGraphics, field_2019, 1.0f);
            } else {
                IClientItemExtensions.of(item).renderHelmetOverlay(itemstack, (class_1657)this.field_2035.field_1724, this.field_2011, this.field_2029, partialTick);
            }
        }
        return false;
    }

    void renderFrostbite(class_332 guiGraphics) {
        if (this.field_2035.field_1724.method_32312() > 0) {
            this.method_31977(guiGraphics, field_27960, this.field_2035.field_1724.method_32313());
        }
    }

    protected void renderArmor(class_332 guiGraphics, int width, int height) {
        this.field_2035.method_16011().method_15396("armor");
        RenderSystem.enableBlend();
        int left = width / 2 - 91;
        int top = height - this.leftHeight;
        int level = this.field_2035.field_1724.method_6096();
        for (int i = 1; level > 0 && i < 20; i += 2) {
            if (i < level) {
                guiGraphics.method_25302(field_44654, left, top, 34, 9, 9, 9);
            } else if (i == level) {
                guiGraphics.method_25302(field_44654, left, top, 25, 9, 9, 9);
            } else if (i > level) {
                guiGraphics.method_25302(field_44654, left, top, 16, 9, 9, 9);
            }
            left += 8;
        }
        this.leftHeight += 10;
        RenderSystem.disableBlend();
        this.field_2035.method_16011().method_15407();
    }

    public void method_1746(class_332 guiGraphics, float alpha) {
        if (alpha > 0.0f) {
            super.method_1746(guiGraphics, alpha);
        }
    }

    protected void renderAir(int width, int height, class_332 guiGraphics) {
        this.field_2035.method_16011().method_15396("air");
        class_1657 player = (class_1657)this.field_2035.method_1560();
        RenderSystem.enableBlend();
        int left = width / 2 + 91;
        int top = height - this.rightHeight;
        int air = player.method_5669();
        if (player.isEyeInFluidType(ForgeMod.WATER_TYPE.get()) || air < 300) {
            int full = class_3532.method_15384((double)((double)(air - 2) * 10.0 / 300.0));
            int partial = class_3532.method_15384((double)((double)air * 10.0 / 300.0)) - full;
            for (int i = 0; i < full + partial; ++i) {
                guiGraphics.method_25302(field_44654, left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
            }
            this.rightHeight += 10;
        }
        RenderSystem.disableBlend();
        this.field_2035.method_16011().method_15407();
    }

    public void renderHealth(int width, int height, class_332 guiGraphics) {
        boolean highlight;
        this.field_2035.method_16011().method_15396("health");
        RenderSystem.enableBlend();
        class_1657 player = (class_1657)this.field_2035.method_1560();
        int health = class_3532.method_15386((float)player.method_6032());
        boolean bl = highlight = this.field_2032 > (long)this.field_2042 && (this.field_2032 - (long)this.field_2042) / 3L % 2L == 1L;
        if (health < this.field_2014 && player.field_6008 > 0) {
            this.field_2012 = class_156.method_658();
            this.field_2032 = this.field_2042 + 20;
        } else if (health > this.field_2014 && player.field_6008 > 0) {
            this.field_2012 = class_156.method_658();
            this.field_2032 = this.field_2042 + 10;
        }
        if (class_156.method_658() - this.field_2012 > 1000L) {
            this.field_2014 = health;
            this.field_2033 = health;
            this.field_2012 = class_156.method_658();
        }
        this.field_2014 = health;
        int healthLast = this.field_2033;
        class_1324 attrMaxHealth = player.method_5996(class_5134.field_23716);
        float healthMax = Math.max((float)attrMaxHealth.method_6194(), (float)Math.max(healthLast, health));
        int absorb = class_3532.method_15386((float)player.method_6067());
        int healthRows = class_3532.method_15386((float)((healthMax + (float)absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.field_2034.method_43052((long)(this.field_2042 * 312871));
        int left = width / 2 - 91;
        int top = height - this.leftHeight;
        this.leftHeight += healthRows * rowHeight;
        if (rowHeight != 10) {
            this.leftHeight += 10 - rowHeight;
        }
        int regen = -1;
        if (player.method_6059(class_1294.field_5924)) {
            regen = this.field_2042 % class_3532.method_15386((float)(healthMax + 5.0f));
        }
        this.method_37298(guiGraphics, player, left, top, rowHeight, regen, healthMax, health, healthLast, absorb, highlight);
        RenderSystem.disableBlend();
        this.field_2035.method_16011().method_15407();
    }

    public void renderFood(int width, int height, class_332 guiGraphics) {
        this.field_2035.method_16011().method_15396("food");
        class_1657 player = (class_1657)this.field_2035.method_1560();
        RenderSystem.enableBlend();
        int left = width / 2 + 91;
        int top = height - this.rightHeight;
        this.rightHeight += 10;
        boolean unused = false;
        class_1702 stats = this.field_2035.field_1724.method_7344();
        int level = stats.method_7586();
        for (int i = 0; i < 10; ++i) {
            int idx = i * 2 + 1;
            int x = left - i * 8 - 9;
            int y = top;
            int icon = 16;
            int background = 0;
            if (this.field_2035.field_1724.method_6059(class_1294.field_5903)) {
                icon += 36;
                background = 13;
            }
            if (unused) {
                background = 1;
            }
            if (player.method_7344().method_7589() <= 0.0f && this.field_2042 % (level * 3 + 1) == 0) {
                y = top + (this.field_2034.method_43048(3) - 1);
            }
            guiGraphics.method_25302(field_44654, x, y, 16 + background * 9, 27, 9, 9);
            if (idx < level) {
                guiGraphics.method_25302(field_44654, x, y, icon + 36, 27, 9, 9);
                continue;
            }
            if (idx != level) continue;
            guiGraphics.method_25302(field_44654, x, y, icon + 45, 27, 9, 9);
        }
        RenderSystem.disableBlend();
        this.field_2035.method_16011().method_15407();
    }

    protected void renderSleepFade(int width, int height, class_332 guiGraphics) {
        if (this.field_2035.field_1724.method_7297() > 0) {
            this.field_2035.method_16011().method_15396("sleep");
            int sleepTime = this.field_2035.field_1724.method_7297();
            float opacity = (float)sleepTime / 100.0f;
            if (opacity > 1.0f) {
                opacity = 1.0f - (float)(sleepTime - 100) / 10.0f;
            }
            int color = (int)(220.0f * opacity) << 24 | 0x101020;
            guiGraphics.method_51739(class_1921.method_51785(), 0, 0, width, height, color);
            this.field_2035.method_16011().method_15407();
        }
    }

    protected void renderExperience(int x, class_332 guiGraphics) {
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        if (this.field_2035.field_1761.method_2913()) {
            super.method_1754(guiGraphics, x);
        }
        RenderSystem.enableBlend();
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void method_1752(class_1316 playerRideableJumping, class_332 guiGraphics, int x) {
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        super.method_1752(playerRideableJumping, guiGraphics, x);
        RenderSystem.enableBlend();
        this.field_2035.method_16011().method_15407();
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void renderHUDText(int width, int height, class_332 guiGraphics) {
        this.field_2035.method_16011().method_15396("forgeHudText");
        RenderSystem.defaultBlendFunc();
        ArrayList<String> listL = new ArrayList<String>();
        ArrayList<String> listR = new ArrayList<String>();
        if (this.field_2035.method_1530()) {
            long time = this.field_2035.field_1687.method_8510();
            if (time >= 120500L) {
                listR.add(class_1074.method_4662((String)"demo.demoExpired", (Object[])new Object[0]));
            } else {
                listR.add(class_1074.method_4662((String)"demo.remainingTime", (Object[])new Object[]{class_3544.method_15439((int)((int)(120500L - time)))}));
            }
        }
        if (this.field_2035.field_1690.field_1866) {
            this.debugOverlay.update();
            listL.addAll(this.debugOverlay.getLeft());
            listR.addAll(this.debugOverlay.getRight());
        }
        CustomizeGuiOverlayEvent.DebugText event = new CustomizeGuiOverlayEvent.DebugText(this.field_2035.method_22683(), guiGraphics, this.field_2035.method_1488(), listL, listR);
        MinecraftForge.EVENT_BUS.post((Event)event);
        int top = 2;
        for (String msg : listL) {
            if (msg != null && !msg.isEmpty()) {
                int n = 2 + this.font.method_1727(msg) + 1;
                Objects.requireNonNull(this.font);
                guiGraphics.method_25294(1, top - 1, n, top + 9 - 1, -1873784752);
                guiGraphics.method_51433(this.font, msg, 2, top, 0xE0E0E0, false);
            }
            Objects.requireNonNull(this.font);
            top += 9;
        }
        top = 2;
        for (String msg : listR) {
            if (msg != null && !msg.isEmpty()) {
                int w = this.font.method_1727(msg);
                int left = width - 2 - w;
                Objects.requireNonNull(this.font);
                guiGraphics.method_25294(left - 1, top - 1, left + w + 1, top + 9 - 1, -1873784752);
                guiGraphics.method_51433(this.font, msg, left, top, 0xE0E0E0, false);
            }
            Objects.requireNonNull(this.font);
            top += 9;
        }
        this.field_2035.method_16011().method_15407();
    }

    protected void renderFPSGraph(class_332 guiGraphics) {
        if (this.field_2035.field_1690.field_1866 && this.field_2035.field_1690.field_1893) {
            this.debugOverlay.method_1846(guiGraphics);
        }
    }

    public void method_1745() {
        super.method_1745();
        this.debugOverlay.method_1842();
    }

    protected void renderRecordOverlay(int width, int height, float partialTick, class_332 guiGraphics) {
        if (this.field_2041 > 0) {
            this.field_2035.method_16011().method_15396("overlayMessage");
            float hue = (float)this.field_2041 - partialTick;
            int opacity = (int)(hue * 255.0f / 20.0f);
            if (opacity > 255) {
                opacity = 255;
            }
            if (opacity > 8) {
                int yShift = Math.max(this.leftHeight, this.rightHeight) + 9;
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_22904((double)width / 2.0, (double)(height - Math.max(yShift, 68)), 0.0);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                int color = this.field_2038 ? class_3532.method_15369((float)(hue / 50.0f), (float)0.7f, (float)0.6f) & 0xFFFFFF : 0xFFFFFF;
                int messageWidth = this.font.method_27525((class_5348)this.field_2018);
                this.method_19346(guiGraphics, this.font, -4, messageWidth, 0xFFFFFF | opacity << 24);
                guiGraphics.method_35720(this.font, this.field_2018.method_30937(), -messageWidth / 2, -4, color | opacity << 24);
                RenderSystem.disableBlend();
                guiGraphics.method_51448().method_22909();
            }
            this.field_2035.method_16011().method_15407();
        }
    }

    protected void renderTitle(int width, int height, float partialTick, class_332 guiGraphics) {
        if (this.field_2016 != null && this.field_2023 > 0) {
            this.field_2035.method_16011().method_15396("titleAndSubtitle");
            float age = (float)this.field_2023 - partialTick;
            int opacity = 255;
            if (this.field_2023 > this.field_2036 + this.field_2017) {
                float f3 = (float)(this.field_2037 + this.field_2017 + this.field_2036) - age;
                opacity = (int)(f3 * 255.0f / (float)this.field_2037);
            }
            if (this.field_2023 <= this.field_2036) {
                opacity = (int)(age * 255.0f / (float)this.field_2036);
            }
            if ((opacity = class_3532.method_15340((int)opacity, (int)0, (int)255)) > 8) {
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_22904((double)width / 2.0, (double)height / 2.0, 0.0);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_22905(4.0f, 4.0f, 4.0f);
                int l = opacity << 24 & 0xFF000000;
                guiGraphics.method_51430(this.font, this.field_2016.method_30937(), -this.method_1756().method_27525((class_5348)this.field_2016) / 2, -10, 0xFFFFFF | l, true);
                guiGraphics.method_51448().method_22909();
                if (this.field_2039 != null) {
                    guiGraphics.method_51448().method_22903();
                    guiGraphics.method_51448().method_22905(2.0f, 2.0f, 2.0f);
                    guiGraphics.method_51430(this.font, this.field_2039.method_30937(), -this.method_1756().method_27525((class_5348)this.field_2039) / 2, 5, 0xFFFFFF | l, true);
                    guiGraphics.method_51448().method_22909();
                }
                RenderSystem.disableBlend();
                guiGraphics.method_51448().method_22909();
            }
            this.field_2035.method_16011().method_15407();
        }
    }

    protected void renderChat(int width, int height, class_332 guiGraphics) {
        this.field_2035.method_16011().method_15396("chat");
        class_1041 window = this.field_2035.method_22683();
        CustomizeGuiOverlayEvent.Chat event = new CustomizeGuiOverlayEvent.Chat(window, guiGraphics, this.field_2035.method_1488(), 0, height - 40);
        MinecraftForge.EVENT_BUS.post((Event)event);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22904((double)event.getPosX(), (double)(event.getPosY() - height + 40) / this.field_2021.method_1814(), 0.0);
        int mouseX = class_3532.method_15357((double)(this.field_2035.field_1729.method_1603() * (double)window.method_4486() / (double)window.method_4480()));
        int mouseY = class_3532.method_15357((double)(this.field_2035.field_1729.method_1604() * (double)window.method_4502() / (double)window.method_4507()));
        this.field_2021.method_1805(guiGraphics, this.field_2042, mouseX, mouseY);
        guiGraphics.method_51448().method_22909();
        this.field_2035.method_16011().method_15407();
    }

    protected void renderPlayerList(int width, int height, class_332 guiGraphics) {
        class_266 scoreobjective = this.field_2035.field_1687.method_8428().method_1189(0);
        class_634 handler = this.field_2035.field_1724.field_3944;
        if (this.field_2035.field_1690.field_1907.method_1434() && (!this.field_2035.method_1542() || handler.method_2880().size() > 1 || scoreobjective != null)) {
            this.field_2015.method_1921(true);
            this.field_2015.method_1919(guiGraphics, width, this.field_2035.field_1687.method_8428(), scoreobjective);
        } else {
            this.field_2015.method_1921(false);
        }
    }

    protected void renderHealthMount(int width, int height, class_332 guiGraphics) {
        class_1657 player = (class_1657)this.field_2035.method_1560();
        class_1297 tmp = player.method_5854();
        if (!(tmp instanceof class_1309)) {
            return;
        }
        boolean unused = false;
        int left_align = width / 2 + 91;
        this.field_2035.method_16011().method_15405("mountHealth");
        RenderSystem.enableBlend();
        class_1309 mount = (class_1309)tmp;
        int health = (int)Math.ceil(mount.method_6032());
        float healthMax = mount.method_6063();
        int hearts = (int)(healthMax + 0.5f) / 2;
        if (hearts > 30) {
            hearts = 30;
        }
        int MARGIN = 52;
        int BACKGROUND = 52 + (unused ? 1 : 0);
        int HALF = 97;
        int FULL = 88;
        int heart = 0;
        while (hearts > 0) {
            int top = height - this.rightHeight;
            int rowCount = Math.min(hearts, 10);
            hearts -= rowCount;
            for (int i = 0; i < rowCount; ++i) {
                int x = left_align - i * 8 - 9;
                guiGraphics.method_25302(field_44654, x, top, BACKGROUND, 9, 9, 9);
                if (i * 2 + 1 + heart < health) {
                    guiGraphics.method_25302(field_44654, x, top, 88, 9, 9, 9);
                    continue;
                }
                if (i * 2 + 1 + heart != health) continue;
                guiGraphics.method_25302(field_44654, x, top, 97, 9, 9, 9);
            }
            this.rightHeight += 10;
            heart += 20;
        }
        RenderSystem.disableBlend();
    }

    private boolean pre(NamedGuiOverlay overlay, class_332 guiGraphics) {
        return MinecraftForge.EVENT_BUS.post((Event)new RenderGuiOverlayEvent.Pre(this.field_2035.method_22683(), guiGraphics, this.field_2035.method_1488(), overlay));
    }

    private void post(NamedGuiOverlay overlay, class_332 guiGraphics) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderGuiOverlayEvent.Post(this.field_2035.method_22683(), guiGraphics, this.field_2035.method_1488(), overlay));
    }

    private static class ForgeDebugScreenOverlay
    extends class_340 {
        private final class_310 mc;

        private ForgeDebugScreenOverlay(class_310 mc) {
            super(mc);
            this.mc = mc;
        }

        public void update() {
            class_1297 entity = this.mc.method_1560();
            this.field_2082 = entity.method_5745(rayTraceDistance, 0.0f, false);
            this.field_2083 = entity.method_5745(rayTraceDistance, 0.0f, true);
        }

        protected void method_1847(class_332 guiGraphics) {
            RenderSystem.disableDepthTest();
        }

        protected void method_1848(class_332 guiGraphics) {
        }

        private List<String> getLeft() {
            List ret = this.method_1835();
            ret.add("");
            boolean flag = this.mc.method_1576() != null;
            ret.add("Debug: Pie [shift]: " + (this.mc.field_1690.field_1880 ? "visible" : "hidden") + (flag ? " FPS + TPS" : " FPS") + " [alt]: " + (this.mc.field_1690.field_1893 ? "visible" : "hidden"));
            ret.add("For help: press F3 + Q");
            return ret;
        }

        private List<String> getRight() {
            return this.method_1839();
        }
    }
}

