/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.loading;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3695;
import net.minecraft.class_437;
import net.minecraft.class_5352;
import net.minecraftforge.client.gui.LoadingErrorScreen;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.ModWorkManager;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.internal.BrandingControl;
import net.minecraftforge.logging.CrashReportExtender;
import net.minecraftforge.resource.DelegatingPackResources;
import net.minecraftforge.resource.PathPackResources;
import net.minecraftforge.server.LanguageHook;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean loading;
    private static class_310 mc;
    private static boolean loadingComplete;
    private static LoadingFailedException error;

    public static void begin(class_310 minecraft, class_3283 defaultResourcePacks, class_3304 mcResourceManager) {
        Runtime.getRuntime().addShutdownHook(new Thread(LogManager::shutdown));
        loading = true;
        mc = minecraft;
        LogicalSidedProvider.setClient(() -> minecraft);
        LanguageHook.loadForgeAndMCLangs();
        ClientModLoader.createRunnableWithCatch(() -> ModLoader.get().gatherAndInitializeMods(ModWorkManager.syncExecutor(), ModWorkManager.parallelExecutor(), () -> {})).run();
        if (error == null) {
            ModLoader.get().postEvent(new AddPackFindersEvent(class_3264.field_14188, arg_0 -> defaultResourcePacks.addPackFinder(arg_0)));
            mcResourceManager.method_14477(ClientModLoader::onResourceReload);
            mcResourceManager.method_14477((class_3302)BrandingControl.resourceManagerReloadListener());
        }
    }

    private static CompletableFuture<Void> onResourceReload(class_3302.class_4045 stage, class_3300 resourceManager, class_3695 prepareProfiler, class_3695 executeProfiler, Executor asyncExecutor, Executor syncExecutor) {
        return ((CompletableFuture)CompletableFuture.runAsync(ClientModLoader.createRunnableWithCatch(() -> ClientModLoader.startModLoading(ModWorkManager.wrappedExecutor(syncExecutor), asyncExecutor)), syncExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)stage).method_18352(arg_0))).thenRunAsync(() -> ClientModLoader.finishModLoading(ModWorkManager.wrappedExecutor(syncExecutor), asyncExecutor), syncExecutor);
    }

    private static Runnable createRunnableWithCatch(Runnable r) {
        return () -> {
            block3: {
                if (loadingComplete) {
                    return;
                }
                try {
                    r.run();
                }
                catch (LoadingFailedException e) {
                    if (error != null) break block3;
                    error = e;
                }
            }
        };
    }

    private static void startModLoading(ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor) {
        ClientModLoader.createRunnableWithCatch(() -> ModLoader.get().loadMods(syncExecutor, parallelExecutor, () -> {})).run();
    }

    private static void finishModLoading(ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor) {
        ClientModLoader.createRunnableWithCatch(() -> ModLoader.get().finishMods(syncExecutor, parallelExecutor, () -> {})).run();
        loading = false;
        loadingComplete = true;
        syncExecutor.execute(() -> ClientModLoader.mc.field_1690.method_1636());
    }

    public static VersionChecker.Status checkForUpdates() {
        boolean anyOutdated = ModList.get().getMods().stream().map(VersionChecker::getResult).map(VersionChecker.CheckResult::status).anyMatch(VersionChecker.Status::isOutdated);
        return anyOutdated ? VersionChecker.Status.OUTDATED : null;
    }

    public static boolean completeModLoading() {
        List<ModLoadingWarning> warnings = ModLoader.get().getWarnings();
        boolean showWarnings = ForgeConfig.CLIENT.showLoadWarnings();
        if (!showWarnings) {
            if (!warnings.isEmpty()) {
                LOGGER.warn(Logging.LOADING, "Mods loaded with {} warning(s)", (Object)warnings.size());
                warnings.forEach(warning -> LOGGER.warn(Logging.LOADING, warning.formatToString()));
            }
            warnings = Collections.emptyList();
        }
        File dumpedLocation = null;
        if (error == null) {
            MinecraftForge.EVENT_BUS.start();
        } else {
            LanguageHook.loadForgeAndMCLangs();
            dumpedLocation = CrashReportExtender.dumpModLoadingCrashReport(LOGGER, error, ClientModLoader.mc.field_1697);
        }
        if (error != null || !warnings.isEmpty()) {
            mc.method_1507((class_437)new LoadingErrorScreen(error, warnings, dumpedLocation));
            return true;
        }
        return false;
    }

    public static boolean isLoading() {
        return loading;
    }

    private static class_3285 buildPackFinder(Map<IModFile, ? extends PathPackResources> modResourcePacks) {
        return packAcceptor -> ClientModLoader.clientPackFinder(modResourcePacks, packAcceptor);
    }

    private static void clientPackFinder(Map<IModFile, ? extends PathPackResources> modResourcePacks, Consumer<class_3288> packAcceptor) {
        ArrayList<PathPackResources> hiddenPacks = new ArrayList<PathPackResources>();
        for (Map.Entry<IModFile, ? extends PathPackResources> e : modResourcePacks.entrySet()) {
            IModInfo mod = (IModInfo)e.getKey().getModInfos().get(0);
            String name = "mod:" + mod.getModId();
            class_3288 modPack = class_3288.method_45275((String)name, (class_2561)class_2561.method_43470((String)e.getValue().method_14409()), (boolean)false, id -> (class_3262)e.getValue(), (class_3264)class_3264.field_14188, (class_3288.class_3289)class_3288.class_3289.field_14281, (class_5352)class_5352.field_25347);
            if (modPack == null) {
                ModLoader.get().addWarning(new ModLoadingWarning(mod, ModLoadingStage.ERROR, "fml.modloading.brokenresources", e.getKey()));
                continue;
            }
            LOGGER.debug(Logging.CORE, "Generating PackInfo named {} for mod file {}", (Object)name, (Object)e.getKey().getFilePath());
            if (mod.getOwningFile().showAsResourcePack()) {
                packAcceptor.accept(modPack);
                continue;
            }
            hiddenPacks.add(e.getValue());
        }
        class_3288 modResourcesPack = class_3288.method_45275((String)"mod_resources", (class_2561)class_2561.method_43470((String)"Mod Resources"), (boolean)true, id -> new DelegatingPackResources(id, false, new class_3272((class_2561)class_2561.method_43469((String)"fml.resources.modresources", (Object[])new Object[]{hiddenPacks.size()}), class_155.method_16673().method_48017(class_3264.field_14188)), hiddenPacks), (class_3264)class_3264.field_14188, (class_3288.class_3289)class_3288.class_3289.field_14281, (class_5352)class_5352.field_25347);
        packAcceptor.accept(modResourcesPack);
    }
}

