/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_326;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_785;
import net.minecraft.class_806;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class DynamicFluidContainerModel
implements IUnbakedGeometry<DynamicFluidContainerModel> {
    private static final class_4590 FLUID_TRANSFORM = new class_4590(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.002f), new Quaternionf());
    private static final class_4590 COVER_TRANSFORM = new class_4590(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.004f), new Quaternionf());
    private final class_3611 fluid;
    private final boolean flipGas;
    private final boolean coverIsMask;
    private final boolean applyFluidLuminosity;

    private DynamicFluidContainerModel(class_3611 fluid, boolean flipGas, boolean coverIsMask, boolean applyFluidLuminosity) {
        this.fluid = fluid;
        this.flipGas = flipGas;
        this.coverIsMask = coverIsMask;
        this.applyFluidLuminosity = applyFluidLuminosity;
    }

    public static RenderTypeGroup getLayerRenderTypes(boolean unlit) {
        return new RenderTypeGroup(class_1921.method_23583(), unlit ? ForgeRenderTypes.ITEM_UNSORTED_UNLIT_TRANSLUCENT.get() : ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
    }

    public DynamicFluidContainerModel withFluid(class_3611 newFluid) {
        return new DynamicFluidContainerModel(newFluid, this.flipGas, this.coverIsMask, this.applyFluidLuminosity);
    }

    @Override
    public class_1087 bake(IGeometryBakingContext context, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_806 overrides, class_2960 modelLocation) {
        List<class_777> quads;
        List<class_785> unbaked;
        SimpleModelState transformedState;
        class_1058 templateSprite;
        class_1058 particleSprite;
        class_4730 particleLocation = context.hasMaterial("particle") ? context.getMaterial("particle") : null;
        class_4730 baseLocation = context.hasMaterial("base") ? context.getMaterial("base") : null;
        class_4730 fluidMaskLocation = context.hasMaterial("fluid") ? context.getMaterial("fluid") : null;
        class_4730 coverLocation = context.hasMaterial("cover") ? context.getMaterial("cover") : null;
        class_1058 baseSprite = baseLocation != null ? spriteGetter.apply(baseLocation) : null;
        class_1058 fluidSprite = this.fluid != class_3612.field_15906 ? spriteGetter.apply(ForgeHooksClient.getBlockMaterial(IClientFluidTypeExtensions.of(this.fluid).getStillTexture())) : null;
        class_1058 coverSprite = coverLocation != null && (!this.coverIsMask || baseLocation != null) ? spriteGetter.apply(coverLocation) : null;
        class_1058 class_10582 = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        if (particleSprite == null) {
            particleSprite = baseSprite;
        }
        if (particleSprite == null && !this.coverIsMask) {
            particleSprite = coverSprite;
        }
        if (this.flipGas && this.fluid != class_3612.field_15906 && this.fluid.getFluidType().isLighterThanAir()) {
            modelState = new SimpleModelState(modelState.method_3509().method_22933(new class_4590(null, new Quaternionf(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder(context).withGui3d(false).withUseBlockLight(false).build(modelLocation);
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder(itemContext, particleSprite, new ContainedFluidOverrideHandler(overrides, baker, itemContext, this), context.getTransforms());
        RenderTypeGroup normalRenderTypes = DynamicFluidContainerModel.getLayerRenderTypes(false);
        if (baseLocation != null && baseSprite != null) {
            List<class_785> unbaked2 = UnbakedGeometryHelper.createUnbakedItemElements(0, baseSprite.method_45851());
            List<class_777> quads2 = UnbakedGeometryHelper.bakeElements(unbaked2, $ -> baseSprite, modelState, modelLocation);
            modelBuilder.addQuads(normalRenderTypes, quads2);
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            transformedState = new SimpleModelState(modelState.method_3509().method_22933(FLUID_TRANSFORM), modelState.method_3512());
            unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements(1, templateSprite.method_45851());
            quads = UnbakedGeometryHelper.bakeElements(unbaked, $ -> fluidSprite, transformedState, modelLocation);
            boolean emissive = this.applyFluidLuminosity && this.fluid.getFluidType().getLightLevel() > 0;
            RenderTypeGroup renderTypes = DynamicFluidContainerModel.getLayerRenderTypes(emissive);
            if (emissive) {
                QuadTransformers.settingMaxEmissivity().processInPlace(quads);
            }
            modelBuilder.addQuads(renderTypes, quads);
        }
        if (coverSprite != null) {
            class_1058 sprite;
            class_1058 class_10583 = sprite = this.coverIsMask ? baseSprite : coverSprite;
            if (sprite != null) {
                transformedState = new SimpleModelState(modelState.method_3509().method_22933(COVER_TRANSFORM), modelState.method_3512());
                unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements(2, coverSprite.method_45851());
                quads = UnbakedGeometryHelper.bakeElements(unbaked, $ -> sprite, transformedState, modelLocation);
                modelBuilder.addQuads(normalRenderTypes, quads);
            }
        }
        modelBuilder.setParticle(particleSprite);
        return modelBuilder.build();
    }

    private static final class ContainedFluidOverrideHandler
    extends class_806 {
        private final Map<String, class_1087> cache = Maps.newHashMap();
        private final class_806 nested;
        private final class_7775 baker;
        private final IGeometryBakingContext owner;
        private final DynamicFluidContainerModel parent;

        private ContainedFluidOverrideHandler(class_806 nested, class_7775 baker, IGeometryBakingContext owner, DynamicFluidContainerModel parent) {
            this.nested = nested;
            this.baker = baker;
            this.owner = owner;
            this.parent = parent;
        }

        public class_1087 method_3495(class_1087 originalModel, class_1799 stack, @Nullable class_638 level, @Nullable class_1309 entity, int seed) {
            class_1087 overridden = this.nested.method_3495(originalModel, stack, level, entity, seed);
            if (overridden != originalModel) {
                return overridden;
            }
            return FluidUtil.getFluidContained(stack).map(fluidStack -> {
                class_3611 fluid = fluidStack.getFluid();
                String name = ForgeRegistries.FLUIDS.getKey(fluid).toString();
                if (!this.cache.containsKey(name)) {
                    DynamicFluidContainerModel unbaked = this.parent.withFluid(fluid);
                    class_1087 bakedModel = unbaked.bake(this.owner, this.baker, class_4730::method_24148, (class_3665)class_1086.field_5350, this, new class_2960("forge:bucket_override"));
                    this.cache.put(name, bakedModel);
                    return bakedModel;
                }
                return this.cache.get(name);
            }).orElse(originalModel);
        }
    }

    public static class Colors
    implements class_326 {
        public int getColor(@NotNull class_1799 stack, int tintIndex) {
            if (tintIndex != 1) {
                return -1;
            }
            return FluidUtil.getFluidContained(stack).map(fluidStack -> IClientFluidTypeExtensions.of(fluidStack.getFluid()).getTintColor((FluidStack)((Object)fluidStack))).orElse(-1);
        }
    }

    public static final class Loader
    implements IGeometryLoader<DynamicFluidContainerModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        @Override
        public DynamicFluidContainerModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            if (!jsonObject.has("fluid")) {
                throw new RuntimeException("Bucket model requires 'fluid' value.");
            }
            class_2960 fluidName = new class_2960(jsonObject.get("fluid").getAsString());
            class_3611 fluid = ForgeRegistries.FLUIDS.getValue(fluidName);
            boolean flip = class_3518.method_15258((JsonObject)jsonObject, (String)"flip_gas", (boolean)false);
            boolean coverIsMask = class_3518.method_15258((JsonObject)jsonObject, (String)"cover_is_mask", (boolean)true);
            boolean applyFluidLuminosity = class_3518.method_15258((JsonObject)jsonObject, (String)"apply_fluid_luminosity", (boolean)true);
            return new DynamicFluidContainerModel(fluid, flip, coverIsMask, applyFluidLuminosity);
        }
    }
}

