/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1093;
import net.minecraft.class_2350;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.EmptyModel;
import xyz.bluspring.kilt.injections.client.resources.model.SimpleBakedModelBuilderInjection;

public interface IModelBuilder<T extends IModelBuilder<T>> {
    public static IModelBuilder<?> of(boolean hasAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, class_809 transforms, class_806 overrides, class_1058 particle, RenderTypeGroup renderTypes) {
        return new Simple(hasAmbientOcclusion, usesBlockLight, isGui3d, transforms, overrides, particle, renderTypes);
    }

    public static IModelBuilder<?> of(boolean hasAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, class_809 transforms, class_806 overrides, class_1058 particle, RenderTypeGroup renderTypes, RenderTypeGroup renderTypesFast) {
        return new Simple(hasAmbientOcclusion, usesBlockLight, isGui3d, transforms, overrides, particle, renderTypes, renderTypesFast);
    }

    public static IModelBuilder<?> collecting(List<class_777> quads) {
        return new Collecting(quads);
    }

    public T addCulledFace(class_2350 var1, class_777 var2);

    public T addUnculledFace(class_777 var1);

    public class_1087 build();

    public static class Simple
    implements IModelBuilder<Simple> {
        private final class_1093.class_1094 builder;
        private final RenderTypeGroup renderTypes;
        private final RenderTypeGroup renderTypesFast;

        private Simple(boolean hasAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, class_809 transforms, class_806 overrides, class_1058 particle, RenderTypeGroup renderTypes) {
            this(hasAmbientOcclusion, usesBlockLight, isGui3d, transforms, overrides, particle, renderTypes, RenderTypeGroup.EMPTY);
        }

        private Simple(boolean hasAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, class_809 transforms, class_806 overrides, class_1058 particle, RenderTypeGroup renderTypes, RenderTypeGroup renderTypesFast) {
            this.builder = new class_1093.class_1094(hasAmbientOcclusion, usesBlockLight, isGui3d, transforms, overrides).method_4747(particle);
            this.renderTypes = renderTypes;
            this.renderTypesFast = renderTypesFast;
        }

        @Override
        public Simple addCulledFace(class_2350 facing, class_777 quad) {
            this.builder.method_4745(facing, quad);
            return this;
        }

        @Override
        public Simple addUnculledFace(class_777 quad) {
            this.builder.method_4748(quad);
            return this;
        }

        @Override
        @Deprecated
        public class_1087 build() {
            return ((SimpleBakedModelBuilderInjection)this.builder).build(this.renderTypes, this.renderTypesFast);
        }
    }

    public static class Collecting
    implements IModelBuilder<Collecting> {
        private final List<class_777> quads;

        private Collecting(List<class_777> quads) {
            this.quads = quads;
        }

        @Override
        public Collecting addCulledFace(class_2350 facing, class_777 quad) {
            this.quads.add(quad);
            return this;
        }

        @Override
        public Collecting addUnculledFace(class_777 quad) {
            this.quads.add(quad);
            return this;
        }

        @Override
        public class_1087 build() {
            return EmptyModel.BAKED;
        }
    }
}

