/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;
import net.minecraft.class_811;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeparateTransformsModel
implements IUnbakedGeometry<SeparateTransformsModel> {
    private final class_793 baseModel;
    private final ImmutableMap<class_811, class_793> perspectives;

    public SeparateTransformsModel(class_793 baseModel, ImmutableMap<class_811, class_793> perspectives) {
        this.baseModel = baseModel;
        this.perspectives = perspectives;
    }

    @Override
    public class_1087 bake(IGeometryBakingContext context, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_806 overrides, class_2960 modelLocation) {
        return new Baked(context.useAmbientOcclusion(), context.isGui3d(), context.useBlockLight(), spriteGetter.apply(context.getMaterial("particle")), overrides, UnbakedGeometryHelper.bake(this.baseModel, baker, this.baseModel, spriteGetter, modelState, modelLocation, context.useBlockLight()), (ImmutableMap<class_811, class_1087>)ImmutableMap.copyOf((Map)Maps.transformValues(this.perspectives, value -> UnbakedGeometryHelper.bake(value, baker, value, spriteGetter, modelState, modelLocation, context.useBlockLight()))));
    }

    @Override
    public void resolveParents(Function<class_2960, class_1100> modelGetter, IGeometryBakingContext context) {
        this.baseModel.method_45785(modelGetter);
        this.perspectives.values().forEach(model -> model.method_45785(modelGetter));
    }

    public static class Baked
    implements IDynamicBakedModel {
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final class_1058 particle;
        private final class_806 overrides;
        private final class_1087 baseModel;
        private final ImmutableMap<class_811, class_1087> perspectives;

        public Baked(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, class_1058 particle, class_806 overrides, class_1087 baseModel, ImmutableMap<class_811, class_1087> perspectives) {
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.overrides = overrides;
            this.baseModel = baseModel;
            this.perspectives = perspectives;
        }

        @Override
        @NotNull
        public List<class_777> getQuads(@Nullable class_2680 state, @Nullable class_2350 side, @NotNull class_5819 rand, @NotNull ModelData data, @Nullable class_1921 renderType) {
            return this.baseModel.getQuads(state, side, rand, data, renderType);
        }

        public boolean method_4708() {
            return this.isAmbientOcclusion;
        }

        public boolean method_4712() {
            return this.isGui3d;
        }

        public boolean method_24304() {
            return this.isSideLit;
        }

        public boolean method_4713() {
            return false;
        }

        public class_1058 method_4711() {
            return this.particle;
        }

        public class_806 method_4710() {
            return this.overrides;
        }

        public class_809 method_4709() {
            return class_809.field_4301;
        }

        public class_1087 applyTransform(class_811 cameraTransformType, class_4587 poseStack, boolean applyLeftHandTransform) {
            if (this.perspectives.containsKey((Object)cameraTransformType)) {
                class_1087 p = (class_1087)this.perspectives.get((Object)cameraTransformType);
                return p.applyTransform(cameraTransformType, poseStack, applyLeftHandTransform);
            }
            return this.baseModel.applyTransform(cameraTransformType, poseStack, applyLeftHandTransform);
        }

        public ChunkRenderTypeSet getRenderTypes(@NotNull class_2680 state, @NotNull class_5819 rand, @NotNull ModelData data) {
            return this.baseModel.getRenderTypes(state, rand, data);
        }
    }

    public static final class Loader
    implements IGeometryLoader<SeparateTransformsModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        @Override
        public SeparateTransformsModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            class_793 baseModel = (class_793)deserializationContext.deserialize((JsonElement)class_3518.method_15296((JsonObject)jsonObject, (String)"base"), class_793.class);
            JsonObject perspectiveData = class_3518.method_15296((JsonObject)jsonObject, (String)"perspectives");
            HashMap<class_811, class_793> perspectives = new HashMap<class_811, class_793>();
            for (class_811 transform : class_811.values()) {
                if (!perspectiveData.has(transform.method_15434())) continue;
                class_793 perspectiveModel = (class_793)deserializationContext.deserialize((JsonElement)class_3518.method_15296((JsonObject)perspectiveData, (String)transform.method_15434()), class_793.class);
                perspectives.put(transform, perspectiveModel);
            }
            return new SeparateTransformsModel(baseModel, (ImmutableMap<class_811, class_793>)ImmutableMap.copyOf(perspectives));
        }
    }
}

