/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.generators;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2310;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2389;
import net.minecraft.class_2405;
import net.minecraft.class_2429;
import net.minecraft.class_2440;
import net.minecraft.class_2465;
import net.minecraft.class_2482;
import net.minecraft.class_2508;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2544;
import net.minecraft.class_2551;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_2960;
import net.minecraft.class_4778;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.IGeneratedBlockState;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class BlockStateProvider
implements class_2405 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    @VisibleForTesting
    protected final Map<class_2248, IGeneratedBlockState> registeredBlocks = new LinkedHashMap<class_2248, IGeneratedBlockState>();
    private final class_7784 output;
    private final String modid;
    private final BlockModelProvider blockModels;
    private final ItemModelProvider itemModels;
    private static final int DEFAULT_ANGLE_OFFSET = 180;
    public static final ImmutableMap<class_2350, class_2769<class_4778>> WALL_PROPS = ImmutableMap.builder().put((Object)class_2350.field_11034, (Object)class_2741.field_22174).put((Object)class_2350.field_11043, (Object)class_2741.field_22175).put((Object)class_2350.field_11035, (Object)class_2741.field_22176).put((Object)class_2350.field_11039, (Object)class_2741.field_22177).build();

    public BlockStateProvider(class_7784 output, String modid, ExistingFileHelper exFileHelper) {
        this.output = output;
        this.modid = modid;
        this.blockModels = new BlockModelProvider(output, modid, exFileHelper){

            @Override
            public CompletableFuture<?> method_10319(class_7403 cache) {
                return CompletableFuture.allOf(new CompletableFuture[0]);
            }

            @Override
            protected void registerModels() {
            }
        };
        this.itemModels = new ItemModelProvider(output, modid, this.blockModels.existingFileHelper){

            @Override
            protected void registerModels() {
            }

            @Override
            public CompletableFuture<?> method_10319(class_7403 cache) {
                return CompletableFuture.allOf(new CompletableFuture[0]);
            }
        };
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.models().clear();
        this.itemModels().clear();
        this.registeredBlocks.clear();
        this.registerStatesAndModels();
        CompletableFuture[] futures = new CompletableFuture[2 + this.registeredBlocks.size()];
        int i = 0;
        futures[i++] = this.models().generateAll(cache);
        futures[i++] = this.itemModels().generateAll(cache);
        for (Map.Entry<class_2248, IGeneratedBlockState> entry : this.registeredBlocks.entrySet()) {
            futures[i++] = this.saveBlockState(cache, entry.getValue().toJson(), entry.getKey());
        }
        return CompletableFuture.allOf(futures);
    }

    protected abstract void registerStatesAndModels();

    public VariantBlockStateBuilder getVariantBuilder(class_2248 b) {
        if (this.registeredBlocks.containsKey(b)) {
            IGeneratedBlockState old = this.registeredBlocks.get(b);
            Preconditions.checkState((boolean)(old instanceof VariantBlockStateBuilder));
            return (VariantBlockStateBuilder)old;
        }
        VariantBlockStateBuilder ret = new VariantBlockStateBuilder(b);
        this.registeredBlocks.put(b, ret);
        return ret;
    }

    public MultiPartBlockStateBuilder getMultipartBuilder(class_2248 b) {
        if (this.registeredBlocks.containsKey(b)) {
            IGeneratedBlockState old = this.registeredBlocks.get(b);
            Preconditions.checkState((boolean)(old instanceof MultiPartBlockStateBuilder));
            return (MultiPartBlockStateBuilder)old;
        }
        MultiPartBlockStateBuilder ret = new MultiPartBlockStateBuilder(b);
        this.registeredBlocks.put(b, ret);
        return ret;
    }

    public BlockModelProvider models() {
        return this.blockModels;
    }

    public ItemModelProvider itemModels() {
        return this.itemModels;
    }

    public class_2960 modLoc(String name) {
        return new class_2960(this.modid, name);
    }

    public class_2960 mcLoc(String name) {
        return new class_2960(name);
    }

    private class_2960 key(class_2248 block) {
        return ForgeRegistries.BLOCKS.getKey(block);
    }

    private String name(class_2248 block) {
        return this.key(block).method_12832();
    }

    public class_2960 blockTexture(class_2248 block) {
        class_2960 name = this.key(block);
        return new class_2960(name.method_12836(), "block/" + name.method_12832());
    }

    private class_2960 extend(class_2960 rl, String suffix) {
        return new class_2960(rl.method_12836(), rl.method_12832() + suffix);
    }

    public ModelFile cubeAll(class_2248 block) {
        return this.models().cubeAll(this.name(block), this.blockTexture(block));
    }

    public void simpleBlock(class_2248 block) {
        this.simpleBlock(block, this.cubeAll(block));
    }

    public void simpleBlock(class_2248 block, Function<ModelFile, ConfiguredModel[]> expander) {
        this.simpleBlock(block, expander.apply(this.cubeAll(block)));
    }

    public void simpleBlock(class_2248 block, ModelFile model) {
        this.simpleBlock(block, new ConfiguredModel(model));
    }

    public void simpleBlockItem(class_2248 block, ModelFile model) {
        ((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).method_12832())).parent(model);
    }

    public void simpleBlockWithItem(class_2248 block, ModelFile model) {
        this.simpleBlock(block, model);
        this.simpleBlockItem(block, model);
    }

    public void simpleBlock(class_2248 block, ConfiguredModel ... models) {
        this.getVariantBuilder(block).partialState().setModels(models);
    }

    public void axisBlock(class_2465 block) {
        this.axisBlock(block, this.blockTexture((class_2248)block));
    }

    public void logBlock(class_2465 block) {
        this.axisBlock(block, this.blockTexture((class_2248)block), this.extend(this.blockTexture((class_2248)block), "_top"));
    }

    public void axisBlock(class_2465 block, class_2960 baseName) {
        this.axisBlock(block, this.extend(baseName, "_side"), this.extend(baseName, "_end"));
    }

    public void axisBlock(class_2465 block, class_2960 side, class_2960 end) {
        this.axisBlock(block, (ModelFile)this.models().cubeColumn(this.name((class_2248)block), side, end), (ModelFile)this.models().cubeColumnHorizontal(this.name((class_2248)block) + "_horizontal", side, end));
    }

    public void axisBlockWithRenderType(class_2465 block, String renderType) {
        this.axisBlockWithRenderType(block, this.blockTexture((class_2248)block), renderType);
    }

    public void logBlockWithRenderType(class_2465 block, String renderType) {
        this.axisBlockWithRenderType(block, this.blockTexture((class_2248)block), this.extend(this.blockTexture((class_2248)block), "_top"), renderType);
    }

    public void axisBlockWithRenderType(class_2465 block, class_2960 baseName, String renderType) {
        this.axisBlockWithRenderType(block, this.extend(baseName, "_side"), this.extend(baseName, "_end"), renderType);
    }

    public void axisBlockWithRenderType(class_2465 block, class_2960 side, class_2960 end, String renderType) {
        this.axisBlock(block, (ModelFile)((BlockModelBuilder)this.models().cubeColumn(this.name((class_2248)block), side, end)).renderType(renderType), (ModelFile)((BlockModelBuilder)this.models().cubeColumnHorizontal(this.name((class_2248)block) + "_horizontal", side, end)).renderType(renderType));
    }

    public void axisBlockWithRenderType(class_2465 block, class_2960 renderType) {
        this.axisBlockWithRenderType(block, this.blockTexture((class_2248)block), renderType);
    }

    public void logBlockWithRenderType(class_2465 block, class_2960 renderType) {
        this.axisBlockWithRenderType(block, this.blockTexture((class_2248)block), this.extend(this.blockTexture((class_2248)block), "_top"), renderType);
    }

    public void axisBlockWithRenderType(class_2465 block, class_2960 baseName, class_2960 renderType) {
        this.axisBlockWithRenderType(block, this.extend(baseName, "_side"), this.extend(baseName, "_end"), renderType);
    }

    public void axisBlockWithRenderType(class_2465 block, class_2960 side, class_2960 end, class_2960 renderType) {
        this.axisBlock(block, (ModelFile)((BlockModelBuilder)this.models().cubeColumn(this.name((class_2248)block), side, end)).renderType(renderType), (ModelFile)((BlockModelBuilder)this.models().cubeColumnHorizontal(this.name((class_2248)block) + "_horizontal", side, end)).renderType(renderType));
    }

    public void axisBlockWithRenderTypeAndFast(class_2465 block, String renderType, String renderTypeFast) {
        this.axisBlockWithRenderTypeAndFast(block, this.blockTexture((class_2248)block), renderType, renderTypeFast);
    }

    public void logBlockWithRenderTypeAndFast(class_2465 block, String renderType, String renderTypeFast) {
        this.axisBlockWithRenderTypeAndFast(block, this.blockTexture((class_2248)block), this.extend(this.blockTexture((class_2248)block), "_top"), renderType, renderTypeFast);
    }

    public void axisBlockWithRenderTypeAndFast(class_2465 block, class_2960 baseName, String renderType, String renderTypeFast) {
        this.axisBlockWithRenderTypeAndFast(block, this.extend(baseName, "_side"), this.extend(baseName, "_end"), renderType, renderTypeFast);
    }

    public void axisBlockWithRenderTypeAndFast(class_2465 block, class_2960 side, class_2960 end, String renderType, String renderTypeFast) {
        this.axisBlock(block, (ModelFile)((BlockModelBuilder)this.models().cubeColumn(this.name((class_2248)block), side, end)).renderType(renderType, renderTypeFast), (ModelFile)((BlockModelBuilder)this.models().cubeColumnHorizontal(this.name((class_2248)block) + "_horizontal", side, end)).renderType(renderType, renderTypeFast));
    }

    public void axisBlockWithRenderTypeAndFast(class_2465 block, class_2960 renderType, class_2960 renderTypeFast) {
        this.axisBlockWithRenderTypeAndFast(block, this.blockTexture((class_2248)block), renderType, renderTypeFast);
    }

    public void logBlockWithRenderType(class_2465 block, class_2960 renderType, class_2960 renderTypeFast) {
        this.axisBlockWithRenderTypeAndFast(block, this.blockTexture((class_2248)block), this.extend(this.blockTexture((class_2248)block), "_top"), renderType, renderTypeFast);
    }

    public void axisBlockWithRenderTypeAndFast(class_2465 block, class_2960 baseName, class_2960 renderType, class_2960 renderTypeFast) {
        this.axisBlockWithRenderTypeAndFast(block, this.extend(baseName, "_side"), this.extend(baseName, "_end"), renderType, renderTypeFast);
    }

    public void axisBlockWithRenderTypeAndFast(class_2465 block, class_2960 side, class_2960 end, class_2960 renderType, class_2960 renderTypeFast) {
        this.axisBlock(block, (ModelFile)((BlockModelBuilder)this.models().cubeColumn(this.name((class_2248)block), side, end)).renderType(renderType, renderTypeFast), (ModelFile)((BlockModelBuilder)this.models().cubeColumnHorizontal(this.name((class_2248)block) + "_horizontal", side, end)).renderType(renderType, renderTypeFast));
    }

    public void axisBlock(class_2465 block, ModelFile vertical, ModelFile horizontal) {
        this.getVariantBuilder((class_2248)block).partialState().with(class_2465.field_11459, class_2350.class_2351.field_11052).modelForState().modelFile(vertical).addModel().partialState().with(class_2465.field_11459, class_2350.class_2351.field_11051).modelForState().modelFile(horizontal).rotationX(90).addModel().partialState().with(class_2465.field_11459, class_2350.class_2351.field_11048).modelForState().modelFile(horizontal).rotationX(90).rotationY(90).addModel();
    }

    public void horizontalBlock(class_2248 block, class_2960 side, class_2960 front, class_2960 top) {
        this.horizontalBlock(block, (ModelFile)this.models().orientable(this.name(block), side, front, top));
    }

    public void horizontalBlock(class_2248 block, ModelFile model) {
        this.horizontalBlock(block, model, 180);
    }

    public void horizontalBlock(class_2248 block, ModelFile model, int angleOffset) {
        this.horizontalBlock(block, (class_2680 $) -> model, angleOffset);
    }

    public void horizontalBlock(class_2248 block, Function<class_2680, ModelFile> modelFunc) {
        this.horizontalBlock(block, modelFunc, 180);
    }

    public void horizontalBlock(class_2248 block, Function<class_2680, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((class_2680)state)).rotationY(((int)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10144() + angleOffset) % 360).build());
    }

    public void horizontalFaceBlock(class_2248 block, ModelFile model) {
        this.horizontalFaceBlock(block, model, 180);
    }

    public void horizontalFaceBlock(class_2248 block, ModelFile model, int angleOffset) {
        this.horizontalFaceBlock(block, (class_2680 $) -> model, angleOffset);
    }

    public void horizontalFaceBlock(class_2248 block, Function<class_2680, ModelFile> modelFunc) {
        this.horizontalFaceBlock(block, modelFunc, 180);
    }

    public void horizontalFaceBlock(class_2248 block, Function<class_2680, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((class_2680)state)).rotationX(((class_2738)state.method_11654((class_2769)class_2741.field_12555)).ordinal() * 90).rotationY(((int)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10144() + angleOffset + (state.method_11654((class_2769)class_2741.field_12555) == class_2738.field_12473 ? 180 : 0)) % 360).build());
    }

    public void directionalBlock(class_2248 block, ModelFile model) {
        this.directionalBlock(block, model, 180);
    }

    public void directionalBlock(class_2248 block, ModelFile model, int angleOffset) {
        this.directionalBlock(block, (class_2680 $) -> model, angleOffset);
    }

    public void directionalBlock(class_2248 block, Function<class_2680, ModelFile> modelFunc) {
        this.directionalBlock(block, modelFunc, 180);
    }

    public void directionalBlock(class_2248 block, Function<class_2680, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStates(state -> {
            class_2350 dir = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((class_2680)state)).rotationX(dir == class_2350.field_11033 ? 180 : (dir.method_10166().method_10179() ? 90 : 0)).rotationY(dir.method_10166().method_10178() ? 0 : ((int)dir.method_10144() + angleOffset) % 360).build();
        });
    }

    public void stairsBlock(class_2510 block, class_2960 texture) {
        this.stairsBlock(block, texture, texture, texture);
    }

    public void stairsBlock(class_2510 block, String name, class_2960 texture) {
        this.stairsBlock(block, name, texture, texture, texture);
    }

    public void stairsBlock(class_2510 block, class_2960 side, class_2960 bottom, class_2960 top) {
        this.stairsBlockInternal(block, this.key((class_2248)block).toString(), side, bottom, top);
    }

    public void stairsBlock(class_2510 block, String name, class_2960 side, class_2960 bottom, class_2960 top) {
        this.stairsBlockInternal(block, name + "_stairs", side, bottom, top);
    }

    public void stairsBlockWithRenderType(class_2510 block, class_2960 texture, String renderType) {
        this.stairsBlockWithRenderType(block, texture, texture, texture, renderType);
    }

    public void stairsBlockWithRenderType(class_2510 block, String name, class_2960 texture, String renderType) {
        this.stairsBlockWithRenderType(block, name, texture, texture, texture, renderType);
    }

    public void stairsBlockWithRenderType(class_2510 block, class_2960 side, class_2960 bottom, class_2960 top, String renderType) {
        this.stairsBlockInternalWithRenderType(block, this.key((class_2248)block).toString(), side, bottom, top, class_2960.method_12829((String)renderType));
    }

    public void stairsBlockWithRenderType(class_2510 block, String name, class_2960 side, class_2960 bottom, class_2960 top, String renderType) {
        this.stairsBlockInternalWithRenderType(block, name + "_stairs", side, bottom, top, class_2960.method_12829((String)renderType));
    }

    public void stairsBlockWithRenderType(class_2510 block, class_2960 texture, class_2960 renderType) {
        this.stairsBlockWithRenderType(block, texture, texture, texture, renderType);
    }

    public void stairsBlockWithRenderType(class_2510 block, String name, class_2960 texture, class_2960 renderType) {
        this.stairsBlockWithRenderType(block, name, texture, texture, texture, renderType);
    }

    public void stairsBlockWithRenderType(class_2510 block, class_2960 side, class_2960 bottom, class_2960 top, class_2960 renderType) {
        this.stairsBlockInternalWithRenderType(block, this.key((class_2248)block).toString(), side, bottom, top, renderType);
    }

    public void stairsBlockWithRenderType(class_2510 block, String name, class_2960 side, class_2960 bottom, class_2960 top, class_2960 renderType) {
        this.stairsBlockInternalWithRenderType(block, name + "_stairs", side, bottom, top, renderType);
    }

    public void stairsBlockWithRenderTypeAndFast(class_2510 block, class_2960 texture, String renderType, String renderTypeFast) {
        this.stairsBlockWithRenderTypeAndFast(block, texture, texture, texture, renderType, renderTypeFast);
    }

    public void stairsBlockWithRenderTypeAndFast(class_2510 block, String name, class_2960 texture, String renderType, String renderTypeFast) {
        this.stairsBlockWithRenderTypeAndFast(block, name, texture, texture, texture, renderType, renderTypeFast);
    }

    public void stairsBlockWithRenderTypeAndFast(class_2510 block, class_2960 side, class_2960 bottom, class_2960 top, String renderType, String renderTypeFast) {
        this.stairsBlockInternalWithRenderTypeAndFast(block, this.key((class_2248)block).toString(), side, bottom, top, class_2960.method_12829((String)renderType), class_2960.method_12829((String)renderTypeFast));
    }

    public void stairsBlockWithRenderTypeAndFast(class_2510 block, String name, class_2960 side, class_2960 bottom, class_2960 top, String renderType, String renderTypeFast) {
        this.stairsBlockInternalWithRenderTypeAndFast(block, name + "_stairs", side, bottom, top, class_2960.method_12829((String)renderType), class_2960.method_12829((String)renderTypeFast));
    }

    public void stairsBlockWithRenderTypeAndFast(class_2510 block, class_2960 texture, class_2960 renderType, class_2960 renderTypeFast) {
        this.stairsBlockWithRenderTypeAndFast(block, texture, texture, texture, renderType, renderTypeFast);
    }

    public void stairsBlockWithRenderTypeAndFast(class_2510 block, String name, class_2960 texture, class_2960 renderType, class_2960 renderTypeFast) {
        this.stairsBlockWithRenderTypeAndFast(block, name, texture, texture, texture, renderType, renderTypeFast);
    }

    public void stairsBlockWithRenderTypeAndFast(class_2510 block, class_2960 side, class_2960 bottom, class_2960 top, class_2960 renderType, class_2960 renderTypeFast) {
        this.stairsBlockInternalWithRenderTypeAndFast(block, this.key((class_2248)block).toString(), side, bottom, top, renderType, renderTypeFast);
    }

    public void stairsBlockWithRenderTypeAndFast(class_2510 block, String name, class_2960 side, class_2960 bottom, class_2960 top, class_2960 renderType, class_2960 renderTypeFast) {
        this.stairsBlockInternalWithRenderTypeAndFast(block, name + "_stairs", side, bottom, top, renderType, renderTypeFast);
    }

    private void stairsBlockInternal(class_2510 block, String baseName, class_2960 side, class_2960 bottom, class_2960 top) {
        Object stairs = this.models().stairs(baseName, side, bottom, top);
        Object stairsInner = this.models().stairsInner(baseName + "_inner", side, bottom, top);
        Object stairsOuter = this.models().stairsOuter(baseName + "_outer", side, bottom, top);
        this.stairsBlock(block, (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
    }

    private void stairsBlockInternalWithRenderType(class_2510 block, String baseName, class_2960 side, class_2960 bottom, class_2960 top, class_2960 renderType) {
        Object stairs = ((BlockModelBuilder)this.models().stairs(baseName, side, bottom, top)).renderType(renderType);
        Object stairsInner = ((BlockModelBuilder)this.models().stairsInner(baseName + "_inner", side, bottom, top)).renderType(renderType);
        Object stairsOuter = ((BlockModelBuilder)this.models().stairsOuter(baseName + "_outer", side, bottom, top)).renderType(renderType);
        this.stairsBlock(block, (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
    }

    private void stairsBlockInternalWithRenderTypeAndFast(class_2510 block, String baseName, class_2960 side, class_2960 bottom, class_2960 top, class_2960 renderType, class_2960 renderTypeFast) {
        Object stairs = ((BlockModelBuilder)this.models().stairs(baseName, side, bottom, top)).renderType(renderType, renderTypeFast);
        Object stairsInner = ((BlockModelBuilder)this.models().stairsInner(baseName + "_inner", side, bottom, top)).renderType(renderType, renderTypeFast);
        Object stairsOuter = ((BlockModelBuilder)this.models().stairsOuter(baseName + "_outer", side, bottom, top)).renderType(renderType, renderTypeFast);
        this.stairsBlock(block, (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
    }

    public void stairsBlock(class_2510 block, ModelFile stairs, ModelFile stairsInner, ModelFile stairsOuter) {
        this.getVariantBuilder((class_2248)block).forAllStatesExcept(state -> {
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2510.field_11571);
            class_2760 half = (class_2760)state.method_11654((class_2769)class_2510.field_11572);
            class_2778 shape = (class_2778)state.method_11654((class_2769)class_2510.field_11565);
            int yRot = (int)facing.method_10170().method_10144();
            if (shape == class_2778.field_12712 || shape == class_2778.field_12708) {
                yRot += 270;
            }
            if (shape != class_2778.field_12710 && half == class_2760.field_12619) {
                yRot += 90;
            }
            boolean uvlock = (yRot %= 360) != 0 || half == class_2760.field_12619;
            return ConfiguredModel.builder().modelFile(shape == class_2778.field_12710 ? stairs : (shape == class_2778.field_12712 || shape == class_2778.field_12713 ? stairsInner : stairsOuter)).rotationX(half == class_2760.field_12617 ? 0 : 180).rotationY(yRot).uvLock(uvlock).build();
        }, new class_2769[]{class_2510.field_11573});
    }

    public void slabBlock(class_2482 block, class_2960 doubleslab, class_2960 texture) {
        this.slabBlock(block, doubleslab, texture, texture, texture);
    }

    public void slabBlock(class_2482 block, class_2960 doubleslab, class_2960 side, class_2960 bottom, class_2960 top) {
        this.slabBlock(block, (ModelFile)this.models().slab(this.name((class_2248)block), side, bottom, top), (ModelFile)this.models().slabTop(this.name((class_2248)block) + "_top", side, bottom, top), this.models().getExistingFile(doubleslab));
    }

    public void slabBlock(class_2482 block, ModelFile bottom, ModelFile top, ModelFile doubleslab) {
        this.getVariantBuilder((class_2248)block).partialState().with(class_2482.field_11501, class_2771.field_12681).addModels(new ConfiguredModel(bottom)).partialState().with(class_2482.field_11501, class_2771.field_12679).addModels(new ConfiguredModel(top)).partialState().with(class_2482.field_11501, class_2771.field_12682).addModels(new ConfiguredModel(doubleslab));
    }

    public void buttonBlock(class_2269 block, class_2960 texture) {
        Object button = this.models().button(this.name((class_2248)block), texture);
        Object buttonPressed = this.models().buttonPressed(this.name((class_2248)block) + "_pressed", texture);
        this.buttonBlock(block, (ModelFile)button, (ModelFile)buttonPressed);
    }

    public void buttonBlock(class_2269 block, ModelFile button, ModelFile buttonPressed) {
        this.getVariantBuilder((class_2248)block).forAllStates(state -> {
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2269.field_11177);
            class_2738 face = (class_2738)state.method_11654((class_2769)class_2269.field_11007);
            boolean powered = (Boolean)state.method_11654((class_2769)class_2269.field_10729);
            return ConfiguredModel.builder().modelFile(powered ? buttonPressed : button).rotationX(face == class_2738.field_12475 ? 0 : (face == class_2738.field_12471 ? 90 : 180)).rotationY((int)(face == class_2738.field_12473 ? facing : facing.method_10153()).method_10144()).uvLock(face == class_2738.field_12471).build();
        });
    }

    public void pressurePlateBlock(class_2440 block, class_2960 texture) {
        Object pressurePlate = this.models().pressurePlate(this.name((class_2248)block), texture);
        Object pressurePlateDown = this.models().pressurePlateDown(this.name((class_2248)block) + "_down", texture);
        this.pressurePlateBlock(block, (ModelFile)pressurePlate, (ModelFile)pressurePlateDown);
    }

    public void pressurePlateBlock(class_2440 block, ModelFile pressurePlate, ModelFile pressurePlateDown) {
        this.getVariantBuilder((class_2248)block).partialState().with(class_2440.field_11358, true).addModels(new ConfiguredModel(pressurePlateDown)).partialState().with(class_2440.field_11358, false).addModels(new ConfiguredModel(pressurePlate));
    }

    public void signBlock(class_2508 signBlock, class_2551 wallSignBlock, class_2960 texture) {
        Object sign = this.models().sign(this.name((class_2248)signBlock), texture);
        this.signBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }

    public void signBlock(class_2508 signBlock, class_2551 wallSignBlock, ModelFile sign) {
        this.simpleBlock((class_2248)signBlock, sign);
        this.simpleBlock((class_2248)wallSignBlock, sign);
    }

    public void fourWayBlock(class_2310 block, ModelFile post, ModelFile side) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((class_2248)block).part().modelFile(post).addModel().end();
        this.fourWayMultipart(builder, side);
    }

    public void fourWayMultipart(MultiPartBlockStateBuilder builder, ModelFile side) {
        class_2429.field_11329.entrySet().forEach(e -> {
            class_2350 dir = (class_2350)e.getKey();
            if (dir.method_10166().method_10179()) {
                builder.part().modelFile(side).rotationY(((int)dir.method_10144() + 180) % 360).uvLock(true).addModel().condition((class_2769)e.getValue(), new Boolean[]{true});
            }
        });
    }

    public void fenceBlock(class_2354 block, class_2960 texture) {
        String baseName = this.key((class_2248)block).toString();
        this.fourWayBlock((class_2310)block, (ModelFile)this.models().fencePost(baseName + "_post", texture), (ModelFile)this.models().fenceSide(baseName + "_side", texture));
    }

    public void fenceBlock(class_2354 block, String name, class_2960 texture) {
        this.fourWayBlock((class_2310)block, (ModelFile)this.models().fencePost(name + "_fence_post", texture), (ModelFile)this.models().fenceSide(name + "_fence_side", texture));
    }

    public void fenceBlockWithRenderType(class_2354 block, class_2960 texture, String renderType) {
        String baseName = this.key((class_2248)block).toString();
        this.fourWayBlock((class_2310)block, (ModelFile)((BlockModelBuilder)this.models().fencePost(baseName + "_post", texture)).renderType(renderType), (ModelFile)((BlockModelBuilder)this.models().fenceSide(baseName + "_side", texture)).renderType(renderType));
    }

    public void fenceBlockWithRenderType(class_2354 block, String name, class_2960 texture, String renderType) {
        this.fourWayBlock((class_2310)block, (ModelFile)((BlockModelBuilder)this.models().fencePost(name + "_fence_post", texture)).renderType(renderType), (ModelFile)((BlockModelBuilder)this.models().fenceSide(name + "_fence_side", texture)).renderType(renderType));
    }

    public void fenceBlockWithRenderType(class_2354 block, class_2960 texture, class_2960 renderType) {
        String baseName = this.key((class_2248)block).toString();
        this.fourWayBlock((class_2310)block, (ModelFile)((BlockModelBuilder)this.models().fencePost(baseName + "_post", texture)).renderType(renderType), (ModelFile)((BlockModelBuilder)this.models().fenceSide(baseName + "_side", texture)).renderType(renderType));
    }

    public void fenceBlockWithRenderType(class_2354 block, String name, class_2960 texture, class_2960 renderType) {
        this.fourWayBlock((class_2310)block, (ModelFile)((BlockModelBuilder)this.models().fencePost(name + "_fence_post", texture)).renderType(renderType), (ModelFile)((BlockModelBuilder)this.models().fenceSide(name + "_fence_side", texture)).renderType(renderType));
    }

    public void fenceBlockWithRenderTypeAndFast(class_2354 block, class_2960 texture, String renderType, String renderTypeFast) {
        String baseName = this.key((class_2248)block).toString();
        this.fourWayBlock((class_2310)block, (ModelFile)((BlockModelBuilder)this.models().fencePost(baseName + "_post", texture)).renderType(renderType, renderTypeFast), (ModelFile)((BlockModelBuilder)this.models().fenceSide(baseName + "_side", texture)).renderType(renderType, renderTypeFast));
    }

    public void fenceBlockWithRenderTypeAndFast(class_2354 block, String name, class_2960 texture, String renderType, String renderTypeFast) {
        this.fourWayBlock((class_2310)block, (ModelFile)((BlockModelBuilder)this.models().fencePost(name + "_fence_post", texture)).renderType(renderType, renderTypeFast), (ModelFile)((BlockModelBuilder)this.models().fenceSide(name + "_fence_side", texture)).renderType(renderType, renderTypeFast));
    }

    public void fenceBlockWithRenderTypeAndFast(class_2354 block, class_2960 texture, class_2960 renderType, class_2960 renderTypeFast) {
        String baseName = this.key((class_2248)block).toString();
        this.fourWayBlock((class_2310)block, (ModelFile)((BlockModelBuilder)this.models().fencePost(baseName + "_post", texture)).renderType(renderType, renderTypeFast), (ModelFile)((BlockModelBuilder)this.models().fenceSide(baseName + "_side", texture)).renderType(renderType, renderTypeFast));
    }

    public void fenceBlockWithRenderTypeAndFast(class_2354 block, String name, class_2960 texture, class_2960 renderType, class_2960 renderTypeFast) {
        this.fourWayBlock((class_2310)block, (ModelFile)((BlockModelBuilder)this.models().fencePost(name + "_fence_post", texture)).renderType(renderType, renderTypeFast), (ModelFile)((BlockModelBuilder)this.models().fenceSide(name + "_fence_side", texture)).renderType(renderType, renderTypeFast));
    }

    public void fenceGateBlock(class_2349 block, class_2960 texture) {
        this.fenceGateBlockInternal(block, this.key((class_2248)block).toString(), texture);
    }

    public void fenceGateBlock(class_2349 block, String name, class_2960 texture) {
        this.fenceGateBlockInternal(block, name + "_fence_gate", texture);
    }

    public void fenceGateBlockWithRenderType(class_2349 block, class_2960 texture, String renderType) {
        this.fenceGateBlockInternalWithRenderType(block, this.key((class_2248)block).toString(), texture, class_2960.method_12829((String)renderType));
    }

    public void fenceGateBlockWithRenderType(class_2349 block, String name, class_2960 texture, String renderType) {
        this.fenceGateBlockInternalWithRenderType(block, name + "_fence_gate", texture, class_2960.method_12829((String)renderType));
    }

    public void fenceGateBlockWithRenderType(class_2349 block, class_2960 texture, class_2960 renderType) {
        this.fenceGateBlockInternalWithRenderType(block, this.key((class_2248)block).toString(), texture, renderType);
    }

    public void fenceGateBlockWithRenderType(class_2349 block, String name, class_2960 texture, class_2960 renderType) {
        this.fenceGateBlockInternalWithRenderType(block, name + "_fence_gate", texture, renderType);
    }

    public void fenceGateBlockWithRenderTypeAndFast(class_2349 block, class_2960 texture, String renderType, String renderTypeFast) {
        this.fenceGateBlockInternalWithRenderTypeAndFast(block, this.key((class_2248)block).toString(), texture, class_2960.method_12829((String)renderType), class_2960.method_12829((String)renderTypeFast));
    }

    public void fenceGateBlockWithRenderTypeAndFast(class_2349 block, String name, class_2960 texture, String renderType, String renderTypeFast) {
        this.fenceGateBlockInternalWithRenderTypeAndFast(block, name + "_fence_gate", texture, class_2960.method_12829((String)renderType), class_2960.method_12829((String)renderTypeFast));
    }

    public void fenceGateBlockWithRenderTypeAndFast(class_2349 block, class_2960 texture, class_2960 renderType, class_2960 renderTypeFast) {
        this.fenceGateBlockInternalWithRenderTypeAndFast(block, this.key((class_2248)block).toString(), texture, renderType, renderTypeFast);
    }

    public void fenceGateBlockWithRenderTypeAndFast(class_2349 block, String name, class_2960 texture, class_2960 renderType, class_2960 renderTypeFast) {
        this.fenceGateBlockInternalWithRenderTypeAndFast(block, name + "_fence_gate", texture, renderType, renderTypeFast);
    }

    private void fenceGateBlockInternal(class_2349 block, String baseName, class_2960 texture) {
        Object gate = this.models().fenceGate(baseName, texture);
        Object gateOpen = this.models().fenceGateOpen(baseName + "_open", texture);
        Object gateWall = this.models().fenceGateWall(baseName + "_wall", texture);
        Object gateWallOpen = this.models().fenceGateWallOpen(baseName + "_wall_open", texture);
        this.fenceGateBlock(block, (ModelFile)gate, (ModelFile)gateOpen, (ModelFile)gateWall, (ModelFile)gateWallOpen);
    }

    private void fenceGateBlockInternalWithRenderType(class_2349 block, String baseName, class_2960 texture, class_2960 renderType) {
        Object gate = ((BlockModelBuilder)this.models().fenceGate(baseName, texture)).renderType(renderType);
        Object gateOpen = ((BlockModelBuilder)this.models().fenceGateOpen(baseName + "_open", texture)).renderType(renderType);
        Object gateWall = ((BlockModelBuilder)this.models().fenceGateWall(baseName + "_wall", texture)).renderType(renderType);
        Object gateWallOpen = ((BlockModelBuilder)this.models().fenceGateWallOpen(baseName + "_wall_open", texture)).renderType(renderType);
        this.fenceGateBlock(block, (ModelFile)gate, (ModelFile)gateOpen, (ModelFile)gateWall, (ModelFile)gateWallOpen);
    }

    private void fenceGateBlockInternalWithRenderTypeAndFast(class_2349 block, String baseName, class_2960 texture, class_2960 renderType, class_2960 renderTypeFast) {
        Object gate = ((BlockModelBuilder)this.models().fenceGate(baseName, texture)).renderType(renderType, renderTypeFast);
        Object gateOpen = ((BlockModelBuilder)this.models().fenceGateOpen(baseName + "_open", texture)).renderType(renderType, renderTypeFast);
        Object gateWall = ((BlockModelBuilder)this.models().fenceGateWall(baseName + "_wall", texture)).renderType(renderType, renderTypeFast);
        Object gateWallOpen = ((BlockModelBuilder)this.models().fenceGateWallOpen(baseName + "_wall_open", texture)).renderType(renderType, renderTypeFast);
        this.fenceGateBlock(block, (ModelFile)gate, (ModelFile)gateOpen, (ModelFile)gateWall, (ModelFile)gateWallOpen);
    }

    public void fenceGateBlock(class_2349 block, ModelFile gate, ModelFile gateOpen, ModelFile gateWall, ModelFile gateWallOpen) {
        this.getVariantBuilder((class_2248)block).forAllStatesExcept(state -> {
            ModelFile model = gate;
            if (((Boolean)state.method_11654((class_2769)class_2349.field_11024)).booleanValue()) {
                model = gateWall;
            }
            if (((Boolean)state.method_11654((class_2769)class_2349.field_11026)).booleanValue()) {
                model = model == gateWall ? gateWallOpen : gateOpen;
            }
            return ConfiguredModel.builder().modelFile(model).rotationY((int)((class_2350)state.method_11654((class_2769)class_2349.field_11177)).method_10144()).uvLock(true).build();
        }, new class_2769[]{class_2349.field_11021});
    }

    public void wallBlock(class_2544 block, class_2960 texture) {
        this.wallBlockInternal(block, this.key((class_2248)block).toString(), texture);
    }

    public void wallBlock(class_2544 block, String name, class_2960 texture) {
        this.wallBlockInternal(block, name + "_wall", texture);
    }

    public void wallBlockWithRenderType(class_2544 block, class_2960 texture, String renderType) {
        this.wallBlockInternalWithRenderType(block, this.key((class_2248)block).toString(), texture, class_2960.method_12829((String)renderType));
    }

    public void wallBlockWithRenderType(class_2544 block, String name, class_2960 texture, String renderType) {
        this.wallBlockInternalWithRenderType(block, name + "_wall", texture, class_2960.method_12829((String)renderType));
    }

    public void wallBlockWithRenderType(class_2544 block, class_2960 texture, class_2960 renderType) {
        this.wallBlockInternalWithRenderType(block, this.key((class_2248)block).toString(), texture, renderType);
    }

    public void wallBlockWithRenderType(class_2544 block, String name, class_2960 texture, class_2960 renderType) {
        this.wallBlockInternalWithRenderType(block, name + "_wall", texture, renderType);
    }

    public void wallBlockWithRenderTypeAndFast(class_2544 block, class_2960 texture, String renderType, String renderTypeFast) {
        this.wallBlockInternalWithRenderTypeAndFast(block, this.key((class_2248)block).toString(), texture, class_2960.method_12829((String)renderType), class_2960.method_12829((String)renderTypeFast));
    }

    public void wallBlockWithRenderTypeAndFast(class_2544 block, String name, class_2960 texture, String renderType, String renderTypeFast) {
        this.wallBlockInternalWithRenderTypeAndFast(block, name + "_wall", texture, class_2960.method_12829((String)renderType), class_2960.method_12829((String)renderTypeFast));
    }

    public void wallBlockWithRenderTypeAndFast(class_2544 block, class_2960 texture, class_2960 renderType, class_2960 renderTypeFast) {
        this.wallBlockInternalWithRenderTypeAndFast(block, this.key((class_2248)block).toString(), texture, renderType, renderTypeFast);
    }

    public void wallBlockWithRenderTypeAndFast(class_2544 block, String name, class_2960 texture, class_2960 renderType, class_2960 renderTypeFast) {
        this.wallBlockInternalWithRenderTypeAndFast(block, name + "_wall", texture, renderType, renderTypeFast);
    }

    private void wallBlockInternal(class_2544 block, String baseName, class_2960 texture) {
        this.wallBlock(block, (ModelFile)this.models().wallPost(baseName + "_post", texture), (ModelFile)this.models().wallSide(baseName + "_side", texture), (ModelFile)this.models().wallSideTall(baseName + "_side_tall", texture));
    }

    private void wallBlockInternalWithRenderType(class_2544 block, String baseName, class_2960 texture, class_2960 renderType) {
        this.wallBlock(block, (ModelFile)((BlockModelBuilder)this.models().wallPost(baseName + "_post", texture)).renderType(renderType), (ModelFile)((BlockModelBuilder)this.models().wallSide(baseName + "_side", texture)).renderType(renderType), (ModelFile)((BlockModelBuilder)this.models().wallSideTall(baseName + "_side_tall", texture)).renderType(renderType));
    }

    private void wallBlockInternalWithRenderTypeAndFast(class_2544 block, String baseName, class_2960 texture, class_2960 renderType, class_2960 renderTypeFast) {
        this.wallBlock(block, (ModelFile)((BlockModelBuilder)this.models().wallPost(baseName + "_post", texture)).renderType(renderType, renderTypeFast), (ModelFile)((BlockModelBuilder)this.models().wallSide(baseName + "_side", texture)).renderType(renderType, renderTypeFast), (ModelFile)((BlockModelBuilder)this.models().wallSideTall(baseName + "_side_tall", texture)).renderType(renderType, renderTypeFast));
    }

    public void wallBlock(class_2544 block, ModelFile post, ModelFile side, ModelFile sideTall) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((class_2248)block).part().modelFile(post).addModel().condition((class_2769)class_2544.field_11717, new Boolean[]{true}).end();
        WALL_PROPS.entrySet().stream().filter(e -> ((class_2350)e.getKey()).method_10166().method_10179()).forEach(e -> {
            this.wallSidePart(builder, side, (Map.Entry<class_2350, class_2769<class_4778>>)e, class_4778.field_22179);
            this.wallSidePart(builder, sideTall, (Map.Entry<class_2350, class_2769<class_4778>>)e, class_4778.field_22180);
        });
    }

    private void wallSidePart(MultiPartBlockStateBuilder builder, ModelFile model, Map.Entry<class_2350, class_2769<class_4778>> entry, class_4778 height) {
        builder.part().modelFile(model).rotationY(((int)entry.getKey().method_10144() + 180) % 360).uvLock(true).addModel().condition(entry.getValue(), (Comparable[])new class_4778[]{height});
    }

    public void paneBlock(class_2389 block, class_2960 pane, class_2960 edge) {
        this.paneBlockInternal(block, this.key((class_2248)block).toString(), pane, edge);
    }

    public void paneBlock(class_2389 block, String name, class_2960 pane, class_2960 edge) {
        this.paneBlockInternal(block, name + "_pane", pane, edge);
    }

    public void paneBlockWithRenderType(class_2389 block, class_2960 pane, class_2960 edge, String renderType) {
        this.paneBlockInternalWithRenderType(block, this.key((class_2248)block).toString(), pane, edge, class_2960.method_12829((String)renderType));
    }

    public void paneBlockWithRenderType(class_2389 block, String name, class_2960 pane, class_2960 edge, String renderType) {
        this.paneBlockInternalWithRenderType(block, name + "_pane", pane, edge, class_2960.method_12829((String)renderType));
    }

    public void paneBlockWithRenderType(class_2389 block, class_2960 pane, class_2960 edge, class_2960 renderType) {
        this.paneBlockInternalWithRenderType(block, this.key((class_2248)block).toString(), pane, edge, renderType);
    }

    public void paneBlockWithRenderType(class_2389 block, String name, class_2960 pane, class_2960 edge, class_2960 renderType) {
        this.paneBlockInternalWithRenderType(block, name + "_pane", pane, edge, renderType);
    }

    public void paneBlockWithRenderTypeAndFast(class_2389 block, class_2960 pane, class_2960 edge, String renderType, String renderTypeFast) {
        this.paneBlockInternalWithRenderTypeAndFast(block, this.key((class_2248)block).toString(), pane, edge, class_2960.method_12829((String)renderType), class_2960.method_12829((String)renderTypeFast));
    }

    public void paneBlockWithRenderTypeAndFast(class_2389 block, String name, class_2960 pane, class_2960 edge, String renderType, String renderTypeFast) {
        this.paneBlockInternalWithRenderTypeAndFast(block, name + "_pane", pane, edge, class_2960.method_12829((String)renderType), class_2960.method_12829((String)renderTypeFast));
    }

    public void paneBlockWithRenderTypeAndFast(class_2389 block, class_2960 pane, class_2960 edge, class_2960 renderType, class_2960 renderTypeFast) {
        this.paneBlockInternalWithRenderTypeAndFast(block, this.key((class_2248)block).toString(), pane, edge, renderType, renderTypeFast);
    }

    public void paneBlockWithRenderTypeAndFast(class_2389 block, String name, class_2960 pane, class_2960 edge, class_2960 renderType, class_2960 renderTypeFast) {
        this.paneBlockInternalWithRenderTypeAndFast(block, name + "_pane", pane, edge, renderType, renderTypeFast);
    }

    private void paneBlockInternal(class_2389 block, String baseName, class_2960 pane, class_2960 edge) {
        Object post = this.models().panePost(baseName + "_post", pane, edge);
        Object side = this.models().paneSide(baseName + "_side", pane, edge);
        Object sideAlt = this.models().paneSideAlt(baseName + "_side_alt", pane, edge);
        Object noSide = this.models().paneNoSide(baseName + "_noside", pane);
        Object noSideAlt = this.models().paneNoSideAlt(baseName + "_noside_alt", pane);
        this.paneBlock(block, (ModelFile)post, (ModelFile)side, (ModelFile)sideAlt, (ModelFile)noSide, (ModelFile)noSideAlt);
    }

    private void paneBlockInternalWithRenderType(class_2389 block, String baseName, class_2960 pane, class_2960 edge, class_2960 renderType) {
        Object post = ((BlockModelBuilder)this.models().panePost(baseName + "_post", pane, edge)).renderType(renderType);
        Object side = ((BlockModelBuilder)this.models().paneSide(baseName + "_side", pane, edge)).renderType(renderType);
        Object sideAlt = ((BlockModelBuilder)this.models().paneSideAlt(baseName + "_side_alt", pane, edge)).renderType(renderType);
        Object noSide = ((BlockModelBuilder)this.models().paneNoSide(baseName + "_noside", pane)).renderType(renderType);
        Object noSideAlt = ((BlockModelBuilder)this.models().paneNoSideAlt(baseName + "_noside_alt", pane)).renderType(renderType);
        this.paneBlock(block, (ModelFile)post, (ModelFile)side, (ModelFile)sideAlt, (ModelFile)noSide, (ModelFile)noSideAlt);
    }

    private void paneBlockInternalWithRenderTypeAndFast(class_2389 block, String baseName, class_2960 pane, class_2960 edge, class_2960 renderType, class_2960 renderTypeFast) {
        Object post = ((BlockModelBuilder)this.models().panePost(baseName + "_post", pane, edge)).renderType(renderType, renderTypeFast);
        Object side = ((BlockModelBuilder)this.models().paneSide(baseName + "_side", pane, edge)).renderType(renderType, renderTypeFast);
        Object sideAlt = ((BlockModelBuilder)this.models().paneSideAlt(baseName + "_side_alt", pane, edge)).renderType(renderType, renderTypeFast);
        Object noSide = ((BlockModelBuilder)this.models().paneNoSide(baseName + "_noside", pane)).renderType(renderType, renderTypeFast);
        Object noSideAlt = ((BlockModelBuilder)this.models().paneNoSideAlt(baseName + "_noside_alt", pane)).renderType(renderType, renderTypeFast);
        this.paneBlock(block, (ModelFile)post, (ModelFile)side, (ModelFile)sideAlt, (ModelFile)noSide, (ModelFile)noSideAlt);
    }

    public void paneBlock(class_2389 block, ModelFile post, ModelFile side, ModelFile sideAlt, ModelFile noSide, ModelFile noSideAlt) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((class_2248)block).part().modelFile(post).addModel().end();
        class_2429.field_11329.entrySet().forEach(e -> {
            class_2350 dir = (class_2350)e.getKey();
            if (dir.method_10166().method_10179()) {
                boolean alt = dir == class_2350.field_11035;
                builder.part().modelFile(alt || dir == class_2350.field_11039 ? sideAlt : side).rotationY(dir.method_10166() == class_2350.class_2351.field_11048 ? 90 : 0).addModel().condition((class_2769)e.getValue(), new Boolean[]{true}).end().part().modelFile(alt || dir == class_2350.field_11034 ? noSideAlt : noSide).rotationY(dir == class_2350.field_11039 ? 270 : (dir == class_2350.field_11035 ? 90 : 0)).addModel().condition((class_2769)e.getValue(), new Boolean[]{false});
            }
        });
    }

    public void doorBlock(class_2323 block, class_2960 bottom, class_2960 top) {
        this.doorBlockInternal(block, this.key((class_2248)block).toString(), bottom, top);
    }

    public void doorBlock(class_2323 block, String name, class_2960 bottom, class_2960 top) {
        this.doorBlockInternal(block, name + "_door", bottom, top);
    }

    public void doorBlockWithRenderType(class_2323 block, class_2960 bottom, class_2960 top, String renderType) {
        this.doorBlockInternalWithRenderType(block, this.key((class_2248)block).toString(), bottom, top, class_2960.method_12829((String)renderType));
    }

    public void doorBlockWithRenderType(class_2323 block, String name, class_2960 bottom, class_2960 top, String renderType) {
        this.doorBlockInternalWithRenderType(block, name + "_door", bottom, top, class_2960.method_12829((String)renderType));
    }

    public void doorBlockWithRenderType(class_2323 block, class_2960 bottom, class_2960 top, class_2960 renderType) {
        this.doorBlockInternalWithRenderType(block, this.key((class_2248)block).toString(), bottom, top, renderType);
    }

    public void doorBlockWithRenderType(class_2323 block, String name, class_2960 bottom, class_2960 top, class_2960 renderType) {
        this.doorBlockInternalWithRenderType(block, name + "_door", bottom, top, renderType);
    }

    public void doorBlockWithRenderTypeAndFast(class_2323 block, class_2960 bottom, class_2960 top, String renderType, String renderTypeFast) {
        this.doorBlockInternalWithRenderTypeAndFast(block, this.key((class_2248)block).toString(), bottom, top, class_2960.method_12829((String)renderType), class_2960.method_12829((String)renderTypeFast));
    }

    public void doorBlockWithRenderTypeAndFast(class_2323 block, String name, class_2960 bottom, class_2960 top, String renderType, String renderTypeFast) {
        this.doorBlockInternalWithRenderTypeAndFast(block, name + "_door", bottom, top, class_2960.method_12829((String)renderType), class_2960.method_12829((String)renderTypeFast));
    }

    public void doorBlockWithRenderTypeAndFast(class_2323 block, class_2960 bottom, class_2960 top, class_2960 renderType, class_2960 renderTypeFast) {
        this.doorBlockInternalWithRenderTypeAndFast(block, this.key((class_2248)block).toString(), bottom, top, renderType, renderTypeFast);
    }

    public void doorBlockWithRenderTypeAndFast(class_2323 block, String name, class_2960 bottom, class_2960 top, class_2960 renderType, class_2960 renderTypeFast) {
        this.doorBlockInternalWithRenderTypeAndFast(block, name + "_door", bottom, top, renderType, renderTypeFast);
    }

    private void doorBlockInternal(class_2323 block, String baseName, class_2960 bottom, class_2960 top) {
        Object bottomLeft = this.models().doorBottomLeft(baseName + "_bottom_left", bottom, top);
        Object bottomLeftOpen = this.models().doorBottomLeftOpen(baseName + "_bottom_left_open", bottom, top);
        Object bottomRight = this.models().doorBottomRight(baseName + "_bottom_right", bottom, top);
        Object bottomRightOpen = this.models().doorBottomRightOpen(baseName + "_bottom_right_open", bottom, top);
        Object topLeft = this.models().doorTopLeft(baseName + "_top_left", bottom, top);
        Object topLeftOpen = this.models().doorTopLeftOpen(baseName + "_top_left_open", bottom, top);
        Object topRight = this.models().doorTopRight(baseName + "_top_right", bottom, top);
        Object topRightOpen = this.models().doorTopRightOpen(baseName + "_top_right_open", bottom, top);
        this.doorBlock(block, (ModelFile)bottomLeft, (ModelFile)bottomLeftOpen, (ModelFile)bottomRight, (ModelFile)bottomRightOpen, (ModelFile)topLeft, (ModelFile)topLeftOpen, (ModelFile)topRight, (ModelFile)topRightOpen);
    }

    private void doorBlockInternalWithRenderType(class_2323 block, String baseName, class_2960 bottom, class_2960 top, class_2960 renderType) {
        Object bottomLeft = ((BlockModelBuilder)this.models().doorBottomLeft(baseName + "_bottom_left", bottom, top)).renderType(renderType);
        Object bottomLeftOpen = ((BlockModelBuilder)this.models().doorBottomLeftOpen(baseName + "_bottom_left_open", bottom, top)).renderType(renderType);
        Object bottomRight = ((BlockModelBuilder)this.models().doorBottomRight(baseName + "_bottom_right", bottom, top)).renderType(renderType);
        Object bottomRightOpen = ((BlockModelBuilder)this.models().doorBottomRightOpen(baseName + "_bottom_right_open", bottom, top)).renderType(renderType);
        Object topLeft = ((BlockModelBuilder)this.models().doorTopLeft(baseName + "_top_left", bottom, top)).renderType(renderType);
        Object topLeftOpen = ((BlockModelBuilder)this.models().doorTopLeftOpen(baseName + "_top_left_open", bottom, top)).renderType(renderType);
        Object topRight = ((BlockModelBuilder)this.models().doorTopRight(baseName + "_top_right", bottom, top)).renderType(renderType);
        Object topRightOpen = ((BlockModelBuilder)this.models().doorTopRightOpen(baseName + "_top_right_open", bottom, top)).renderType(renderType);
        this.doorBlock(block, (ModelFile)bottomLeft, (ModelFile)bottomLeftOpen, (ModelFile)bottomRight, (ModelFile)bottomRightOpen, (ModelFile)topLeft, (ModelFile)topLeftOpen, (ModelFile)topRight, (ModelFile)topRightOpen);
    }

    private void doorBlockInternalWithRenderTypeAndFast(class_2323 block, String baseName, class_2960 bottom, class_2960 top, class_2960 renderType, class_2960 renderTypeFast) {
        Object bottomLeft = ((BlockModelBuilder)this.models().doorBottomLeft(baseName + "_bottom_left", bottom, top)).renderType(renderType, renderTypeFast);
        Object bottomLeftOpen = ((BlockModelBuilder)this.models().doorBottomLeftOpen(baseName + "_bottom_left_open", bottom, top)).renderType(renderType, renderTypeFast);
        Object bottomRight = ((BlockModelBuilder)this.models().doorBottomRight(baseName + "_bottom_right", bottom, top)).renderType(renderType, renderTypeFast);
        Object bottomRightOpen = ((BlockModelBuilder)this.models().doorBottomRightOpen(baseName + "_bottom_right_open", bottom, top)).renderType(renderType, renderTypeFast);
        Object topLeft = ((BlockModelBuilder)this.models().doorTopLeft(baseName + "_top_left", bottom, top)).renderType(renderType, renderTypeFast);
        Object topLeftOpen = ((BlockModelBuilder)this.models().doorTopLeftOpen(baseName + "_top_left_open", bottom, top)).renderType(renderType, renderTypeFast);
        Object topRight = ((BlockModelBuilder)this.models().doorTopRight(baseName + "_top_right", bottom, top)).renderType(renderType, renderTypeFast);
        Object topRightOpen = ((BlockModelBuilder)this.models().doorTopRightOpen(baseName + "_top_right_open", bottom, top)).renderType(renderType, renderTypeFast);
        this.doorBlock(block, (ModelFile)bottomLeft, (ModelFile)bottomLeftOpen, (ModelFile)bottomRight, (ModelFile)bottomRightOpen, (ModelFile)topLeft, (ModelFile)topLeftOpen, (ModelFile)topRight, (ModelFile)topRightOpen);
    }

    public void doorBlock(class_2323 block, ModelFile bottomLeft, ModelFile bottomLeftOpen, ModelFile bottomRight, ModelFile bottomRightOpen, ModelFile topLeft, ModelFile topLeftOpen, ModelFile topRight, ModelFile topRightOpen) {
        this.getVariantBuilder((class_2248)block).forAllStatesExcept(state -> {
            boolean lower;
            int yRot = (int)((class_2350)state.method_11654((class_2769)class_2323.field_10938)).method_10144() + 90;
            boolean right = state.method_11654((class_2769)class_2323.field_10941) == class_2750.field_12586;
            boolean open = (Boolean)state.method_11654((class_2769)class_2323.field_10945);
            boolean bl = lower = state.method_11654((class_2769)class_2323.field_10946) == class_2756.field_12607;
            if (open) {
                yRot += 90;
            }
            if (right && open) {
                yRot += 180;
            }
            yRot %= 360;
            ModelFile model = null;
            if (lower && right && open) {
                model = bottomRightOpen;
            } else if (lower && !right && open) {
                model = bottomLeftOpen;
            }
            if (lower && right && !open) {
                model = bottomRight;
            } else if (lower && !right && !open) {
                model = bottomLeft;
            }
            if (!lower && right && open) {
                model = topRightOpen;
            } else if (!lower && !right && open) {
                model = topLeftOpen;
            }
            if (!lower && right && !open) {
                model = topRight;
            } else if (!(lower || right || open)) {
                model = topLeft;
            }
            return ConfiguredModel.builder().modelFile(model).rotationY(yRot).build();
        }, new class_2769[]{class_2323.field_10940});
    }

    public void trapdoorBlock(class_2533 block, class_2960 texture, boolean orientable) {
        this.trapdoorBlockInternal(block, this.key((class_2248)block).toString(), texture, orientable);
    }

    public void trapdoorBlock(class_2533 block, String name, class_2960 texture, boolean orientable) {
        this.trapdoorBlockInternal(block, name + "_trapdoor", texture, orientable);
    }

    public void trapdoorBlockWithRenderType(class_2533 block, class_2960 texture, boolean orientable, String renderType) {
        this.trapdoorBlockInternalWithRenderType(block, this.key((class_2248)block).toString(), texture, orientable, class_2960.method_12829((String)renderType));
    }

    public void trapdoorBlockWithRenderType(class_2533 block, String name, class_2960 texture, boolean orientable, String renderType) {
        this.trapdoorBlockInternalWithRenderType(block, name + "_trapdoor", texture, orientable, class_2960.method_12829((String)renderType));
    }

    public void trapdoorBlockWithRenderType(class_2533 block, class_2960 texture, boolean orientable, class_2960 renderType) {
        this.trapdoorBlockInternalWithRenderType(block, this.key((class_2248)block).toString(), texture, orientable, renderType);
    }

    public void trapdoorBlockWithRenderType(class_2533 block, String name, class_2960 texture, boolean orientable, class_2960 renderType) {
        this.trapdoorBlockInternalWithRenderType(block, name + "_trapdoor", texture, orientable, renderType);
    }

    public void trapdoorBlockWithRenderTypeAndFast(class_2533 block, class_2960 texture, boolean orientable, String renderType, String renderTypeFast) {
        this.trapdoorBlockInternalWithRenderTypeAndFast(block, this.key((class_2248)block).toString(), texture, orientable, class_2960.method_12829((String)renderType), class_2960.method_12829((String)renderTypeFast));
    }

    public void trapdoorBlockWithRenderTypeAndFast(class_2533 block, String name, class_2960 texture, boolean orientable, String renderType, String renderTypeFast) {
        this.trapdoorBlockInternalWithRenderTypeAndFast(block, name + "_trapdoor", texture, orientable, class_2960.method_12829((String)renderType), class_2960.method_12829((String)renderTypeFast));
    }

    public void trapdoorBlockWithRenderTypeAndFast(class_2533 block, class_2960 texture, boolean orientable, class_2960 renderType, class_2960 renderTypeFast) {
        this.trapdoorBlockInternalWithRenderTypeAndFast(block, this.key((class_2248)block).toString(), texture, orientable, renderType, renderTypeFast);
    }

    public void trapdoorBlockWithRenderTypeAndFast(class_2533 block, String name, class_2960 texture, boolean orientable, class_2960 renderType, class_2960 renderTypeFast) {
        this.trapdoorBlockInternalWithRenderTypeAndFast(block, name + "_trapdoor", texture, orientable, renderType, renderTypeFast);
    }

    private void trapdoorBlockInternal(class_2533 block, String baseName, class_2960 texture, boolean orientable) {
        Object bottom = orientable ? this.models().trapdoorOrientableBottom(baseName + "_bottom", texture) : this.models().trapdoorBottom(baseName + "_bottom", texture);
        Object top = orientable ? this.models().trapdoorOrientableTop(baseName + "_top", texture) : this.models().trapdoorTop(baseName + "_top", texture);
        Object open = orientable ? this.models().trapdoorOrientableOpen(baseName + "_open", texture) : this.models().trapdoorOpen(baseName + "_open", texture);
        this.trapdoorBlock(block, (ModelFile)bottom, (ModelFile)top, (ModelFile)open, orientable);
    }

    private void trapdoorBlockInternalWithRenderType(class_2533 block, String baseName, class_2960 texture, boolean orientable, class_2960 renderType) {
        Object bottom = orientable ? ((BlockModelBuilder)this.models().trapdoorOrientableBottom(baseName + "_bottom", texture)).renderType(renderType) : ((BlockModelBuilder)this.models().trapdoorBottom(baseName + "_bottom", texture)).renderType(renderType);
        Object top = orientable ? ((BlockModelBuilder)this.models().trapdoorOrientableTop(baseName + "_top", texture)).renderType(renderType) : ((BlockModelBuilder)this.models().trapdoorTop(baseName + "_top", texture)).renderType(renderType);
        Object open = orientable ? ((BlockModelBuilder)this.models().trapdoorOrientableOpen(baseName + "_open", texture)).renderType(renderType) : ((BlockModelBuilder)this.models().trapdoorOpen(baseName + "_open", texture)).renderType(renderType);
        this.trapdoorBlock(block, (ModelFile)bottom, (ModelFile)top, (ModelFile)open, orientable);
    }

    private void trapdoorBlockInternalWithRenderTypeAndFast(class_2533 block, String baseName, class_2960 texture, boolean orientable, class_2960 renderType, class_2960 renderTypeFast) {
        Object bottom = orientable ? ((BlockModelBuilder)this.models().trapdoorOrientableBottom(baseName + "_bottom", texture)).renderType(renderType, renderTypeFast) : ((BlockModelBuilder)this.models().trapdoorBottom(baseName + "_bottom", texture)).renderType(renderType, renderTypeFast);
        Object top = orientable ? ((BlockModelBuilder)this.models().trapdoorOrientableTop(baseName + "_top", texture)).renderType(renderType, renderTypeFast) : ((BlockModelBuilder)this.models().trapdoorTop(baseName + "_top", texture)).renderType(renderType, renderTypeFast);
        Object open = orientable ? ((BlockModelBuilder)this.models().trapdoorOrientableOpen(baseName + "_open", texture)).renderType(renderType, renderTypeFast) : ((BlockModelBuilder)this.models().trapdoorOpen(baseName + "_open", texture)).renderType(renderType, renderTypeFast);
        this.trapdoorBlock(block, (ModelFile)bottom, (ModelFile)top, (ModelFile)open, orientable);
    }

    public void trapdoorBlock(class_2533 block, ModelFile bottom, ModelFile top, ModelFile open, boolean orientable) {
        this.getVariantBuilder((class_2248)block).forAllStatesExcept(state -> {
            int xRot = 0;
            int yRot = (int)((class_2350)state.method_11654((class_2769)class_2533.field_11177)).method_10144() + 180;
            boolean isOpen = (Boolean)state.method_11654((class_2769)class_2533.field_11631);
            if (orientable && isOpen && state.method_11654((class_2769)class_2533.field_11625) == class_2760.field_12619) {
                xRot += 180;
                yRot += 180;
            }
            if (!orientable && !isOpen) {
                yRot = 0;
            }
            return ConfiguredModel.builder().modelFile(isOpen ? open : (state.method_11654((class_2769)class_2533.field_11625) == class_2760.field_12619 ? top : bottom)).rotationX(xRot).rotationY(yRot %= 360).build();
        }, new class_2769[]{class_2533.field_11629, class_2533.field_11626});
    }

    private CompletableFuture<?> saveBlockState(class_7403 cache, JsonObject stateJson, class_2248 owner) {
        class_2960 blockName = (class_2960)Preconditions.checkNotNull((Object)this.key(owner));
        Path outputPath = this.output.method_45972(class_7784.class_7490.field_39368).resolve(blockName.method_12836()).resolve("blockstates").resolve(blockName.method_12832() + ".json");
        return class_2405.method_10320((class_7403)cache, (JsonElement)stateJson, (Path)outputPath);
    }

    @NotNull
    public String method_10321() {
        return "Block States: " + this.modid;
    }

    public static class ConfiguredModelList {
        private final List<ConfiguredModel> models;

        private ConfiguredModelList(List<ConfiguredModel> models) {
            Preconditions.checkArgument((!models.isEmpty() ? 1 : 0) != 0);
            this.models = models;
        }

        public ConfiguredModelList(ConfiguredModel model) {
            this((List<ConfiguredModel>)ImmutableList.of((Object)model));
        }

        public ConfiguredModelList(ConfiguredModel ... models) {
            this(Arrays.asList(models));
        }

        public JsonElement toJSON() {
            if (this.models.size() == 1) {
                return this.models.get(0).toJSON(false);
            }
            JsonArray ret = new JsonArray();
            for (ConfiguredModel m : this.models) {
                ret.add((JsonElement)m.toJSON(true));
            }
            return ret;
        }

        public ConfiguredModelList append(ConfiguredModel ... models) {
            return new ConfiguredModelList((List<ConfiguredModel>)ImmutableList.builder().addAll(this.models).add((Object[])models).build());
        }
    }
}

