/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.geometry;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xyz.bluspring.kilt.injections.client.renderer.block.model.BlockModelInjection;

public class BlockGeometryBakingContext
implements IGeometryBakingContext {
    public final class_793 owner;
    public final VisibilityData visibilityData = new VisibilityData();
    @Nullable
    private IUnbakedGeometry<?> customGeometry;
    @Nullable
    private class_4590 rootTransform;
    @Nullable
    private class_2960 renderTypeHint;
    @Nullable
    private class_2960 renderTypeFastHint;
    private boolean gui3d = true;

    @ApiStatus.Internal
    public BlockGeometryBakingContext(class_793 owner) {
        this.owner = owner;
    }

    @Override
    public String getModelName() {
        return this.owner.field_4252;
    }

    public boolean hasCustomGeometry() {
        return this.getCustomGeometry() != null;
    }

    @Nullable
    public IUnbakedGeometry<?> getCustomGeometry() {
        return this.owner.field_4253 != null && this.customGeometry == null ? ((BlockModelInjection)this.owner.field_4253).kilt$getCustomData().getCustomGeometry() : this.customGeometry;
    }

    public void setCustomGeometry(IUnbakedGeometry<?> geometry) {
        this.customGeometry = geometry;
    }

    @Override
    public boolean isComponentVisible(String part, boolean fallback) {
        return this.owner.field_4253 != null && !this.visibilityData.hasCustomVisibility(part) ? ((BlockModelInjection)this.owner.field_4253).kilt$getCustomData().isComponentVisible(part, fallback) : this.visibilityData.isVisible(part, fallback);
    }

    @Override
    public boolean hasMaterial(String name) {
        return this.owner.method_3432(name);
    }

    @Override
    public class_4730 getMaterial(String name) {
        return this.owner.method_24077(name);
    }

    @Override
    public boolean isGui3d() {
        return this.gui3d;
    }

    @Override
    public boolean useBlockLight() {
        return this.owner.method_24298().method_24299();
    }

    @Override
    public boolean useAmbientOcclusion() {
        return this.owner.method_3444();
    }

    @Override
    public class_809 getTransforms() {
        return this.owner.method_3443();
    }

    @Override
    public class_4590 getRootTransform() {
        if (this.rootTransform != null) {
            return this.rootTransform;
        }
        return this.owner.field_4253 != null ? ((BlockModelInjection)this.owner.field_4253).kilt$getCustomData().getRootTransform() : class_4590.method_22931();
    }

    public void setRootTransform(class_4590 rootTransform) {
        this.rootTransform = rootTransform;
    }

    @Override
    @Nullable
    public class_2960 getRenderTypeHint() {
        if (this.renderTypeHint != null) {
            return this.renderTypeHint;
        }
        return this.owner.field_4253 != null ? ((BlockModelInjection)this.owner.field_4253).kilt$getCustomData().getRenderTypeHint() : null;
    }

    @Override
    @Nullable
    public class_2960 getRenderTypeFastHint() {
        if (this.renderTypeFastHint != null) {
            return this.renderTypeFastHint;
        }
        return this.owner.field_4253 != null ? ((BlockModelInjection)this.owner.field_4253).kilt$getCustomData().getRenderTypeFastHint() : null;
    }

    public void setRenderTypeHint(class_2960 renderTypeHint) {
        this.renderTypeHint = renderTypeHint;
    }

    public void setRenderTypeFastHint(class_2960 renderTypeFastHint) {
        this.renderTypeFastHint = renderTypeFastHint;
    }

    public void setGui3d(boolean gui3d) {
        this.gui3d = gui3d;
    }

    public void copyFrom(BlockGeometryBakingContext other) {
        this.customGeometry = other.customGeometry;
        this.rootTransform = other.rootTransform;
        this.visibilityData.copyFrom(other.visibilityData);
        this.renderTypeHint = other.renderTypeHint;
        this.renderTypeFastHint = other.renderTypeFastHint;
        this.gui3d = other.gui3d;
    }

    public class_1087 bake(class_7775 baker, Function<class_4730, class_1058> bakedTextureGetter, class_3665 modelTransform, class_806 overrides, class_2960 modelLocation) {
        IUnbakedGeometry<?> geometry = this.getCustomGeometry();
        if (geometry == null) {
            throw new IllegalStateException("Can not use custom baking without custom geometry");
        }
        return geometry.bake(this, baker, bakedTextureGetter, modelTransform, overrides, modelLocation);
    }

    public static class VisibilityData {
        private final Map<String, Boolean> data = new HashMap<String, Boolean>();

        public boolean hasCustomVisibility(String part) {
            return this.data.containsKey(part);
        }

        public boolean isVisible(String part, boolean fallback) {
            return this.data.getOrDefault(part, fallback);
        }

        public void setVisibilityState(String partName, boolean type) {
            this.data.put(partName, type);
        }

        public void copyFrom(VisibilityData visibilityData) {
            this.data.clear();
            this.data.putAll(visibilityData.data);
        }

        public boolean kilt$hasAnyData() {
            return !this.data.isEmpty();
        }
    }
}

