/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.geometry;

import com.google.common.base.Predicates;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1047;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_809;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.Nullable;

public class StandaloneGeometryBakingContext
implements IGeometryBakingContext {
    public static final class_2960 LOCATION = new class_2960("forge", "standalone");
    public static final StandaloneGeometryBakingContext INSTANCE = StandaloneGeometryBakingContext.create(LOCATION);
    private final class_2960 modelName;
    private final Predicate<String> materialCheck;
    private final Function<String, class_4730> materialLookup;
    private final boolean isGui3d;
    private final boolean useBlockLight;
    private final boolean useAmbientOcclusion;
    private final class_809 transforms;
    private final class_4590 rootTransform;
    @Nullable
    private final class_2960 renderTypeHint;
    @Nullable
    private final class_2960 renderTypeFastHint;
    private final BiPredicate<String, Boolean> visibilityTest;

    public static StandaloneGeometryBakingContext create(class_2960 modelName) {
        return StandaloneGeometryBakingContext.builder().build(modelName);
    }

    public static StandaloneGeometryBakingContext create(Map<String, class_2960> textures) {
        return StandaloneGeometryBakingContext.create(LOCATION, textures);
    }

    public static StandaloneGeometryBakingContext create(class_2960 modelName, Map<String, class_2960> textures) {
        return StandaloneGeometryBakingContext.builder().withTextures(textures, class_1047.method_4539()).build(modelName);
    }

    private StandaloneGeometryBakingContext(class_2960 modelName, Predicate<String> materialCheck, Function<String, class_4730> materialLookup, boolean isGui3d, boolean useBlockLight, boolean useAmbientOcclusion, class_809 transforms, class_4590 rootTransform, @Nullable class_2960 renderTypeHint, BiPredicate<String, Boolean> visibilityTest) {
        this.modelName = modelName;
        this.materialCheck = materialCheck;
        this.materialLookup = materialLookup;
        this.isGui3d = isGui3d;
        this.useBlockLight = useBlockLight;
        this.useAmbientOcclusion = useAmbientOcclusion;
        this.transforms = transforms;
        this.rootTransform = rootTransform;
        this.renderTypeHint = renderTypeHint;
        this.renderTypeFastHint = null;
        this.visibilityTest = visibilityTest;
    }

    private StandaloneGeometryBakingContext(class_2960 modelName, Predicate<String> materialCheck, Function<String, class_4730> materialLookup, boolean isGui3d, boolean useBlockLight, boolean useAmbientOcclusion, class_809 transforms, class_4590 rootTransform, @Nullable class_2960 renderTypeHint, @Nullable class_2960 renderTypeFastHint, BiPredicate<String, Boolean> visibilityTest) {
        this.modelName = modelName;
        this.materialCheck = materialCheck;
        this.materialLookup = materialLookup;
        this.isGui3d = isGui3d;
        this.useBlockLight = useBlockLight;
        this.useAmbientOcclusion = useAmbientOcclusion;
        this.transforms = transforms;
        this.rootTransform = rootTransform;
        this.renderTypeHint = renderTypeHint;
        this.renderTypeFastHint = renderTypeFastHint;
        this.visibilityTest = visibilityTest;
    }

    @Override
    public String getModelName() {
        return this.modelName.toString();
    }

    @Override
    public boolean hasMaterial(String name) {
        return this.materialCheck.test(name);
    }

    @Override
    public class_4730 getMaterial(String name) {
        return this.materialLookup.apply(name);
    }

    @Override
    public boolean isGui3d() {
        return this.isGui3d;
    }

    @Override
    public boolean useBlockLight() {
        return this.useBlockLight;
    }

    @Override
    public boolean useAmbientOcclusion() {
        return this.useAmbientOcclusion;
    }

    @Override
    public class_809 getTransforms() {
        return this.transforms;
    }

    @Override
    public class_4590 getRootTransform() {
        return this.rootTransform;
    }

    @Override
    @Nullable
    public class_2960 getRenderTypeHint() {
        return this.renderTypeHint;
    }

    @Override
    @Nullable
    public class_2960 getRenderTypeFastHint() {
        return this.renderTypeFastHint;
    }

    @Override
    public boolean isComponentVisible(String component, boolean fallback) {
        return this.visibilityTest.test(component, fallback);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(IGeometryBakingContext parent) {
        return new Builder(parent);
    }

    public static final class Builder {
        private static final class_4730 NO_MATERIAL = new class_4730(class_1059.field_5275, class_1047.method_4539());
        private Predicate<String> materialCheck = Predicates.alwaysFalse();
        private Function<String, class_4730> materialLookup = $ -> NO_MATERIAL;
        private boolean isGui3d = true;
        private boolean useBlockLight = true;
        private boolean useAmbientOcclusion = true;
        private class_809 transforms = class_809.field_4301;
        private class_4590 rootTransform = class_4590.method_22931();
        @Nullable
        private class_2960 renderTypeHint;
        @Nullable
        private class_2960 renderTypeFastHint;
        private BiPredicate<String, Boolean> visibilityTest = (c, def) -> def;

        private Builder() {
        }

        private Builder(IGeometryBakingContext parent) {
            this.materialCheck = parent::hasMaterial;
            this.materialLookup = parent::getMaterial;
            this.isGui3d = parent.isGui3d();
            this.useBlockLight = parent.useBlockLight();
            this.useAmbientOcclusion = parent.useAmbientOcclusion();
            this.transforms = parent.getTransforms();
            this.rootTransform = parent.getRootTransform();
            this.renderTypeHint = parent.getRenderTypeHint();
            this.renderTypeFastHint = parent.getRenderTypeFastHint();
            this.visibilityTest = parent::isComponentVisible;
        }

        public Builder withTextures(Map<String, class_2960> textures, class_2960 defaultTexture) {
            return this.withTextures(class_1059.field_5275, textures, defaultTexture);
        }

        public Builder withTextures(class_2960 atlasLocation, Map<String, class_2960> textures, class_2960 defaultTexture) {
            this.materialCheck = textures::containsKey;
            this.materialLookup = name -> new class_4730(atlasLocation, textures.getOrDefault(name, defaultTexture));
            return this;
        }

        public Builder withMaterials(Map<String, class_4730> materials, class_4730 defaultMaterial) {
            this.materialCheck = materials::containsKey;
            this.materialLookup = name -> materials.getOrDefault(name, defaultMaterial);
            return this;
        }

        public Builder withGui3d(boolean isGui3d) {
            this.isGui3d = isGui3d;
            return this;
        }

        public Builder withUseBlockLight(boolean useBlockLight) {
            this.useBlockLight = useBlockLight;
            return this;
        }

        public Builder withUseAmbientOcclusion(boolean useAmbientOcclusion) {
            this.useAmbientOcclusion = useAmbientOcclusion;
            return this;
        }

        public Builder withTransforms(class_809 transforms) {
            this.transforms = transforms;
            return this;
        }

        public Builder withRootTransform(class_4590 rootTransform) {
            this.rootTransform = rootTransform;
            return this;
        }

        public Builder withRenderTypeHint(class_2960 renderTypeHint) {
            this.renderTypeHint = renderTypeHint;
            return this;
        }

        public Builder withRenderTypeHint(class_2960 renderTypeHint, class_2960 renderTypeFastHint) {
            this.renderTypeHint = renderTypeHint;
            this.renderTypeFastHint = renderTypeFastHint;
            return this;
        }

        public Builder withVisibleComponents(Object2BooleanMap<String> parts) {
            this.visibilityTest = (arg_0, arg_1) -> parts.getOrDefault(arg_0, arg_1);
            return this;
        }

        public StandaloneGeometryBakingContext build(class_2960 modelName) {
            return new StandaloneGeometryBakingContext(modelName, this.materialCheck, this.materialLookup, this.isGui3d, this.useBlockLight, this.useAmbientOcclusion, this.transforms, this.rootTransform, this.renderTypeHint, this.renderTypeFastHint, this.visibilityTest);
        }
    }
}

