/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.lighting;

import java.util.Objects;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_324;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_777;
import net.minecraftforge.client.extensions.IForgeBlockAndTintGetter;
import net.minecraftforge.client.model.IQuadTransformer;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class QuadLighter {
    private static final float[] WHITE = new float[]{1.0f, 1.0f, 1.0f};
    private final class_324 colors;
    private int currentHash = 0;
    private class_1920 level;
    private class_2338 pos;
    private class_2680 state;
    private int cachedTintIndex = -1;
    private final float[] cachedTintColor = new float[3];
    private final float[] brightness = new float[4];
    private final int[] lightmap = new int[4];
    private final float[][] positions = new float[4][3];
    private final byte[][] normals = new byte[4][3];
    private final int[] packedLightmaps = new int[4];

    protected QuadLighter(class_324 colors) {
        this.colors = colors;
    }

    protected abstract void computeLightingAt(class_1920 var1, class_2338 var2, class_2680 var3);

    protected abstract float calculateBrightness(float[] var1);

    protected abstract int calculateLightmap(float[] var1, byte[] var2);

    public final void setup(class_1920 level, class_2338 pos, class_2680 state) {
        int hash2 = Objects.hash(level, pos, state);
        if (this.level != null && this.currentHash == hash2) {
            return;
        }
        this.currentHash = hash2;
        this.level = level;
        this.pos = pos;
        this.state = state;
        this.cachedTintIndex = -1;
        this.computeLightingAt(level, pos, state);
    }

    public final void reset() {
        this.level = null;
    }

    public final void process(class_4588 consumer, class_4587.class_4665 pose, class_777 quad, int overlay) {
        int i;
        int[] vertices = quad.method_3357();
        for (i = 0; i < 4; ++i) {
            int offset = i * IQuadTransformer.STRIDE;
            this.positions[i][0] = Float.intBitsToFloat(vertices[offset + IQuadTransformer.POSITION]);
            this.positions[i][1] = Float.intBitsToFloat(vertices[offset + IQuadTransformer.POSITION + 1]);
            this.positions[i][2] = Float.intBitsToFloat(vertices[offset + IQuadTransformer.POSITION + 2]);
            int packedNormal = vertices[offset + IQuadTransformer.NORMAL];
            this.normals[i][0] = (byte)(packedNormal & 0xFF);
            this.normals[i][1] = (byte)(packedNormal >> 8 & 0xFF);
            this.normals[i][2] = (byte)(packedNormal >> 16 & 0xFF);
            this.packedLightmaps[i] = vertices[offset + IQuadTransformer.UV2];
        }
        if (this.normals[0][0] == 0 && this.normals[0][1] == 0 && this.normals[0][2] == 0) {
            Vector3f a = new Vector3f(this.positions[0]);
            Vector3f ab = new Vector3f(this.positions[1]);
            Vector3f ac = new Vector3f(this.positions[2]);
            ac.sub((Vector3fc)a);
            ab.sub((Vector3fc)a);
            ab.cross((Vector3fc)ac);
            ab.normalize();
            for (int v = 0; v < 4; ++v) {
                this.normals[v][0] = (byte)(ab.x() * 127.0f);
                this.normals[v][1] = (byte)(ab.y() * 127.0f);
                this.normals[v][2] = (byte)(ab.z() * 127.0f);
            }
        }
        for (i = 0; i < 4; ++i) {
            float[] position = this.positions[i];
            byte[] normal = this.normals[i];
            int packedLightmap = this.packedLightmaps[i];
            float[] adjustedPosition = new float[]{position[0] - 0.5f + (float)normal[0] / 127.0f * 0.5f, position[1] - 0.5f + (float)normal[1] / 127.0f * 0.5f, position[2] - 0.5f + (float)normal[2] / 127.0f * 0.5f};
            float shade = ((IForgeBlockAndTintGetter)this.level).getShade((float)this.normals[i][0] / 127.0f, (float)this.normals[i][1] / 127.0f, (float)this.normals[i][2] / 127.0f, quad.method_24874());
            this.brightness[i] = this.calculateBrightness(adjustedPosition) * shade;
            int newLightmap = this.calculateLightmap(adjustedPosition, normal);
            this.lightmap[i] = Math.max(packedLightmap & 0xFFFF, newLightmap & 0xFFFF) | Math.max(packedLightmap >> 16 & 0xFFFF, newLightmap >> 16 & 0xFFFF) << 16;
        }
        float[] color = quad.method_3360() ? this.getColorFast(quad.method_3359()) : WHITE;
        consumer.method_22920(pose, quad, this.brightness, color[0], color[1], color[2], this.lightmap, overlay, true);
    }

    private float[] getColorFast(int tintIndex) {
        if (tintIndex != this.cachedTintIndex) {
            int packedColor = this.colors.method_1697(this.state, this.level, this.pos, tintIndex);
            this.cachedTintIndex = tintIndex;
            this.cachedTintColor[0] = (float)(packedColor >> 16 & 0xFF) / 255.0f;
            this.cachedTintColor[1] = (float)(packedColor >> 8 & 0xFF) / 255.0f;
            this.cachedTintColor[2] = (float)(packedColor & 0xFF) / 255.0f;
        }
        return this.cachedTintColor;
    }

    public static float calculateShade(float normalX, float normalY, float normalZ, boolean constantAmbientLight) {
        float yFactor = constantAmbientLight ? 0.9f : (3.0f + normalY) / 4.0f;
        return Math.min(normalX * normalX * 0.6f + normalY * normalY * yFactor + normalZ * normalZ * 0.8f, 1.0f);
    }

    @Deprecated(since="1.20.1")
    protected static int getLightColor(class_1920 level, class_2338 pos, class_2680 state) {
        if (state.method_26208((class_1922)level, pos)) {
            return 0xF000F0;
        }
        int skyLight = level.method_8314(class_1944.field_9284, pos);
        int blockLight = Math.max(level.method_8314(class_1944.field_9282, pos), level.method_8320(pos).getLightEmission((class_1922)level, pos));
        return skyLight << 20 | blockLight << 4;
    }
}

