/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2791;
import net.minecraft.class_4538;
import net.minecraftforge.common.ticket.AABBTicket;
import net.minecraftforge.common.ticket.ChunkTicketManager;
import net.minecraftforge.common.ticket.SimpleTicket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FarmlandWaterManager {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugFarmlandWaterManager", "false"));
    private static final Map<class_4538, Map<class_1923, ChunkTicketManager<class_243>>> customWaterHandler = new WeakHashMap<class_4538, Map<class_1923, ChunkTicketManager<class_243>>>();
    private static final Logger LOGGER = LogManager.getLogger();

    public static <T extends SimpleTicket<class_243>> T addCustomTicket(class_1937 level, T ticket, class_1923 masterChunk, class_1923 ... additionalChunks) {
        Preconditions.checkArgument((!level.field_9236 ? 1 : 0) != 0, (Object)"Water region is only determined server-side");
        Map ticketMap = customWaterHandler.computeIfAbsent((class_4538)level, id -> new MapMaker().weakValues().makeMap());
        ChunkTicketManager[] additionalTickets = new ChunkTicketManager[additionalChunks.length];
        for (int i = 0; i < additionalChunks.length; ++i) {
            additionalTickets[i] = ticketMap.computeIfAbsent(additionalChunks[i], ChunkTicketManager::new);
        }
        ticket.setManager(ticketMap.computeIfAbsent(masterChunk, ChunkTicketManager::new), additionalTickets);
        ticket.validate();
        return ticket;
    }

    public static AABBTicket addAABBTicket(class_1937 level, class_238 aabb) {
        if (DEBUG) {
            LOGGER.info("FarmlandWaterManager: New AABBTicket, aabb={}", (Object)aabb);
        }
        class_1923 leftUp = new class_1923((int)aabb.field_1323 >> 4, (int)aabb.field_1321 >> 4);
        class_1923 rightDown = new class_1923((int)aabb.field_1320 >> 4, (int)aabb.field_1324 >> 4);
        HashSet<class_1923> posSet = new HashSet<class_1923>();
        for (int x = leftUp.field_9181; x <= rightDown.field_9181; ++x) {
            for (int z = leftUp.field_9180; z <= rightDown.field_9180; ++z) {
                posSet.add(new class_1923(x, z));
            }
        }
        class_1923 masterPos = null;
        double masterDistance = Double.MAX_VALUE;
        for (class_1923 pos : posSet) {
            double distToCenter = FarmlandWaterManager.getDistanceSq(pos, aabb.method_1005());
            if (!(distToCenter < masterDistance)) continue;
            if (DEBUG) {
                LOGGER.info("FarmlandWaterManager: New better pos then {}: {}, prev dist {}, new dist {}", (Object)masterPos, (Object)pos, (Object)masterDistance, (Object)distToCenter);
            }
            masterPos = pos;
            masterDistance = distToCenter;
        }
        posSet.remove(masterPos);
        if (DEBUG) {
            LOGGER.info("FarmlandWaterManager: {} center pos, {} dummy posses. Dist to center {}", masterPos, (Object)posSet.toArray(new class_1923[0]), (Object)masterDistance);
        }
        return FarmlandWaterManager.addCustomTicket(level, new AABBTicket(aabb), masterPos, posSet.toArray(new class_1923[0]));
    }

    private static double getDistanceSq(class_1923 pos, class_243 vec3d) {
        double d0 = pos.field_9181 * 16 + 8;
        double d1 = pos.field_9180 * 16 + 8;
        double d2 = d0 - vec3d.field_1352;
        double d3 = d1 - vec3d.field_1350;
        return d2 * d2 + d3 * d3;
    }

    public static boolean hasBlockWaterTicket(class_4538 level, class_2338 pos) {
        ChunkTicketManager<class_243> ticketManager = FarmlandWaterManager.getTicketManager(new class_1923(pos.method_10263() >> 4, pos.method_10260() >> 4), level);
        if (ticketManager != null) {
            class_243 posAsVec3d = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            for (SimpleTicket<class_243> ticket : ticketManager.getTickets()) {
                if (!ticket.matches(posAsVec3d)) continue;
                return true;
            }
        }
        return false;
    }

    static void removeTickets(class_2791 chunk) {
        ChunkTicketManager<class_243> ticketManager = FarmlandWaterManager.getTicketManager(chunk.method_12004(), (class_4538)chunk.getWorldForge());
        if (ticketManager != null) {
            if (DEBUG) {
                LOGGER.info("FarmlandWaterManager: got tickets {} at {} before", (Object)ticketManager.getTickets().size(), (Object)ticketManager.pos);
            }
            ticketManager.getTickets().removeIf(next -> next.unload(ticketManager));
            if (DEBUG) {
                LOGGER.info("FarmlandWaterManager: got tickets {} at {} after", (Object)ticketManager.getTickets().size(), (Object)ticketManager.pos);
            }
        }
    }

    private static ChunkTicketManager<class_243> getTicketManager(class_1923 pos, class_4538 level) {
        Preconditions.checkArgument((!level.method_8608() ? 1 : 0) != 0, (Object)"Water region is only determined server-side");
        Map<class_1923, ChunkTicketManager<class_243>> ticketMap = customWaterHandler.get(level);
        if (ticketMap == null) {
            return null;
        }
        return ticketMap.get(pos);
    }
}

