/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributeHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_151;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1560;
import net.minecraft.class_1657;
import net.minecraft.class_1706;
import net.minecraft.class_1735;
import net.minecraft.class_1755;
import net.minecraft.class_1761;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1826;
import net.minecraft.class_1833;
import net.minecraft.class_1834;
import net.minecraft.class_1838;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2846;
import net.minecraft.class_2941;
import net.minecraft.class_2960;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3497;
import net.minecraft.class_3513;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3866;
import net.minecraft.class_3914;
import net.minecraft.class_3956;
import net.minecraft.class_3965;
import net.minecraft.class_4095;
import net.minecraft.class_4538;
import net.minecraft.class_47;
import net.minecraft.class_4763;
import net.minecraft.class_5132;
import net.minecraft.class_5135;
import net.minecraft.class_52;
import net.minecraft.class_5219;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7046;
import net.minecraft.class_7225;
import net.minecraft.class_7417;
import net.minecraft.class_7492;
import net.minecraft.class_7708;
import net.minecraft.class_7876;
import net.minecraft.class_7924;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.ForgeInternalHandler;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifierManager;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.BrainBuilder;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.MavenVersionStringHelper;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.DifficultyChangeEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.GrindstoneEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.ItemStackedOnOtherEvent;
import net.minecraftforge.event.ModMismatchEvent;
import net.minecraftforge.event.RegisterStructureConversionsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.VanillaGameEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.EnderManAngerEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingBreatheEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingDrownEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingGetProjectileEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.LivingMakeBrainEvent;
import net.minecraftforge.event.entity.living.LivingSwapItemsEvent;
import net.minecraftforge.event.entity.living.LivingUseTotemEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.NoteBlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.resource.ResourcePackLoader;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.bluspring.kilt.injections.entity.AttributeSupplierBuilderInjection;
import xyz.bluspring.kilt.injections.world.entity.ai.BrainInjection;
import xyz.bluspring.kilt.injections.world.inventory.AnvilMenuInjection;
import xyz.bluspring.kilt.injections.world.level.LevelInjection;

public class ForgeHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker FORGEHOOKS = MarkerManager.getMarker((String)"FORGEHOOKS");
    private static final Marker WORLDPERSISTENCE = MarkerManager.getMarker((String)"WP");
    static final Pattern URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);
    private static ThreadLocal<class_1657> craftingPlayer = new ThreadLocal();
    private static final ThreadLocal<Deque<LootTableContext>> lootContext = new ThreadLocal();
    private static final Map<class_6880.class_6883<class_1792>, Integer> VANILLA_BURNS = new HashMap<class_6880.class_6883<class_1792>, Integer>();
    private static final Set<String> VANILLA_DIMS = Sets.newHashSet((Object[])new String[]{"minecraft:overworld", "minecraft:the_nether", "minecraft:the_end"});
    private static final String DIMENSIONS_KEY = "dimensions";
    private static final String SEED_KEY = "seed";
    private static final Map<class_1299<? extends class_1309>, class_5132> FORGE_ATTRIBUTES = new HashMap<class_1299<? extends class_1309>, class_5132>();
    private static final Lazy<Map<String, class_7046.class_7047>> FORGE_CONVERSION_MAP = Lazy.concurrentOf(() -> {
        HashMap<String, class_7046.class_7047> map = new HashMap<String, class_7046.class_7047>();
        MinecraftForge.EVENT_BUS.post((Event)new RegisterStructureConversionsEvent(map));
        return ImmutableMap.copyOf(map);
    });

    public static boolean canContinueUsing(@NotNull class_1799 from, @NotNull class_1799 to) {
        if (!from.method_7960() && !to.method_7960()) {
            return from.method_7909().canContinueUsing(from, to);
        }
        return false;
    }

    public static boolean isCorrectToolForDrops(@NotNull class_2680 state, @NotNull class_1657 player) {
        if (!state.method_29291()) {
            return ForgeEventFactory.doPlayerHarvestCheck(player, state, true);
        }
        return player.method_7305(state);
    }

    public static boolean onItemStackedOn(class_1799 carriedItem, class_1799 stackedOnItem, class_1735 slot, class_5536 action, class_1657 player, class_5630 carriedSlotAccess) {
        return MinecraftForge.EVENT_BUS.post((Event)new ItemStackedOnOtherEvent(carriedItem, stackedOnItem, slot, action, player, carriedSlotAccess));
    }

    public static void onDifficultyChange(class_1267 difficulty, class_1267 oldDifficulty) {
        MinecraftForge.EVENT_BUS.post((Event)new DifficultyChangeEvent(difficulty, oldDifficulty));
    }

    public static LivingChangeTargetEvent onLivingChangeTarget(class_1309 entity, class_1309 originalTarget, LivingChangeTargetEvent.ILivingTargetType targetType) {
        LivingChangeTargetEvent event = new LivingChangeTargetEvent(entity, originalTarget, targetType);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static class_4095<?> onLivingMakeBrain(class_1309 entity, class_4095<?> originalBrain, Dynamic<?> dynamic) {
        BrainBuilder brainBuilder = ((BrainInjection)originalBrain).createBuilder();
        LivingMakeBrainEvent event = new LivingMakeBrainEvent(entity, brainBuilder);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return brainBuilder.makeBrain(dynamic);
    }

    public static boolean onLivingTick(class_1309 entity) {
        return MinecraftForge.EVENT_BUS.post((Event)new LivingEvent.LivingTickEvent(entity));
    }

    public static boolean onLivingAttack(class_1309 entity, class_1282 src, float amount) {
        return entity instanceof class_1657 || !MinecraftForge.EVENT_BUS.post((Event)new LivingAttackEvent(entity, src, amount));
    }

    public static boolean onPlayerAttack(class_1309 entity, class_1282 src, float amount) {
        return !MinecraftForge.EVENT_BUS.post((Event)new LivingAttackEvent(entity, src, amount));
    }

    public static LivingKnockBackEvent onLivingKnockBack(class_1309 target, float strength, double ratioX, double ratioZ) {
        LivingKnockBackEvent event = new LivingKnockBackEvent(target, strength, ratioX, ratioZ);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static boolean onLivingUseTotem(class_1309 entity, class_1282 damageSource, class_1799 totem, class_1268 hand) {
        return !MinecraftForge.EVENT_BUS.post((Event)new LivingUseTotemEvent(entity, damageSource, totem, hand));
    }

    public static float onLivingHurt(class_1309 entity, class_1282 src, float amount) {
        LivingHurtEvent event = new LivingHurtEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? 0.0f : event.getAmount();
    }

    public static float onLivingDamage(class_1309 entity, class_1282 src, float amount) {
        LivingDamageEvent event = new LivingDamageEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? 0.0f : event.getAmount();
    }

    public static boolean onLivingDeath(class_1309 entity, class_1282 src) {
        return MinecraftForge.EVENT_BUS.post((Event)new LivingDeathEvent(entity, src));
    }

    public static boolean onLivingDrops(class_1309 entity, class_1282 source, Collection<class_1542> drops, int lootingLevel, boolean recentlyHit) {
        return MinecraftForge.EVENT_BUS.post((Event)new LivingDropsEvent(entity, source, drops, lootingLevel, recentlyHit));
    }

    @Nullable
    public static float[] onLivingFall(class_1309 entity, float distance, float damageMultiplier) {
        float[] fArray;
        LivingFallEvent event = new LivingFallEvent(entity, distance, damageMultiplier);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            fArray = null;
        } else {
            float[] fArray2 = new float[2];
            fArray2[0] = event.getDistance();
            fArray = fArray2;
            fArray2[1] = event.getDamageMultiplier();
        }
        return fArray;
    }

    public static int getLootingLevel(class_1297 target, @Nullable class_1297 killer, @Nullable class_1282 cause) {
        int looting = 0;
        if (killer instanceof class_1309) {
            looting = class_1890.method_8226((class_1309)((class_1309)killer));
        }
        if (target instanceof class_1309) {
            looting = ForgeHooks.getLootingLevel((class_1309)target, cause, looting);
        }
        return looting;
    }

    public static int getLootingLevel(class_1309 target, @Nullable class_1282 cause, int level) {
        LootingLevelEvent event = new LootingLevelEvent(target, cause, level);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getLootingLevel();
    }

    public static double getEntityVisibilityMultiplier(class_1309 entity, class_1297 lookingEntity, double originalMultiplier) {
        LivingEvent.LivingVisibilityEvent event = new LivingEvent.LivingVisibilityEvent(entity, lookingEntity, originalMultiplier);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return Math.max(0.0, event.getVisibilityModifier());
    }

    public static Optional<class_2338> isLivingOnLadder(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1309 entity) {
        boolean isSpectator;
        boolean bl = isSpectator = entity instanceof class_1657 && entity.method_7325();
        if (isSpectator) {
            return Optional.empty();
        }
        if (!((Boolean)ForgeConfig.SERVER.fullBoundingBoxLadders.get()).booleanValue()) {
            return state.isLadder((class_4538)level, pos, entity) ? Optional.of(pos) : Optional.empty();
        }
        class_238 bb = entity.method_5829();
        int mX = class_3532.method_15357((double)bb.field_1323);
        int mY = class_3532.method_15357((double)bb.field_1322);
        int mZ = class_3532.method_15357((double)bb.field_1321);
        int y2 = mY;
        while ((double)y2 < bb.field_1325) {
            int x2 = mX;
            while ((double)x2 < bb.field_1320) {
                int z2 = mZ;
                while ((double)z2 < bb.field_1324) {
                    class_2338 tmp = new class_2338(x2, y2, z2);
                    state = level.method_8320(tmp);
                    if (state.isLadder((class_4538)level, tmp, entity)) {
                        return Optional.of(tmp);
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return Optional.empty();
    }

    public static void onLivingJump(class_1309 entity) {
        MinecraftForge.EVENT_BUS.post((Event)new LivingEvent.LivingJumpEvent(entity));
    }

    @Nullable
    public static class_1542 onPlayerTossEvent(@NotNull class_1657 player, @NotNull class_1799 item, boolean includeName) {
        return ForgeHooks.kilt$onPlayerTossEvent(player, item, includeName, () -> player.method_7329(item, false, includeName));
    }

    @Nullable
    public static class_1542 kilt$onPlayerTossEvent(@NotNull class_1657 player, @NotNull class_1799 item, boolean includeName, Supplier<class_1542> original) {
        player.captureDrops((Collection)Lists.newArrayList());
        class_1542 ret = original.get();
        player.captureDrops(null);
        if (ret == null) {
            return null;
        }
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return null;
        }
        if (!player.method_37908().field_9236) {
            player.method_5770().method_8649((class_1297)event.getEntity());
        }
        return event.getEntity();
    }

    public static boolean onVanillaGameEvent(class_1937 level, class_5712 vanillaEvent, class_243 pos, class_5712.class_7397 context) {
        return !MinecraftForge.EVENT_BUS.post((Event)new VanillaGameEvent(level, vanillaEvent, pos, context));
    }

    private static String getRawText(class_2561 message2) {
        String string;
        class_7417 class_74172 = message2.method_10851();
        if (class_74172 instanceof class_2585) {
            class_2585 literalContents = (class_2585)class_74172;
            string = literalContents.comp_737();
        } else {
            string = "";
        }
        return string;
    }

    @Nullable
    public static class_2561 onServerChatSubmittedEvent(class_3222 player, String plain, class_2561 decorated) {
        ServerChatEvent event = new ServerChatEvent(player, plain, decorated);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? null : event.getMessage();
    }

    @NotNull
    public static class_7492 getServerChatSubmittedDecorator() {
        return (sender, message2) -> CompletableFuture.supplyAsync(() -> {
            if (sender == null) {
                return message2;
            }
            return ForgeHooks.onServerChatSubmittedEvent(sender, ForgeHooks.getRawText(message2), message2);
        }, class_156.method_18349());
    }

    public static class_2561 newChatWithLinks(String string) {
        return ForgeHooks.newChatWithLinks(string, true);
    }

    public static class_2561 newChatWithLinks(String string, boolean allowMissingHeader) {
        class_5250 ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            class_5250 link;
            Object url;
            block13: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (part.length() > 0) {
                    if (ichat == null) {
                        ichat = class_2561.method_43470((String)part);
                    } else {
                        ichat.method_27693(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = class_2561.method_43470((String)url);
                try {
                    if (new URI((String)url).getScheme() != null) break block13;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = class_2561.method_43470((String)url);
                            continue;
                        }
                        ichat.method_27693((String)url);
                        continue;
                    }
                    url = "http://" + (String)url;
                }
                catch (URISyntaxException e) {
                    if (ichat == null) {
                        ichat = class_2561.method_43470((String)url);
                        continue;
                    }
                    ichat.method_27693((String)url);
                    continue;
                }
            }
            class_2558 click = new class_2558(class_2558.class_2559.field_11749, (String)url);
            link.method_10862(link.method_10866().method_10958(click).method_30938(Boolean.valueOf(true)).method_27703(class_5251.method_27718((class_124)class_124.field_1078)));
            if (ichat == null) {
                ichat = class_2561.method_43470((String)"");
            }
            ichat.method_10852((class_2561)link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = class_2561.method_43470((String)end);
        } else if (end.length() > 0) {
            ichat.method_10852((class_2561)class_2561.method_43470((String)string.substring(lastEnd)));
        }
        return ichat;
    }

    public static void dropXpForBlock(class_2680 state, class_3218 level, class_2338 pos, class_1799 stack) {
        int silkTouchLevel;
        int fortuneLevel = stack.getEnchantmentLevel(class_1893.field_9130);
        int exp = state.getExpDrop((class_4538)level, level.field_9229, pos, fortuneLevel, silkTouchLevel = stack.getEnchantmentLevel(class_1893.field_9099));
        if (exp > 0) {
            state.method_26204().method_9583(level, pos, exp);
        }
    }

    public static int onBlockBreakEvent(class_1937 level, class_1934 gameType, class_3222 entityPlayer, class_2338 pos) {
        return ForgeHooks.kilt$onBlockBreakEvent(level, gameType, entityPlayer, pos, () -> entityPlayer.method_6047().method_7909().method_7885(level.method_8320(pos), level, pos, (class_1657)entityPlayer));
    }

    public static int kilt$onBlockBreakEvent(class_1937 level, class_1934 gameType, class_3222 entityPlayer, class_2338 pos, BooleanSupplier original) {
        boolean preCancelEvent = false;
        class_1799 itemstack = entityPlayer.method_6047();
        if (!itemstack.method_7960() && !original.getAsBoolean()) {
            preCancelEvent = true;
        }
        if (gameType.method_8387()) {
            if (gameType == class_1934.field_9219) {
                preCancelEvent = true;
            }
            if (!(entityPlayer.method_7294() || !itemstack.method_7960() && itemstack.method_7940(level.method_30349().method_30530(class_7924.field_41254), new class_2694((class_4538)level, pos, false)))) {
                preCancelEvent = true;
            }
        }
        if (level.method_8321(pos) == null) {
            entityPlayer.field_13987.method_14364((class_2596)new class_2626(pos, level.method_8316(pos).method_15759()));
        }
        class_2680 state = level.method_8320(pos);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, state, (class_1657)entityPlayer);
        event.setCanceled(preCancelEvent);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            class_2596 pkt;
            entityPlayer.field_13987.method_14364((class_2596)new class_2626((class_1922)level, pos));
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity != null && (pkt = blockEntity.method_38235()) != null) {
                entityPlayer.field_13987.method_14364(pkt);
            }
        }
        return event.isCanceled() ? -1 : event.getExpToDrop();
    }

    public static class_1269 onPlaceItemIntoWorld(@NotNull class_1838 context) {
        class_1799 itemstack = context.method_8041();
        class_1937 level = context.method_8045();
        class_1657 player = context.method_8036();
        if (player != null && !player.method_31549().field_7476 && !itemstack.method_7944(level.method_30349().method_30530(class_7924.field_41254), new class_2694((class_4538)level, context.method_8037(), false))) {
            return class_1269.field_5811;
        }
        class_1792 item = itemstack.method_7909();
        int size = itemstack.method_7947();
        class_2487 nbt = null;
        if (itemstack.method_7969() != null) {
            nbt = itemstack.method_7969().method_10553();
        }
        if (!(itemstack.method_7909() instanceof class_1755)) {
            ((LevelInjection)level).kilt$setCapturingBlockSnapshots(true);
        }
        class_1799 copy = itemstack.method_7972();
        class_1269 ret = itemstack.method_7909().method_7884(context);
        if (itemstack.method_7960()) {
            ForgeEventFactory.onPlayerDestroyItem(player, copy, context.method_20287());
        }
        ((LevelInjection)level).kilt$setCapturingBlockSnapshots(false);
        if (ret.method_23665()) {
            int newSize = itemstack.method_7947();
            class_2487 newNBT = null;
            if (itemstack.method_7969() != null) {
                newNBT = itemstack.method_7969().method_10553();
            }
            List blockSnapshots = (List)((LevelInjection)level).getCapturedBlockSnapshots().clone();
            ((LevelInjection)level).getCapturedBlockSnapshots().clear();
            itemstack.method_7939(size);
            itemstack.method_7980(nbt);
            class_2350 side = context.method_8038();
            boolean eventResult = false;
            if (blockSnapshots.size() > 1) {
                eventResult = ForgeEventFactory.onMultiBlockPlace((class_1297)player, blockSnapshots, side);
            } else if (blockSnapshots.size() == 1) {
                eventResult = ForgeEventFactory.onBlockPlace((class_1297)player, (BlockSnapshot)blockSnapshots.get(0), side);
            }
            if (eventResult) {
                ret = class_1269.field_5814;
                for (BlockSnapshot blocksnapshot : Lists.reverse((List)blockSnapshots)) {
                    ((LevelInjection)level).kilt$setRestoringBlockSnapshots(true);
                    blocksnapshot.restore(true, false);
                    ((LevelInjection)level).kilt$setRestoringBlockSnapshots(false);
                }
            } else {
                itemstack.method_7939(newSize);
                itemstack.method_7980(newNBT);
                for (BlockSnapshot snap : blockSnapshots) {
                    int updateFlag = snap.getFlag();
                    class_2680 oldBlock = snap.getReplacedBlock();
                    class_2680 newBlock = level.method_8320(snap.getPos());
                    newBlock.method_26182(level, snap.getPos(), oldBlock, false);
                    level.markAndNotifyBlock(snap.getPos(), level.method_8500(snap.getPos()), oldBlock, newBlock, updateFlag, 512);
                }
                if (player != null) {
                    player.method_7259(class_3468.field_15372.method_14956((Object)item));
                }
            }
        }
        ((LevelInjection)level).getCapturedBlockSnapshots().clear();
        return ret;
    }

    public static boolean onAnvilChange(class_1706 container, @NotNull class_1799 left, @NotNull class_1799 right, class_1263 outputSlot, String name, int baseCost, class_1657 player) {
        AnvilUpdateEvent e = new AnvilUpdateEvent(left, right, name, baseCost, player);
        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
            return false;
        }
        if (e.getOutput().method_7960()) {
            return true;
        }
        outputSlot.method_5447(0, e.getOutput());
        ((AnvilMenuInjection)container).setMaximumCost(e.getCost());
        container.field_7776 = e.getMaterialCost();
        return false;
    }

    public static float onAnvilRepair(class_1657 player, @NotNull class_1799 output, @NotNull class_1799 left, @NotNull class_1799 right) {
        AnvilRepairEvent e = new AnvilRepairEvent(player, left, right, output);
        MinecraftForge.EVENT_BUS.post((Event)e);
        return e.getBreakChance();
    }

    public static int onGrindstoneChange(@NotNull class_1799 top, @NotNull class_1799 bottom, class_1263 outputSlot, int xp) {
        GrindstoneEvent.OnPlaceItem e = new GrindstoneEvent.OnPlaceItem(top, bottom, xp);
        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
            outputSlot.method_5447(0, class_1799.field_8037);
            return -1;
        }
        if (e.getOutput().method_7960()) {
            return Integer.MIN_VALUE;
        }
        outputSlot.method_5447(0, e.getOutput());
        return e.getXp();
    }

    public static boolean onGrindstoneTake(class_1263 inputSlots, class_3914 access, Function<class_1937, Integer> xpFunction) {
        access.method_17393((l, p) -> {
            int xp = (Integer)xpFunction.apply((class_1937)l);
            GrindstoneEvent.OnTakeItem e = new GrindstoneEvent.OnTakeItem(inputSlots.method_5438(0), inputSlots.method_5438(1), xp);
            if (MinecraftForge.EVENT_BUS.post((Event)e)) {
                return;
            }
            if (l instanceof class_3218) {
                class_1303.method_31493((class_3218)((class_3218)l), (class_243)class_243.method_24953((class_2382)p), (int)e.getXp());
            }
            l.method_20290(1042, p, 0);
            inputSlots.method_5447(0, e.getNewTopItem());
            inputSlots.method_5447(1, e.getNewBottomItem());
            inputSlots.method_5431();
        });
        return true;
    }

    public static void setCraftingPlayer(class_1657 player) {
        craftingPlayer.set(player);
    }

    public static class_1657 getCraftingPlayer() {
        return craftingPlayer.get();
    }

    @NotNull
    public static class_1799 getCraftingRemainingItem(@NotNull class_1799 stack) {
        if (stack.method_7909().hasCraftingRemainingItem(stack)) {
            if (!(stack = stack.method_7909().getCraftingRemainingItem(stack)).method_7960() && stack.method_7963() && stack.method_7919() > stack.method_7936()) {
                ForgeEventFactory.onPlayerDestroyItem(craftingPlayer.get(), stack, null);
                return class_1799.field_8037;
            }
            return stack;
        }
        return class_1799.field_8037;
    }

    public static boolean onPlayerAttackTarget(class_1657 player, class_1297 target) {
        if (MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent(player, target))) {
            return false;
        }
        class_1799 stack = player.method_6047();
        return stack.method_7960() || !stack.method_7909().onLeftClickEntity(stack, player, target);
    }

    public static boolean onTravelToDimension(class_1297 entity, class_5321<class_1937> dimension) {
        EntityTravelToDimensionEvent event = new EntityTravelToDimensionEvent(entity, dimension);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public static class_1269 onInteractEntityAt(class_1657 player, class_1297 entity, class_239 ray, class_1268 hand) {
        class_243 vec3d = ray.method_17784().method_1020(entity.method_19538());
        return ForgeHooks.onInteractEntityAt(player, entity, vec3d, hand);
    }

    public static class_1269 onInteractEntityAt(class_1657 player, class_1297 entity, class_243 vec3d, class_1268 hand) {
        PlayerInteractEvent.EntityInteractSpecific evt = new PlayerInteractEvent.EntityInteractSpecific(player, hand, entity, vec3d);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.isCanceled() ? evt.getCancellationResult() : null;
    }

    public static class_1269 onInteractEntity(class_1657 player, class_1297 entity, class_1268 hand) {
        PlayerInteractEvent.EntityInteract evt = new PlayerInteractEvent.EntityInteract(player, hand, entity);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.isCanceled() ? evt.getCancellationResult() : null;
    }

    public static class_1269 onItemRightClick(class_1657 player, class_1268 hand) {
        PlayerInteractEvent.RightClickItem evt = new PlayerInteractEvent.RightClickItem(player, hand);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.isCanceled() ? evt.getCancellationResult() : null;
    }

    @Deprecated(since="1.20.1", forRemoval=true)
    public static PlayerInteractEvent.LeftClickBlock onLeftClickBlock(class_1657 player, class_2338 pos, class_2350 face) {
        return ForgeHooks.onLeftClickBlock(player, pos, face, class_2846.class_2847.field_12968);
    }

    public static PlayerInteractEvent.LeftClickBlock onLeftClickBlock(class_1657 player, class_2338 pos, class_2350 face, class_2846.class_2847 action) {
        PlayerInteractEvent.LeftClickBlock evt = new PlayerInteractEvent.LeftClickBlock(player, pos, face, PlayerInteractEvent.LeftClickBlock.Action.convert(action));
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    public static PlayerInteractEvent.LeftClickBlock onClientMineHold(class_1657 player, class_2338 pos, class_2350 face) {
        PlayerInteractEvent.LeftClickBlock evt = new PlayerInteractEvent.LeftClickBlock(player, pos, face, PlayerInteractEvent.LeftClickBlock.Action.CLIENT_HOLD);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    public static PlayerInteractEvent.RightClickBlock onRightClickBlock(class_1657 player, class_1268 hand, class_2338 pos, class_3965 hitVec) {
        PlayerInteractEvent.RightClickBlock evt = new PlayerInteractEvent.RightClickBlock(player, hand, pos, hitVec);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    public static void onEmptyClick(class_1657 player, class_1268 hand) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerInteractEvent.RightClickEmpty(player, hand));
    }

    public static void onEmptyLeftClick(class_1657 player) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerInteractEvent.LeftClickEmpty(player));
    }

    @Nullable
    public static class_1934 onChangeGameType(class_1657 player, class_1934 currentGameType, class_1934 newGameType) {
        if (currentGameType != newGameType) {
            PlayerEvent.PlayerChangeGameModeEvent evt = new PlayerEvent.PlayerChangeGameModeEvent(player, currentGameType, newGameType);
            MinecraftForge.EVENT_BUS.post((Event)evt);
            return evt.isCanceled() ? null : evt.getNewGameMode();
        }
        return newGameType;
    }

    private static LootTableContext getLootTableContext() {
        LootTableContext ctx = lootContext.get().peek();
        if (ctx == null) {
            throw new JsonParseException("Invalid call stack, could not grab json context!");
        }
        return ctx;
    }

    public static TriFunction<class_2960, JsonElement, class_3300, Optional<class_52>> getLootTableDeserializer(Gson gson, String directory) {
        return (location, data, resourceManager) -> {
            try {
                class_3298 resource = resourceManager.method_14486(location.method_45136(directory + "/" + location.method_12832() + ".json")).orElse(null);
                boolean custom = resource == null || !resource.method_45305();
                return Optional.ofNullable(ForgeHooks.loadLootTable(gson, location, data, custom));
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't parse element {}:{}", (Object)directory, location, (Object)exception);
                return Optional.empty();
            }
        };
    }

    public static class_52 loadLootTable(Gson gson, class_2960 name, JsonElement data, boolean custom) {
        class_52 ret;
        ArrayDeque que = lootContext.get();
        if (que == null) {
            que = Queues.newArrayDeque();
            lootContext.set(que);
        }
        try {
            que.push(new LootTableContext(name, custom));
            ret = (class_52)gson.fromJson(data, class_52.class);
            ret.setLootTableId(name);
        }
        catch (JsonParseException e) {
            throw e;
        }
        finally {
            que.pop();
        }
        if (!custom) {
            ret = ForgeEventFactory.loadLootTable(name, ret);
        }
        return ret;
    }

    public static String readPoolName(JsonObject json) {
        LootTableContext ctx;
        if (json.has("name")) {
            return class_3518.method_15265((JsonObject)json, (String)"name");
        }
        try {
            ctx = ForgeHooks.getLootTableContext();
        }
        catch (NullPointerException ignored) {
            return "main";
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        ++ctx.poolCount;
        return ctx.poolCount == 1 ? "main" : "pool" + (ctx.poolCount - 1);
    }

    public static FluidType getVanillaFluidType(class_3611 fluid) {
        if (fluid == class_3612.field_15906) {
            return ForgeMod.EMPTY_TYPE.get();
        }
        if (fluid == class_3612.field_15910 || fluid == class_3612.field_15909) {
            return ForgeMod.WATER_TYPE.get();
        }
        if (fluid == class_3612.field_15908 || fluid == class_3612.field_15907) {
            return ForgeMod.LAVA_TYPE.get();
        }
        if (ForgeMod.MILK.filter(milk -> milk == fluid).isPresent() || ForgeMod.FLOWING_MILK.filter(milk -> milk == fluid).isPresent()) {
            return ForgeMod.MILK_TYPE.get();
        }
        io.github.fabricators_of_create.porting_lib.fluids.FluidType fabricFluidType = fluid.getFluidType();
        if (fabricFluidType != null) {
            return FluidType.kilt$tryGetWrappingFluidType(fabricFluidType);
        }
        FluidVariantAttributeHandler handler = FluidVariantAttributes.getHandlerOrDefault((class_3611)fluid);
        if (handler != null) {
            return FluidType.kilt$tryGetWrappingFluidType(FluidVariant.of((class_3611)fluid), handler);
        }
        throw new RuntimeException("Mod fluids must override getFluidType.");
    }

    public static class_6862<class_2248> getTagFromVanillaTier(class_1834 tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case class_1834.field_8922 -> Tags.Blocks.NEEDS_WOOD_TOOL;
            case class_1834.field_8929 -> Tags.Blocks.NEEDS_GOLD_TOOL;
            case class_1834.field_8927 -> class_3481.field_33719;
            case class_1834.field_8923 -> class_3481.field_33718;
            case class_1834.field_8930 -> class_3481.field_33717;
            case class_1834.field_22033 -> Tags.Blocks.NEEDS_NETHERITE_TOOL;
        };
    }

    public static Collection<class_1761> onCheckCreativeTabs(class_1761 ... vanillaTabs) {
        ArrayList<class_1761> tabs = new ArrayList<class_1761>(Arrays.asList(vanillaTabs));
        return tabs;
    }

    public static boolean onCropsGrowPre(class_1937 level, class_2338 pos, class_2680 state, boolean def) {
        BlockEvent.CropGrowEvent.Pre ev = new BlockEvent.CropGrowEvent.Pre(level, pos, state);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev.getResult() == Event.Result.ALLOW || ev.getResult() == Event.Result.DEFAULT && def;
    }

    public static void onCropsGrowPost(class_1937 level, class_2338 pos, class_2680 state) {
        MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.CropGrowEvent.Post(level, pos, state, level.method_8320(pos)));
    }

    @Nullable
    public static CriticalHitEvent getCriticalHit(class_1657 player, class_1297 target, boolean vanillaCritical, float damageModifier) {
        CriticalHitEvent hitResult = new CriticalHitEvent(player, target, damageModifier, vanillaCritical);
        MinecraftForge.EVENT_BUS.post((Event)hitResult);
        if (hitResult.getResult() == Event.Result.ALLOW || vanillaCritical && hitResult.getResult() == Event.Result.DEFAULT) {
            return hitResult;
        }
        return null;
    }

    public static Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 equipmentSlot, Multimap<class_1320, class_1322> attributes) {
        ItemAttributeModifierEvent event = new ItemAttributeModifierEvent(stack, equipmentSlot, attributes);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getModifiers();
    }

    public static class_1799 getProjectile(class_1309 entity, class_1799 projectileWeaponItem, class_1799 projectile) {
        LivingGetProjectileEvent event = new LivingGetProjectileEvent(entity, projectileWeaponItem, projectile);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getProjectileItemStack();
    }

    @Nullable
    public static String getDefaultCreatorModId(@NotNull class_1799 itemStack) {
        String modId;
        class_1792 item = itemStack.method_7909();
        class_2960 registryName = ForgeRegistries.ITEMS.getKey(item);
        String string = modId = registryName == null ? null : registryName.method_12836();
        if ("minecraft".equals(modId)) {
            class_2960 resourceLocation;
            if (item instanceof class_1772) {
                class_2487 nbttagcompound;
                class_2960 resourceLocation2;
                class_2499 enchantmentsNbt = class_1772.method_7806((class_1799)itemStack);
                if (enchantmentsNbt.size() == 1 && (resourceLocation2 = class_2960.method_12829((String)(nbttagcompound = enchantmentsNbt.method_10602(0)).method_10558("id"))) != null && ForgeRegistries.ENCHANTMENTS.containsKey(resourceLocation2)) {
                    return resourceLocation2.method_12836();
                }
            } else if (item instanceof class_1812 || item instanceof class_1833) {
                class_1842 potionType = class_1844.method_8063((class_1799)itemStack);
                class_2960 resourceLocation3 = ForgeRegistries.POTIONS.getKey(potionType);
                if (resourceLocation3 != null) {
                    return resourceLocation3.method_12836();
                }
            } else if (item instanceof class_1826 && (resourceLocation = ForgeRegistries.ENTITY_TYPES.getKey(((class_1826)item).method_8015(null))) != null) {
                return resourceLocation.method_12836();
            }
        }
        return modId;
    }

    public static boolean onFarmlandTrample(class_1937 level, class_2338 pos, class_2680 state, float fallDistance, class_1297 entity) {
        if (entity.canTrample(state, pos, fallDistance)) {
            BlockEvent.FarmlandTrampleEvent event = new BlockEvent.FarmlandTrampleEvent(level, pos, state, fallDistance, entity);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return !event.isCanceled();
        }
        return false;
    }

    public static int onNoteChange(class_1937 level, class_2338 pos, class_2680 state, int old, int _new) {
        NoteBlockEvent.Change event = new NoteBlockEvent.Change(level, pos, state, old, _new);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return -1;
        }
        return event.getVanillaNoteId();
    }

    public static boolean hasNoElements(class_1856 ingredient) {
        class_1799[] items = ingredient.method_8105();
        if (items.length == 0) {
            return true;
        }
        if (items.length == 1) {
            class_5250 hoverName;
            class_2561 class_25612;
            class_1799 item = items[0];
            return item.method_7909() == class_1802.field_8077 && (class_25612 = item.method_7964()) instanceof class_5250 && (hoverName = (class_5250)class_25612).getString().startsWith("Empty Tag: ");
        }
        return false;
    }

    @Deprecated(forRemoval=true, since="1.20.1")
    public static <T> void deserializeTagAdditions(List<class_3497> list, JsonObject json, List<class_3497> allList) {
    }

    @Nullable
    public static class_2941<?> getSerializer(int id, class_3513<class_2941<?>> vanilla) {
        ForgeRegistry registry;
        class_2941 serializer = (class_2941)vanilla.method_10200(id);
        if (serializer == null && (registry = (ForgeRegistry)ForgeRegistries.ENTITY_DATA_SERIALIZERS.get()) != null) {
            serializer = (class_2941)registry.getValue(id);
        }
        return serializer;
    }

    public static int getSerializerId(class_2941<?> serializer, class_3513<class_2941<?>> vanilla) {
        ForgeRegistry registry;
        int id = vanilla.method_10206(serializer);
        if (id < 0 && (registry = (ForgeRegistry)ForgeRegistries.ENTITY_DATA_SERIALIZERS.get()) != null) {
            id = registry.getID(serializer);
        }
        return id;
    }

    public static boolean canEntityDestroy(class_1937 level, class_2338 pos, class_1309 entity) {
        if (!level.method_8477(pos)) {
            return false;
        }
        class_2680 state = level.method_8320(pos);
        return ForgeEventFactory.getMobGriefingEvent(level, (class_1297)entity) && state.canEntityDestroy((class_1922)level, pos, (class_1297)entity) && ForgeEventFactory.onEntityDestroyBlock(entity, pos, state);
    }

    public static int getBurnTime(class_1799 stack, @Nullable class_3956<?> recipeType) {
        if (stack.method_7960()) {
            return 0;
        }
        class_1792 item = stack.method_7909();
        int ret = stack.getBurnTime(recipeType);
        return ForgeEventFactory.getItemBurnTime(stack, ret == -1 ? VANILLA_BURNS.getOrDefault(ForgeRegistries.ITEMS.getDelegateOrThrow(item), 0) : ret, recipeType);
    }

    public static synchronized void updateBurns() {
        VANILLA_BURNS.clear();
        class_3866.method_11196().entrySet().forEach(e -> VANILLA_BURNS.put(ForgeRegistries.ITEMS.getDelegateOrThrow((class_1792)e.getKey()), (Integer)e.getValue()));
    }

    @Deprecated
    public static List<class_1799> modifyLoot(List<class_1799> list, class_47 context) {
        return ForgeHooks.modifyLoot(LootTableIdCondition.UNKNOWN_LOOT_TABLE, (ObjectArrayList<class_1799>)ObjectArrayList.wrap((Object[])((class_1799[])list.toArray())), context);
    }

    public static ObjectArrayList<class_1799> modifyLoot(class_2960 lootTableId, ObjectArrayList<class_1799> generatedLoot, class_47 context) {
        context.setQueriedLootTableId(lootTableId);
        LootModifierManager man = ForgeInternalHandler.getLootModifierManager();
        for (IGlobalLootModifier mod : man.getAllLootMods()) {
            generatedLoot = mod.apply(generatedLoot, context);
        }
        return generatedLoot;
    }

    public static List<String> getModPacks() {
        List<String> modpacks = ResourcePackLoader.getPackNames();
        if (modpacks.isEmpty()) {
            throw new IllegalStateException("Attempted to retrieve mod packs before they were loaded in!");
        }
        return modpacks;
    }

    public static List<String> getModPacksWithVanilla() {
        List<String> modpacks = ForgeHooks.getModPacks();
        modpacks.add("vanilla");
        return modpacks;
    }

    @Deprecated
    public static Map<class_1299<? extends class_1309>, class_5132> getAttributesView() {
        return Collections.unmodifiableMap(FORGE_ATTRIBUTES);
    }

    @Deprecated
    public static void modifyAttributes() {
        ModLoader.get().postEvent(new EntityAttributeCreationEvent(FORGE_ATTRIBUTES));
        HashMap<class_1299<? extends class_1309>, class_5132.class_5133> finalMap = new HashMap<class_1299<? extends class_1309>, class_5132.class_5133>();
        ModLoader.get().postEvent(new EntityAttributeModificationEvent(finalMap));
        finalMap.forEach((k, v) -> {
            class_5132 supplier = class_5135.method_26873((class_1299)k);
            class_5132.class_5133 newBuilder = supplier != null ? AttributeSupplierBuilderInjection.create(supplier) : new class_5132.class_5133();
            newBuilder.combine((class_5132.class_5133)v);
            FORGE_ATTRIBUTES.put((class_1299<? extends class_1309>)k, newBuilder.method_26866());
        });
    }

    public static void onEntityEnterSection(class_1297 entity, long packedOldPos, long packedNewPos) {
        MinecraftForge.EVENT_BUS.post((Event)new EntityEvent.EnteringSection(entity, packedOldPos, packedNewPos));
    }

    public static ShieldBlockEvent onShieldBlock(class_1309 blocker, class_1282 source, float blocked) {
        ShieldBlockEvent e = new ShieldBlockEvent(blocker, source, blocked);
        MinecraftForge.EVENT_BUS.post((Event)e);
        return e;
    }

    public static LivingSwapItemsEvent.Hands onLivingSwapHandItems(class_1309 livingEntity) {
        LivingSwapItemsEvent.Hands event = new LivingSwapItemsEvent.Hands(livingEntity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static void writeAdditionalLevelSaveData(class_5219 worldData, class_2487 levelTag) {
        class_2487 fmlData = new class_2487();
        class_2499 modList = new class_2499();
        ModList.get().getMods().forEach(mi -> {
            class_2487 mod = new class_2487();
            mod.method_10582("ModId", mi.getModId());
            mod.method_10582("ModVersion", MavenVersionStringHelper.artifactVersionToString(mi.getVersion()));
            modList.add((Object)mod);
        });
        fmlData.method_10566("LoadingModList", (class_2520)modList);
        class_2487 registries = new class_2487();
        fmlData.method_10566("Registries", (class_2520)registries);
        LOGGER.debug(WORLDPERSISTENCE, "Gathering id map for writing to world save {}", (Object)worldData.method_150());
        for (Map.Entry<class_2960, ForgeRegistry.Snapshot> e : RegistryManager.ACTIVE.takeSnapshot(true).entrySet()) {
            registries.method_10566(e.getKey().toString(), (class_2520)e.getValue().write());
        }
        LOGGER.debug(WORLDPERSISTENCE, "ID Map collection complete {}", (Object)worldData.method_150());
        levelTag.method_10566("fml", (class_2520)fmlData);
    }

    @ApiStatus.Internal
    public static void readAdditionalLevelSaveData(class_2487 rootTag, class_32.class_7411 levelDirectory) {
        class_2487 tag = rootTag.method_10562("fml");
        if (tag.method_10545("LoadingModList")) {
            class_2499 modList = tag.method_10554("LoadingModList", 10);
            HashMap<String, ArtifactVersion> mismatchedVersions = new HashMap<String, ArtifactVersion>(modList.size());
            HashMap<String, ArtifactVersion> missingVersions = new HashMap<String, ArtifactVersion>(modList.size());
            for (int i = 0; i < modList.size(); ++i) {
                class_2487 mod = modList.method_10602(i);
                String modId = mod.method_10558("ModId");
                if (Objects.equals("minecraft", modId)) continue;
                String modVersion = mod.method_10558("ModVersion");
                DefaultArtifactVersion previousVersion = new DefaultArtifactVersion(modVersion);
                ModList.get().getModContainerById(modId).ifPresentOrElse(container -> {
                    ArtifactVersion loadingVersion = container.getModInfo().getVersion();
                    if (!loadingVersion.equals(previousVersion)) {
                        mismatchedVersions.put(modId, (ArtifactVersion)previousVersion);
                    }
                }, () -> missingVersions.put(modId, (ArtifactVersion)previousVersion));
            }
            ModMismatchEvent mismatchEvent = new ModMismatchEvent(levelDirectory, mismatchedVersions, missingVersions);
            ModLoader.get().postEvent(mismatchEvent);
            StringBuilder resolved = new StringBuilder("The following mods have version differences that were marked resolved:");
            StringBuilder unresolved = new StringBuilder("The following mods have version differences that were not resolved:");
            mismatchEvent.getResolved().forEachOrdered(res -> {
                String modid = res.modid();
                ModMismatchEvent.MismatchedVersionInfo diff = res.versionDifference();
                if (res.wasSelfResolved()) {
                    resolved.append(System.lineSeparator()).append(diff.isMissing() ? "%s (version %s -> MISSING, self-resolved)".formatted(modid, diff.oldVersion()) : "%s (version %s -> %s, self-resolved)".formatted(modid, diff.oldVersion(), diff.newVersion()));
                } else {
                    String resolver = res.resolver().getModId();
                    resolved.append(System.lineSeparator()).append(diff.isMissing() ? "%s (version %s -> MISSING, resolved by %s)".formatted(modid, diff.oldVersion(), resolver) : "%s (version %s -> %s, resolved by %s)".formatted(modid, diff.oldVersion(), diff.newVersion(), resolver));
                }
            });
            mismatchEvent.getUnresolved().forEachOrdered(unres -> {
                String modid = unres.modid();
                ModMismatchEvent.MismatchedVersionInfo diff = unres.versionDifference();
                unresolved.append(System.lineSeparator()).append(diff.isMissing() ? "%s (version %s -> MISSING)".formatted(modid, diff.oldVersion()) : "%s (version %s -> %s)".formatted(modid, diff.oldVersion(), diff.newVersion()));
            });
            if (mismatchEvent.anyResolved()) {
                resolved.append(System.lineSeparator()).append("Things may not work well.");
                LOGGER.debug(WORLDPERSISTENCE, resolved.toString());
            }
            if (mismatchEvent.anyUnresolved()) {
                unresolved.append(System.lineSeparator()).append("Things may not work well.");
                LOGGER.warn(WORLDPERSISTENCE, unresolved.toString());
            }
        }
        Object failedElements = null;
    }

    public static String encodeLifecycle(Lifecycle lifecycle) {
        if (lifecycle == Lifecycle.stable()) {
            return "stable";
        }
        if (lifecycle == Lifecycle.experimental()) {
            return "experimental";
        }
        if (lifecycle instanceof Lifecycle.Deprecated) {
            Lifecycle.Deprecated dep = (Lifecycle.Deprecated)lifecycle;
            return "deprecated=" + dep.since();
        }
        throw new IllegalArgumentException("Unknown lifecycle.");
    }

    public static Lifecycle parseLifecycle(String lifecycle) {
        if (lifecycle.equals("stable")) {
            return Lifecycle.stable();
        }
        if (lifecycle.equals("experimental")) {
            return Lifecycle.experimental();
        }
        if (lifecycle.startsWith("deprecated=")) {
            return Lifecycle.deprecated((int)Integer.parseInt(lifecycle.substring(lifecycle.indexOf(61) + 1)));
        }
        throw new IllegalArgumentException("Unknown lifecycle.");
    }

    public static void saveMobEffect(class_2487 nbt, String key, class_1291 effect) {
        class_2960 registryName = ForgeRegistries.MOB_EFFECTS.getKey(effect);
        if (registryName != null) {
            nbt.method_10582(key, registryName.toString());
        }
    }

    @Nullable
    public static class_1291 loadMobEffect(class_2487 nbt, String key, @Nullable class_1291 fallback) {
        String registryName = nbt.method_10558(key);
        if (Strings.isNullOrEmpty((String)registryName)) {
            return fallback;
        }
        try {
            return ForgeRegistries.MOB_EFFECTS.getValue(new class_2960(registryName));
        }
        catch (class_151 e) {
            return fallback;
        }
    }

    public static boolean shouldSuppressEnderManAnger(class_1560 enderMan, class_1657 player, class_1799 mask) {
        return mask.isEnderMask(player, enderMan) || MinecraftForge.EVENT_BUS.post((Event)new EnderManAngerEvent(enderMan, player));
    }

    @Nullable
    public static class_7046.class_7047 getStructureConversion(String originalBiome) {
        return (class_7046.class_7047)((Map)FORGE_CONVERSION_MAP.get()).get(originalBiome);
    }

    public static boolean checkStructureNamespace(String biome) {
        @Nullable class_2960 biomeLocation = class_2960.method_12829((String)biome);
        return biomeLocation != null && !biomeLocation.method_12836().equals("minecraft");
    }

    public static Map<class_3264, Integer> readTypedPackFormats(JsonObject json) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (class_3264 packType : class_3264.values()) {
            String key = ForgeHooks.makePackFormatKey(packType);
            if (!json.has(key)) continue;
            map.put((Object)packType, (Object)class_3518.method_15260((JsonObject)json, (String)key));
        }
        return map.buildOrThrow();
    }

    public static void writeTypedPackFormats(JsonObject json, class_3272 section) {
        int packFormat = section.method_14424();
        for (class_3264 packType : class_3264.values()) {
            int format = section.method_14424();
            if (format == packFormat) continue;
            json.addProperty(ForgeHooks.makePackFormatKey(packType), (Number)format);
        }
    }

    private static String makePackFormatKey(class_3264 packType) {
        return "forge:" + packType.name().toLowerCase(Locale.ROOT) + "_pack_format";
    }

    public static String prefixNamespace(class_2960 registryKey) {
        return registryKey.method_12836().equals("minecraft") ? registryKey.method_12832() : registryKey.method_12836() + "/" + registryKey.method_12832();
    }

    public static boolean canUseEntitySelectors(class_2172 provider) {
        if (provider.method_9259(2)) {
            return true;
        }
        if (provider instanceof class_2168) {
            class_2168 source = (class_2168)provider;
            class_2165 class_21652 = source.field_9819;
            if (class_21652 instanceof class_3222) {
                class_3222 player = (class_3222)class_21652;
                return PermissionAPI.getPermission(player, ForgeMod.USE_SELECTORS_PERMISSION, new PermissionDynamicContext[0]);
            }
        }
        return false;
    }

    @ApiStatus.Internal
    public static <T> class_7225.class_7226<T> wrapRegistryLookup(final class_7225.class_7226<T> lookup) {
        return new class_7225.class_7226.class_7875<T>(){

            protected class_7225.class_7226<T> method_46725() {
                return lookup;
            }

            public Stream<class_6885.class_6888<T>> method_42020() {
                return Stream.empty();
            }

            public Optional<class_6885.class_6888<T>> method_46733(class_6862<T> key) {
                return Optional.of(class_6885.method_45924((class_7876)lookup, key));
            }
        };
    }

    public static void onLivingBreathe(class_1309 entity, int consumeAirAmount, int refillAirAmount) {
        LivingDrownEvent drownEvent;
        boolean isAir = entity.getEyeInFluidType().isAir() || entity.method_37908().method_8320(class_2338.method_49637((double)entity.method_23317(), (double)entity.method_23320(), (double)entity.method_23321())).method_27852(class_2246.field_10422);
        boolean canBreathe = !entity.canDrownInFluidType(entity.getEyeInFluidType()) || class_1292.method_5574((class_1309)entity) || entity instanceof class_1657 && ((class_1657)entity).method_31549().field_7480;
        LivingBreatheEvent breatheEvent = new LivingBreatheEvent(entity, isAir || canBreathe, consumeAirAmount, refillAirAmount, isAir);
        MinecraftForge.EVENT_BUS.post((Event)breatheEvent);
        if (breatheEvent.canBreathe()) {
            if (breatheEvent.canRefillAir()) {
                entity.method_5855(Math.min(entity.method_5669() + breatheEvent.getRefillAirAmount(), entity.method_5748()));
            }
        } else {
            entity.method_5855(entity.method_5669() - breatheEvent.getConsumeAirAmount());
        }
        if (entity.method_5669() <= 0 && !MinecraftForge.EVENT_BUS.post((Event)(drownEvent = new LivingDrownEvent(entity, entity.method_5669() <= -20, 2.0f, 8))) && drownEvent.isDrowning()) {
            entity.method_5855(0);
            class_243 vec3 = entity.method_18798();
            for (int i = 0; i < drownEvent.getBubbleCount(); ++i) {
                double d2 = entity.method_6051().method_43058() - entity.method_6051().method_43058();
                double d3 = entity.method_6051().method_43058() - entity.method_6051().method_43058();
                double d4 = entity.method_6051().method_43058() - entity.method_6051().method_43058();
                entity.method_37908().method_8406((class_2394)class_2398.field_11247, entity.method_23317() + d2, entity.method_23318() + d3, entity.method_23321() + d4, vec3.field_1352, vec3.field_1351, vec3.field_1350);
            }
            if (drownEvent.getDamageAmount() > 0.0f) {
                entity.method_5643(entity.method_48923().method_48824(), drownEvent.getDamageAmount());
            }
        }
        if (!isAir && !entity.method_37908().field_9236 && entity.method_5765() && entity.method_5854() != null && !entity.method_5854().canBeRiddenUnderFluidType(entity.getEyeInFluidType(), (class_1297)entity)) {
            entity.method_5848();
        }
    }

    public static void onCreativeModeTabBuildContents(class_1761 tab, class_5321<class_1761> tabKey, class_1761.class_7914 originalGenerator, class_1761.class_8128 params, class_1761.class_7704 output) {
        MutableHashedLinkedMap<class_1799, class_1761.class_7705> entries = new MutableHashedLinkedMap<class_1799, class_1761.class_7705>(class_7708.field_40212, (key, left, right) -> class_1761.class_7705.field_40191);
        originalGenerator.accept(params, (stack, vis) -> {
            if (stack.method_7947() != 1) {
                throw new IllegalArgumentException("The stack count must be 1");
            }
            entries.put(stack, vis);
        });
        ModLoader.get().postEvent(new BuildCreativeModeTabContentsEvent(tab, tabKey, params, entries));
        for (Map.Entry<class_1799, class_1761.class_7705> entry : entries) {
            output.method_45417(entry.getKey(), entry.getValue());
        }
    }

    private static class LootTableContext {
        public final class_2960 name;
        public final boolean vanilla;
        public final boolean custom;
        public int poolCount = 0;

        private LootTableContext(class_2960 name, boolean custom) {
            this.name = name;
            this.custom = custom;
            this.vanilla = "minecraft".equals(this.name.method_12836());
        }
    }

    @FunctionalInterface
    public static interface BiomeCallbackFunction {
        public class_1959 apply(class_1959.class_5482 var1, class_4763 var2, class_5485 var3, class_5483 var4);
    }
}

