/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import net.minecraft.class_1255;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3302;
import net.minecraft.class_3738;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.common.loot.LootModifierManager;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.server.command.ConfigCommand;
import net.minecraftforge.server.command.ForgeCommand;
import xyz.bluspring.kilt.injections.world.entity.MobInjection;

public class ForgeInternalHandler {
    private static LootModifierManager INSTANCE;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        class_1297 newEntity;
        class_1799 stack;
        class_1792 item;
        class_1297 entity = event.getEntity();
        if (entity.getClass().equals(class_1542.class) && (item = (stack = ((class_1542)entity).method_6983()).method_7909()).hasCustomEntity(stack) && (newEntity = item.createEntity(event.getLevel(), entity, stack)) != null) {
            entity.method_31472();
            event.setCanceled(true);
            class_1255<? super class_3738> executor = LogicalSidedProvider.WORKQUEUE.get(event.getLevel().field_9236 ? LogicalSide.CLIENT : LogicalSide.SERVER);
            executor.method_18858((Runnable)new class_3738(0, () -> event.getLevel().method_8649(newEntity)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDimensionUnload(LevelEvent.Unload event) {
        if (event.getLevel() instanceof class_3218) {
            FakePlayerFactory.unloadLevel((class_3218)event.getLevel());
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        WorldWorkerManager.tick(event.phase == TickEvent.Phase.START);
    }

    @SubscribeEvent
    public void checkSettings(TickEvent.ClientTickEvent event) {
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        if (!event.getLevel().method_8608()) {
            FarmlandWaterManager.removeTickets(event.getChunk());
        }
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        UsernameCache.setUsername(event.getEntity().method_5667(), event.getEntity().method_7334().getName());
    }

    @SubscribeEvent
    public void tagsUpdated(TagsUpdatedEvent event) {
        if (event.shouldUpdateStaticData()) {
            ForgeHooks.updateBurns();
        }
    }

    @SubscribeEvent
    public void onCommandsRegister(RegisterCommandsEvent event) {
        new ForgeCommand(event.getDispatcher());
        ConfigCommand.register(event.getDispatcher());
    }

    @SubscribeEvent
    public void onResourceReload(AddReloadListenerEvent event) {
        INSTANCE = new LootModifierManager();
        event.addListener((class_3302)INSTANCE);
    }

    static LootModifierManager getLootModifierManager() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Can not retrieve LootModifierManager until resources have loaded once.");
        }
        return INSTANCE;
    }

    @SubscribeEvent
    public void resourceReloadListeners(AddReloadListenerEvent event) {
        event.addListener(TierSortingRegistry.getReloadListener());
        event.addListener(CreativeModeTabRegistry.getReloadListener());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void builtinMobSpawnBlocker(EntityJoinLevelEvent event) {
        class_1308 mob;
        class_1297 class_12972 = event.getEntity();
        if (class_12972 instanceof class_1308 && ((MobInjection)(mob = (class_1308)class_12972)).isSpawnCancelled()) {
            event.setCanceled(true);
        }
    }
}

