/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1163;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1320;
import net.minecraft.class_1329;
import net.minecraft.class_1542;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2338;
import net.minecraft.class_2403;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3797;
import net.minecraft.class_5483;
import net.minecraft.class_5699;
import net.minecraft.class_6489;
import net.minecraft.class_6796;
import net.minecraft.class_6895;
import net.minecraft.class_7;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import net.minecraft.class_7796;
import net.minecraft.class_7924;
import net.minecraft.class_811;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.VillagerTradingManager;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.DifferenceIngredient;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import net.minecraftforge.common.crafting.PartialNBTIngredient;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.AndCondition;
import net.minecraftforge.common.crafting.conditions.FalseCondition;
import net.minecraftforge.common.crafting.conditions.ItemExistsCondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.common.crafting.conditions.TrueCondition;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeBiomeTagsProvider;
import net.minecraftforge.common.data.ForgeBlockTagsProvider;
import net.minecraftforge.common.data.ForgeEntityTypeTagsProvider;
import net.minecraftforge.common.data.ForgeFluidTagsProvider;
import net.minecraftforge.common.data.ForgeItemTagsProvider;
import net.minecraftforge.common.data.ForgeLootTableProvider;
import net.minecraftforge.common.data.ForgeRecipeProvider;
import net.minecraftforge.common.data.ForgeSpriteSourceProvider;
import net.minecraftforge.common.data.VanillaSoundDefinitionsProvider;
import net.minecraftforge.common.loot.CanToolPerformAction;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.common.world.NoneBiomeModifier;
import net.minecraftforge.common.world.NoneStructureModifier;
import net.minecraftforge.common.world.StructureModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.CrashReportCallables;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.filters.VanillaPacketSplitter;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeDeferredRegistriesSetup;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.IdMappingEvent;
import net.minecraftforge.registries.MissingMappingsEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.holdersets.AndHolderSet;
import net.minecraftforge.registries.holdersets.AnyHolderSet;
import net.minecraftforge.registries.holdersets.HolderSetType;
import net.minecraftforge.registries.holdersets.NotHolderSet;
import net.minecraftforge.registries.holdersets.OrHolderSet;
import net.minecraftforge.server.command.EnumArgument;
import net.minecraftforge.server.command.ModIdArgument;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionTypes;
import net.minecraftforge.versions.forge.ForgeVersion;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;
import xyz.bluspring.kilt.injections.commands.synchronization.ArgumentTypeInfosInjection;
import xyz.bluspring.kilt.injections.item.crafting.IngredientInjection;
import xyz.bluspring.kilt.injections.server.packs.metadata.pack.PackMetadataSectionInjection;
import xyz.bluspring.kilt.injections.world.item.ItemDisplayContextInjection;

@Mod(value="forge")
public class ForgeMod {
    public static final String VERSION_CHECK_CAT = "version_checking";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker FORGEMOD = MarkerManager.getMarker((String)"FORGEMOD");
    private static final DeferredRegister<class_1320> ATTRIBUTES = DeferredRegister.create(ForgeRegistries.Keys.ATTRIBUTES, "forge");
    private static final DeferredRegister<class_2314<?, ?>> COMMAND_ARGUMENT_TYPES = DeferredRegister.create(class_7924.field_41262, "forge");
    private static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create(ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, "forge");
    private static final DeferredRegister<Codec<? extends StructureModifier>> STRUCTURE_MODIFIER_SERIALIZERS = DeferredRegister.create(ForgeRegistries.Keys.STRUCTURE_MODIFIER_SERIALIZERS, "forge");
    private static final DeferredRegister<HolderSetType> HOLDER_SET_TYPES = DeferredRegister.create(ForgeRegistries.Keys.HOLDER_SET_TYPES, "forge");
    private static final RegistryObject<EnumArgument.Info> ENUM_COMMAND_ARGUMENT_TYPE = COMMAND_ARGUMENT_TYPES.register("enum", () -> ArgumentTypeInfosInjection.registerByClass(EnumArgument.class, new EnumArgument.Info()));
    private static final RegistryObject<class_2319<ModIdArgument>> MODID_COMMAND_ARGUMENT_TYPE = COMMAND_ARGUMENT_TYPES.register("modid", () -> ArgumentTypeInfosInjection.registerByClass(ModIdArgument.class, class_2319.method_41999(ModIdArgument::modIdArgument)));
    public static final RegistryObject<class_1320> SWIM_SPEED = ATTRIBUTES.kilt$getValue("swim_speed");
    public static final RegistryObject<class_1320> NAMETAG_DISTANCE = ATTRIBUTES.register("nametag_distance", () -> new class_1329("forge.name_tag_distance", 64.0, 0.0, 64.0).method_26829(true));
    public static final RegistryObject<class_1320> ENTITY_GRAVITY = ATTRIBUTES.kilt$getValue("entity_gravity");
    public static final RegistryObject<class_1320> BLOCK_REACH = ATTRIBUTES.kilt$getValue("block_reach");
    public static final RegistryObject<class_1320> ENTITY_REACH = ATTRIBUTES.kilt$getValue("entity_reach");
    public static final RegistryObject<class_1320> STEP_HEIGHT_ADDITION = ATTRIBUTES.kilt$getValue("step_height_addition");
    public static final RegistryObject<Codec<NoneBiomeModifier>> NONE_BIOME_MODIFIER_TYPE = BIOME_MODIFIER_SERIALIZERS.register("none", () -> Codec.unit((Object)NoneBiomeModifier.INSTANCE));
    public static final RegistryObject<Codec<ForgeBiomeModifiers.AddFeaturesBiomeModifier>> ADD_FEATURES_BIOME_MODIFIER_TYPE = BIOME_MODIFIER_SERIALIZERS.register("add_features", () -> RecordCodecBuilder.create(builder -> builder.group((App)class_1959.field_26750.fieldOf("biomes").forGetter(ForgeBiomeModifiers.AddFeaturesBiomeModifier::biomes), (App)class_6796.field_35731.fieldOf("features").forGetter(ForgeBiomeModifiers.AddFeaturesBiomeModifier::features), (App)class_2893.class_2895.field_37680.fieldOf("step").forGetter(ForgeBiomeModifiers.AddFeaturesBiomeModifier::step)).apply((Applicative)builder, ForgeBiomeModifiers.AddFeaturesBiomeModifier::new)));
    public static final RegistryObject<Codec<ForgeBiomeModifiers.RemoveFeaturesBiomeModifier>> REMOVE_FEATURES_BIOME_MODIFIER_TYPE = BIOME_MODIFIER_SERIALIZERS.register("remove_features", () -> RecordCodecBuilder.create(builder -> builder.group((App)class_1959.field_26750.fieldOf("biomes").forGetter(ForgeBiomeModifiers.RemoveFeaturesBiomeModifier::biomes), (App)class_6796.field_35731.fieldOf("features").forGetter(ForgeBiomeModifiers.RemoveFeaturesBiomeModifier::features), (App)new class_5699.class_6495(class_2893.class_2895.field_37680.listOf(), class_2893.class_2895.field_37680).xmap(either -> (Set)either.map(Set::copyOf, Set::of), set -> set.size() == 1 ? Either.right((Object)((class_2893.class_2895[])set.toArray(class_2893.class_2895[]::new))[0]) : Either.left(List.copyOf(set))).optionalFieldOf("steps", EnumSet.allOf(class_2893.class_2895.class)).forGetter(ForgeBiomeModifiers.RemoveFeaturesBiomeModifier::steps)).apply((Applicative)builder, ForgeBiomeModifiers.RemoveFeaturesBiomeModifier::new)));
    public static final RegistryObject<Codec<ForgeBiomeModifiers.AddSpawnsBiomeModifier>> ADD_SPAWNS_BIOME_MODIFIER_TYPE = BIOME_MODIFIER_SERIALIZERS.register("add_spawns", () -> RecordCodecBuilder.create(builder -> builder.group((App)class_1959.field_26750.fieldOf("biomes").forGetter(ForgeBiomeModifiers.AddSpawnsBiomeModifier::biomes), (App)new class_5699.class_6495(class_5483.class_1964.field_24681.listOf(), class_5483.class_1964.field_24681).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((class_5483.class_1964)list.get(0))) : Either.left((Object)list)).fieldOf("spawners").forGetter(ForgeBiomeModifiers.AddSpawnsBiomeModifier::spawners)).apply((Applicative)builder, ForgeBiomeModifiers.AddSpawnsBiomeModifier::new)));
    public static final RegistryObject<Codec<ForgeBiomeModifiers.RemoveSpawnsBiomeModifier>> REMOVE_SPAWNS_BIOME_MODIFIER_TYPE = BIOME_MODIFIER_SERIALIZERS.register("remove_spawns", () -> RecordCodecBuilder.create(builder -> builder.group((App)class_1959.field_26750.fieldOf("biomes").forGetter(ForgeBiomeModifiers.RemoveSpawnsBiomeModifier::biomes), (App)class_6895.method_40340(ForgeRegistries.Keys.ENTITY_TYPES).fieldOf("entity_types").forGetter(ForgeBiomeModifiers.RemoveSpawnsBiomeModifier::entityTypes)).apply((Applicative)builder, ForgeBiomeModifiers.RemoveSpawnsBiomeModifier::new)));
    public static final RegistryObject<Codec<NoneStructureModifier>> NONE_STRUCTURE_MODIFIER_TYPE = STRUCTURE_MODIFIER_SERIALIZERS.register("none", () -> Codec.unit((Object)NoneStructureModifier.INSTANCE));
    public static final RegistryObject<HolderSetType> ANY_HOLDER_SET = HOLDER_SET_TYPES.register("any", () -> AnyHolderSet::codec);
    public static final RegistryObject<HolderSetType> AND_HOLDER_SET = HOLDER_SET_TYPES.register("and", () -> AndHolderSet::codec);
    public static final RegistryObject<HolderSetType> OR_HOLDER_SET = HOLDER_SET_TYPES.register("or", () -> OrHolderSet::codec);
    public static final RegistryObject<HolderSetType> NOT_HOLDER_SET = HOLDER_SET_TYPES.register("not", () -> NotHolderSet::codec);
    private static final DeferredRegister<FluidType> VANILLA_FLUID_TYPES = DeferredRegister.create(ForgeRegistries.Keys.FLUID_TYPES, "minecraft");
    public static final RegistryObject<FluidType> EMPTY_TYPE = VANILLA_FLUID_TYPES.register("empty", () -> new FluidType(FluidType.Properties.create().descriptionId("block.minecraft.air").motionScale(1.0).canPushEntity(false).canSwim(false).canDrown(false).fallDistanceModifier(1.0f).pathType(null).adjacentPathType(null).density(0).temperature(0).viscosity(0)){

        public void setItemMovement(class_1542 entity) {
            if (!entity.method_5740()) {
                entity.method_18799(entity.method_18798().method_1031(0.0, -0.04, 0.0));
            }
        }
    });
    public static final RegistryObject<FluidType> WATER_TYPE = VANILLA_FLUID_TYPES.register("water", () -> new FluidType(FluidType.Properties.create().descriptionId("block.minecraft.water").fallDistanceModifier(0.0f).canExtinguish(true).canConvertToSource(true).supportsBoating(true).sound(SoundActions.BUCKET_FILL, class_3417.field_15126).sound(SoundActions.BUCKET_EMPTY, class_3417.field_14834).sound(SoundActions.FLUID_VAPORIZE, class_3417.field_15102).canHydrate(true)){

        @Nullable
        public class_7 getBlockPathType(class_3610 state, class_1922 level, class_2338 pos, @Nullable class_1308 mob, boolean canFluidLog) {
            return canFluidLog ? super.getBlockPathType(state, level, pos, mob, true) : null;
        }

        @Override
        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final class_2960 UNDERWATER_LOCATION = new class_2960("textures/misc/underwater.png");
                private static final class_2960 WATER_STILL = new class_2960("block/water_still");
                private static final class_2960 WATER_FLOW = new class_2960("block/water_flow");
                private static final class_2960 WATER_OVERLAY = new class_2960("block/water_overlay");

                @Override
                public class_2960 getStillTexture() {
                    return WATER_STILL;
                }

                @Override
                public class_2960 getFlowingTexture() {
                    return WATER_FLOW;
                }

                @Override
                @Nullable
                public class_2960 getOverlayTexture() {
                    return WATER_OVERLAY;
                }

                @Override
                public class_2960 getRenderOverlayTexture(class_310 mc) {
                    return UNDERWATER_LOCATION;
                }

                @Override
                public int getTintColor() {
                    return -12618012;
                }

                @Override
                public int getTintColor(class_3610 state, class_1920 getter, class_2338 pos) {
                    return class_1163.method_4961((class_1920)getter, (class_2338)pos) | 0xFF000000;
                }
            });
        }
    });
    public static final RegistryObject<FluidType> LAVA_TYPE = VANILLA_FLUID_TYPES.register("lava", () -> new FluidType(FluidType.Properties.create().descriptionId("block.minecraft.lava").canSwim(false).canDrown(false).pathType(class_7.field_14).adjacentPathType(null).sound(SoundActions.BUCKET_FILL, class_3417.field_15202).sound(SoundActions.BUCKET_EMPTY, class_3417.field_15010).lightLevel(15).density(3000).viscosity(6000).temperature(1300)){

        public double motionScale(class_1297 entity) {
            return entity.method_37908().method_8597().comp_644() ? 0.007 : 0.0023333333333333335;
        }

        public void setItemMovement(class_1542 entity) {
            class_243 vec3 = entity.method_18798();
            entity.method_18800(vec3.field_1352 * (double)0.95f, vec3.field_1351 + (double)(vec3.field_1351 < (double)0.06f ? 5.0E-4f : 0.0f), vec3.field_1350 * (double)0.95f);
        }

        @Override
        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final class_2960 LAVA_STILL = new class_2960("block/lava_still");
                private static final class_2960 LAVA_FLOW = new class_2960("block/lava_flow");

                @Override
                public class_2960 getStillTexture() {
                    return LAVA_STILL;
                }

                @Override
                public class_2960 getFlowingTexture() {
                    return LAVA_FLOW;
                }
            });
        }
    });
    private static boolean enableMilkFluid = false;
    public static final RegistryObject<class_3414> BUCKET_EMPTY_MILK = RegistryObject.create(new class_2960("item.bucket.empty_milk"), ForgeRegistries.SOUND_EVENTS);
    public static final RegistryObject<class_3414> BUCKET_FILL_MILK = RegistryObject.create(new class_2960("item.bucket.fill_milk"), ForgeRegistries.SOUND_EVENTS);
    public static final RegistryObject<FluidType> MILK_TYPE = RegistryObject.createOptional(new class_2960("milk"), ForgeRegistries.Keys.FLUID_TYPES.method_29177(), "minecraft");
    public static final RegistryObject<class_3611> MILK = RegistryObject.create(new class_2960("milk"), ForgeRegistries.FLUIDS);
    public static final RegistryObject<class_3611> FLOWING_MILK = RegistryObject.create(new class_2960("flowing_milk"), ForgeRegistries.FLUIDS);
    private static ForgeMod INSTANCE;
    public static final PermissionNode<Boolean> USE_SELECTORS_PERMISSION;

    public static ForgeMod getInstance() {
        return INSTANCE;
    }

    public static void enableMilkFluid() {
        enableMilkFluid = true;
    }

    public ForgeMod(FMLJavaModLoadingContext context) {
        LOGGER.info(FORGEMOD, "Forge mod loading, version {}, for MC {} with MCP {}", (Object)ForgeVersion.getVersion(), (Object)MCPVersion.getMCVersion(), (Object)MCPVersion.getMCPVersion());
        INSTANCE = this;
        MinecraftForge.initialize();
        CrashReportCallables.registerCrashCallable("Crash Report UUID", () -> {
            UUID uuid = UUID.randomUUID();
            LOGGER.fatal("Preparing crash report with UUID {}", (Object)uuid);
            return uuid.toString();
        });
        CrashReportCallables.registerCrashCallable("FML", ForgeVersion::getSpec);
        CrashReportCallables.registerCrashCallable("Forge", () -> ForgeVersion.getGroup() + ":" + ForgeVersion.getVersion());
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(event -> {
            event.dataPackRegistry(ForgeRegistries.Keys.BIOME_MODIFIERS, BiomeModifier.DIRECT_CODEC.orElse(error -> LOGGER.error("[Kilt] Failed to load biome modifier, falling back to empty biome modifier. Error: {}", error), (Object)NoneBiomeModifier.INSTANCE));
            event.dataPackRegistry(ForgeRegistries.Keys.STRUCTURE_MODIFIERS, StructureModifier.DIRECT_CODEC.orElse(error -> LOGGER.error("[Kilt] Failed to load structure modifier, falling back to empty structure modifier. Error: {}", error), (Object)NoneStructureModifier.INSTANCE));
        });
        modEventBus.addListener(this::preInit);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::loadComplete);
        modEventBus.addListener(this::registerFluids);
        modEventBus.addListener(this::registerVanillaDisplayContexts);
        modEventBus.addListener(this::registerRecipeSerializers);
        modEventBus.addListener(this::registerLootData);
        modEventBus.register((Object)this);
        ATTRIBUTES.register(modEventBus);
        COMMAND_ARGUMENT_TYPES.register(modEventBus);
        BIOME_MODIFIER_SERIALIZERS.register(modEventBus);
        STRUCTURE_MODIFIER_SERIALIZERS.register(modEventBus);
        HOLDER_SET_TYPES.register(modEventBus);
        VANILLA_FLUID_TYPES.register(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopping);
        MinecraftForge.EVENT_BUS.addListener(this::missingSoundMapping);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec<?>)ForgeConfig.clientSpec);
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec<?>)ForgeConfig.serverSpec);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec<?>)ForgeConfig.commonSpec);
        modEventBus.register(ForgeConfig.class);
        ForgeDeferredRegistriesSetup.setup(modEventBus);
        context.registerDisplayTest(IExtensionPoint.DisplayTest.IGNORE_ALL_VERSION);
        StartupMessageManager.addModMessage("Forge version " + ForgeVersion.getVersion());
        MinecraftForge.EVENT_BUS.addListener(VillagerTradingManager::loadTrades);
        MinecraftForge.EVENT_BUS.register((Object)MinecraftForge.INTERNAL_HANDLER);
        MinecraftForge.EVENT_BUS.addListener(this::mappingChanged);
        MinecraftForge.EVENT_BUS.addListener(this::registerPermissionNodes);
        ForgeRegistries.ITEMS.tags().addOptionalTagDefaults(Tags.Items.ENCHANTING_FUELS, Set.of(ForgeRegistries.ITEMS.getDelegateOrThrow(class_1802.field_8759)));
        ForgeMod.addAlias(ForgeRegistries.ATTRIBUTES, new class_2960("forge", "reach_distance"), new class_2960("forge", "block_reach"));
        ForgeMod.addAlias(ForgeRegistries.ATTRIBUTES, new class_2960("forge", "attack_range"), new class_2960("forge", "entity_reach"));
        ((ForgeRegistry)ForgeRegistries.ATTRIBUTES).addAlias(new class_2960("forge", "block_reach"), new class_2960("reach-entity-attributes", "reach"));
        ((ForgeRegistry)ForgeRegistries.ATTRIBUTES).addAlias(new class_2960("forge", "entity_reach"), new class_2960("reach-entity-attributes", "attack_range"));
        ((ForgeRegistry)ForgeRegistries.ATTRIBUTES).addAlias(new class_2960("forge", "step_height"), new class_2960("porting_lib", "step_height_addition"));
        ((ForgeRegistry)ForgeRegistries.ATTRIBUTES).addAlias(new class_2960("forge", "step_height_addition"), new class_2960("porting_lib", "step_height_addition"));
        ((ForgeRegistry)ForgeRegistries.ATTRIBUTES).addAlias(new class_2960("forge", "entity_gravity"), new class_2960("porting_lib", "entity_gravity"));
        ((ForgeRegistry)ForgeRegistries.ATTRIBUTES).addAlias(new class_2960("forge", "swim_speed"), new class_2960("porting_lib", "swim_speed"));
    }

    public void preInit(FMLCommonSetupEvent evt) {
        VanillaPacketSplitter.register();
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
    }

    public void serverStopping(ServerStoppingEvent evt) {
        WorldWorkerManager.clear();
    }

    public void mappingChanged(IdMappingEvent evt) {
        IngredientInjection.invalidateAll();
    }

    public void gatherData(GatherDataEvent event) {
        class_2403 gen = event.getGenerator();
        class_7784 packOutput = gen.getPackOutput();
        CompletableFuture<class_7225.class_7874> lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        gen.addProvider(true, new class_7796(packOutput).method_46185(class_3272.field_14202, (Object)PackMetadataSectionInjection.create((class_2561)class_2561.method_43471((String)"pack.forge.description"), class_3797.field_25319.method_48017(class_3264.field_14188), Arrays.stream(class_3264.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((class_6489)class_3797.field_25319).method_48017(arg_0))))));
        ForgeBlockTagsProvider blockTags = new ForgeBlockTagsProvider(packOutput, lookupProvider, existingFileHelper);
        gen.addProvider(event.includeServer(), blockTags);
        gen.addProvider(event.includeServer(), new ForgeItemTagsProvider(packOutput, lookupProvider, blockTags.method_49662(), existingFileHelper));
        gen.addProvider(event.includeServer(), new ForgeEntityTypeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeServer(), new ForgeFluidTagsProvider(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeServer(), new ForgeRecipeProvider(packOutput));
        gen.addProvider(event.includeServer(), new ForgeLootTableProvider(packOutput));
        gen.addProvider(event.includeServer(), new ForgeBiomeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeClient(), new ForgeSpriteSourceProvider(packOutput, existingFileHelper));
        gen.addProvider(event.includeClient(), new VanillaSoundDefinitionsProvider(packOutput, existingFileHelper));
    }

    public void missingSoundMapping(MissingMappingsEvent event) {
        if (event.getKey() != ForgeRegistries.Keys.SOUND_EVENTS) {
            return;
        }
        List<String> removedSounds = Arrays.asList("entity.parrot.imitate.panda", "entity.parrot.imitate.zombie_pigman", "entity.parrot.imitate.enderman", "entity.parrot.imitate.polar_bear", "entity.parrot.imitate.wolf");
        for (MissingMappingsEvent.Mapping<class_3414> mapping : event.getAllMappings(ForgeRegistries.Keys.SOUND_EVENTS)) {
            class_2960 regName = mapping.getKey();
            if (regName == null || !regName.method_12836().equals("minecraft")) continue;
            String path = regName.method_12832();
            if (!removedSounds.stream().anyMatch(s -> s.equals(path))) continue;
            LOGGER.info("Ignoring removed minecraft sound {}", (Object)regName);
            mapping.ignore();
        }
    }

    public void registerFluids(RegisterEvent event) {
        if (enableMilkFluid) {
            event.register(ForgeRegistries.Keys.SOUND_EVENTS, helper -> {
                helper.register(BUCKET_EMPTY_MILK.getId(), class_3414.method_47908((class_2960)BUCKET_EMPTY_MILK.getId()));
                helper.register(BUCKET_FILL_MILK.getId(), class_3414.method_47908((class_2960)BUCKET_FILL_MILK.getId()));
            });
            event.register(ForgeRegistries.Keys.FLUID_TYPES, helper -> helper.register(MILK_TYPE.getId(), new FluidType(FluidType.Properties.create().density(1024).viscosity(1024).sound(SoundActions.BUCKET_FILL, BUCKET_FILL_MILK.get()).sound(SoundActions.BUCKET_EMPTY, BUCKET_EMPTY_MILK.get())){

                @Override
                public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                    consumer.accept(new IClientFluidTypeExtensions(){
                        private static final class_2960 MILK_STILL = new class_2960("forge", "block/milk_still");
                        private static final class_2960 MILK_FLOW = new class_2960("forge", "block/milk_flowing");

                        @Override
                        public class_2960 getStillTexture() {
                            return MILK_STILL;
                        }

                        @Override
                        public class_2960 getFlowingTexture() {
                            return MILK_FLOW;
                        }
                    });
                }
            }));
            event.register(ForgeRegistries.Keys.FLUIDS, helper -> {
                ForgeFlowingFluid.Properties properties = new ForgeFlowingFluid.Properties(MILK_TYPE, MILK, FLOWING_MILK).bucket(() -> class_1802.field_8103);
                helper.register(MILK.getId(), new ForgeFlowingFluid.Source(properties));
                helper.register(FLOWING_MILK.getId(), new ForgeFlowingFluid.Flowing(properties));
            });
        }
    }

    public void registerVanillaDisplayContexts(RegisterEvent event) {
        if (event.getRegistryKey().equals(ForgeRegistries.Keys.DISPLAY_CONTEXTS)) {
            IForgeRegistryInternal forgeRegistry = (IForgeRegistryInternal)event.getForgeRegistry();
            if (forgeRegistry == null) {
                throw new IllegalStateException("Item display context was not a forge registry, wtf???");
            }
            Arrays.stream(class_811.values()).filter(Predicate.not(ctx -> ((ItemDisplayContextInjection)ctx).isModded())).forEach(ctx -> forgeRegistry.register(ctx.method_48961(), new class_2960("minecraft", ctx.method_15434()), ctx));
        }
    }

    public void registerRecipeSerializers(RegisterEvent event) {
        if (event.getRegistryKey().equals(ForgeRegistries.Keys.RECIPE_SERIALIZERS)) {
            CraftingHelper.register(AndCondition.Serializer.INSTANCE);
            CraftingHelper.register(FalseCondition.Serializer.INSTANCE);
            CraftingHelper.register(ItemExistsCondition.Serializer.INSTANCE);
            CraftingHelper.register(ModLoadedCondition.Serializer.INSTANCE);
            CraftingHelper.register(NotCondition.Serializer.INSTANCE);
            CraftingHelper.register(OrCondition.Serializer.INSTANCE);
            CraftingHelper.register(TrueCondition.Serializer.INSTANCE);
            CraftingHelper.register(TagEmptyCondition.Serializer.INSTANCE);
            CraftingHelper.register(new class_2960("forge", "compound"), CompoundIngredient.Serializer.INSTANCE);
            CraftingHelper.register(new class_2960("forge", "nbt"), StrictNBTIngredient.Serializer.INSTANCE);
            CraftingHelper.register(new class_2960("forge", "partial_nbt"), PartialNBTIngredient.Serializer.INSTANCE);
            CraftingHelper.register(new class_2960("forge", "difference"), DifferenceIngredient.Serializer.INSTANCE);
            CraftingHelper.register(new class_2960("forge", "intersection"), IntersectionIngredient.Serializer.INSTANCE);
            CraftingHelper.register(new class_2960("minecraft", "item"), VanillaIngredientSerializer.INSTANCE);
            event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, new class_2960("forge", "conditional"), ConditionalRecipe.Serializer::new);
        }
    }

    public void registerLootData(RegisterEvent event) {
        if (!event.getRegistryKey().equals((Object)class_7924.field_41198)) {
            return;
        }
        event.register(class_7924.field_41198, new class_2960("forge:loot_table_id"), () -> LootTableIdCondition.LOOT_TABLE_ID);
        event.register(class_7924.field_41198, new class_2960("forge:can_tool_perform_action"), () -> CanToolPerformAction.LOOT_CONDITION_TYPE);
    }

    public void registerPermissionNodes(PermissionGatherEvent.Nodes event) {
        event.addNodes(USE_SELECTORS_PERMISSION);
    }

    @Deprecated(forRemoval=true, since="1.20")
    private static <T> void addAlias(IForgeRegistry<T> registry, class_2960 from, class_2960 to) {
        ForgeRegistry fReg = (ForgeRegistry)registry;
        fReg.addAlias(from, to);
    }

    static {
        USE_SELECTORS_PERMISSION = new PermissionNode<Boolean>("forge", "use_entity_selectors", PermissionTypes.BOOLEAN, (player, uuid, contexts) -> player != null && player.method_5687(2), new PermissionDynamicContextKey[0]);
    }
}

