/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3481;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_6862;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.toposort.TopologicalSort;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TierSortingRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_2960 ITEM_TIER_ORDERING_JSON = new class_2960("forge", "item_tier_ordering.json");
    private static boolean hasCustomTiers = false;
    private static final BiMap<class_2960, class_1832> tiers = HashBiMap.create();
    private static final Multimap<class_2960, class_2960> edges = HashMultimap.create();
    private static final Multimap<class_2960, class_2960> vanillaEdges = HashMultimap.create();
    private static final List<class_1832> sortedTiers;
    private static final List<class_1832> sortedTiersUnmodifiable;
    private static final class_2960 CHANNEL_NAME;
    private static final String PROTOCOL_VERSION = "1.0";
    private static final SimpleChannel SYNC_CHANNEL;

    public static synchronized class_1832 registerTier(class_1832 tier, class_2960 name, List<Object> after, List<Object> before) {
        if (tiers.containsKey((Object)name)) {
            throw new IllegalStateException("Duplicate tier name " + String.valueOf(name));
        }
        TierSortingRegistry.processTier(tier, name, after, before);
        hasCustomTiers = true;
        return tier;
    }

    public static List<class_1832> getSortedTiers() {
        return sortedTiersUnmodifiable;
    }

    @Nullable
    public static class_1832 byName(class_2960 name) {
        return (class_1832)tiers.get((Object)name);
    }

    @Nullable
    public static class_2960 getName(class_1832 tier) {
        return (class_2960)tiers.inverse().get((Object)tier);
    }

    public static boolean isTierSorted(class_1832 tier) {
        return TierSortingRegistry.getName(tier) != null;
    }

    public static boolean isCorrectTierForDrops(class_1832 tier, class_2680 state) {
        if (!TierSortingRegistry.isTierSorted(tier)) {
            return TierSortingRegistry.isCorrectTierVanilla(tier, state);
        }
        for (int x = sortedTiers.indexOf(tier) + 1; x < sortedTiers.size(); ++x) {
            class_6862 tag = sortedTiers.get(x).getTag();
            if (tag == null || !state.method_26164(tag)) continue;
            return false;
        }
        return true;
    }

    public static List<class_1832> getTiersLowerThan(class_1832 tier) {
        if (!TierSortingRegistry.isTierSorted(tier)) {
            return List.of();
        }
        return sortedTiers.stream().takeWhile(t -> t != tier).toList();
    }

    private static boolean isCorrectTierVanilla(class_1832 tier, class_2680 state) {
        int i = tier.method_8024();
        if (i < 3 && state.method_26164(class_3481.field_33717)) {
            return false;
        }
        if (i < 2 && state.method_26164(class_3481.field_33718)) {
            return false;
        }
        return i >= 1 || !state.method_26164(class_3481.field_33719);
    }

    private static void processTier(class_1832 tier, class_2960 name, List<Object> afters, List<Object> befores) {
        class_2960 other;
        tiers.put((Object)name, (Object)tier);
        for (Object after : afters) {
            other = TierSortingRegistry.getTierName(after);
            edges.put((Object)other, (Object)name);
        }
        for (Object before : befores) {
            other = TierSortingRegistry.getTierName(before);
            edges.put((Object)name, (Object)other);
        }
    }

    private static class_2960 getTierName(Object entry) {
        if (entry instanceof String) {
            String s = (String)entry;
            return new class_2960(s);
        }
        if (entry instanceof class_2960) {
            class_2960 rl = (class_2960)entry;
            return rl;
        }
        if (entry instanceof class_1832) {
            class_1832 t = (class_1832)entry;
            return Objects.requireNonNull(TierSortingRegistry.getName(t), "Can't have sorting dependencies for tiers not registered in the TierSortingRegistry");
        }
        throw new IllegalStateException("Invalid object type passed into the tier dependencies " + String.valueOf(entry.getClass()));
    }

    static boolean allowVanilla() {
        return !hasCustomTiers;
    }

    static void init() {
        SYNC_CHANNEL.registerMessage(0, SyncPacket.class, SyncPacket::encode, TierSortingRegistry::receive, TierSortingRegistry::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MinecraftForge.EVENT_BUS.addListener(TierSortingRegistry::playerLoggedIn);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEvents.init();
        }
    }

    static class_3302 getReloadListener() {
        return new class_4080<JsonObject>(){
            final Gson gson = new GsonBuilder().create();

            @NotNull
            protected JsonObject prepare(@NotNull class_3300 resourceManager, class_3695 p) {
                JsonObject jsonObject;
                block9: {
                    Optional res = resourceManager.method_14486(ITEM_TIER_ORDERING_JSON);
                    if (res.isEmpty()) {
                        return new JsonObject();
                    }
                    BufferedReader reader = ((class_3298)res.get()).method_43039();
                    try {
                        jsonObject = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
                        if (reader == null) break block9;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (reader != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                            }
                            throw throwable2;
                        }
                        catch (IOException e) {
                            LOGGER.error("Could not read Tier sorting file " + String.valueOf(ITEM_TIER_ORDERING_JSON), (Throwable)e);
                            return new JsonObject();
                        }
                    }
                    ((Reader)reader).close();
                }
                return jsonObject;
            }

            protected void apply(@NotNull JsonObject data, @NotNull class_3300 resourceManager, class_3695 p) {
                try {
                    if (data.size() > 0) {
                        JsonArray order = class_3518.method_15261((JsonObject)data, (String)"order");
                        ArrayList<class_1832> customOrder = new ArrayList<class_1832>();
                        for (JsonElement entry : order) {
                            class_2960 id = new class_2960(entry.getAsString());
                            class_1832 tier2 = TierSortingRegistry.byName(id);
                            if (tier2 == null) {
                                throw new IllegalStateException("Tier not found with name " + String.valueOf(id));
                            }
                            customOrder.add(tier2);
                        }
                        List<class_1832> missingTiers = tiers.values().stream().filter(tier -> !customOrder.contains(tier)).toList();
                        if (missingTiers.size() > 0) {
                            throw new IllegalStateException("Tiers missing from the ordered list: " + missingTiers.stream().map(tier -> Objects.toString(TierSortingRegistry.getName(tier))).collect(Collectors.joining(", ")));
                        }
                        TierSortingRegistry.setTierOrder(customOrder);
                        return;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error parsing Tier sorting file " + String.valueOf(ITEM_TIER_ORDERING_JSON), (Throwable)e);
                }
                TierSortingRegistry.recalculateItemTiers();
            }
        };
    }

    private static void recalculateItemTiers() {
        MutableGraph graph = GraphBuilder.directed().nodeOrder(ElementOrder.insertion()).build();
        for (class_1832 tier : tiers.values()) {
            graph.addNode((Object)tier);
        }
        edges.forEach((key, value) -> {
            if (tiers.containsKey(key) && tiers.containsKey(value)) {
                graph.putEdge((Object)((class_1832)tiers.get(key)), (Object)((class_1832)tiers.get(value)));
            }
        });
        List<class_1832> tierList = TopologicalSort.topologicalSort(graph, null);
        TierSortingRegistry.setTierOrder(tierList);
    }

    private static void setTierOrder(List<class_1832> tierList) {
        TierSortingRegistry.runInServerThreadIfPossible(hasServer -> {
            sortedTiers.clear();
            sortedTiers.addAll(tierList);
            if (hasServer) {
                TierSortingRegistry.syncToAll();
            }
        });
    }

    private static void runInServerThreadIfPossible(BooleanConsumer runnable) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.execute(() -> runnable.accept(true));
        } else {
            runnable.accept(false);
        }
    }

    private static void syncToAll() {
        for (class_3222 serverPlayer : ServerLifecycleHooks.getCurrentServer().method_3760().method_14571()) {
            TierSortingRegistry.syncToPlayer(serverPlayer);
        }
    }

    private static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        class_1657 class_16572 = event.getEntity();
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            TierSortingRegistry.syncToPlayer(serverPlayer);
        }
    }

    private static void syncToPlayer(class_3222 serverPlayer) {
        if (SYNC_CHANNEL.isRemotePresent(serverPlayer.field_13987.field_14127) && !serverPlayer.field_13987.field_14127.method_10756()) {
            SYNC_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), new SyncPacket(sortedTiers.stream().map(TierSortingRegistry::getName).toList()));
        }
    }

    private static SyncPacket receive(class_2540 buffer) {
        int count = buffer.method_10816();
        ArrayList<class_2960> list = new ArrayList<class_2960>();
        for (int i = 0; i < count; ++i) {
            list.add(buffer.method_10810());
        }
        return new SyncPacket(list);
    }

    private static void handle(SyncPacket packet, Supplier<NetworkEvent.Context> context) {
        TierSortingRegistry.setTierOrder(packet.tiers.stream().map(TierSortingRegistry::byName).toList());
        context.get().setPacketHandled(true);
    }

    static {
        class_2960 wood = new class_2960("wood");
        class_2960 stone = new class_2960("stone");
        class_2960 iron = new class_2960("iron");
        class_2960 diamond = new class_2960("diamond");
        class_2960 netherite = new class_2960("netherite");
        class_2960 gold = new class_2960("gold");
        TierSortingRegistry.processTier((class_1832)class_1834.field_8922, wood, List.of(), List.of());
        TierSortingRegistry.processTier((class_1832)class_1834.field_8929, gold, List.of(wood), List.of(stone));
        TierSortingRegistry.processTier((class_1832)class_1834.field_8927, stone, List.of(wood), List.of(iron));
        TierSortingRegistry.processTier((class_1832)class_1834.field_8923, iron, List.of(stone), List.of(diamond));
        TierSortingRegistry.processTier((class_1832)class_1834.field_8930, diamond, List.of(iron), List.of(netherite));
        TierSortingRegistry.processTier((class_1832)class_1834.field_22033, netherite, List.of(diamond), List.of());
        vanillaEdges.putAll(edges);
        sortedTiers = new ArrayList<class_1832>();
        sortedTiersUnmodifiable = Collections.unmodifiableList(sortedTiers);
        CHANNEL_NAME = new class_2960("forge:tier_sorting");
        SYNC_CHANNEL = NetworkRegistry.newSimpleChannel(CHANNEL_NAME, () -> PROTOCOL_VERSION, versionFromServer -> PROTOCOL_VERSION.equals(versionFromServer) || TierSortingRegistry.allowVanilla() && NetworkRegistry.ACCEPTVANILLA.equals(versionFromServer), versionFromClient -> PROTOCOL_VERSION.equals(versionFromClient) || TierSortingRegistry.allowVanilla() && NetworkRegistry.ACCEPTVANILLA.equals(versionFromClient));
    }

    private record SyncPacket(List<class_2960> tiers) {
        private void encode(class_2540 buffer) {
            buffer.method_10804(this.tiers.size());
            for (class_2960 loc : this.tiers) {
                buffer.method_10812(loc);
            }
        }
    }

    private static class ClientEvents {
        private ClientEvents() {
        }

        public static void init() {
            MinecraftForge.EVENT_BUS.addListener(ClientEvents::clientLogInToServer);
        }

        private static void clientLogInToServer(ClientPlayerNetworkEvent.LoggingIn event) {
            if (event.getConnection() == null || !event.getConnection().method_10756()) {
                TierSortingRegistry.recalculateItemTiers();
            }
        }
    }
}

