/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.capabilities;

import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_6328;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilityProviderImpl;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import xyz.bluspring.kilt.workarounds.CapabilityInvalidationWorkaround;
import xyz.bluspring.kilt.workarounds.CapabilityProviderWorkaround;

@class_6328
@ParametersAreNonnullByDefault
public abstract class CapabilityProvider<B extends ICapabilityProviderImpl<B>>
implements ICapabilityProviderImpl<B>,
CapabilityInvalidationWorkaround {
    @VisibleForTesting
    static boolean SUPPORTS_LAZY_CAPABILITIES = true;
    @NotNull
    private final Class<B> baseClass;
    @Nullable
    private CapabilityDispatcher capabilities;
    private boolean valid = true;
    private boolean isLazy = false;
    private Supplier<ICapabilityProvider> lazyParentSupplier = null;
    private class_2487 lazyData = null;
    private boolean initialized = false;
    private CapabilityProviderWorkaround<B> kilt$deferred;

    protected CapabilityProvider() {
        Class<?> currentClass;
        Class<?> classBeforeThisOne = this.getClass();
        while ((currentClass = classBeforeThisOne.getSuperclass()) != CapabilityProvider.class) {
            classBeforeThisOne = currentClass;
        }
        this.baseClass = classBeforeThisOne;
        this.isLazy = false;
        this.kilt$deferred = new CapabilityProviderWorkaround<CapabilityProvider>(this.baseClass, this.isLazy, this);
    }

    protected CapabilityProvider(Class<B> baseClass) {
        this(baseClass, false);
    }

    protected CapabilityProvider(Class<B> baseClass, boolean isLazy) {
        this.baseClass = baseClass;
        this.isLazy = SUPPORTS_LAZY_CAPABILITIES && isLazy;
    }

    @Override
    public void kilt$setLazy(boolean isLazy) {
        this.isLazy = isLazy;
    }

    protected final void gatherCapabilities() {
        if (this.kilt$deferred != null) {
            this.kilt$deferred.gatherCapabilities();
            return;
        }
        this.gatherCapabilities(() -> null);
    }

    protected final void gatherCapabilities(@Nullable ICapabilityProvider parent) {
        if (this.kilt$deferred != null) {
            this.kilt$deferred.gatherCapabilities(parent);
            return;
        }
        this.gatherCapabilities(() -> parent);
    }

    protected final void gatherCapabilities(@Nullable Supplier<ICapabilityProvider> parent) {
        if (this.kilt$deferred != null) {
            this.kilt$deferred.gatherCapabilities(parent);
            return;
        }
        if (this.isLazy && !this.initialized) {
            this.lazyParentSupplier = parent == null ? () -> null : parent;
            return;
        }
        this.doGatherCapabilities(parent == null ? null : parent.get());
    }

    private void doGatherCapabilities(@Nullable ICapabilityProvider parent) {
        this.capabilities = ForgeEventFactory.gatherCapabilities(this.baseClass, this.getProvider(), parent);
        this.initialized = true;
    }

    @NotNull
    public B getProvider() {
        if (this.kilt$deferred != null) {
            return this.kilt$deferred.getProvider();
        }
        return (B)this;
    }

    @Nullable
    public final CapabilityDispatcher getCapabilities() {
        if (this.kilt$deferred != null) {
            return this.kilt$deferred.getCapabilities();
        }
        if (this.isLazy && !this.initialized) {
            this.doGatherCapabilities(this.lazyParentSupplier == null ? null : this.lazyParentSupplier.get());
            if (this.lazyData != null) {
                this.deserializeCaps(this.lazyData);
            }
        }
        return this.capabilities;
    }

    @Override
    public final boolean areCapsCompatible(CapabilityProvider<B> other) {
        if (this.kilt$deferred != null) {
            return this.kilt$deferred.areCapsCompatible(other);
        }
        return this.areCapsCompatible(other.getCapabilities());
    }

    @Override
    public final boolean areCapsCompatible(@Nullable CapabilityDispatcher other) {
        if (this.kilt$deferred != null) {
            return this.kilt$deferred.areCapsCompatible(other);
        }
        CapabilityDispatcher disp = this.getCapabilities();
        if (disp == null) {
            if (other == null) {
                return true;
            }
            return other.areCompatible(null);
        }
        return disp.areCompatible(other);
    }

    @Nullable
    protected final class_2487 serializeCaps() {
        if (this.kilt$deferred != null) {
            return this.kilt$deferred.serializeCaps();
        }
        if (this.isLazy && !this.initialized) {
            return this.lazyData;
        }
        CapabilityDispatcher disp = this.getCapabilities();
        if (disp != null) {
            return disp.serializeNBT();
        }
        return null;
    }

    protected final void deserializeCaps(class_2487 tag) {
        if (this.kilt$deferred != null) {
            this.kilt$deferred.deserializeCaps(tag);
            return;
        }
        if (this.isLazy && !this.initialized) {
            this.lazyData = tag;
            return;
        }
        CapabilityDispatcher disp = this.getCapabilities();
        if (disp != null) {
            disp.deserializeNBT(tag);
        }
    }

    @Override
    public void kilt$invalidateCaps() {
        if (this.kilt$deferred != null) {
            this.kilt$deferred.kilt$invalidateCaps();
            return;
        }
        this.valid = false;
        CapabilityDispatcher disp = this.getCapabilities();
        if (disp != null) {
            disp.invalidate();
        }
    }

    @Override
    public void invalidateCaps() {
        this.kilt$invalidateCaps();
    }

    @Override
    public void reviveCaps() {
        if (this.kilt$deferred != null) {
            this.kilt$deferred.reviveCaps();
            return;
        }
        this.valid = true;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable class_2350 side) {
        if (this.kilt$deferred != null) {
            return this.kilt$deferred.getCapability(cap, side);
        }
        CapabilityDispatcher disp = this.getCapabilities();
        return !this.valid || disp == null ? LazyOptional.empty() : disp.getCapability(cap, side);
    }

    @Override
    public CapabilityProviderWorkaround<B> kilt$getCapabilityWorkaround() {
        return this.kilt$deferred;
    }

    public static class AsField<B extends ICapabilityProviderImpl<B>>
    extends CapabilityProvider<B> {
        private final B owner;

        public AsField(Class<B> baseClass, B owner) {
            super(baseClass);
            this.owner = owner;
        }

        public AsField(Class<B> baseClass, B owner, boolean isLazy) {
            super(baseClass, isLazy);
            this.owner = owner;
        }

        public void initInternal() {
            this.gatherCapabilities();
        }

        @Nullable
        public class_2487 serializeInternal() {
            return this.serializeCaps();
        }

        public void deserializeInternal(class_2487 tag) {
            this.deserializeCaps(tag);
        }

        @Override
        @NotNull
        public B getProvider() {
            return this.owner;
        }
    }
}

