/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.class_2300;
import net.minecraft.class_2303;
import net.minecraftforge.common.command.IEntitySelectorType;

public class EntitySelectorManager {
    private static final HashMap<String, IEntitySelectorType> REGISTRY = new HashMap();

    public static void register(String token, IEntitySelectorType type) {
        if (token.isEmpty()) {
            throw new IllegalArgumentException("Token must not be empty");
        }
        if (Arrays.asList("p", "a", "r", "s", "e").contains(token)) {
            throw new IllegalArgumentException("Token clashes with vanilla @" + token);
        }
        for (char c : token.toCharArray()) {
            if (StringReader.isAllowedInUnquotedString((char)c)) continue;
            throw new IllegalArgumentException("Token must only contain allowed characters");
        }
        REGISTRY.put(token, type);
    }

    public static class_2300 parseSelector(class_2303 parser) throws CommandSyntaxException {
        if (parser.method_9835().canRead()) {
            int i = parser.method_9835().getCursor();
            String token = parser.method_9835().readUnquotedString();
            IEntitySelectorType type = REGISTRY.get(token);
            if (type != null) {
                return type.build(parser);
            }
            parser.method_9835().setCursor(i);
        }
        return null;
    }

    public static void fillSelectorSuggestions(SuggestionsBuilder suggestionBuilder) {
        REGISTRY.forEach((token, type) -> suggestionBuilder.suggest("@" + token, (Message)type.getSuggestionTooltip()));
    }
}

