/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1865;
import net.minecraft.class_2444;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ObjectHolder;
import org.jetbrains.annotations.Nullable;

public class ConditionalRecipe {
    @ObjectHolder(registryName="recipe_serializer", value="forge:conditional")
    public static final class_1865<class_1860<?>> SERIALZIER = null;

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<ICondition[]> conditions = new ArrayList<ICondition[]>();
        private List<class_2444> recipes = new ArrayList<class_2444>();
        private class_2960 advId;
        private ConditionalAdvancement.Builder adv;
        private List<ICondition> currentConditions = new ArrayList<ICondition>();

        public Builder addCondition(ICondition condition) {
            this.currentConditions.add(condition);
            return this;
        }

        public Builder addRecipe(Consumer<Consumer<class_2444>> callable) {
            callable.accept(this::addRecipe);
            return this;
        }

        public Builder addRecipe(class_2444 recipe) {
            if (this.currentConditions.isEmpty()) {
                throw new IllegalStateException("Can not add a recipe with no conditions.");
            }
            this.conditions.add(this.currentConditions.toArray(new ICondition[this.currentConditions.size()]));
            this.recipes.add(recipe);
            this.currentConditions.clear();
            return this;
        }

        public Builder generateAdvancement() {
            return this.generateAdvancement(null);
        }

        public Builder generateAdvancement(@Nullable class_2960 id) {
            ConditionalAdvancement.Builder builder = ConditionalAdvancement.builder();
            for (int i = 0; i < this.recipes.size(); ++i) {
                for (ICondition cond : this.conditions.get(i)) {
                    builder = builder.addCondition(cond);
                }
                builder = builder.addAdvancement(this.recipes.get(i));
            }
            return this.setAdvancement(id, builder);
        }

        public Builder setAdvancement(ConditionalAdvancement.Builder advancement) {
            return this.setAdvancement(null, advancement);
        }

        public Builder setAdvancement(String namespace, String path, ConditionalAdvancement.Builder advancement) {
            return this.setAdvancement(new class_2960(namespace, path), advancement);
        }

        public Builder setAdvancement(@Nullable class_2960 id, ConditionalAdvancement.Builder advancement) {
            if (this.adv != null) {
                throw new IllegalStateException("Invalid ConditionalRecipeBuilder, Advancement already set");
            }
            this.advId = id;
            this.adv = advancement;
            return this;
        }

        public void build(Consumer<class_2444> consumer, String namespace, String path) {
            this.build(consumer, new class_2960(namespace, path));
        }

        public void build(Consumer<class_2444> consumer, class_2960 id) {
            if (!this.currentConditions.isEmpty()) {
                throw new IllegalStateException("Invalid ConditionalRecipe builder, Orphaned conditions");
            }
            if (this.recipes.isEmpty()) {
                throw new IllegalStateException("Invalid ConditionalRecipe builder, No recipes");
            }
            if (this.advId == null && this.adv != null) {
                this.advId = new class_2960(id.method_12836(), "recipes/" + id.method_12832());
            }
            consumer.accept(new Finished(id, this.conditions, this.recipes, this.advId, this.adv));
        }
    }

    private static class Finished
    implements class_2444 {
        private final class_2960 id;
        private final List<ICondition[]> conditions;
        private final List<class_2444> recipes;
        private final class_2960 advId;
        private final ConditionalAdvancement.Builder adv;

        private Finished(class_2960 id, List<ICondition[]> conditions, List<class_2444> recipes, @Nullable class_2960 advId, @Nullable ConditionalAdvancement.Builder adv) {
            this.id = id;
            this.conditions = conditions;
            this.recipes = recipes;
            this.advId = advId;
            this.adv = adv;
        }

        public void method_10416(JsonObject json) {
            JsonArray array = new JsonArray();
            json.add("recipes", (JsonElement)array);
            for (int x = 0; x < this.conditions.size(); ++x) {
                JsonObject holder = new JsonObject();
                JsonArray conds = new JsonArray();
                for (ICondition c : this.conditions.get(x)) {
                    conds.add((JsonElement)CraftingHelper.serialize(c));
                }
                holder.add("conditions", (JsonElement)conds);
                holder.add("recipe", (JsonElement)this.recipes.get(x).method_17799());
                array.add((JsonElement)holder);
            }
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return SERIALZIER;
        }

        public JsonObject method_10415() {
            return this.adv == null ? null : this.adv.write();
        }

        public class_2960 method_10418() {
            return this.advId;
        }
    }

    public static class Serializer<T extends class_1860<?>>
    implements class_1865<T> {
        public T method_8121(class_2960 recipeId, JsonObject json) {
            return this.fromJson(recipeId, json, ICondition.IContext.EMPTY);
        }

        public T fromJson(class_2960 recipeId, JsonObject json, ICondition.IContext context) {
            JsonArray items = class_3518.method_15261((JsonObject)json, (String)"recipes");
            int idx = 0;
            for (JsonElement ele : items) {
                if (!ele.isJsonObject()) {
                    throw new JsonSyntaxException("Invalid recipes entry at index " + idx + " Must be JsonObject");
                }
                if (CraftingHelper.processConditions(class_3518.method_15261((JsonObject)ele.getAsJsonObject(), (String)"conditions"), context)) {
                    return (T)class_1863.method_17720((class_2960)recipeId, (JsonObject)class_3518.method_15296((JsonObject)ele.getAsJsonObject(), (String)"recipe"));
                }
                ++idx;
            }
            return null;
        }

        public T method_8122(class_2960 recipeId, class_2540 buffer) {
            return null;
        }

        public void method_8124(class_2540 buffer, T recipe) {
        }
    }
}

