/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;
import xyz.bluspring.kilt.injections.item.crafting.IngredientInjection;

public class CraftingHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker CRAFTHELPER = MarkerManager.getMarker((String)"CRAFTHELPER");
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<class_2960, IConditionSerializer<?>> conditions = new HashMap();
    private static final BiMap<class_2960, IIngredientSerializer<?>> ingredients = HashBiMap.create();

    public static IConditionSerializer<?> register(IConditionSerializer<?> serializer) {
        class_2960 key = serializer.getID();
        if (conditions.containsKey(key)) {
            throw new IllegalStateException("Duplicate recipe condition serializer: " + String.valueOf(key));
        }
        conditions.put(key, serializer);
        return serializer;
    }

    public static <T extends class_1856> IIngredientSerializer<T> register(class_2960 key, IIngredientSerializer<T> serializer) {
        if (ingredients.containsKey((Object)key)) {
            throw new IllegalStateException("Duplicate recipe ingredient serializer: " + String.valueOf(key));
        }
        if (ingredients.containsValue(serializer)) {
            throw new IllegalStateException("Duplicate recipe ingredient serializer: " + String.valueOf(key) + " " + String.valueOf(serializer));
        }
        ingredients.put((Object)key, serializer);
        return serializer;
    }

    @Nullable
    public static class_2960 getID(IIngredientSerializer<?> serializer) {
        return (class_2960)ingredients.inverse().get(serializer);
    }

    public static <T extends class_1856> void write(class_2540 buffer, T ingredient) {
        IIngredientSerializer serializer = ingredient.getSerializer();
        class_2960 key = (class_2960)ingredients.inverse().get((Object)serializer);
        if (key == null) {
            throw new IllegalArgumentException("Tried to serialize unregistered Ingredient: " + String.valueOf(ingredient) + " " + String.valueOf(serializer));
        }
        if (serializer != VanillaIngredientSerializer.INSTANCE) {
            buffer.method_10804(-1);
            buffer.method_10812(key);
        }
        serializer.write(buffer, ingredient);
    }

    public static class_1856 getIngredient(class_2960 type, class_2540 buffer) {
        IIngredientSerializer serializer = (IIngredientSerializer)ingredients.get((Object)type);
        if (serializer == null) {
            throw new IllegalArgumentException("Can not deserialize unknown Ingredient type: " + String.valueOf(type));
        }
        return serializer.parse(buffer);
    }

    public static class_1856 getIngredient(JsonElement json, boolean allowEmpty) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        if (json.isJsonArray()) {
            ArrayList ingredients = Lists.newArrayList();
            ArrayList vanilla = Lists.newArrayList();
            json.getAsJsonArray().forEach(ele -> {
                class_1856 ing = CraftingHelper.getIngredient(ele, allowEmpty);
                if (ing.getClass() == class_1856.class) {
                    vanilla.add(ing);
                } else {
                    ingredients.add(ing);
                }
            });
            if (!vanilla.isEmpty()) {
                ingredients.add(IngredientInjection.merge(vanilla));
            }
            if (ingredients.size() == 0) {
                if (allowEmpty) {
                    return class_1856.field_9017;
                }
                throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
            }
            if (ingredients.size() == 1) {
                return (class_1856)ingredients.get(0);
            }
            return new CompoundIngredient(ingredients);
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expcted ingredient to be a object or array of objects");
        }
        JsonObject obj = (JsonObject)json;
        String type = class_3518.method_15253((JsonObject)obj, (String)"type", (String)"minecraft:item");
        if (type.isEmpty()) {
            throw new JsonSyntaxException("Ingredient type can not be an empty string");
        }
        IIngredientSerializer serializer = (IIngredientSerializer)ingredients.get((Object)new class_2960(type));
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown ingredient type: " + type);
        }
        return serializer.parse(obj);
    }

    public static class_1799 getItemStack(JsonObject json, boolean readNBT) {
        return CraftingHelper.getItemStack(json, readNBT, false);
    }

    public static class_1792 getItem(String itemName, boolean disallowsAirInRecipe) {
        class_2960 itemKey = new class_2960(itemName);
        if (!ForgeRegistries.ITEMS.containsKey(itemKey)) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        }
        class_1792 item = ForgeRegistries.ITEMS.getValue(itemKey);
        if (disallowsAirInRecipe && item == class_1802.field_8162) {
            throw new JsonSyntaxException("Invalid item: " + itemName);
        }
        return Objects.requireNonNull(item);
    }

    public static class_2487 getNBT(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                return class_2522.method_10718((String)GSON.toJson(element));
            }
            return class_2522.method_10718((String)class_3518.method_15287((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Invalid NBT Entry: " + String.valueOf((Object)e));
        }
    }

    public static class_1799 getItemStack(JsonObject json, boolean readNBT, boolean disallowsAirInRecipe) {
        String itemName = class_3518.method_15265((JsonObject)json, (String)"item");
        class_1792 item = CraftingHelper.getItem(itemName, disallowsAirInRecipe);
        if (readNBT && json.has("nbt")) {
            class_2487 nbt = CraftingHelper.getNBT(json.get("nbt"));
            class_2487 tmp = new class_2487();
            if (nbt.method_10545("ForgeCaps")) {
                tmp.method_10566("ForgeCaps", nbt.method_10580("ForgeCaps"));
                nbt.method_10551("ForgeCaps");
            }
            tmp.method_10566("tag", (class_2520)nbt);
            tmp.method_10582("id", itemName);
            tmp.method_10569("Count", class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
            return class_1799.method_7915((class_2487)tmp);
        }
        return new class_1799((class_1935)item, class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
    }

    public static boolean processConditions(JsonObject json, String memberName, ICondition.IContext context) {
        return !json.has(memberName) || CraftingHelper.processConditions(class_3518.method_15261((JsonObject)json, (String)memberName), context);
    }

    public static boolean processConditions(JsonArray conditions, ICondition.IContext context) {
        for (int x = 0; x < conditions.size(); ++x) {
            if (!conditions.get(x).isJsonObject()) {
                throw new JsonSyntaxException("Conditions must be an array of JsonObjects");
            }
            JsonObject json = conditions.get(x).getAsJsonObject();
            if (CraftingHelper.getCondition(json).test(context)) continue;
            return false;
        }
        return true;
    }

    public static ICondition getCondition(JsonObject json) {
        class_2960 type = new class_2960(class_3518.method_15265((JsonObject)json, (String)"type"));
        IConditionSerializer<?> serializer = conditions.get(type);
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown condition type: " + type.toString());
        }
        return serializer.read(json);
    }

    public static <T extends ICondition> JsonObject serialize(T condition) {
        IConditionSerializer<?> serializer = conditions.get(condition.getID());
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown condition type: " + condition.getID().toString());
        }
        return serializer.getJson(condition);
    }

    public static JsonArray serialize(ICondition ... conditions) {
        JsonArray arr = new JsonArray();
        for (ICondition iCond : conditions) {
            arr.add((JsonElement)CraftingHelper.serialize(iCond));
        }
        return arr;
    }
}

