/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class StrictNBTIngredient
extends AbstractIngredient {
    private final class_1799 stack;

    protected StrictNBTIngredient(class_1799 stack) {
        super(Stream.of(new class_1856.class_1857(stack)));
        this.stack = stack;
    }

    public static StrictNBTIngredient of(class_1799 stack) {
        return new StrictNBTIngredient(stack);
    }

    public boolean method_8093(@Nullable class_1799 input) {
        if (input == null) {
            return false;
        }
        return this.stack.method_7909() == input.method_7909() && this.stack.method_7919() == input.method_7919() && this.stack.areShareTagsEqual(input);
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public IIngredientSerializer<? extends class_1856> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Override
    public JsonElement method_8089() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID(Serializer.INSTANCE).toString());
        json.addProperty("item", ForgeRegistries.ITEMS.getKey(this.stack.method_7909()).toString());
        json.addProperty("count", (Number)this.stack.method_7947());
        if (this.stack.method_7985()) {
            json.addProperty("nbt", this.stack.method_7969().toString());
        }
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<StrictNBTIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public StrictNBTIngredient parse(class_2540 buffer) {
            return new StrictNBTIngredient(buffer.method_10819());
        }

        @Override
        public StrictNBTIngredient parse(JsonObject json) {
            return new StrictNBTIngredient(CraftingHelper.getItemStack(json, true));
        }

        @Override
        public void write(class_2540 buffer, StrictNBTIngredient ingredient) {
            buffer.method_10793(ingredient.stack);
        }
    }
}

