/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_186;
import net.minecraft.class_207;
import net.minecraft.class_2073;
import net.minecraft.class_223;
import net.minecraft.class_2438;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_58;
import net.minecraft.class_69;
import net.minecraft.class_7784;
import net.minecraft.class_7791;
import net.minecraft.class_7794;
import net.minecraft.class_79;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.loot.CanToolPerformAction;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public final class ForgeLootTableProvider
extends class_2438 {
    public ForgeLootTableProvider(class_7784 packOutput) {
        super(packOutput, Set.of(), class_7794.method_46184((class_7784)packOutput).getTables());
    }

    public void validate(Map<class_2960, class_52> map, class_58 validationcontext) {
    }

    public List<class_2438.class_7790> getTables() {
        return super.getTables().stream().map(entry -> new class_2438.class_7790(() -> this.replaceAndFilterChangesOnly((class_7791)entry.comp_1068().get()), entry.comp_1069())).collect(Collectors.toList());
    }

    private class_7791 replaceAndFilterChangesOnly(class_7791 subProvider) {
        return newConsumer -> subProvider.method_10399((resourceLocation, builder) -> {
            if (this.findAndReplaceInLootTableBuilder((class_52.class_53)builder, class_1802.field_8868, ToolActions.SHEARS_DIG)) {
                newConsumer.accept(resourceLocation, builder);
            }
        });
    }

    private boolean findAndReplaceInLootTableBuilder(class_52.class_53 builder, class_1792 from, ToolAction toolAction) {
        List lootPools = (List)ObfuscationReflectionHelper.getPrivateValue(class_52.class_53.class, builder, "f_79156_");
        boolean found = false;
        if (lootPools == null) {
            throw new IllegalStateException(class_52.class_53.class.getName() + " is missing field f_79156_");
        }
        for (class_55 lootPool : lootPools) {
            if (!this.findAndReplaceInLootPool(lootPool, from, toolAction)) continue;
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInLootPool(class_55 lootPool, class_1792 from, ToolAction toolAction) {
        class_79[] lootEntries = (class_79[])ObfuscationReflectionHelper.getPrivateValue(class_55.class, lootPool, "f_79023_");
        class_5341[] lootConditions = (class_5341[])ObfuscationReflectionHelper.getPrivateValue(class_55.class, lootPool, "f_79024_");
        boolean found = false;
        if (lootEntries == null) {
            throw new IllegalStateException(class_55.class.getName() + " is missing field f_79023_");
        }
        for (class_79 lootEntry : lootEntries) {
            if (this.findAndReplaceInLootEntry(lootEntry, from, toolAction)) {
                found = true;
            }
            if (!(lootEntry instanceof class_69) || !this.findAndReplaceInParentedLootEntry((class_69)lootEntry, from, toolAction)) continue;
            found = true;
        }
        if (lootConditions == null) {
            throw new IllegalStateException(class_55.class.getName() + " is missing field f_79024_");
        }
        for (int i = 0; i < lootConditions.length; ++i) {
            class_186 compositeLootItemCondition;
            class_5341 lootCondition = lootConditions[i];
            if (lootCondition instanceof class_223 && this.checkMatchTool((class_223)lootCondition, from)) {
                lootConditions[i] = CanToolPerformAction.canToolPerformAction(toolAction).build();
                found = true;
                continue;
            }
            if (!(lootCondition instanceof class_207)) continue;
            class_5341 invLootCondition = (class_5341)ObfuscationReflectionHelper.getPrivateValue(class_207.class, (class_207)lootCondition, "f_81681_");
            if (invLootCondition instanceof class_223 && this.checkMatchTool((class_223)invLootCondition, from)) {
                lootConditions[i] = class_207.method_889((class_5341.class_210)CanToolPerformAction.canToolPerformAction(toolAction)).build();
                found = true;
                continue;
            }
            if (!(invLootCondition instanceof class_186) || !this.findAndReplaceInComposite(compositeLootItemCondition = (class_186)invLootCondition, from, toolAction)) continue;
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInParentedLootEntry(class_69 entry, class_1792 from, ToolAction toolAction) {
        class_79[] lootEntries = (class_79[])ObfuscationReflectionHelper.getPrivateValue(class_69.class, entry, "f_79428_");
        boolean found = false;
        if (lootEntries == null) {
            throw new IllegalStateException(class_69.class.getName() + " is missing field f_79428_");
        }
        for (class_79 lootEntry : lootEntries) {
            if (!this.findAndReplaceInLootEntry(lootEntry, from, toolAction)) continue;
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInLootEntry(class_79 entry, class_1792 from, ToolAction toolAction) {
        class_5341[] lootConditions = (class_5341[])ObfuscationReflectionHelper.getPrivateValue(class_79.class, entry, "f_79636_");
        boolean found = false;
        if (lootConditions == null) {
            throw new IllegalStateException(class_79.class.getName() + " is missing field f_79636_");
        }
        for (int i = 0; i < lootConditions.length; ++i) {
            class_186 composite;
            class_5341 class_53412 = lootConditions[i];
            if (class_53412 instanceof class_186 && this.findAndReplaceInComposite(composite = (class_186)class_53412, from, toolAction)) {
                found = true;
                continue;
            }
            if (!(lootConditions[i] instanceof class_223) || !this.checkMatchTool((class_223)lootConditions[i], from)) continue;
            lootConditions[i] = CanToolPerformAction.canToolPerformAction(toolAction).build();
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInComposite(class_186 alternative, class_1792 from, ToolAction toolAction) {
        class_5341[] lootConditions = (class_5341[])ObfuscationReflectionHelper.getPrivateValue(class_186.class, alternative, "f_285609_");
        boolean found = false;
        if (lootConditions == null) {
            throw new IllegalStateException(class_186.class.getName() + " is missing field f_285609_");
        }
        for (int i = 0; i < lootConditions.length; ++i) {
            if (!(lootConditions[i] instanceof class_223) || !this.checkMatchTool((class_223)lootConditions[i], from)) continue;
            lootConditions[i] = CanToolPerformAction.canToolPerformAction(toolAction).build();
            found = true;
        }
        return found;
    }

    private boolean checkMatchTool(class_223 lootCondition, class_1792 expected) {
        class_2073 predicate = (class_2073)ObfuscationReflectionHelper.getPrivateValue(class_223.class, lootCondition, "f_81993_");
        Set items = (Set)ObfuscationReflectionHelper.getPrivateValue(class_2073.class, predicate, "f_151427_");
        return items != null && items.contains(expected);
    }
}

