/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.slf4j.Logger;

public class JsonCodecProvider<T>
implements class_2405 {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final class_7784 output;
    protected final ExistingFileHelper existingFileHelper;
    protected final String modid;
    protected final DynamicOps<JsonElement> dynamicOps;
    protected final class_3264 packType;
    protected final String directory;
    protected final Codec<T> codec;
    protected final Map<class_2960, T> entries;
    protected Map<class_2960, ICondition[]> conditions = Collections.emptyMap();

    public JsonCodecProvider(class_7784 output, ExistingFileHelper existingFileHelper, String modid, DynamicOps<JsonElement> dynamicOps, class_3264 packType, String directory, Codec<T> codec, Map<class_2960, T> entries) {
        ExistingFileHelper.ResourceType resourceType = new ExistingFileHelper.ResourceType(packType, ".json", directory);
        for (class_2960 id : entries.keySet()) {
            existingFileHelper.trackGenerated(id, resourceType);
        }
        this.output = output;
        this.existingFileHelper = existingFileHelper;
        this.modid = modid;
        this.dynamicOps = dynamicOps;
        this.packType = packType;
        this.directory = directory;
        this.codec = codec;
        this.entries = entries;
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        Path outputFolder = this.output.method_45972(this.packType == class_3264.field_14188 ? class_7784.class_7490.field_39368 : class_7784.class_7490.field_39367);
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        this.gather(LamdbaExceptionUtils.rethrowBiConsumer((id, value) -> {
            Path path = outputFolder.resolve(id.method_12836()).resolve(this.directory).resolve(id.method_12832() + ".json");
            JsonElement encoded = (JsonElement)this.codec.encodeStart(this.dynamicOps, value).getOrThrow(false, msg -> LOGGER.error("Failed to encode {}: {}", (Object)path, msg));
            ICondition[] conditions = this.conditions.get(id);
            if (conditions != null && conditions.length > 0) {
                if (encoded instanceof JsonObject) {
                    JsonObject obj = (JsonObject)encoded;
                    obj.add("forge:conditions", (JsonElement)CraftingHelper.serialize(conditions));
                } else {
                    LOGGER.error("Attempted to apply conditions to a type that is not a JsonObject! - Path: {}", (Object)path);
                }
            }
            futuresBuilder.add((Object)class_2405.method_10320((class_7403)cache, (JsonElement)encoded, (Path)path));
        }));
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    protected void gather(BiConsumer<class_2960, T> consumer) {
        this.entries.forEach(consumer);
    }

    public String method_10321() {
        return String.format("%s generator for %s", this.directory, this.modid);
    }

    public JsonCodecProvider<T> setConditions(Map<class_2960, ICondition[]> conditions) {
        this.conditions = conditions;
        return this;
    }
}

