/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_7893;
import org.jetbrains.annotations.ApiStatus;
import xyz.bluspring.kilt.injections.world.entity.ai.BrainInjection;

public class BrainBuilder<E extends class_1309> {
    private final Collection<class_4140<?>> memoryTypes = new HashSet();
    private final Collection<class_4149<? extends class_4148<? super E>>> sensorTypes = new HashSet<class_4149<? extends class_4148<? super E>>>();
    private final Map<Integer, Map<class_4168, Set<class_7893<? super E>>>> availableBehaviorsByPriority = Maps.newTreeMap();
    private class_4170 schedule = class_4170.field_18603;
    private final Map<class_4168, Set<Pair<class_4140<?>, class_4141>>> activityRequirements = Maps.newHashMap();
    private final Map<class_4168, Set<class_4140<?>>> activityMemoriesToEraseWhenStopped = Maps.newHashMap();
    private final Set<class_4168> coreActivities = Sets.newHashSet();
    private final Set<class_4168> activeActivites = Sets.newHashSet();
    private class_4168 defaultActivity = class_4168.field_18595;

    public BrainBuilder(class_4095<E> ignoredBrain) {
    }

    public class_4095.class_5303<E> provider() {
        return class_4095.method_28311(this.memoryTypes, this.sensorTypes);
    }

    public Collection<class_4140<?>> getMemoryTypes() {
        return this.memoryTypes;
    }

    public Collection<class_4149<? extends class_4148<? super E>>> getSensorTypes() {
        return this.sensorTypes;
    }

    public Map<Integer, Map<class_4168, Set<class_7893<? super E>>>> getAvailableBehaviorsByPriority() {
        return this.availableBehaviorsByPriority;
    }

    public class_4170 getSchedule() {
        return this.schedule;
    }

    public void setSchedule(class_4170 schedule) {
        this.schedule = schedule;
    }

    public Map<class_4168, Set<Pair<class_4140<?>, class_4141>>> getActivityRequirements() {
        return this.activityRequirements;
    }

    public Map<class_4168, Set<class_4140<?>>> getActivityMemoriesToEraseWhenStopped() {
        return this.activityMemoriesToEraseWhenStopped;
    }

    public Set<class_4168> getCoreActivities() {
        return this.coreActivities;
    }

    public class_4168 getDefaultActivity() {
        return this.defaultActivity;
    }

    public void setDefaultActivity(class_4168 defaultActivity) {
        this.defaultActivity = defaultActivity;
    }

    public Set<class_4168> getActiveActivites() {
        return this.activeActivites;
    }

    public void setActiveActivites(Set<class_4168> value) {
        this.activeActivites.clear();
        this.activeActivites.addAll(value);
    }

    public void addBehaviorToActivityByPriority(Integer priority, class_4168 activity, class_7893<? super E> behaviorControl) {
        this.availableBehaviorsByPriority.computeIfAbsent(priority, i -> Maps.newHashMap()).computeIfAbsent(activity, a -> Sets.newLinkedHashSet()).add(behaviorControl);
    }

    public void addRequirementsToActivity(class_4168 activity, Collection<Pair<class_4140<?>, class_4141>> requirements) {
        BrainBuilder.addRequirementsToActivityInternal(this.activityRequirements, activity, requirements);
    }

    public void addMemoriesToEraseWhenActivityStopped(class_4168 activity, Collection<class_4140<?>> memories) {
        BrainBuilder.addMemoriesToEraseWhenActivityStoppedInternal(this.activityMemoriesToEraseWhenStopped, activity, memories);
    }

    @ApiStatus.Internal
    public void addAvailableBehaviorsByPriorityFrom(Map<Integer, Map<class_4168, Set<class_7893<? super E>>>> addFrom) {
        addFrom.forEach((priority, activitySetMap) -> activitySetMap.forEach((activity, behaviorControls) -> this.availableBehaviorsByPriority.computeIfAbsent((Integer)priority, p -> Maps.newHashMap()).computeIfAbsent(activity, a -> Sets.newLinkedHashSet()).addAll(behaviorControls)));
    }

    @ApiStatus.Internal
    public void addAvailableBehaviorsByPriorityTo(Map<Integer, Map<class_4168, Set<class_7893<? super E>>>> addTo) {
        this.availableBehaviorsByPriority.forEach((priority, activitySetMap) -> activitySetMap.forEach((activity, behaviorControls) -> addTo.computeIfAbsent((Integer)priority, p -> Maps.newHashMap()).computeIfAbsent(activity, a -> Sets.newLinkedHashSet()).addAll(behaviorControls)));
    }

    @ApiStatus.Internal
    public void addActivityRequirementsFrom(Map<class_4168, Set<Pair<class_4140<?>, class_4141>>> addFrom) {
        addFrom.forEach(this::addRequirementsToActivity);
    }

    @ApiStatus.Internal
    public void addActivityRequirementsTo(Map<class_4168, Set<Pair<class_4140<?>, class_4141>>> addTo) {
        this.activityRequirements.forEach((activity, requirements) -> BrainBuilder.addRequirementsToActivityInternal(addTo, activity, requirements));
    }

    @ApiStatus.Internal
    public void addActivityMemoriesToEraseWhenStoppedFrom(Map<class_4168, Set<class_4140<?>>> addFrom) {
        addFrom.forEach(this::addMemoriesToEraseWhenActivityStopped);
    }

    @ApiStatus.Internal
    public void addActivityMemoriesToEraseWhenStoppedTo(Map<class_4168, Set<class_4140<?>>> addTo) {
        this.activityMemoriesToEraseWhenStopped.forEach((activity, memories) -> BrainBuilder.addMemoriesToEraseWhenActivityStoppedInternal(addTo, activity, memories));
    }

    private static void addMemoriesToEraseWhenActivityStoppedInternal(Map<class_4168, Set<class_4140<?>>> activityMemoriesToEraseWhenStopped, class_4168 activity, Collection<class_4140<?>> memories) {
        activityMemoriesToEraseWhenStopped.computeIfAbsent(activity, a -> Sets.newHashSet()).addAll(memories);
    }

    private static void addRequirementsToActivityInternal(Map<class_4168, Set<Pair<class_4140<?>, class_4141>>> activityRequirements, class_4168 activity, Collection<Pair<class_4140<?>, class_4141>> requirements) {
        activityRequirements.computeIfAbsent(activity, a -> Sets.newHashSet()).addAll(requirements);
    }

    @ApiStatus.Internal
    public class_4095<E> makeBrain(Dynamic<?> dynamic) {
        class_4095 brain = class_4095.method_28311(this.memoryTypes, this.sensorTypes).method_28335(dynamic);
        ((BrainInjection)brain).copyFromBuilder(this);
        return brain;
    }
}

