/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_7046;
import net.minecraftforge.eventbus.api.Event;

public class RegisterStructureConversionsEvent
extends Event {
    private final Map<String, class_7046.class_7047> map;

    public RegisterStructureConversionsEvent(Map<String, class_7046.class_7047> map) {
        this.map = map;
    }

    public void register(String oldStructureID, class_7046.class_7047 conversion) {
        Preconditions.checkNotNull((Object)oldStructureID, (Object)"Original structure ID must not be null");
        Preconditions.checkArgument((boolean)oldStructureID.toLowerCase(Locale.ROOT).equals(oldStructureID), (Object)"Original structure ID should be in all lowercase");
        Preconditions.checkNotNull((Object)conversion, (Object)"Structure conversion must not be null");
        Preconditions.checkNotNull((Object)conversion.comp_463(), (Object)"Fallback structure ID in structure conversion must not be null");
        if (this.map.putIfAbsent(oldStructureID.toLowerCase(Locale.ROOT), conversion) != null) {
            throw new IllegalArgumentException("Conversion has already been registered for structure " + oldStructureID);
        }
    }
}

