/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import com.google.common.base.Preconditions;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2846;
import net.minecraft.class_3965;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerInteractEvent
extends PlayerEvent {
    private final class_1268 hand;
    private final class_2338 pos;
    @Nullable
    private final class_2350 face;
    private class_1269 cancellationResult = class_1269.field_5811;

    public PlayerInteractEvent() {
        super((class_1657)null);
        this.hand = null;
        this.pos = null;
        this.face = null;
    }

    private PlayerInteractEvent(class_1657 player, class_1268 hand, class_2338 pos, @Nullable class_2350 face) {
        super((class_1657)Preconditions.checkNotNull((Object)player, (Object)"Null player in PlayerInteractEvent!"));
        this.hand = (class_1268)Preconditions.checkNotNull((Object)hand, (Object)"Null hand in PlayerInteractEvent!");
        this.pos = (class_2338)Preconditions.checkNotNull((Object)pos, (Object)"Null position in PlayerInteractEvent!");
        this.face = face;
    }

    @NotNull
    public class_1268 getHand() {
        return this.hand;
    }

    @NotNull
    public class_1799 getItemStack() {
        return this.getEntity().method_5998(this.hand);
    }

    @NotNull
    public class_2338 getPos() {
        return this.pos;
    }

    @Nullable
    public class_2350 getFace() {
        return this.face;
    }

    public class_1937 getLevel() {
        return this.getEntity().method_37908();
    }

    public LogicalSide getSide() {
        return this.getLevel().field_9236 ? LogicalSide.CLIENT : LogicalSide.SERVER;
    }

    public class_1269 getCancellationResult() {
        return this.cancellationResult;
    }

    public void setCancellationResult(class_1269 result) {
        this.cancellationResult = result;
    }

    public static class LeftClickEmpty
    extends PlayerInteractEvent {
        public LeftClickEmpty(class_1657 player) {
            super(player, class_1268.field_5808, player.method_24515(), null);
        }
    }

    @Cancelable
    public static class LeftClickBlock
    extends PlayerInteractEvent {
        private Event.Result useBlock = Event.Result.DEFAULT;
        private Event.Result useItem = Event.Result.DEFAULT;
        private final Action action;

        @Deprecated(since="1.20.1", forRemoval=true)
        public LeftClickBlock(class_1657 player, class_2338 pos, class_2350 face) {
            this(player, pos, face, Action.START);
        }

        @ApiStatus.Internal
        public LeftClickBlock(class_1657 player, class_2338 pos, class_2350 face, Action action) {
            super(player, class_1268.field_5808, pos, face);
            this.action = action;
        }

        public Event.Result getUseBlock() {
            return this.useBlock;
        }

        public Event.Result getUseItem() {
            return this.useItem;
        }

        @NotNull
        public Action getAction() {
            return this.action;
        }

        public void setUseBlock(Event.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Event.Result triggerItem) {
            this.useItem = triggerItem;
        }

        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = Event.Result.DENY;
                this.useItem = Event.Result.DENY;
            }
        }

        public static enum Action {
            START,
            STOP,
            ABORT,
            CLIENT_HOLD;


            public static Action convert(class_2846.class_2847 action) {
                return switch (action) {
                    default -> START;
                    case class_2846.class_2847.field_12968 -> START;
                    case class_2846.class_2847.field_12973 -> STOP;
                    case class_2846.class_2847.field_12971 -> ABORT;
                };
            }
        }
    }

    public static class RightClickEmpty
    extends PlayerInteractEvent {
        public RightClickEmpty(class_1657 player, class_1268 hand) {
            super(player, hand, player.method_24515(), null);
        }
    }

    @Cancelable
    public static class RightClickItem
    extends PlayerInteractEvent {
        public RightClickItem(class_1657 player, class_1268 hand) {
            super(player, hand, player.method_24515(), null);
        }
    }

    @Cancelable
    public static class RightClickBlock
    extends PlayerInteractEvent {
        private Event.Result useBlock = Event.Result.DEFAULT;
        private Event.Result useItem = Event.Result.DEFAULT;
        private class_3965 hitVec;

        public RightClickBlock(class_1657 player, class_1268 hand, class_2338 pos, class_3965 hitVec) {
            super(player, hand, pos, hitVec.method_17780());
            this.hitVec = hitVec;
        }

        public Event.Result getUseBlock() {
            return this.useBlock;
        }

        public Event.Result getUseItem() {
            return this.useItem;
        }

        public class_3965 getHitVec() {
            return this.hitVec;
        }

        public void setUseBlock(Event.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Event.Result triggerItem) {
            this.useItem = triggerItem;
        }

        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = Event.Result.DENY;
                this.useItem = Event.Result.DENY;
            }
        }
    }

    @Cancelable
    public static class EntityInteract
    extends PlayerInteractEvent {
        private final class_1297 target;

        public EntityInteract(class_1657 player, class_1268 hand, class_1297 target) {
            super(player, hand, target.method_24515(), null);
            this.target = target;
        }

        public class_1297 getTarget() {
            return this.target;
        }
    }

    @Cancelable
    public static class EntityInteractSpecific
    extends PlayerInteractEvent {
        private final class_243 localPos;
        private final class_1297 target;

        public EntityInteractSpecific(class_1657 player, class_1268 hand, class_1297 target, class_243 localPos) {
            super(player, hand, target.method_24515(), null);
            this.localPos = localPos;
            this.target = target;
        }

        public class_243 getLocalPos() {
            return this.localPos;
        }

        public class_1297 getTarget() {
            return this.target;
        }
    }
}

