/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2601;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public class DispenseFluidContainer
extends class_2347 {
    private static final DispenseFluidContainer INSTANCE = new DispenseFluidContainer();
    private final class_2347 dispenseBehavior = new class_2347();

    public static DispenseFluidContainer getInstance() {
        return INSTANCE;
    }

    private DispenseFluidContainer() {
    }

    @NotNull
    public class_1799 method_10135(@NotNull class_2342 source, @NotNull class_1799 stack) {
        if (FluidUtil.getFluidContained(stack).isPresent()) {
            return this.dumpContainer(source, stack);
        }
        return this.fillContainer(source, stack);
    }

    @NotNull
    private class_1799 fillContainer(@NotNull class_2342 source, @NotNull class_1799 stack) {
        class_3218 level = source.method_10207();
        class_2350 dispenserFacing = (class_2350)source.method_10120().method_11654((class_2769)class_2315.field_10918);
        class_2338 blockpos = source.method_10122().method_10093(dispenserFacing);
        FluidActionResult actionResult = FluidUtil.tryPickUpFluid(stack, null, (class_1937)level, blockpos, dispenserFacing.method_10153());
        class_1799 resultStack = actionResult.getResult();
        if (!actionResult.isSuccess() || resultStack.method_7960()) {
            return super.method_10135(source, stack);
        }
        if (stack.method_7947() == 1) {
            return resultStack;
        }
        if (((class_2601)source.method_10121()).method_11075(resultStack) < 0) {
            this.dispenseBehavior.dispense(source, resultStack);
        }
        class_1799 stackCopy = stack.method_7972();
        stackCopy.method_7934(1);
        return stackCopy;
    }

    @NotNull
    private class_1799 dumpContainer(class_2342 source, @NotNull class_1799 stack) {
        class_1799 singleStack = stack.method_7972();
        singleStack.method_7939(1);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler(singleStack).orElse(null);
        if (fluidHandler == null) {
            return super.method_10135(source, stack);
        }
        FluidStack fluidStack = fluidHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        class_2350 dispenserFacing = (class_2350)source.method_10120().method_11654((class_2769)class_2315.field_10918);
        class_2338 blockpos = source.method_10122().method_10093(dispenserFacing);
        FluidActionResult result = FluidUtil.tryPlaceFluid(null, (class_1937)source.method_10207(), class_1268.field_5808, blockpos, stack, fluidStack);
        if (result.isSuccess()) {
            class_1799 drainedStack = result.getResult();
            if (drainedStack.method_7947() == 1) {
                return drainedStack;
            }
            if (!drainedStack.method_7960() && ((class_2601)source.method_10121()).method_11075(drainedStack) < 0) {
                this.dispenseBehavior.dispense(source, drainedStack);
            }
            class_1799 stackCopy = drainedStack.method_7972();
            stackCopy.method_7934(1);
            return stackCopy;
        }
        return this.dispenseBehavior.dispense(source, stack);
    }
}

