/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class FluidStack
extends io.github.fabricators_of_create.porting_lib.fluids.FluidStack {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final FluidStack EMPTY = new FluidStack(class_3612.field_15906, 0);
    public static final Codec<FluidStack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41173.method_39673().fieldOf("FluidName").forGetter(FluidStack::getFluid), (App)Codec.INT.fieldOf("Amount").forGetter(FluidStack::forge$getAmount), (App)class_2487.field_25128.optionalFieldOf("Tag").forGetter(stack -> Optional.ofNullable(stack.getTag()))).apply((Applicative)instance, (fluid, amount, tag) -> {
        FluidStack stack = new FluidStack((class_3611)fluid, (int)amount);
        tag.ifPresent(stack::setTag);
        return stack;
    }));
    private boolean isEmpty;
    private int amount;
    private class_2487 tag;
    private class_6880.class_6883<class_3611> fluidDelegate;

    public FluidStack(class_3611 fluid, int amount) {
        super(fluid, (long)amount);
        if (fluid == null) {
            LOGGER.fatal("Null fluid supplied to fluidstack. Did you try and create a stack for an unregistered fluid?");
            throw new IllegalArgumentException("Cannot create a fluidstack from a null fluid");
        }
        if (ForgeRegistries.FLUIDS.getKey(fluid) == null) {
            LOGGER.fatal("Failed attempt to create a FluidStack for an unregistered Fluid {} (type {})", (Object)ForgeRegistries.FLUIDS.getKey(fluid), (Object)fluid.getClass().getName());
            throw new IllegalArgumentException("Cannot create a fluidstack from an unregistered fluid");
        }
        this.fluidDelegate = ForgeRegistries.FLUIDS.getDelegateOrThrow(fluid);
        this.amount = amount;
        this.updateEmpty();
    }

    public FluidStack(class_3611 fluid, int amount, class_2487 nbt) {
        this(fluid, amount);
        if (nbt != null) {
            this.tag = nbt.method_10553();
        }
    }

    public FluidStack(FluidStack stack, int amount) {
        this(stack.getFluid(), amount, stack.tag);
    }

    public static FluidStack loadFluidStackFromNBT(class_2487 nbt) {
        if (nbt == null) {
            return EMPTY;
        }
        if (!nbt.method_10573("FluidName", 8)) {
            return EMPTY;
        }
        class_2960 fluidName = new class_2960(nbt.method_10558("FluidName"));
        class_3611 fluid = ForgeRegistries.FLUIDS.getValue(fluidName);
        if (fluid == null) {
            return EMPTY;
        }
        FluidStack stack = new FluidStack(fluid, nbt.method_10550("Amount"));
        if (nbt.method_10573("Tag", 10)) {
            stack.tag = nbt.method_10562("Tag");
        }
        return stack;
    }

    public class_2487 writeToNBT(class_2487 nbt) {
        nbt.method_10582("FluidName", ForgeRegistries.FLUIDS.getKey(this.getFluid()).toString());
        nbt.method_10569("Amount", this.amount);
        if (this.tag != null) {
            nbt.method_10566("Tag", (class_2520)this.tag);
        }
        return nbt;
    }

    public void forge$writeToPacket(class_2540 buf) {
        buf.writeRegistryId(ForgeRegistries.FLUIDS, (Object)this.getFluid());
        buf.method_10804(this.forge$getAmount());
        buf.method_10794(this.tag);
    }

    public static FluidStack readFromPacket(class_2540 buf) {
        class_3611 fluid = (class_3611)buf.readRegistryId();
        int amount = buf.method_10816();
        class_2487 tag = buf.method_10798();
        if (fluid == class_3612.field_15906) {
            return EMPTY;
        }
        return new FluidStack(fluid, amount, tag);
    }

    public final class_3611 getFluid() {
        return this.isEmpty ? class_3612.field_15906 : (class_3611)this.fluidDelegate.comp_349();
    }

    public final class_3611 getRawFluid() {
        return (class_3611)this.fluidDelegate.comp_349();
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    protected void updateEmpty() {
        this.isEmpty = this.getRawFluid() == class_3612.field_15906 || this.amount <= 0;
    }

    public int forge$getAmount() {
        return (int)this.getAmount();
    }

    public void setAmount(int amount) {
        this.setAmount(amount);
    }

    public void grow(int amount) {
        this.grow(amount);
    }

    public void shrink(int amount) {
        this.shrink(amount);
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public class_2487 getTag() {
        return this.tag;
    }

    public void setTag(class_2487 tag) {
        if (this.getRawFluid() == class_3612.field_15906) {
            throw new IllegalStateException("Can't modify the empty stack.");
        }
        this.tag = tag;
    }

    public class_2487 getOrCreateTag() {
        if (this.tag == null) {
            this.setTag(new class_2487());
        }
        return this.tag;
    }

    public class_2487 getChildTag(String childName) {
        if (this.tag == null) {
            return null;
        }
        return this.tag.method_10562(childName);
    }

    public class_2487 getOrCreateChildTag(String childName) {
        this.getOrCreateTag();
        class_2487 child = this.tag.method_10562(childName);
        if (!this.tag.method_10573(childName, 10)) {
            this.tag.method_10566(childName, (class_2520)child);
        }
        return child;
    }

    public void removeChildTag(String childName) {
        if (this.tag != null) {
            this.tag.method_10551(childName);
        }
    }

    public class_2561 getDisplayName() {
        return this.getFluid().getFluidType().getDescription(this);
    }

    public String getTranslationKey() {
        return this.getFluid().getFluidType().getDescriptionId(this);
    }

    public FluidStack copy() {
        return new FluidStack(this.getFluid(), this.amount, this.tag);
    }

    public boolean isFluidEqual(@NotNull FluidStack other) {
        return this.isFluidEqual(other);
    }

    private boolean isFluidStackTagEqual(FluidStack other) {
        return this.tag == null ? other.tag == null : other.tag != null && this.tag.equals((Object)other.tag);
    }

    public static boolean areFluidStackTagsEqual(@NotNull FluidStack stack1, @NotNull FluidStack stack2) {
        return stack1.isFluidStackTagEqual(stack2);
    }

    public boolean containsFluid(@NotNull FluidStack other) {
        return this.containsFluid(other);
    }

    public boolean isFluidStackIdentical(FluidStack other) {
        return this.isFluidStackIdentical(other);
    }

    public boolean isFluidEqual(@NotNull class_1799 other) {
        return FluidUtil.getFluidContained(other).map(this::isFluidEqual).orElse(false);
    }
}

