/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2402;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;
import net.minecraftforge.fluids.capability.wrappers.BucketPickupHandlerWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidUtil {
    private FluidUtil() {
    }

    public static boolean interactWithFluidHandler(@NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_1937 level, @NotNull class_2338 pos, @Nullable class_2350 side) {
        Preconditions.checkNotNull((Object)level);
        Preconditions.checkNotNull((Object)pos);
        return FluidUtil.getFluidHandler(level, pos, side).map(handler -> FluidUtil.interactWithFluidHandler(player, hand, handler)).orElse(false);
    }

    public static boolean interactWithFluidHandler(@NotNull class_1657 player, @NotNull class_1268 hand, @NotNull IFluidHandler handler) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)hand);
        Preconditions.checkNotNull((Object)handler);
        class_1799 heldItem = player.method_5998(hand);
        if (!heldItem.method_7960()) {
            return player.getCapability(ForgeCapabilities.ITEM_HANDLER).map(playerInventory -> {
                FluidActionResult fluidActionResult = FluidUtil.tryFillContainerAndStow(heldItem, handler, playerInventory, Integer.MAX_VALUE, player, true);
                if (!fluidActionResult.isSuccess()) {
                    fluidActionResult = FluidUtil.tryEmptyContainerAndStow(heldItem, handler, playerInventory, Integer.MAX_VALUE, player, true);
                }
                if (fluidActionResult.isSuccess()) {
                    player.method_6122(hand, fluidActionResult.getResult());
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    @NotNull
    public static FluidActionResult tryFillContainer(@NotNull class_1799 container, IFluidHandler fluidSource, int maxAmount, @Nullable class_1657 player, boolean doFill) {
        class_1799 containerCopy = ItemHandlerHelper.copyStackWithSize(container, 1);
        return FluidUtil.getFluidHandler(containerCopy).map(containerFluidHandler -> {
            FluidStack simulatedTransfer = FluidUtil.tryFluidTransfer((IFluidHandler)containerFluidHandler, fluidSource, maxAmount, false);
            if (!simulatedTransfer.isEmpty()) {
                if (doFill) {
                    class_3414 soundevent;
                    FluidUtil.tryFluidTransfer((IFluidHandler)containerFluidHandler, fluidSource, maxAmount, true);
                    if (player != null && (soundevent = simulatedTransfer.getFluid().getFluidType().getSound(simulatedTransfer, SoundActions.BUCKET_FILL)) != null) {
                        player.method_37908().method_43128(null, player.method_23317(), player.method_23318() + 0.5, player.method_23321(), soundevent, class_3419.field_15245, 1.0f, 1.0f);
                    }
                } else {
                    containerFluidHandler.fill(simulatedTransfer, IFluidHandler.FluidAction.EXECUTE);
                }
                class_1799 resultContainer = containerFluidHandler.getContainer();
                return new FluidActionResult(resultContainer);
            }
            return FluidActionResult.FAILURE;
        }).orElse(FluidActionResult.FAILURE);
    }

    @NotNull
    public static FluidActionResult tryEmptyContainer(@NotNull class_1799 container, IFluidHandler fluidDestination, int maxAmount, @Nullable class_1657 player, boolean doDrain) {
        class_1799 containerCopy = ItemHandlerHelper.copyStackWithSize(container, 1);
        return FluidUtil.getFluidHandler(containerCopy).map(containerFluidHandler -> {
            class_3414 soundevent;
            FluidStack transfer = FluidUtil.tryFluidTransfer(fluidDestination, (IFluidHandler)containerFluidHandler, maxAmount, doDrain);
            if (transfer.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            if (!doDrain) {
                containerFluidHandler.drain(transfer, IFluidHandler.FluidAction.EXECUTE);
            }
            if (doDrain && player != null && (soundevent = transfer.getFluid().getFluidType().getSound(transfer, SoundActions.BUCKET_EMPTY)) != null) {
                player.method_37908().method_43128(null, player.method_23317(), player.method_23318() + 0.5, player.method_23321(), soundevent, class_3419.field_15245, 1.0f, 1.0f);
            }
            class_1799 resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }).orElse(FluidActionResult.FAILURE);
    }

    @NotNull
    public static FluidActionResult tryFillContainerAndStow(@NotNull class_1799 container, IFluidHandler fluidSource, IItemHandler inventory, int maxAmount, @Nullable class_1657 player, boolean doFill) {
        if (container.method_7960()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.method_31549().field_7477) {
            FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
            if (filledReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.method_7947() == 1) {
            FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
            if (filledReal.isSuccess()) {
                return filledReal;
            }
        } else {
            class_1799 remainder;
            FluidActionResult filledSimulated = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, false);
            if (filledSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked(inventory, filledSimulated.getResult(), true)).method_7960() || player != null)) {
                FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
                remainder = ItemHandlerHelper.insertItemStacked(inventory, filledReal.getResult(), !doFill);
                if (!remainder.method_7960() && player != null && doFill) {
                    ItemHandlerHelper.giveItemToPlayer(player, remainder);
                }
                class_1799 containerCopy = container.method_7972();
                containerCopy.method_7934(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @NotNull
    public static FluidActionResult tryEmptyContainerAndStow(@NotNull class_1799 container, IFluidHandler fluidDestination, IItemHandler inventory, int maxAmount, @Nullable class_1657 player, boolean doDrain) {
        if (container.method_7960()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.method_31549().field_7477) {
            FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.method_7947() == 1) {
            FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return emptiedReal;
            }
        } else {
            class_1799 remainder;
            FluidActionResult emptiedSimulated = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, false);
            if (emptiedSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked(inventory, emptiedSimulated.getResult(), true)).method_7960() || player != null)) {
                FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
                remainder = ItemHandlerHelper.insertItemStacked(inventory, emptiedReal.getResult(), !doDrain);
                if (!remainder.method_7960() && player != null && doDrain) {
                    ItemHandlerHelper.giveItemToPlayer(player, remainder);
                }
                class_1799 containerCopy = container.method_7972();
                containerCopy.method_7934(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @NotNull
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer) {
        FluidStack drainable = fluidSource.drain(maxAmount, IFluidHandler.FluidAction.SIMULATE);
        if (!drainable.isEmpty()) {
            return FluidUtil.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, FluidStack resource, boolean doTransfer) {
        FluidStack drainable = fluidSource.drain(resource, IFluidHandler.FluidAction.SIMULATE);
        if (!drainable.isEmpty() && resource.isFluidEqual(drainable)) {
            return FluidUtil.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    private static FluidStack tryFluidTransfer_Internal(IFluidHandler fluidDestination, IFluidHandler fluidSource, FluidStack drainable, boolean doTransfer) {
        int fillableAmount = fluidDestination.fill(drainable, IFluidHandler.FluidAction.SIMULATE);
        if (fillableAmount > 0) {
            drainable.setAmount(fillableAmount);
            if (doTransfer) {
                FluidStack drained = fluidSource.drain(drainable, IFluidHandler.FluidAction.EXECUTE);
                if (!drained.isEmpty()) {
                    drained.setAmount(fluidDestination.fill(drained, IFluidHandler.FluidAction.EXECUTE));
                    return drained;
                }
            } else {
                return drainable;
            }
        }
        return FluidStack.EMPTY;
    }

    public static LazyOptional<IFluidHandlerItem> getFluidHandler(@NotNull class_1799 itemStack) {
        return itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
    }

    public static Optional<FluidStack> getFluidContained(@NotNull class_1799 container) {
        Optional<FluidStack> fluidContained;
        if (!container.method_7960() && (fluidContained = FluidUtil.getFluidHandler(container = ItemHandlerHelper.copyStackWithSize(container, 1)).map(handler -> handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE))).isPresent() && !fluidContained.get().isEmpty()) {
            return fluidContained;
        }
        return Optional.empty();
    }

    public static LazyOptional<IFluidHandler> getFluidHandler(class_1937 level, class_2338 blockPos, @Nullable class_2350 side) {
        class_2586 blockEntity;
        class_2680 state = level.method_8320(blockPos);
        if (state.method_31709() && (blockEntity = level.method_8321(blockPos)) != null) {
            return blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, side);
        }
        return LazyOptional.empty();
    }

    @NotNull
    public static FluidActionResult tryPickUpFluid(@NotNull class_1799 emptyContainer, @Nullable class_1657 playerIn, class_1937 level, class_2338 pos, class_2350 side) {
        IFluidHandler targetFluidHandler;
        if (emptyContainer.method_7960() || level == null || pos == null) {
            return FluidActionResult.FAILURE;
        }
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        if (block instanceof IFluidBlock) {
            targetFluidHandler = new FluidBlockWrapper((IFluidBlock)block, level, pos);
        } else if (block instanceof class_2263) {
            targetFluidHandler = new BucketPickupHandlerWrapper((class_2263)block, level, pos);
        } else {
            Optional<IFluidHandler> fluidHandler = FluidUtil.getFluidHandler(level, pos, side).resolve();
            if (!fluidHandler.isPresent()) {
                return FluidActionResult.FAILURE;
            }
            targetFluidHandler = fluidHandler.get();
        }
        return FluidUtil.tryFillContainer(emptyContainer, targetFluidHandler, Integer.MAX_VALUE, playerIn, true);
    }

    @NotNull
    public static FluidActionResult tryPlaceFluid(@Nullable class_1657 player, class_1937 level, class_1268 hand, class_2338 pos, @NotNull class_1799 container, FluidStack resource) {
        class_1799 containerCopy = ItemHandlerHelper.copyStackWithSize(container, 1);
        return FluidUtil.getFluidHandler(containerCopy).filter(handler -> FluidUtil.tryPlaceFluid(player, level, hand, pos, handler, resource)).map(IFluidHandlerItem::getContainer).map(FluidActionResult::new).orElse(FluidActionResult.FAILURE);
    }

    public static boolean tryPlaceFluid(@Nullable class_1657 player, class_1937 level, class_1268 hand, class_2338 pos, IFluidHandler fluidSource, FluidStack resource) {
        boolean canDestContainFluid;
        if (level == null || pos == null) {
            return false;
        }
        class_3611 fluid = resource.getFluid();
        if (fluid == class_3612.field_15906 || !fluid.getFluidType().canBePlacedInLevel((class_1920)level, pos, resource)) {
            return false;
        }
        if (fluidSource.drain(resource, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
            return false;
        }
        class_1750 context = new class_1750(level, player, hand, player == null ? class_1799.field_8037 : player.method_5998(hand), new class_3965(class_243.field_1353, class_2350.field_11036, pos, false));
        class_2680 destBlockState = level.method_8320(pos);
        boolean isDestNonSolid = !destBlockState.method_51367();
        boolean isDestReplaceable = destBlockState.method_26166(context);
        boolean bl = canDestContainFluid = destBlockState.method_26204() instanceof class_2402 && ((class_2402)destBlockState.method_26204()).method_10310((class_1922)level, pos, destBlockState, fluid);
        if (!(level.method_22347(pos) || isDestNonSolid || isDestReplaceable || canDestContainFluid)) {
            return false;
        }
        if (fluid.getFluidType().isVaporizedOnPlacement(level, pos, resource)) {
            FluidStack result = fluidSource.drain(resource, IFluidHandler.FluidAction.EXECUTE);
            if (!result.isEmpty()) {
                result.getFluid().getFluidType().onVaporize(player, level, pos, result);
                return true;
            }
        } else {
            IFluidHandler handler = canDestContainFluid ? new BlockWrapper.LiquidContainerBlockWrapper((class_2402)destBlockState.method_26204(), level, pos) : FluidUtil.getFluidBlockHandler(fluid, level, pos);
            FluidStack result = FluidUtil.tryFluidTransfer(handler, fluidSource, resource, true);
            if (!result.isEmpty()) {
                class_3414 soundevent = resource.getFluid().getFluidType().getSound(resource, SoundActions.BUCKET_EMPTY);
                if (soundevent != null) {
                    level.method_8396(player, pos, soundevent, class_3419.field_15245, 1.0f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }

    private static IFluidHandler getFluidBlockHandler(class_3611 fluid, class_1937 level, class_2338 pos) {
        class_2680 state = fluid.getFluidType().getBlockForFluidState((class_1920)level, pos, fluid.method_15785());
        return new BlockWrapper(state, level, pos);
    }

    public static void destroyBlockOnFluidPlacement(class_1937 level, class_2338 pos) {
        if (!level.field_9236) {
            class_2680 destBlockState = level.method_8320(pos);
            boolean isDestNonSolid = !destBlockState.method_51367();
            boolean isDestReplaceable = false;
            if ((isDestNonSolid || isDestReplaceable) && !destBlockState.method_51176()) {
                level.method_22352(pos, true);
            }
        }
    }

    @NotNull
    public static class_1799 getFilledBucket(@NotNull FluidStack fluidStack) {
        class_3611 fluid = fluidStack.getFluid();
        if (!fluidStack.hasTag() || fluidStack.getTag().method_33133()) {
            if (fluid == class_3612.field_15910) {
                return new class_1799((class_1935)class_1802.field_8705);
            }
            if (fluid == class_3612.field_15908) {
                return new class_1799((class_1935)class_1802.field_8187);
            }
        }
        return fluid.getFluidType().getBucket(fluidStack);
    }
}

